/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecureSourceManagerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#id GoogleSecureSourceManagerInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for the Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#instance_id GoogleSecureSourceManagerInstance#instance_id}
    */
    readonly instanceId: string;
    /**
    * Customer-managed encryption key name, in the format projects/* /locations/* /keyRings/* /cryptoKeys/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#kms_key GoogleSecureSourceManagerInstance#kms_key}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKey?: string;
    /**
    * Labels as key value pairs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#labels GoogleSecureSourceManagerInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#location GoogleSecureSourceManagerInstance#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#project GoogleSecureSourceManagerInstance#project}
    */
    readonly project?: string;
    /**
    * private_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#private_config GoogleSecureSourceManagerInstance#private_config}
    */
    readonly privateConfig?: GoogleSecureSourceManagerInstancePrivateConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#timeouts GoogleSecureSourceManagerInstance#timeouts}
    */
    readonly timeouts?: GoogleSecureSourceManagerInstanceTimeouts;
}
export interface GoogleSecureSourceManagerInstanceHostConfig {
}
export declare function googleSecureSourceManagerInstanceHostConfigToTerraform(struct?: GoogleSecureSourceManagerInstanceHostConfig): any;
export declare function googleSecureSourceManagerInstanceHostConfigToHclTerraform(struct?: GoogleSecureSourceManagerInstanceHostConfig): any;
export declare class GoogleSecureSourceManagerInstanceHostConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecureSourceManagerInstanceHostConfig | undefined;
    set internalValue(value: GoogleSecureSourceManagerInstanceHostConfig | undefined);
    get api(): string;
    get gitHttp(): string;
    get gitSsh(): string;
    get html(): string;
}
export declare class GoogleSecureSourceManagerInstanceHostConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecureSourceManagerInstanceHostConfigOutputReference;
}
export interface GoogleSecureSourceManagerInstancePrivateConfig {
    /**
    * CA pool resource, resource must in the format of 'projects/{project}/locations/{location}/caPools/{ca_pool}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#ca_pool GoogleSecureSourceManagerInstance#ca_pool}
    */
    readonly caPool: string;
    /**
    * 'Indicate if it's private instance.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#is_private GoogleSecureSourceManagerInstance#is_private}
    */
    readonly isPrivate: boolean | cdktf.IResolvable;
}
export declare function googleSecureSourceManagerInstancePrivateConfigToTerraform(struct?: GoogleSecureSourceManagerInstancePrivateConfigOutputReference | GoogleSecureSourceManagerInstancePrivateConfig): any;
export declare function googleSecureSourceManagerInstancePrivateConfigToHclTerraform(struct?: GoogleSecureSourceManagerInstancePrivateConfigOutputReference | GoogleSecureSourceManagerInstancePrivateConfig): any;
export declare class GoogleSecureSourceManagerInstancePrivateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecureSourceManagerInstancePrivateConfig | undefined;
    set internalValue(value: GoogleSecureSourceManagerInstancePrivateConfig | undefined);
    private _caPool?;
    get caPool(): string;
    set caPool(value: string);
    get caPoolInput(): string | undefined;
    get httpServiceAttachment(): string;
    private _isPrivate?;
    get isPrivate(): boolean | cdktf.IResolvable;
    set isPrivate(value: boolean | cdktf.IResolvable);
    get isPrivateInput(): boolean | cdktf.IResolvable | undefined;
    get sshServiceAttachment(): string;
}
export interface GoogleSecureSourceManagerInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#create GoogleSecureSourceManagerInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#delete GoogleSecureSourceManagerInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#update GoogleSecureSourceManagerInstance#update}
    */
    readonly update?: string;
}
export declare function googleSecureSourceManagerInstanceTimeoutsToTerraform(struct?: GoogleSecureSourceManagerInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleSecureSourceManagerInstanceTimeoutsToHclTerraform(struct?: GoogleSecureSourceManagerInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleSecureSourceManagerInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecureSourceManagerInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecureSourceManagerInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance google_secure_source_manager_instance}
*/
export declare class GoogleSecureSourceManagerInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_secure_source_manager_instance";
    /**
    * Generates CDKTF code for importing a GoogleSecureSourceManagerInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSecureSourceManagerInstance to import
    * @param importFromId The id of the existing GoogleSecureSourceManagerInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSecureSourceManagerInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secure_source_manager_instance google_secure_source_manager_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecureSourceManagerInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecureSourceManagerInstanceConfig);
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _hostConfig;
    get hostConfig(): GoogleSecureSourceManagerInstanceHostConfigList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get stateNote(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _privateConfig;
    get privateConfig(): GoogleSecureSourceManagerInstancePrivateConfigOutputReference;
    putPrivateConfig(value: GoogleSecureSourceManagerInstancePrivateConfig): void;
    resetPrivateConfig(): void;
    get privateConfigInput(): GoogleSecureSourceManagerInstancePrivateConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSecureSourceManagerInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleSecureSourceManagerInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSecureSourceManagerInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
