/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecurityposturePostureDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the posture deployment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#description GoogleSecurityposturePostureDeployment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#id GoogleSecurityposturePostureDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource, eg. global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#location GoogleSecurityposturePostureDeployment#location}
    */
    readonly location: string;
    /**
    * The parent of the resource, an organization. Format should be 'organizations/{organization_id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#parent GoogleSecurityposturePostureDeployment#parent}
    */
    readonly parent: string;
    /**
    * ID of the posture deployment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#posture_deployment_id GoogleSecurityposturePostureDeployment#posture_deployment_id}
    */
    readonly postureDeploymentId: string;
    /**
    * Relative name of the posture which needs to be deployed. It should be in the format:
    *   organizations/{organization_id}/locations/{location}/postures/{posture_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#posture_id GoogleSecurityposturePostureDeployment#posture_id}
    */
    readonly postureId: string;
    /**
    * Revision_id the posture which needs to be deployed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#posture_revision_id GoogleSecurityposturePostureDeployment#posture_revision_id}
    */
    readonly postureRevisionId: string;
    /**
    * The resource on which the posture should be deployed. This can be in one of the following formats:
    * projects/{project_number},
    * folders/{folder_number},
    * organizations/{organization_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#target_resource GoogleSecurityposturePostureDeployment#target_resource}
    */
    readonly targetResource: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#timeouts GoogleSecurityposturePostureDeployment#timeouts}
    */
    readonly timeouts?: GoogleSecurityposturePostureDeploymentTimeouts;
}
export interface GoogleSecurityposturePostureDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#create GoogleSecurityposturePostureDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#delete GoogleSecurityposturePostureDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#update GoogleSecurityposturePostureDeployment#update}
    */
    readonly update?: string;
}
export declare function googleSecurityposturePostureDeploymentTimeoutsToTerraform(struct?: GoogleSecurityposturePostureDeploymentTimeouts | cdktf.IResolvable): any;
export declare function googleSecurityposturePostureDeploymentTimeoutsToHclTerraform(struct?: GoogleSecurityposturePostureDeploymentTimeouts | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePostureDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePostureDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePostureDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment google_securityposture_posture_deployment}
*/
export declare class GoogleSecurityposturePostureDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_securityposture_posture_deployment";
    /**
    * Generates CDKTF code for importing a GoogleSecurityposturePostureDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSecurityposturePostureDeployment to import
    * @param importFromId The id of the existing GoogleSecurityposturePostureDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSecurityposturePostureDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture_deployment google_securityposture_posture_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecurityposturePostureDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecurityposturePostureDeploymentConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get desiredPostureId(): string;
    get desiredPostureRevisionId(): string;
    get etag(): string;
    get failureMessage(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _postureDeploymentId?;
    get postureDeploymentId(): string;
    set postureDeploymentId(value: string);
    get postureDeploymentIdInput(): string | undefined;
    private _postureId?;
    get postureId(): string;
    set postureId(value: string);
    get postureIdInput(): string | undefined;
    private _postureRevisionId?;
    get postureRevisionId(): string;
    set postureRevisionId(value: string);
    get postureRevisionIdInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _targetResource?;
    get targetResource(): string;
    set targetResource(value: string);
    get targetResourceInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleSecurityposturePostureDeploymentTimeoutsOutputReference;
    putTimeouts(value: GoogleSecurityposturePostureDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSecurityposturePostureDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
