/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecurityposturePostureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the posture.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#id GoogleSecurityposturePosture#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Location of the resource, eg: global.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#location GoogleSecurityposturePosture#location}
    */
    readonly location: string;
    /**
    * The parent of the resource, an organization. Format should be 'organizations/{organization_id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#parent GoogleSecurityposturePosture#parent}
    */
    readonly parent: string;
    /**
    * Id of the posture. It is an immutable field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#posture_id GoogleSecurityposturePosture#posture_id}
    */
    readonly postureId: string;
    /**
    * State of the posture. Update to state field should not be triggered along with
    * with other field updates. Possible values: ["DEPRECATED", "DRAFT", "ACTIVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#state GoogleSecurityposturePosture#state}
    */
    readonly state: string;
    /**
    * policy_sets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#policy_sets GoogleSecurityposturePosture#policy_sets}
    */
    readonly policySets: GoogleSecurityposturePosturePolicySets[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#timeouts GoogleSecurityposturePosture#timeouts}
    */
    readonly timeouts?: GoogleSecurityposturePostureTimeouts;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards {
    /**
    * Mapping of security controls for the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#control GoogleSecurityposturePosture#control}
    */
    readonly control?: string;
    /**
    * Mapping of compliance standards for the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#standard GoogleSecurityposturePosture#standard}
    */
    readonly standard?: string;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesComplianceStandardsToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards | cdktf.IResolvable): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesComplianceStandardsToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandardsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards | cdktf.IResolvable | undefined);
    private _control?;
    get control(): string;
    set control(value: string);
    resetControl(): void;
    get controlInput(): string | undefined;
    private _standard?;
    get standard(): string;
    set standard(value: string);
    resetStandard(): void;
    get standardInput(): string | undefined;
}
export declare class GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandardsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandardsOutputReference;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#expression GoogleSecurityposturePosture#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#location GoogleSecurityposturePosture#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#title GoogleSecurityposturePosture#title}
    */
    readonly title?: string;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesConditionToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesConditionOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesConditionToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesConditionOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues {
    /**
    * List of values allowed at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#allowed_values GoogleSecurityposturePosture#allowed_values}
    */
    readonly allowedValues?: string[];
    /**
    * List of values denied at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#denied_values GoogleSecurityposturePosture#denied_values}
    */
    readonly deniedValues?: string[];
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValuesToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValuesOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValuesToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValuesOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues | undefined);
    private _allowedValues?;
    get allowedValues(): string[];
    set allowedValues(value: string[]);
    resetAllowedValues(): void;
    get allowedValuesInput(): string[] | undefined;
    private _deniedValues?;
    get deniedValues(): string[];
    set deniedValues(value: string[]);
    resetDeniedValues(): void;
    get deniedValuesInput(): string[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules {
    /**
    * Setting this to true means that all values are allowed. This field can be set only in policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#allow_all GoogleSecurityposturePosture#allow_all}
    */
    readonly allowAll?: boolean | cdktf.IResolvable;
    /**
    * Setting this to true means that all values are denied. This field can be set only in policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#deny_all GoogleSecurityposturePosture#deny_all}
    */
    readonly denyAll?: boolean | cdktf.IResolvable;
    /**
    * If 'true', then the policy is enforced. If 'false', then any configuration is acceptable.
    * This field can be set only in policies for boolean constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#enforce GoogleSecurityposturePosture#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#condition GoogleSecurityposturePosture#condition}
    */
    readonly condition?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#values GoogleSecurityposturePosture#values}
    */
    readonly values?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules | cdktf.IResolvable): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules | cdktf.IResolvable | undefined);
    private _allowAll?;
    get allowAll(): boolean | cdktf.IResolvable;
    set allowAll(value: boolean | cdktf.IResolvable);
    resetAllowAll(): void;
    get allowAllInput(): boolean | cdktf.IResolvable | undefined;
    private _denyAll?;
    get denyAll(): boolean | cdktf.IResolvable;
    set denyAll(value: boolean | cdktf.IResolvable);
    resetDenyAll(): void;
    get denyAllInput(): boolean | cdktf.IResolvable | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    private _condition;
    get condition(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesConditionOutputReference;
    putCondition(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesCondition | undefined;
    private _values;
    get values(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValuesOutputReference;
    putValues(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues): void;
    resetValues(): void;
    get valuesInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesValues | undefined;
}
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesOutputReference;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint {
    /**
    * Organization policy canned constraint Id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#canned_constraint_id GoogleSecurityposturePosture#canned_constraint_id}
    */
    readonly cannedConstraintId: string;
    /**
    * policy_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#policy_rules GoogleSecurityposturePosture#policy_rules}
    */
    readonly policyRules: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules[] | cdktf.IResolvable;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint | undefined);
    private _cannedConstraintId?;
    get cannedConstraintId(): string;
    set cannedConstraintId(value: string);
    get cannedConstraintIdInput(): string | undefined;
    private _policyRules;
    get policyRules(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRulesList;
    putPolicyRules(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules[] | cdktf.IResolvable): void;
    get policyRulesInput(): cdktf.IResolvable | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintPolicyRules[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint {
    /**
    * The action to take if the condition is met. Possible values: ["ALLOW", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#action_type GoogleSecurityposturePosture#action_type}
    */
    readonly actionType: string;
    /**
    * A CEL condition that refers to a supported service resource, for example 'resource.management.autoUpgrade == false'. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#condition GoogleSecurityposturePosture#condition}
    */
    readonly condition: string;
    /**
    * A human-friendly description of the constraint to display as an error message when the policy is violated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * A human-friendly name for the constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#display_name GoogleSecurityposturePosture#display_name}
    */
    readonly displayName?: string;
    /**
    * A list of RESTful methods for which to enforce the constraint. Can be 'CREATE', 'UPDATE', or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#method_types GoogleSecurityposturePosture#method_types}
    */
    readonly methodTypes: string[];
    /**
    * Immutable. The name of the custom constraint. This is unique within the organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#name GoogleSecurityposturePosture#name}
    */
    readonly name: string;
    /**
    * Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, 'container.googleapis.com/NodePool'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#resource_types GoogleSecurityposturePosture#resource_types}
    */
    readonly resourceTypes: string[];
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraintToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraintOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraintToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraintOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _condition?;
    get condition(): string;
    set condition(value: string);
    get conditionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _methodTypes?;
    get methodTypes(): string[];
    set methodTypes(value: string[]);
    get methodTypesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    get resourceTypesInput(): string[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#expression GoogleSecurityposturePosture#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#location GoogleSecurityposturePosture#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#title GoogleSecurityposturePosture#title}
    */
    readonly title?: string;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesConditionToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesConditionOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesConditionToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesConditionOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues {
    /**
    * List of values allowed at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#allowed_values GoogleSecurityposturePosture#allowed_values}
    */
    readonly allowedValues?: string[];
    /**
    * List of values denied at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#denied_values GoogleSecurityposturePosture#denied_values}
    */
    readonly deniedValues?: string[];
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValuesToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValuesOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValuesToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValuesOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues | undefined);
    private _allowedValues?;
    get allowedValues(): string[];
    set allowedValues(value: string[]);
    resetAllowedValues(): void;
    get allowedValuesInput(): string[] | undefined;
    private _deniedValues?;
    get deniedValues(): string[];
    set deniedValues(value: string[]);
    resetDeniedValues(): void;
    get deniedValuesInput(): string[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules {
    /**
    * Setting this to true means that all values are allowed. This field can be set only in policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#allow_all GoogleSecurityposturePosture#allow_all}
    */
    readonly allowAll?: boolean | cdktf.IResolvable;
    /**
    * Setting this to true means that all values are denied. This field can be set only in policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#deny_all GoogleSecurityposturePosture#deny_all}
    */
    readonly denyAll?: boolean | cdktf.IResolvable;
    /**
    * If 'true', then the policy is enforced. If 'false', then any configuration is acceptable.
    * This field can be set only in policies for boolean constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#enforce GoogleSecurityposturePosture#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#condition GoogleSecurityposturePosture#condition}
    */
    readonly condition?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#values GoogleSecurityposturePosture#values}
    */
    readonly values?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules | cdktf.IResolvable): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules | cdktf.IResolvable | undefined);
    private _allowAll?;
    get allowAll(): boolean | cdktf.IResolvable;
    set allowAll(value: boolean | cdktf.IResolvable);
    resetAllowAll(): void;
    get allowAllInput(): boolean | cdktf.IResolvable | undefined;
    private _denyAll?;
    get denyAll(): boolean | cdktf.IResolvable;
    set denyAll(value: boolean | cdktf.IResolvable);
    resetDenyAll(): void;
    get denyAllInput(): boolean | cdktf.IResolvable | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    private _condition;
    get condition(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesConditionOutputReference;
    putCondition(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesCondition | undefined;
    private _values;
    get values(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValuesOutputReference;
    putValues(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues): void;
    resetValues(): void;
    get valuesInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesValues | undefined;
}
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesOutputReference;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom {
    /**
    * custom_constraint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#custom_constraint GoogleSecurityposturePosture#custom_constraint}
    */
    readonly customConstraint?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint;
    /**
    * policy_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#policy_rules GoogleSecurityposturePosture#policy_rules}
    */
    readonly policyRules: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules[] | cdktf.IResolvable;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom | undefined);
    private _customConstraint;
    get customConstraint(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraintOutputReference;
    putCustomConstraint(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint): void;
    resetCustomConstraint(): void;
    get customConstraintInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomCustomConstraint | undefined;
    private _policyRules;
    get policyRules(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRulesList;
    putPolicyRules(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules[] | cdktf.IResolvable): void;
    get policyRulesInput(): cdktf.IResolvable | GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomPolicyRules[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#expression GoogleSecurityposturePosture#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#location GoogleSecurityposturePosture#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#title GoogleSecurityposturePosture#title}
    */
    readonly title?: string;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpressionToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpressionToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties {
    /**
    * Name of the property for the custom output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#name GoogleSecurityposturePosture#name}
    */
    readonly name: string;
    /**
    * value_expression block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#value_expression GoogleSecurityposturePosture#value_expression}
    */
    readonly valueExpression?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _valueExpression;
    get valueExpression(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpressionOutputReference;
    putValueExpression(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression): void;
    resetValueExpression(): void;
    get valueExpressionInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesValueExpression | undefined;
}
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesOutputReference;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput {
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#properties GoogleSecurityposturePosture#properties}
    */
    readonly properties?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties[] | cdktf.IResolvable;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput | undefined);
    private _properties;
    get properties(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputPropertiesList;
    putProperties(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputProperties[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#expression GoogleSecurityposturePosture#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#location GoogleSecurityposturePosture#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#title GoogleSecurityposturePosture#title}
    */
    readonly title?: string;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicateToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicateOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicateToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicateOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector {
    /**
    * The resource types to run the detector on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#resource_types GoogleSecurityposturePosture#resource_types}
    */
    readonly resourceTypes: string[];
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelectorToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelectorOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelectorToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelectorOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector | undefined);
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    get resourceTypesInput(): string[] | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig {
    /**
    * Text that describes the vulnerability or misconfiguration that the custom
    * module detects.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * An explanation of the recommended steps that security teams can take to
    * resolve the detected issue
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#recommendation GoogleSecurityposturePosture#recommendation}
    */
    readonly recommendation?: string;
    /**
    * The severity to assign to findings generated by the module. Possible values: ["SEVERITY_UNSPECIFIED", "CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#severity GoogleSecurityposturePosture#severity}
    */
    readonly severity: string;
    /**
    * custom_output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#custom_output GoogleSecurityposturePosture#custom_output}
    */
    readonly customOutput?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput;
    /**
    * predicate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#predicate GoogleSecurityposturePosture#predicate}
    */
    readonly predicate: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate;
    /**
    * resource_selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#resource_selector GoogleSecurityposturePosture#resource_selector}
    */
    readonly resourceSelector: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _recommendation?;
    get recommendation(): string;
    set recommendation(value: string);
    resetRecommendation(): void;
    get recommendationInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _customOutput;
    get customOutput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutputOutputReference;
    putCustomOutput(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput): void;
    resetCustomOutput(): void;
    get customOutputInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigCustomOutput | undefined;
    private _predicate;
    get predicate(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicateOutputReference;
    putPredicate(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate): void;
    get predicateInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigPredicate | undefined;
    private _resourceSelector;
    get resourceSelector(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelectorOutputReference;
    putResourceSelector(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector): void;
    get resourceSelectorInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigResourceSelector | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule {
    /**
    * The display name of the Security Health Analytics custom module. This
    * display name becomes the finding category for all findings that are
    * returned by this custom module.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#display_name GoogleSecurityposturePosture#display_name}
    */
    readonly displayName?: string;
    /**
    * The state of enablement for the module at its level of the resource hierarchy. Possible values: ["ENABLEMENT_STATE_UNSPECIFIED", "ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#module_enablement_state GoogleSecurityposturePosture#module_enablement_state}
    */
    readonly moduleEnablementState?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#config GoogleSecurityposturePosture#config}
    */
    readonly config: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _moduleEnablementState?;
    get moduleEnablementState(): string;
    set moduleEnablementState(value: string);
    resetModuleEnablementState(): void;
    get moduleEnablementStateInput(): string | undefined;
    private _config;
    get config(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfigOutputReference;
    putConfig(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig): void;
    get configInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleConfig | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule {
    /**
    * The state of enablement for the module at its level of the resource hierarchy. Possible values: ["ENABLEMENT_STATE_UNSPECIFIED", "ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#module_enablement_state GoogleSecurityposturePosture#module_enablement_state}
    */
    readonly moduleEnablementState?: string;
    /**
    * The name of the module eg: BIGQUERY_TABLE_CMEK_DISABLED.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#module_name GoogleSecurityposturePosture#module_name}
    */
    readonly moduleName: string;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModuleToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModuleOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModuleToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModuleOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule | undefined);
    private _moduleEnablementState?;
    get moduleEnablementState(): string;
    set moduleEnablementState(value: string);
    resetModuleEnablementState(): void;
    get moduleEnablementStateInput(): string | undefined;
    private _moduleName?;
    get moduleName(): string;
    set moduleName(value: string);
    get moduleNameInput(): string | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPoliciesConstraint {
    /**
    * org_policy_constraint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#org_policy_constraint GoogleSecurityposturePosture#org_policy_constraint}
    */
    readonly orgPolicyConstraint?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint;
    /**
    * org_policy_constraint_custom block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#org_policy_constraint_custom GoogleSecurityposturePosture#org_policy_constraint_custom}
    */
    readonly orgPolicyConstraintCustom?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom;
    /**
    * security_health_analytics_custom_module block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#security_health_analytics_custom_module GoogleSecurityposturePosture#security_health_analytics_custom_module}
    */
    readonly securityHealthAnalyticsCustomModule?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule;
    /**
    * security_health_analytics_module block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#security_health_analytics_module GoogleSecurityposturePosture#security_health_analytics_module}
    */
    readonly securityHealthAnalyticsModule?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraint): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesConstraintToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOutputReference | GoogleSecurityposturePosturePolicySetsPoliciesConstraint): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPoliciesConstraint | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraint | undefined);
    private _orgPolicyConstraint;
    get orgPolicyConstraint(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintOutputReference;
    putOrgPolicyConstraint(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint): void;
    resetOrgPolicyConstraint(): void;
    get orgPolicyConstraintInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraint | undefined;
    private _orgPolicyConstraintCustom;
    get orgPolicyConstraintCustom(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustomOutputReference;
    putOrgPolicyConstraintCustom(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom): void;
    resetOrgPolicyConstraintCustom(): void;
    get orgPolicyConstraintCustomInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOrgPolicyConstraintCustom | undefined;
    private _securityHealthAnalyticsCustomModule;
    get securityHealthAnalyticsCustomModule(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModuleOutputReference;
    putSecurityHealthAnalyticsCustomModule(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule): void;
    resetSecurityHealthAnalyticsCustomModule(): void;
    get securityHealthAnalyticsCustomModuleInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsCustomModule | undefined;
    private _securityHealthAnalyticsModule;
    get securityHealthAnalyticsModule(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModuleOutputReference;
    putSecurityHealthAnalyticsModule(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule): void;
    resetSecurityHealthAnalyticsModule(): void;
    get securityHealthAnalyticsModuleInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintSecurityHealthAnalyticsModule | undefined;
}
export interface GoogleSecurityposturePosturePolicySetsPolicies {
    /**
    * Description of the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * ID of the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#policy_id GoogleSecurityposturePosture#policy_id}
    */
    readonly policyId: string;
    /**
    * compliance_standards block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#compliance_standards GoogleSecurityposturePosture#compliance_standards}
    */
    readonly complianceStandards?: GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards[] | cdktf.IResolvable;
    /**
    * constraint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#constraint GoogleSecurityposturePosture#constraint}
    */
    readonly constraint: GoogleSecurityposturePosturePolicySetsPoliciesConstraint;
}
export declare function googleSecurityposturePosturePolicySetsPoliciesToTerraform(struct?: GoogleSecurityposturePosturePolicySetsPolicies | cdktf.IResolvable): any;
export declare function googleSecurityposturePosturePolicySetsPoliciesToHclTerraform(struct?: GoogleSecurityposturePosturePolicySetsPolicies | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePosturePolicySetsPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecurityposturePosturePolicySetsPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySetsPolicies | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _complianceStandards;
    get complianceStandards(): GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandardsList;
    putComplianceStandards(value: GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards[] | cdktf.IResolvable): void;
    resetComplianceStandards(): void;
    get complianceStandardsInput(): cdktf.IResolvable | GoogleSecurityposturePosturePolicySetsPoliciesComplianceStandards[] | undefined;
    private _constraint;
    get constraint(): GoogleSecurityposturePosturePolicySetsPoliciesConstraintOutputReference;
    putConstraint(value: GoogleSecurityposturePosturePolicySetsPoliciesConstraint): void;
    get constraintInput(): GoogleSecurityposturePosturePolicySetsPoliciesConstraint | undefined;
}
export declare class GoogleSecurityposturePosturePolicySetsPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecurityposturePosturePolicySetsPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecurityposturePosturePolicySetsPoliciesOutputReference;
}
export interface GoogleSecurityposturePosturePolicySets {
    /**
    * Description of the policy set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#description GoogleSecurityposturePosture#description}
    */
    readonly description?: string;
    /**
    * ID of the policy set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#policy_set_id GoogleSecurityposturePosture#policy_set_id}
    */
    readonly policySetId: string;
    /**
    * policies block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#policies GoogleSecurityposturePosture#policies}
    */
    readonly policies: GoogleSecurityposturePosturePolicySetsPolicies[] | cdktf.IResolvable;
}
export declare function googleSecurityposturePosturePolicySetsToTerraform(struct?: GoogleSecurityposturePosturePolicySets | cdktf.IResolvable): any;
export declare function googleSecurityposturePosturePolicySetsToHclTerraform(struct?: GoogleSecurityposturePosturePolicySets | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePosturePolicySetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecurityposturePosturePolicySets | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePosturePolicySets | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _policySetId?;
    get policySetId(): string;
    set policySetId(value: string);
    get policySetIdInput(): string | undefined;
    private _policies;
    get policies(): GoogleSecurityposturePosturePolicySetsPoliciesList;
    putPolicies(value: GoogleSecurityposturePosturePolicySetsPolicies[] | cdktf.IResolvable): void;
    get policiesInput(): cdktf.IResolvable | GoogleSecurityposturePosturePolicySetsPolicies[] | undefined;
}
export declare class GoogleSecurityposturePosturePolicySetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecurityposturePosturePolicySets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecurityposturePosturePolicySetsOutputReference;
}
export interface GoogleSecurityposturePostureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#create GoogleSecurityposturePosture#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#delete GoogleSecurityposturePosture#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#update GoogleSecurityposturePosture#update}
    */
    readonly update?: string;
}
export declare function googleSecurityposturePostureTimeoutsToTerraform(struct?: GoogleSecurityposturePostureTimeouts | cdktf.IResolvable): any;
export declare function googleSecurityposturePostureTimeoutsToHclTerraform(struct?: GoogleSecurityposturePostureTimeouts | cdktf.IResolvable): any;
export declare class GoogleSecurityposturePostureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityposturePostureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityposturePostureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture google_securityposture_posture}
*/
export declare class GoogleSecurityposturePosture extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_securityposture_posture";
    /**
    * Generates CDKTF code for importing a GoogleSecurityposturePosture resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSecurityposturePosture to import
    * @param importFromId The id of the existing GoogleSecurityposturePosture that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSecurityposturePosture to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_securityposture_posture google_securityposture_posture} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecurityposturePostureConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecurityposturePostureConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _postureId?;
    get postureId(): string;
    set postureId(value: string);
    get postureIdInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get revisionId(): string;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
    get updateTime(): string;
    private _policySets;
    get policySets(): GoogleSecurityposturePosturePolicySetsList;
    putPolicySets(value: GoogleSecurityposturePosturePolicySets[] | cdktf.IResolvable): void;
    get policySetsInput(): cdktf.IResolvable | GoogleSecurityposturePosturePolicySets[] | undefined;
    private _timeouts;
    get timeouts(): GoogleSecurityposturePostureTimeoutsOutputReference;
    putTimeouts(value: GoogleSecurityposturePostureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSecurityposturePostureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
