/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The account id that is used to generate the service account email address and a stable unique id. It is unique within a project, must be 6-30 characters long, and match the regular expression [a-z]([-a-z0-9]*[a-z0-9]) to comply with RFC1035. Changing this forces a new service account to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#account_id GoogleServiceAccount#account_id}
    */
    readonly accountId: string;
    /**
    * If set to true, skip service account creation if a service account with the same email already exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#create_ignore_already_exists GoogleServiceAccount#create_ignore_already_exists}
    */
    readonly createIgnoreAlreadyExists?: boolean | cdktf.IResolvable;
    /**
    * A text description of the service account. Must be less than or equal to 256 UTF-8 bytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#description GoogleServiceAccount#description}
    */
    readonly description?: string;
    /**
    * Whether the service account is disabled. Defaults to false
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#disabled GoogleServiceAccount#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The display name for the service account. Can be updated without creating a new resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#display_name GoogleServiceAccount#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#id GoogleServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#project GoogleServiceAccount#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#timeouts GoogleServiceAccount#timeouts}
    */
    readonly timeouts?: GoogleServiceAccountTimeouts;
}
export interface GoogleServiceAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#create GoogleServiceAccount#create}
    */
    readonly create?: string;
}
export declare function googleServiceAccountTimeoutsToTerraform(struct?: GoogleServiceAccountTimeouts | cdktf.IResolvable): any;
export declare function googleServiceAccountTimeoutsToHclTerraform(struct?: GoogleServiceAccountTimeouts | cdktf.IResolvable): any;
export declare class GoogleServiceAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleServiceAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account google_service_account}
*/
export declare class GoogleServiceAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_account";
    /**
    * Generates CDKTF code for importing a GoogleServiceAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleServiceAccount to import
    * @param importFromId The id of the existing GoogleServiceAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleServiceAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_account google_service_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceAccountConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceAccountConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _createIgnoreAlreadyExists?;
    get createIgnoreAlreadyExists(): boolean | cdktf.IResolvable;
    set createIgnoreAlreadyExists(value: boolean | cdktf.IResolvable);
    resetCreateIgnoreAlreadyExists(): void;
    get createIgnoreAlreadyExistsInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get member(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uniqueId(): string;
    private _timeouts;
    get timeouts(): GoogleServiceAccountTimeoutsOutputReference;
    putTimeouts(value: GoogleServiceAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleServiceAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
