/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceDirectoryServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#id GoogleServiceDirectoryService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Metadata for the service. This data can be consumed
    * by service clients. The entire metadata dictionary may contain
    * up to 2000 characters, spread across all key-value pairs.
    * Metadata that goes beyond any these limits will be rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#metadata GoogleServiceDirectoryService#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The resource name of the namespace this service will belong to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#namespace GoogleServiceDirectoryService#namespace}
    */
    readonly namespace: string;
    /**
    * The Resource ID must be 1-63 characters long, including digits,
    * lowercase letters or the hyphen character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#service_id GoogleServiceDirectoryService#service_id}
    */
    readonly serviceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#timeouts GoogleServiceDirectoryService#timeouts}
    */
    readonly timeouts?: GoogleServiceDirectoryServiceTimeouts;
}
export interface GoogleServiceDirectoryServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#create GoogleServiceDirectoryService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#delete GoogleServiceDirectoryService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#update GoogleServiceDirectoryService#update}
    */
    readonly update?: string;
}
export declare function googleServiceDirectoryServiceTimeoutsToTerraform(struct?: GoogleServiceDirectoryServiceTimeouts | cdktf.IResolvable): any;
export declare function googleServiceDirectoryServiceTimeoutsToHclTerraform(struct?: GoogleServiceDirectoryServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleServiceDirectoryServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceDirectoryServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleServiceDirectoryServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service google_service_directory_service}
*/
export declare class GoogleServiceDirectoryService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_directory_service";
    /**
    * Generates CDKTF code for importing a GoogleServiceDirectoryService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleServiceDirectoryService to import
    * @param importFromId The id of the existing GoogleServiceDirectoryService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleServiceDirectoryService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_directory_service google_service_directory_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceDirectoryServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceDirectoryServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleServiceDirectoryServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleServiceDirectoryServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleServiceDirectoryServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
