/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceNetworkingConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * When set to ABANDON, terraform will abandon management of the resource instead of deleting it. Prevents terraform apply failures with CloudSQL. Note: The resource will still exist.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#deletion_policy GoogleServiceNetworkingConnection#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#id GoogleServiceNetworkingConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of VPC network connected with service producers using VPC peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#network GoogleServiceNetworkingConnection#network}
    */
    readonly network: string;
    /**
    * Named IP address range(s) of PEERING type reserved for this service provider. Note that invoking this method with a different range when connection is already established will not reallocate already provisioned service producer subnetworks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#reserved_peering_ranges GoogleServiceNetworkingConnection#reserved_peering_ranges}
    */
    readonly reservedPeeringRanges: string[];
    /**
    * Provider peering service that is managing peering connectivity for a service provider organization. For Google services that support this functionality it is 'servicenetworking.googleapis.com'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#service GoogleServiceNetworkingConnection#service}
    */
    readonly service: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#timeouts GoogleServiceNetworkingConnection#timeouts}
    */
    readonly timeouts?: GoogleServiceNetworkingConnectionTimeouts;
}
export interface GoogleServiceNetworkingConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#create GoogleServiceNetworkingConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#delete GoogleServiceNetworkingConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#update GoogleServiceNetworkingConnection#update}
    */
    readonly update?: string;
}
export declare function googleServiceNetworkingConnectionTimeoutsToTerraform(struct?: GoogleServiceNetworkingConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleServiceNetworkingConnectionTimeoutsToHclTerraform(struct?: GoogleServiceNetworkingConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleServiceNetworkingConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceNetworkingConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleServiceNetworkingConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection google_service_networking_connection}
*/
export declare class GoogleServiceNetworkingConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_networking_connection";
    /**
    * Generates CDKTF code for importing a GoogleServiceNetworkingConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleServiceNetworkingConnection to import
    * @param importFromId The id of the existing GoogleServiceNetworkingConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleServiceNetworkingConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_networking_connection google_service_networking_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceNetworkingConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceNetworkingConnectionConfig);
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    get peering(): string;
    private _reservedPeeringRanges?;
    get reservedPeeringRanges(): string[];
    set reservedPeeringRanges(value: string[]);
    get reservedPeeringRangesInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleServiceNetworkingConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleServiceNetworkingConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleServiceNetworkingConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
