/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceUsageConsumerQuotaOverrideConfig extends cdktf.TerraformMetaArguments {
    /**
    * If this map is nonempty, then this override applies only to specific values for dimensions defined in the limit unit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#dimensions GoogleServiceUsageConsumerQuotaOverride#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * If the new quota would decrease the existing quota by more than 10%, the request is rejected.
    * If 'force' is 'true', that safety check is ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#force GoogleServiceUsageConsumerQuotaOverride#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#id GoogleServiceUsageConsumerQuotaOverride#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The limit on the metric, e.g. '/project/region'.
    *
    * ~> Make sure that 'limit' is in a format that doesn't start with '1/' or contain curly braces.
    * E.g. use '/project/user' instead of '1/{project}/{user}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#limit GoogleServiceUsageConsumerQuotaOverride#limit}
    */
    readonly limit: string;
    /**
    * The metric that should be limited, e.g. 'compute.googleapis.com/cpus'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#metric GoogleServiceUsageConsumerQuotaOverride#metric}
    */
    readonly metric: string;
    /**
    * The overriding quota limit value. Can be any nonnegative integer, or -1 (unlimited quota).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#override_value GoogleServiceUsageConsumerQuotaOverride#override_value}
    */
    readonly overrideValue: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#project GoogleServiceUsageConsumerQuotaOverride#project}
    */
    readonly project?: string;
    /**
    * The service that the metrics belong to, e.g. 'compute.googleapis.com'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#service GoogleServiceUsageConsumerQuotaOverride#service}
    */
    readonly service: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#timeouts GoogleServiceUsageConsumerQuotaOverride#timeouts}
    */
    readonly timeouts?: GoogleServiceUsageConsumerQuotaOverrideTimeouts;
}
export interface GoogleServiceUsageConsumerQuotaOverrideTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#create GoogleServiceUsageConsumerQuotaOverride#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#delete GoogleServiceUsageConsumerQuotaOverride#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#update GoogleServiceUsageConsumerQuotaOverride#update}
    */
    readonly update?: string;
}
export declare function googleServiceUsageConsumerQuotaOverrideTimeoutsToTerraform(struct?: GoogleServiceUsageConsumerQuotaOverrideTimeouts | cdktf.IResolvable): any;
export declare function googleServiceUsageConsumerQuotaOverrideTimeoutsToHclTerraform(struct?: GoogleServiceUsageConsumerQuotaOverrideTimeouts | cdktf.IResolvable): any;
export declare class GoogleServiceUsageConsumerQuotaOverrideTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceUsageConsumerQuotaOverrideTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleServiceUsageConsumerQuotaOverrideTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override google_service_usage_consumer_quota_override}
*/
export declare class GoogleServiceUsageConsumerQuotaOverride extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_usage_consumer_quota_override";
    /**
    * Generates CDKTF code for importing a GoogleServiceUsageConsumerQuotaOverride resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleServiceUsageConsumerQuotaOverride to import
    * @param importFromId The id of the existing GoogleServiceUsageConsumerQuotaOverride that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleServiceUsageConsumerQuotaOverride to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_service_usage_consumer_quota_override google_service_usage_consumer_quota_override} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceUsageConsumerQuotaOverrideConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceUsageConsumerQuotaOverrideConfig);
    private _dimensions?;
    get dimensions(): {
        [key: string]: string;
    };
    set dimensions(value: {
        [key: string]: string;
    });
    resetDimensions(): void;
    get dimensionsInput(): {
        [key: string]: string;
    } | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _limit?;
    get limit(): string;
    set limit(value: string);
    get limitInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    get name(): string;
    private _overrideValue?;
    get overrideValue(): string;
    set overrideValue(value: string);
    get overrideValueInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleServiceUsageConsumerQuotaOverrideTimeoutsOutputReference;
    putTimeouts(value: GoogleServiceUsageConsumerQuotaOverrideTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleServiceUsageConsumerQuotaOverrideTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
