/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#id GoogleSourcerepoRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name of the repository, of the form '{{repo}}'.
    * The repo name may contain slashes. eg, 'name/with/slash'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#name GoogleSourcerepoRepository#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#project GoogleSourcerepoRepository#project}
    */
    readonly project?: string;
    /**
    * pubsub_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#pubsub_configs GoogleSourcerepoRepository#pubsub_configs}
    */
    readonly pubsubConfigs?: GoogleSourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#timeouts GoogleSourcerepoRepository#timeouts}
    */
    readonly timeouts?: GoogleSourcerepoRepositoryTimeouts;
}
export interface GoogleSourcerepoRepositoryPubsubConfigs {
    /**
    * The format of the Cloud Pub/Sub messages.
    * - PROTOBUF: The message payload is a serialized protocol buffer of SourceRepoEvent.
    * - JSON: The message payload is a JSON string of SourceRepoEvent. Possible values: ["PROTOBUF", "JSON"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#message_format GoogleSourcerepoRepository#message_format}
    */
    readonly messageFormat: string;
    /**
    * Email address of the service account used for publishing Cloud Pub/Sub messages.
    * This service account needs to be in the same project as the PubsubConfig. When added,
    * the caller needs to have iam.serviceAccounts.actAs permission on this service account.
    * If unspecified, it defaults to the compute engine default service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#service_account_email GoogleSourcerepoRepository#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#topic GoogleSourcerepoRepository#topic}
    */
    readonly topic: string;
}
export declare function googleSourcerepoRepositoryPubsubConfigsToTerraform(struct?: GoogleSourcerepoRepositoryPubsubConfigs | cdktf.IResolvable): any;
export declare function googleSourcerepoRepositoryPubsubConfigsToHclTerraform(struct?: GoogleSourcerepoRepositoryPubsubConfigs | cdktf.IResolvable): any;
export declare class GoogleSourcerepoRepositoryPubsubConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSourcerepoRepositoryPubsubConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSourcerepoRepositoryPubsubConfigs | cdktf.IResolvable | undefined);
    private _messageFormat?;
    get messageFormat(): string;
    set messageFormat(value: string);
    get messageFormatInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export declare class GoogleSourcerepoRepositoryPubsubConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSourcerepoRepositoryPubsubConfigsOutputReference;
}
export interface GoogleSourcerepoRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#create GoogleSourcerepoRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#delete GoogleSourcerepoRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#update GoogleSourcerepoRepository#update}
    */
    readonly update?: string;
}
export declare function googleSourcerepoRepositoryTimeoutsToTerraform(struct?: GoogleSourcerepoRepositoryTimeouts | cdktf.IResolvable): any;
export declare function googleSourcerepoRepositoryTimeoutsToHclTerraform(struct?: GoogleSourcerepoRepositoryTimeouts | cdktf.IResolvable): any;
export declare class GoogleSourcerepoRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSourcerepoRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSourcerepoRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository google_sourcerepo_repository}
*/
export declare class GoogleSourcerepoRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sourcerepo_repository";
    /**
    * Generates CDKTF code for importing a GoogleSourcerepoRepository resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSourcerepoRepository to import
    * @param importFromId The id of the existing GoogleSourcerepoRepository that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSourcerepoRepository to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sourcerepo_repository google_sourcerepo_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSourcerepoRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSourcerepoRepositoryConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get size(): number;
    get url(): string;
    private _pubsubConfigs;
    get pubsubConfigs(): GoogleSourcerepoRepositoryPubsubConfigsList;
    putPubsubConfigs(value: GoogleSourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable): void;
    resetPubsubConfigs(): void;
    get pubsubConfigsInput(): cdktf.IResolvable | GoogleSourcerepoRepositoryPubsubConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleSourcerepoRepositoryTimeoutsOutputReference;
    putTimeouts(value: GoogleSourcerepoRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSourcerepoRepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
