/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSpannerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the instance's configuration (similar but not
    * quite the same as a region) which defines the geographic placement and
    * replication of your databases in this instance. It determines where your data
    * is stored. Values are typically of the form 'regional-europe-west1' , 'us-central' etc.
    * In order to obtain a valid list please consult the
    * [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#config GoogleSpannerInstance#config}
    */
    readonly config: string;
    /**
    * The descriptive name for this instance as it appears in UIs. Must be
    * unique per project and between 4 and 30 characters in length.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#display_name GoogleSpannerInstance#display_name}
    */
    readonly displayName: string;
    /**
    * When deleting a spanner instance, this boolean option will delete all backups of this instance.
    * This must be set to true if you created a backup manually in the console.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#force_destroy GoogleSpannerInstance#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#id GoogleSpannerInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#labels GoogleSpannerInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A unique identifier for the instance, which cannot be changed after
    * the instance is created. The name must be between 6 and 30 characters
    * in length.
    *
    *
    * If not provided, a random string starting with 'tf-' will be selected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#name GoogleSpannerInstance#name}
    */
    readonly name?: string;
    /**
    * The number of nodes allocated to this instance. Exactly one of either node_count or processing_units
    * must be present in terraform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#num_nodes GoogleSpannerInstance#num_nodes}
    */
    readonly numNodes?: number;
    /**
    * The number of processing units allocated to this instance. Exactly one of processing_units
    * or node_count must be present in terraform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#processing_units GoogleSpannerInstance#processing_units}
    */
    readonly processingUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#project GoogleSpannerInstance#project}
    */
    readonly project?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#autoscaling_config GoogleSpannerInstance#autoscaling_config}
    */
    readonly autoscalingConfig?: GoogleSpannerInstanceAutoscalingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#timeouts GoogleSpannerInstance#timeouts}
    */
    readonly timeouts?: GoogleSpannerInstanceTimeouts;
}
export interface GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits {
    /**
    * Specifies maximum number of nodes allocated to the instance. If set, this number
    * should be greater than or equal to min_nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#max_nodes GoogleSpannerInstance#max_nodes}
    */
    readonly maxNodes?: number;
    /**
    * Specifies maximum number of processing units allocated to the instance.
    * If set, this number should be multiples of 1000 and be greater than or equal to
    * min_processing_units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#max_processing_units GoogleSpannerInstance#max_processing_units}
    */
    readonly maxProcessingUnits?: number;
    /**
    * Specifies number of nodes allocated to the instance. If set, this number
    * should be greater than or equal to 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#min_nodes GoogleSpannerInstance#min_nodes}
    */
    readonly minNodes?: number;
    /**
    * Specifies minimum number of processing units allocated to the instance.
    * If set, this number should be multiples of 1000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#min_processing_units GoogleSpannerInstance#min_processing_units}
    */
    readonly minProcessingUnits?: number;
}
export declare function googleSpannerInstanceAutoscalingConfigAutoscalingLimitsToTerraform(struct?: GoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsOutputReference | GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits): any;
export declare function googleSpannerInstanceAutoscalingConfigAutoscalingLimitsToHclTerraform(struct?: GoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsOutputReference | GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits): any;
export declare class GoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits | undefined;
    set internalValue(value: GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits | undefined);
    private _maxNodes?;
    get maxNodes(): number;
    set maxNodes(value: number);
    resetMaxNodes(): void;
    get maxNodesInput(): number | undefined;
    private _maxProcessingUnits?;
    get maxProcessingUnits(): number;
    set maxProcessingUnits(value: number);
    resetMaxProcessingUnits(): void;
    get maxProcessingUnitsInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number;
    set minNodes(value: number);
    resetMinNodes(): void;
    get minNodesInput(): number | undefined;
    private _minProcessingUnits?;
    get minProcessingUnits(): number;
    set minProcessingUnits(value: number);
    resetMinProcessingUnits(): void;
    get minProcessingUnitsInput(): number | undefined;
}
export interface GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets {
    /**
    * Specifies the target high priority cpu utilization percentage that the autoscaler
    * should be trying to achieve for the instance.
    * This number is on a scale from 0 (no utilization) to 100 (full utilization)..
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#high_priority_cpu_utilization_percent GoogleSpannerInstance#high_priority_cpu_utilization_percent}
    */
    readonly highPriorityCpuUtilizationPercent?: number;
    /**
    * Specifies the target storage utilization percentage that the autoscaler
    * should be trying to achieve for the instance.
    * This number is on a scale from 0 (no utilization) to 100 (full utilization).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#storage_utilization_percent GoogleSpannerInstance#storage_utilization_percent}
    */
    readonly storageUtilizationPercent?: number;
}
export declare function googleSpannerInstanceAutoscalingConfigAutoscalingTargetsToTerraform(struct?: GoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsOutputReference | GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets): any;
export declare function googleSpannerInstanceAutoscalingConfigAutoscalingTargetsToHclTerraform(struct?: GoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsOutputReference | GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets): any;
export declare class GoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets | undefined;
    set internalValue(value: GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets | undefined);
    private _highPriorityCpuUtilizationPercent?;
    get highPriorityCpuUtilizationPercent(): number;
    set highPriorityCpuUtilizationPercent(value: number);
    resetHighPriorityCpuUtilizationPercent(): void;
    get highPriorityCpuUtilizationPercentInput(): number | undefined;
    private _storageUtilizationPercent?;
    get storageUtilizationPercent(): number;
    set storageUtilizationPercent(value: number);
    resetStorageUtilizationPercent(): void;
    get storageUtilizationPercentInput(): number | undefined;
}
export interface GoogleSpannerInstanceAutoscalingConfig {
    /**
    * autoscaling_limits block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#autoscaling_limits GoogleSpannerInstance#autoscaling_limits}
    */
    readonly autoscalingLimits?: GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits;
    /**
    * autoscaling_targets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#autoscaling_targets GoogleSpannerInstance#autoscaling_targets}
    */
    readonly autoscalingTargets?: GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets;
}
export declare function googleSpannerInstanceAutoscalingConfigToTerraform(struct?: GoogleSpannerInstanceAutoscalingConfigOutputReference | GoogleSpannerInstanceAutoscalingConfig): any;
export declare function googleSpannerInstanceAutoscalingConfigToHclTerraform(struct?: GoogleSpannerInstanceAutoscalingConfigOutputReference | GoogleSpannerInstanceAutoscalingConfig): any;
export declare class GoogleSpannerInstanceAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSpannerInstanceAutoscalingConfig | undefined;
    set internalValue(value: GoogleSpannerInstanceAutoscalingConfig | undefined);
    private _autoscalingLimits;
    get autoscalingLimits(): GoogleSpannerInstanceAutoscalingConfigAutoscalingLimitsOutputReference;
    putAutoscalingLimits(value: GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits): void;
    resetAutoscalingLimits(): void;
    get autoscalingLimitsInput(): GoogleSpannerInstanceAutoscalingConfigAutoscalingLimits | undefined;
    private _autoscalingTargets;
    get autoscalingTargets(): GoogleSpannerInstanceAutoscalingConfigAutoscalingTargetsOutputReference;
    putAutoscalingTargets(value: GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets): void;
    resetAutoscalingTargets(): void;
    get autoscalingTargetsInput(): GoogleSpannerInstanceAutoscalingConfigAutoscalingTargets | undefined;
}
export interface GoogleSpannerInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#create GoogleSpannerInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#delete GoogleSpannerInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#update GoogleSpannerInstance#update}
    */
    readonly update?: string;
}
export declare function googleSpannerInstanceTimeoutsToTerraform(struct?: GoogleSpannerInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleSpannerInstanceTimeoutsToHclTerraform(struct?: GoogleSpannerInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleSpannerInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSpannerInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSpannerInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance google_spanner_instance}
*/
export declare class GoogleSpannerInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_spanner_instance";
    /**
    * Generates CDKTF code for importing a GoogleSpannerInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSpannerInstance to import
    * @param importFromId The id of the existing GoogleSpannerInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSpannerInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_spanner_instance google_spanner_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSpannerInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSpannerInstanceConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    get configInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _numNodes?;
    get numNodes(): number;
    set numNodes(value: number);
    resetNumNodes(): void;
    get numNodesInput(): number | undefined;
    private _processingUnits?;
    get processingUnits(): number;
    set processingUnits(value: number);
    resetProcessingUnits(): void;
    get processingUnitsInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _autoscalingConfig;
    get autoscalingConfig(): GoogleSpannerInstanceAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: GoogleSpannerInstanceAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): GoogleSpannerInstanceAutoscalingConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSpannerInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleSpannerInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSpannerInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
