/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The charset value. See MySQL's
    * [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
    * and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
    * for more details and supported values. Postgres databases only support
    * a value of 'UTF8' at creation time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#charset GoogleSqlDatabase#charset}
    */
    readonly charset?: string;
    /**
    * The collation value. See MySQL's
    * [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
    * and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
    * for more details and supported values. Postgres databases only support
    * a value of 'en_US.UTF8' at creation time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#collation GoogleSqlDatabase#collation}
    */
    readonly collation?: string;
    /**
    * The deletion policy for the database. Setting ABANDON allows the resource
    * to be abandoned rather than deleted. This is useful for Postgres, where databases cannot be
    * deleted from the API if there are users other than cloudsqlsuperuser with access. Possible
    * values are: "ABANDON", "DELETE". Defaults to "DELETE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#deletion_policy GoogleSqlDatabase#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#id GoogleSqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. This does not include the project
    * ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#instance GoogleSqlDatabase#instance}
    */
    readonly instance: string;
    /**
    * The name of the database in the Cloud SQL instance.
    * This does not include the project ID or instance name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#name GoogleSqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#project GoogleSqlDatabase#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#timeouts GoogleSqlDatabase#timeouts}
    */
    readonly timeouts?: GoogleSqlDatabaseTimeouts;
}
export interface GoogleSqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#create GoogleSqlDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#delete GoogleSqlDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#update GoogleSqlDatabase#update}
    */
    readonly update?: string;
}
export declare function googleSqlDatabaseTimeoutsToTerraform(struct?: GoogleSqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare function googleSqlDatabaseTimeoutsToHclTerraform(struct?: GoogleSqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleSqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database google_sql_database}
*/
export declare class GoogleSqlDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_database";
    /**
    * Generates CDKTF code for importing a GoogleSqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSqlDatabase to import
    * @param importFromId The id of the existing GoogleSqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_sql_database google_sql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSqlDatabaseConfig);
    private _charset?;
    get charset(): string;
    set charset(value: string);
    resetCharset(): void;
    get charsetInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleSqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: GoogleSqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
