/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageInsightsReportConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The editable display name of the inventory report configuration. Has a limit of 256 characters. Can be empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#display_name GoogleStorageInsightsReportConfig#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#id GoogleStorageInsightsReportConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the ReportConfig. The source and destination buckets specified in the ReportConfig
    * must be in the same location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#location GoogleStorageInsightsReportConfig#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#project GoogleStorageInsightsReportConfig#project}
    */
    readonly project?: string;
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#csv_options GoogleStorageInsightsReportConfig#csv_options}
    */
    readonly csvOptions: GoogleStorageInsightsReportConfigCsvOptions;
    /**
    * frequency_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#frequency_options GoogleStorageInsightsReportConfig#frequency_options}
    */
    readonly frequencyOptions?: GoogleStorageInsightsReportConfigFrequencyOptions;
    /**
    * object_metadata_report_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#object_metadata_report_options GoogleStorageInsightsReportConfig#object_metadata_report_options}
    */
    readonly objectMetadataReportOptions?: GoogleStorageInsightsReportConfigObjectMetadataReportOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#timeouts GoogleStorageInsightsReportConfig#timeouts}
    */
    readonly timeouts?: GoogleStorageInsightsReportConfigTimeouts;
}
export interface GoogleStorageInsightsReportConfigCsvOptions {
    /**
    * The delimiter used to separate the fields in the inventory report CSV file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#delimiter GoogleStorageInsightsReportConfig#delimiter}
    */
    readonly delimiter?: string;
    /**
    * The boolean that indicates whether or not headers are included in the inventory report CSV file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#header_required GoogleStorageInsightsReportConfig#header_required}
    */
    readonly headerRequired?: boolean | cdktf.IResolvable;
    /**
    * The character used to separate the records in the inventory report CSV file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#record_separator GoogleStorageInsightsReportConfig#record_separator}
    */
    readonly recordSeparator?: string;
}
export declare function googleStorageInsightsReportConfigCsvOptionsToTerraform(struct?: GoogleStorageInsightsReportConfigCsvOptionsOutputReference | GoogleStorageInsightsReportConfigCsvOptions): any;
export declare function googleStorageInsightsReportConfigCsvOptionsToHclTerraform(struct?: GoogleStorageInsightsReportConfigCsvOptionsOutputReference | GoogleStorageInsightsReportConfigCsvOptions): any;
export declare class GoogleStorageInsightsReportConfigCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigCsvOptions | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigCsvOptions | undefined);
    private _delimiter?;
    get delimiter(): string;
    set delimiter(value: string);
    resetDelimiter(): void;
    get delimiterInput(): string | undefined;
    private _headerRequired?;
    get headerRequired(): boolean | cdktf.IResolvable;
    set headerRequired(value: boolean | cdktf.IResolvable);
    resetHeaderRequired(): void;
    get headerRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _recordSeparator?;
    get recordSeparator(): string;
    set recordSeparator(value: string);
    resetRecordSeparator(): void;
    get recordSeparatorInput(): string | undefined;
}
export interface GoogleStorageInsightsReportConfigFrequencyOptionsEndDate {
    /**
    * The day of the month to stop generating inventory reports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#day GoogleStorageInsightsReportConfig#day}
    */
    readonly day: number;
    /**
    * The month to stop generating inventory reports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#month GoogleStorageInsightsReportConfig#month}
    */
    readonly month: number;
    /**
    * The year to stop generating inventory reports
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#year GoogleStorageInsightsReportConfig#year}
    */
    readonly year: number;
}
export declare function googleStorageInsightsReportConfigFrequencyOptionsEndDateToTerraform(struct?: GoogleStorageInsightsReportConfigFrequencyOptionsEndDateOutputReference | GoogleStorageInsightsReportConfigFrequencyOptionsEndDate): any;
export declare function googleStorageInsightsReportConfigFrequencyOptionsEndDateToHclTerraform(struct?: GoogleStorageInsightsReportConfigFrequencyOptionsEndDateOutputReference | GoogleStorageInsightsReportConfigFrequencyOptionsEndDate): any;
export declare class GoogleStorageInsightsReportConfigFrequencyOptionsEndDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigFrequencyOptionsEndDate | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigFrequencyOptionsEndDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface GoogleStorageInsightsReportConfigFrequencyOptionsStartDate {
    /**
    * The day of the month to start generating inventory reports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#day GoogleStorageInsightsReportConfig#day}
    */
    readonly day: number;
    /**
    * The month to start generating inventory reports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#month GoogleStorageInsightsReportConfig#month}
    */
    readonly month: number;
    /**
    * The year to start generating inventory reports
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#year GoogleStorageInsightsReportConfig#year}
    */
    readonly year: number;
}
export declare function googleStorageInsightsReportConfigFrequencyOptionsStartDateToTerraform(struct?: GoogleStorageInsightsReportConfigFrequencyOptionsStartDateOutputReference | GoogleStorageInsightsReportConfigFrequencyOptionsStartDate): any;
export declare function googleStorageInsightsReportConfigFrequencyOptionsStartDateToHclTerraform(struct?: GoogleStorageInsightsReportConfigFrequencyOptionsStartDateOutputReference | GoogleStorageInsightsReportConfigFrequencyOptionsStartDate): any;
export declare class GoogleStorageInsightsReportConfigFrequencyOptionsStartDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigFrequencyOptionsStartDate | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigFrequencyOptionsStartDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface GoogleStorageInsightsReportConfigFrequencyOptions {
    /**
    * The frequency in which inventory reports are generated. Values are DAILY or WEEKLY. Possible values: ["DAILY", "WEEKLY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#frequency GoogleStorageInsightsReportConfig#frequency}
    */
    readonly frequency: string;
    /**
    * end_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#end_date GoogleStorageInsightsReportConfig#end_date}
    */
    readonly endDate: GoogleStorageInsightsReportConfigFrequencyOptionsEndDate;
    /**
    * start_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#start_date GoogleStorageInsightsReportConfig#start_date}
    */
    readonly startDate: GoogleStorageInsightsReportConfigFrequencyOptionsStartDate;
}
export declare function googleStorageInsightsReportConfigFrequencyOptionsToTerraform(struct?: GoogleStorageInsightsReportConfigFrequencyOptionsOutputReference | GoogleStorageInsightsReportConfigFrequencyOptions): any;
export declare function googleStorageInsightsReportConfigFrequencyOptionsToHclTerraform(struct?: GoogleStorageInsightsReportConfigFrequencyOptionsOutputReference | GoogleStorageInsightsReportConfigFrequencyOptions): any;
export declare class GoogleStorageInsightsReportConfigFrequencyOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigFrequencyOptions | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigFrequencyOptions | undefined);
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _endDate;
    get endDate(): GoogleStorageInsightsReportConfigFrequencyOptionsEndDateOutputReference;
    putEndDate(value: GoogleStorageInsightsReportConfigFrequencyOptionsEndDate): void;
    get endDateInput(): GoogleStorageInsightsReportConfigFrequencyOptionsEndDate | undefined;
    private _startDate;
    get startDate(): GoogleStorageInsightsReportConfigFrequencyOptionsStartDateOutputReference;
    putStartDate(value: GoogleStorageInsightsReportConfigFrequencyOptionsStartDate): void;
    get startDateInput(): GoogleStorageInsightsReportConfigFrequencyOptionsStartDate | undefined;
}
export interface GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions {
    /**
    * The destination bucket that stores the generated inventory reports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#bucket GoogleStorageInsightsReportConfig#bucket}
    */
    readonly bucket: string;
    /**
    * The path within the destination bucket to store generated inventory reports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#destination_path GoogleStorageInsightsReportConfig#destination_path}
    */
    readonly destinationPath?: string;
}
export declare function googleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsToTerraform(struct?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsOutputReference | GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions): any;
export declare function googleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsToHclTerraform(struct?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsOutputReference | GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions): any;
export declare class GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _destinationPath?;
    get destinationPath(): string;
    set destinationPath(value: string);
    resetDestinationPath(): void;
    get destinationPathInput(): string | undefined;
}
export interface GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters {
    /**
    * The filter to use when specifying which bucket to generate inventory reports for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#bucket GoogleStorageInsightsReportConfig#bucket}
    */
    readonly bucket?: string;
}
export declare function googleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFiltersToTerraform(struct?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFiltersOutputReference | GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters): any;
export declare function googleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFiltersToHclTerraform(struct?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFiltersOutputReference | GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters): any;
export declare class GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    resetBucket(): void;
    get bucketInput(): string | undefined;
}
export interface GoogleStorageInsightsReportConfigObjectMetadataReportOptions {
    /**
    * The metadata fields included in an inventory report.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#metadata_fields GoogleStorageInsightsReportConfig#metadata_fields}
    */
    readonly metadataFields: string[];
    /**
    * storage_destination_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#storage_destination_options GoogleStorageInsightsReportConfig#storage_destination_options}
    */
    readonly storageDestinationOptions: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions;
    /**
    * storage_filters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#storage_filters GoogleStorageInsightsReportConfig#storage_filters}
    */
    readonly storageFilters?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters;
}
export declare function googleStorageInsightsReportConfigObjectMetadataReportOptionsToTerraform(struct?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsOutputReference | GoogleStorageInsightsReportConfigObjectMetadataReportOptions): any;
export declare function googleStorageInsightsReportConfigObjectMetadataReportOptionsToHclTerraform(struct?: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsOutputReference | GoogleStorageInsightsReportConfigObjectMetadataReportOptions): any;
export declare class GoogleStorageInsightsReportConfigObjectMetadataReportOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigObjectMetadataReportOptions | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigObjectMetadataReportOptions | undefined);
    private _metadataFields?;
    get metadataFields(): string[];
    set metadataFields(value: string[]);
    get metadataFieldsInput(): string[] | undefined;
    private _storageDestinationOptions;
    get storageDestinationOptions(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsOutputReference;
    putStorageDestinationOptions(value: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions): void;
    get storageDestinationOptionsInput(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions | undefined;
    private _storageFilters;
    get storageFilters(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFiltersOutputReference;
    putStorageFilters(value: GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters): void;
    resetStorageFilters(): void;
    get storageFiltersInput(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsStorageFilters | undefined;
}
export interface GoogleStorageInsightsReportConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#create GoogleStorageInsightsReportConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#delete GoogleStorageInsightsReportConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#update GoogleStorageInsightsReportConfig#update}
    */
    readonly update?: string;
}
export declare function googleStorageInsightsReportConfigTimeoutsToTerraform(struct?: GoogleStorageInsightsReportConfigTimeouts | cdktf.IResolvable): any;
export declare function googleStorageInsightsReportConfigTimeoutsToHclTerraform(struct?: GoogleStorageInsightsReportConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleStorageInsightsReportConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageInsightsReportConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageInsightsReportConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config google_storage_insights_report_config}
*/
export declare class GoogleStorageInsightsReportConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_insights_report_config";
    /**
    * Generates CDKTF code for importing a GoogleStorageInsightsReportConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleStorageInsightsReportConfig to import
    * @param importFromId The id of the existing GoogleStorageInsightsReportConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleStorageInsightsReportConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_insights_report_config google_storage_insights_report_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageInsightsReportConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageInsightsReportConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _csvOptions;
    get csvOptions(): GoogleStorageInsightsReportConfigCsvOptionsOutputReference;
    putCsvOptions(value: GoogleStorageInsightsReportConfigCsvOptions): void;
    get csvOptionsInput(): GoogleStorageInsightsReportConfigCsvOptions | undefined;
    private _frequencyOptions;
    get frequencyOptions(): GoogleStorageInsightsReportConfigFrequencyOptionsOutputReference;
    putFrequencyOptions(value: GoogleStorageInsightsReportConfigFrequencyOptions): void;
    resetFrequencyOptions(): void;
    get frequencyOptionsInput(): GoogleStorageInsightsReportConfigFrequencyOptions | undefined;
    private _objectMetadataReportOptions;
    get objectMetadataReportOptions(): GoogleStorageInsightsReportConfigObjectMetadataReportOptionsOutputReference;
    putObjectMetadataReportOptions(value: GoogleStorageInsightsReportConfigObjectMetadataReportOptions): void;
    resetObjectMetadataReportOptions(): void;
    get objectMetadataReportOptionsInput(): GoogleStorageInsightsReportConfigObjectMetadataReportOptions | undefined;
    private _timeouts;
    get timeouts(): GoogleStorageInsightsReportConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleStorageInsightsReportConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleStorageInsightsReportConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
