/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageNotificationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#bucket GoogleStorageNotification#bucket}
    */
    readonly bucket: string;
    /**
    *  A set of key/value attribute pairs to attach to each Cloud Pub/Sub message published for this notification subscription
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#custom_attributes GoogleStorageNotification#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * List of event type filters for this notification config. If not specified, Cloud Storage will send notifications for all event types. The valid types are: "OBJECT_FINALIZE", "OBJECT_METADATA_UPDATE", "OBJECT_DELETE", "OBJECT_ARCHIVE"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#event_types GoogleStorageNotification#event_types}
    */
    readonly eventTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#id GoogleStorageNotification#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies a prefix path filter for this notification config. Cloud Storage will only send notifications for objects in this bucket whose names begin with the specified prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#object_name_prefix GoogleStorageNotification#object_name_prefix}
    */
    readonly objectNamePrefix?: string;
    /**
    * The desired content of the Payload. One of "JSON_API_V1" or "NONE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#payload_format GoogleStorageNotification#payload_format}
    */
    readonly payloadFormat: string;
    /**
    * The Cloud Pub/Sub topic to which this subscription publishes. Expects either the  topic name, assumed to belong to the default GCP provider project, or the project-level name,  i.e. projects/my-gcp-project/topics/my-topic or my-topic. If the project is not set in the provider, you will need to use the project-level name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#topic GoogleStorageNotification#topic}
    */
    readonly topic: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification google_storage_notification}
*/
export declare class GoogleStorageNotification extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_notification";
    /**
    * Generates CDKTF code for importing a GoogleStorageNotification resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleStorageNotification to import
    * @param importFromId The id of the existing GoogleStorageNotification that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleStorageNotification to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_storage_notification google_storage_notification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageNotificationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageNotificationConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get notificationId(): string;
    private _objectNamePrefix?;
    get objectNamePrefix(): string;
    set objectNamePrefix(value: string);
    resetObjectNamePrefix(): void;
    get objectNamePrefixInput(): string | undefined;
    private _payloadFormat?;
    get payloadFormat(): string;
    set payloadFormat(value: string);
    get payloadFormatInput(): string | undefined;
    get selfLink(): string;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
