/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleTagsTagKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-assigned description of the TagKey. Must not exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#description GoogleTagsTagKey#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#id GoogleTagsTagKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Input only. The resource name of the new TagKey's parent. Must be of the form organizations/{org_id} or projects/{project_id_or_number}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#parent GoogleTagsTagKey#parent}
    */
    readonly parent: string;
    /**
    * Optional. A purpose cannot be changed once set.
    *
    * A purpose denotes that this Tag is intended for use in policies of a specific policy engine, and will involve that policy engine in management operations involving this Tag. Possible values: ["GCE_FIREWALL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#purpose GoogleTagsTagKey#purpose}
    */
    readonly purpose?: string;
    /**
    * Optional. Purpose data cannot be changed once set.
    *
    * Purpose data corresponds to the policy system that the tag is intended for. For example, the GCE_FIREWALL purpose expects data in the following format: 'network = "<project-name>/<vpc-name>"'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#purpose_data GoogleTagsTagKey#purpose_data}
    */
    readonly purposeData?: {
        [key: string]: string;
    };
    /**
    * Input only. The user friendly name for a TagKey. The short name should be unique for TagKeys within the same tag namespace.
    *
    * The short name must be 1-63 characters, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#short_name GoogleTagsTagKey#short_name}
    */
    readonly shortName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#timeouts GoogleTagsTagKey#timeouts}
    */
    readonly timeouts?: GoogleTagsTagKeyTimeouts;
}
export interface GoogleTagsTagKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#create GoogleTagsTagKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#delete GoogleTagsTagKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#update GoogleTagsTagKey#update}
    */
    readonly update?: string;
}
export declare function googleTagsTagKeyTimeoutsToTerraform(struct?: GoogleTagsTagKeyTimeouts | cdktf.IResolvable): any;
export declare function googleTagsTagKeyTimeoutsToHclTerraform(struct?: GoogleTagsTagKeyTimeouts | cdktf.IResolvable): any;
export declare class GoogleTagsTagKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTagsTagKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleTagsTagKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key google_tags_tag_key}
*/
export declare class GoogleTagsTagKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tags_tag_key";
    /**
    * Generates CDKTF code for importing a GoogleTagsTagKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleTagsTagKey to import
    * @param importFromId The id of the existing GoogleTagsTagKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleTagsTagKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tags_tag_key google_tags_tag_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleTagsTagKeyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleTagsTagKeyConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _purposeData?;
    get purposeData(): {
        [key: string]: string;
    };
    set purposeData(value: {
        [key: string]: string;
    });
    resetPurposeData(): void;
    get purposeDataInput(): {
        [key: string]: string;
    } | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleTagsTagKeyTimeoutsOutputReference;
    putTimeouts(value: GoogleTagsTagKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleTagsTagKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
