/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleTpuV2VmConfig extends cdktf.TerraformMetaArguments {
    /**
    * TPU accelerator type for the TPU. 'accelerator_type' cannot be used at the same time as
    * 'accelerator_config'. If neither is specified, 'accelerator_type' defaults to 'v2-8'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#accelerator_type GoogleTpuV2Vm#accelerator_type}
    */
    readonly acceleratorType?: string;
    /**
    * The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
    * be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
    * block would be wasteful (a node can only consume one IP address). Errors will occur if the
    * CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
    * with any subnetworks in the user's provided network, or the provided network is peered with
    * another network that is using that CIDR block.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#cidr_block GoogleTpuV2Vm#cidr_block}
    */
    readonly cidrBlock?: string;
    /**
    * Text description of the TPU.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#description GoogleTpuV2Vm#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#id GoogleTpuV2Vm#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#labels GoogleTpuV2Vm#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#metadata GoogleTpuV2Vm#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The immutable name of the TPU.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#name GoogleTpuV2Vm#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#project GoogleTpuV2Vm#project}
    */
    readonly project?: string;
    /**
    * Runtime version for the TPU.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#runtime_version GoogleTpuV2Vm#runtime_version}
    */
    readonly runtimeVersion: string;
    /**
    * Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#tags GoogleTpuV2Vm#tags}
    */
    readonly tags?: string[];
    /**
    * The GCP location for the TPU. If it is not provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#zone GoogleTpuV2Vm#zone}
    */
    readonly zone?: string;
    /**
    * accelerator_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#accelerator_config GoogleTpuV2Vm#accelerator_config}
    */
    readonly acceleratorConfig?: GoogleTpuV2VmAcceleratorConfig;
    /**
    * data_disks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#data_disks GoogleTpuV2Vm#data_disks}
    */
    readonly dataDisks?: GoogleTpuV2VmDataDisks[] | cdktf.IResolvable;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#network_config GoogleTpuV2Vm#network_config}
    */
    readonly networkConfig?: GoogleTpuV2VmNetworkConfig;
    /**
    * scheduling_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#scheduling_config GoogleTpuV2Vm#scheduling_config}
    */
    readonly schedulingConfig?: GoogleTpuV2VmSchedulingConfig;
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#service_account GoogleTpuV2Vm#service_account}
    */
    readonly serviceAccount?: GoogleTpuV2VmServiceAccount;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#shielded_instance_config GoogleTpuV2Vm#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleTpuV2VmShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#timeouts GoogleTpuV2Vm#timeouts}
    */
    readonly timeouts?: GoogleTpuV2VmTimeouts;
}
export interface GoogleTpuV2VmNetworkEndpointsAccessConfig {
}
export declare function googleTpuV2VmNetworkEndpointsAccessConfigToTerraform(struct?: GoogleTpuV2VmNetworkEndpointsAccessConfig): any;
export declare function googleTpuV2VmNetworkEndpointsAccessConfigToHclTerraform(struct?: GoogleTpuV2VmNetworkEndpointsAccessConfig): any;
export declare class GoogleTpuV2VmNetworkEndpointsAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleTpuV2VmNetworkEndpointsAccessConfig | undefined;
    set internalValue(value: GoogleTpuV2VmNetworkEndpointsAccessConfig | undefined);
    get externalIp(): string;
}
export declare class GoogleTpuV2VmNetworkEndpointsAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleTpuV2VmNetworkEndpointsAccessConfigOutputReference;
}
export interface GoogleTpuV2VmNetworkEndpoints {
}
export declare function googleTpuV2VmNetworkEndpointsToTerraform(struct?: GoogleTpuV2VmNetworkEndpoints): any;
export declare function googleTpuV2VmNetworkEndpointsToHclTerraform(struct?: GoogleTpuV2VmNetworkEndpoints): any;
export declare class GoogleTpuV2VmNetworkEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleTpuV2VmNetworkEndpoints | undefined;
    set internalValue(value: GoogleTpuV2VmNetworkEndpoints | undefined);
    private _accessConfig;
    get accessConfig(): GoogleTpuV2VmNetworkEndpointsAccessConfigList;
    get ipAddress(): string;
    get port(): number;
}
export declare class GoogleTpuV2VmNetworkEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleTpuV2VmNetworkEndpointsOutputReference;
}
export interface GoogleTpuV2VmSymptoms {
}
export declare function googleTpuV2VmSymptomsToTerraform(struct?: GoogleTpuV2VmSymptoms): any;
export declare function googleTpuV2VmSymptomsToHclTerraform(struct?: GoogleTpuV2VmSymptoms): any;
export declare class GoogleTpuV2VmSymptomsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleTpuV2VmSymptoms | undefined;
    set internalValue(value: GoogleTpuV2VmSymptoms | undefined);
    get createTime(): string;
    get details(): string;
    get symptomType(): string;
    get workerId(): string;
}
export declare class GoogleTpuV2VmSymptomsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleTpuV2VmSymptomsOutputReference;
}
export interface GoogleTpuV2VmAcceleratorConfig {
    /**
    * Topology of TPU in chips.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#topology GoogleTpuV2Vm#topology}
    */
    readonly topology: string;
    /**
    * Type of TPU. Possible values: ["V2", "V3", "V4"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#type GoogleTpuV2Vm#type}
    */
    readonly type: string;
}
export declare function googleTpuV2VmAcceleratorConfigToTerraform(struct?: GoogleTpuV2VmAcceleratorConfigOutputReference | GoogleTpuV2VmAcceleratorConfig): any;
export declare function googleTpuV2VmAcceleratorConfigToHclTerraform(struct?: GoogleTpuV2VmAcceleratorConfigOutputReference | GoogleTpuV2VmAcceleratorConfig): any;
export declare class GoogleTpuV2VmAcceleratorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuV2VmAcceleratorConfig | undefined;
    set internalValue(value: GoogleTpuV2VmAcceleratorConfig | undefined);
    private _topology?;
    get topology(): string;
    set topology(value: string);
    get topologyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleTpuV2VmDataDisks {
    /**
    * The mode in which to attach this disk. If not specified, the default is READ_WRITE
    * mode. Only applicable to dataDisks. Default value: "READ_WRITE" Possible values: ["READ_WRITE", "READ_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#mode GoogleTpuV2Vm#mode}
    */
    readonly mode?: string;
    /**
    * Specifies the full path to an existing disk. For example:
    * "projects/my-project/zones/us-central1-c/disks/my-disk".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#source_disk GoogleTpuV2Vm#source_disk}
    */
    readonly sourceDisk: string;
}
export declare function googleTpuV2VmDataDisksToTerraform(struct?: GoogleTpuV2VmDataDisks | cdktf.IResolvable): any;
export declare function googleTpuV2VmDataDisksToHclTerraform(struct?: GoogleTpuV2VmDataDisks | cdktf.IResolvable): any;
export declare class GoogleTpuV2VmDataDisksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleTpuV2VmDataDisks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleTpuV2VmDataDisks | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    get sourceDiskInput(): string | undefined;
}
export declare class GoogleTpuV2VmDataDisksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleTpuV2VmDataDisks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleTpuV2VmDataDisksOutputReference;
}
export interface GoogleTpuV2VmNetworkConfig {
    /**
    * Allows the TPU node to send and receive packets with non-matching destination or source
    * IPs. This is required if you plan to use the TPU workers to forward routes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#can_ip_forward GoogleTpuV2Vm#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * Indicates that external IP addresses would be associated with the TPU workers. If set to
    * false, the specified subnetwork or network should have Private Google Access enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#enable_external_ips GoogleTpuV2Vm#enable_external_ips}
    */
    readonly enableExternalIps?: boolean | cdktf.IResolvable;
    /**
    * The name of the network for the TPU node. It must be a preexisting Google Compute Engine
    * network. If both network and subnetwork are specified, the given subnetwork must belong
    * to the given network. If network is not specified, it will be looked up from the
    * subnetwork if one is provided, or otherwise use "default".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#network GoogleTpuV2Vm#network}
    */
    readonly network?: string;
    /**
    * The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
    * Engine subnetwork. If both network and subnetwork are specified, the given subnetwork
    * must belong to the given network. If subnetwork is not specified, the subnetwork with the
    * same name as the network will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#subnetwork GoogleTpuV2Vm#subnetwork}
    */
    readonly subnetwork?: string;
}
export declare function googleTpuV2VmNetworkConfigToTerraform(struct?: GoogleTpuV2VmNetworkConfigOutputReference | GoogleTpuV2VmNetworkConfig): any;
export declare function googleTpuV2VmNetworkConfigToHclTerraform(struct?: GoogleTpuV2VmNetworkConfigOutputReference | GoogleTpuV2VmNetworkConfig): any;
export declare class GoogleTpuV2VmNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuV2VmNetworkConfig | undefined;
    set internalValue(value: GoogleTpuV2VmNetworkConfig | undefined);
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    private _enableExternalIps?;
    get enableExternalIps(): boolean | cdktf.IResolvable;
    set enableExternalIps(value: boolean | cdktf.IResolvable);
    resetEnableExternalIps(): void;
    get enableExternalIpsInput(): boolean | cdktf.IResolvable | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
}
export interface GoogleTpuV2VmSchedulingConfig {
    /**
    * Defines whether the node is preemptible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#preemptible GoogleTpuV2Vm#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the node is created under a reservation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#reserved GoogleTpuV2Vm#reserved}
    */
    readonly reserved?: boolean | cdktf.IResolvable;
}
export declare function googleTpuV2VmSchedulingConfigToTerraform(struct?: GoogleTpuV2VmSchedulingConfigOutputReference | GoogleTpuV2VmSchedulingConfig): any;
export declare function googleTpuV2VmSchedulingConfigToHclTerraform(struct?: GoogleTpuV2VmSchedulingConfigOutputReference | GoogleTpuV2VmSchedulingConfig): any;
export declare class GoogleTpuV2VmSchedulingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuV2VmSchedulingConfig | undefined;
    set internalValue(value: GoogleTpuV2VmSchedulingConfig | undefined);
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _reserved?;
    get reserved(): boolean | cdktf.IResolvable;
    set reserved(value: boolean | cdktf.IResolvable);
    resetReserved(): void;
    get reservedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleTpuV2VmServiceAccount {
    /**
    * Email address of the service account. If empty, default Compute service account will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#email GoogleTpuV2Vm#email}
    */
    readonly email?: string;
    /**
    * The list of scopes to be made available for this service account. If empty, access to all
    * Cloud APIs will be allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#scope GoogleTpuV2Vm#scope}
    */
    readonly scope?: string[];
}
export declare function googleTpuV2VmServiceAccountToTerraform(struct?: GoogleTpuV2VmServiceAccountOutputReference | GoogleTpuV2VmServiceAccount): any;
export declare function googleTpuV2VmServiceAccountToHclTerraform(struct?: GoogleTpuV2VmServiceAccountOutputReference | GoogleTpuV2VmServiceAccount): any;
export declare class GoogleTpuV2VmServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuV2VmServiceAccount | undefined;
    set internalValue(value: GoogleTpuV2VmServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scope?;
    get scope(): string[];
    set scope(value: string[]);
    resetScope(): void;
    get scopeInput(): string[] | undefined;
}
export interface GoogleTpuV2VmShieldedInstanceConfig {
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#enable_secure_boot GoogleTpuV2Vm#enable_secure_boot}
    */
    readonly enableSecureBoot: boolean | cdktf.IResolvable;
}
export declare function googleTpuV2VmShieldedInstanceConfigToTerraform(struct?: GoogleTpuV2VmShieldedInstanceConfigOutputReference | GoogleTpuV2VmShieldedInstanceConfig): any;
export declare function googleTpuV2VmShieldedInstanceConfigToHclTerraform(struct?: GoogleTpuV2VmShieldedInstanceConfigOutputReference | GoogleTpuV2VmShieldedInstanceConfig): any;
export declare class GoogleTpuV2VmShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuV2VmShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleTpuV2VmShieldedInstanceConfig | undefined);
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleTpuV2VmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#create GoogleTpuV2Vm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#delete GoogleTpuV2Vm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#update GoogleTpuV2Vm#update}
    */
    readonly update?: string;
}
export declare function googleTpuV2VmTimeoutsToTerraform(struct?: GoogleTpuV2VmTimeouts | cdktf.IResolvable): any;
export declare function googleTpuV2VmTimeoutsToHclTerraform(struct?: GoogleTpuV2VmTimeouts | cdktf.IResolvable): any;
export declare class GoogleTpuV2VmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuV2VmTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleTpuV2VmTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm google_tpu_v2_vm}
*/
export declare class GoogleTpuV2Vm extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tpu_v2_vm";
    /**
    * Generates CDKTF code for importing a GoogleTpuV2Vm resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleTpuV2Vm to import
    * @param importFromId The id of the existing GoogleTpuV2Vm that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleTpuV2Vm to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_tpu_v2_vm google_tpu_v2_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleTpuV2VmConfig
    */
    constructor(scope: Construct, id: string, config: GoogleTpuV2VmConfig);
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    resetAcceleratorType(): void;
    get acceleratorTypeInput(): string | undefined;
    get apiVersion(): string;
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    resetCidrBlock(): void;
    get cidrBlockInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get health(): string;
    get healthDescription(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get multisliceNode(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkEndpoints;
    get networkEndpoints(): GoogleTpuV2VmNetworkEndpointsList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get queuedResource(): string;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    get runtimeVersionInput(): string | undefined;
    get state(): string;
    private _symptoms;
    get symptoms(): GoogleTpuV2VmSymptomsList;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _acceleratorConfig;
    get acceleratorConfig(): GoogleTpuV2VmAcceleratorConfigOutputReference;
    putAcceleratorConfig(value: GoogleTpuV2VmAcceleratorConfig): void;
    resetAcceleratorConfig(): void;
    get acceleratorConfigInput(): GoogleTpuV2VmAcceleratorConfig | undefined;
    private _dataDisks;
    get dataDisks(): GoogleTpuV2VmDataDisksList;
    putDataDisks(value: GoogleTpuV2VmDataDisks[] | cdktf.IResolvable): void;
    resetDataDisks(): void;
    get dataDisksInput(): cdktf.IResolvable | GoogleTpuV2VmDataDisks[] | undefined;
    private _networkConfig;
    get networkConfig(): GoogleTpuV2VmNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleTpuV2VmNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleTpuV2VmNetworkConfig | undefined;
    private _schedulingConfig;
    get schedulingConfig(): GoogleTpuV2VmSchedulingConfigOutputReference;
    putSchedulingConfig(value: GoogleTpuV2VmSchedulingConfig): void;
    resetSchedulingConfig(): void;
    get schedulingConfigInput(): GoogleTpuV2VmSchedulingConfig | undefined;
    private _serviceAccount;
    get serviceAccount(): GoogleTpuV2VmServiceAccountOutputReference;
    putServiceAccount(value: GoogleTpuV2VmServiceAccount): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): GoogleTpuV2VmServiceAccount | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleTpuV2VmShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleTpuV2VmShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleTpuV2VmShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleTpuV2VmTimeoutsOutputReference;
    putTimeouts(value: GoogleTpuV2VmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleTpuV2VmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
