/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the Endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#description GoogleVertexAiEndpoint#description}
    */
    readonly description?: string;
    /**
    * Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#display_name GoogleVertexAiEndpoint#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#id GoogleVertexAiEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels with user-defined metadata to organize your Endpoints. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#labels GoogleVertexAiEndpoint#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#location GoogleVertexAiEndpoint#location}
    */
    readonly location: string;
    /**
    * The resource name of the Endpoint. The name must be numeric with no leading zeros and can be at most 10 digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#name GoogleVertexAiEndpoint#name}
    */
    readonly name: string;
    /**
    * The full name of the Google Compute Engine [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks) to which the Endpoint should be peered. Private services access must already be configured for the network. If left unspecified, the Endpoint is not peered with any network. Only one of the fields, network or enable_private_service_connect, can be set. [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert): 'projects/{project}/global/networks/{network}'. Where '{project}' is a project number, as in '12345', and '{network}' is network name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#network GoogleVertexAiEndpoint#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#project GoogleVertexAiEndpoint#project}
    */
    readonly project?: string;
    /**
    * The region for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#region GoogleVertexAiEndpoint#region}
    */
    readonly region?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#encryption_spec GoogleVertexAiEndpoint#encryption_spec}
    */
    readonly encryptionSpec?: GoogleVertexAiEndpointEncryptionSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#timeouts GoogleVertexAiEndpoint#timeouts}
    */
    readonly timeouts?: GoogleVertexAiEndpointTimeouts;
}
export interface GoogleVertexAiEndpointDeployedModelsAutomaticResources {
}
export declare function googleVertexAiEndpointDeployedModelsAutomaticResourcesToTerraform(struct?: GoogleVertexAiEndpointDeployedModelsAutomaticResources): any;
export declare function googleVertexAiEndpointDeployedModelsAutomaticResourcesToHclTerraform(struct?: GoogleVertexAiEndpointDeployedModelsAutomaticResources): any;
export declare class GoogleVertexAiEndpointDeployedModelsAutomaticResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiEndpointDeployedModelsAutomaticResources | undefined;
    set internalValue(value: GoogleVertexAiEndpointDeployedModelsAutomaticResources | undefined);
    get maxReplicaCount(): number;
    get minReplicaCount(): number;
}
export declare class GoogleVertexAiEndpointDeployedModelsAutomaticResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiEndpointDeployedModelsAutomaticResourcesOutputReference;
}
export interface GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs {
}
export declare function googleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsToTerraform(struct?: GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs): any;
export declare function googleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsToHclTerraform(struct?: GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs): any;
export declare class GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs | undefined;
    set internalValue(value: GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs | undefined);
    get metricName(): string;
    get target(): number;
}
export declare class GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsOutputReference;
}
export interface GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec {
}
export declare function googleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecToTerraform(struct?: GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec): any;
export declare function googleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecToHclTerraform(struct?: GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec): any;
export declare class GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec | undefined;
    set internalValue(value: GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec | undefined);
    get acceleratorCount(): number;
    get acceleratorType(): string;
    get machineType(): string;
}
export declare class GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecOutputReference;
}
export interface GoogleVertexAiEndpointDeployedModelsDedicatedResources {
}
export declare function googleVertexAiEndpointDeployedModelsDedicatedResourcesToTerraform(struct?: GoogleVertexAiEndpointDeployedModelsDedicatedResources): any;
export declare function googleVertexAiEndpointDeployedModelsDedicatedResourcesToHclTerraform(struct?: GoogleVertexAiEndpointDeployedModelsDedicatedResources): any;
export declare class GoogleVertexAiEndpointDeployedModelsDedicatedResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiEndpointDeployedModelsDedicatedResources | undefined;
    set internalValue(value: GoogleVertexAiEndpointDeployedModelsDedicatedResources | undefined);
    private _autoscalingMetricSpecs;
    get autoscalingMetricSpecs(): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsList;
    private _machineSpec;
    get machineSpec(): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecList;
    get maxReplicaCount(): number;
    get minReplicaCount(): number;
}
export declare class GoogleVertexAiEndpointDeployedModelsDedicatedResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesOutputReference;
}
export interface GoogleVertexAiEndpointDeployedModelsPrivateEndpoints {
}
export declare function googleVertexAiEndpointDeployedModelsPrivateEndpointsToTerraform(struct?: GoogleVertexAiEndpointDeployedModelsPrivateEndpoints): any;
export declare function googleVertexAiEndpointDeployedModelsPrivateEndpointsToHclTerraform(struct?: GoogleVertexAiEndpointDeployedModelsPrivateEndpoints): any;
export declare class GoogleVertexAiEndpointDeployedModelsPrivateEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiEndpointDeployedModelsPrivateEndpoints | undefined;
    set internalValue(value: GoogleVertexAiEndpointDeployedModelsPrivateEndpoints | undefined);
    get explainHttpUri(): string;
    get healthHttpUri(): string;
    get predictHttpUri(): string;
    get serviceAttachment(): string;
}
export declare class GoogleVertexAiEndpointDeployedModelsPrivateEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiEndpointDeployedModelsPrivateEndpointsOutputReference;
}
export interface GoogleVertexAiEndpointDeployedModels {
}
export declare function googleVertexAiEndpointDeployedModelsToTerraform(struct?: GoogleVertexAiEndpointDeployedModels): any;
export declare function googleVertexAiEndpointDeployedModelsToHclTerraform(struct?: GoogleVertexAiEndpointDeployedModels): any;
export declare class GoogleVertexAiEndpointDeployedModelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiEndpointDeployedModels | undefined;
    set internalValue(value: GoogleVertexAiEndpointDeployedModels | undefined);
    private _automaticResources;
    get automaticResources(): GoogleVertexAiEndpointDeployedModelsAutomaticResourcesList;
    get createTime(): string;
    private _dedicatedResources;
    get dedicatedResources(): GoogleVertexAiEndpointDeployedModelsDedicatedResourcesList;
    get displayName(): string;
    get enableAccessLogging(): cdktf.IResolvable;
    get enableContainerLogging(): cdktf.IResolvable;
    get id(): string;
    get model(): string;
    get modelVersionId(): string;
    private _privateEndpoints;
    get privateEndpoints(): GoogleVertexAiEndpointDeployedModelsPrivateEndpointsList;
    get serviceAccount(): string;
    get sharedResources(): string;
}
export declare class GoogleVertexAiEndpointDeployedModelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiEndpointDeployedModelsOutputReference;
}
export interface GoogleVertexAiEndpointEncryptionSpec {
    /**
    * Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: 'projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key'. The key needs to be in the same region as where the compute resource is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#kms_key_name GoogleVertexAiEndpoint#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleVertexAiEndpointEncryptionSpecToTerraform(struct?: GoogleVertexAiEndpointEncryptionSpecOutputReference | GoogleVertexAiEndpointEncryptionSpec): any;
export declare function googleVertexAiEndpointEncryptionSpecToHclTerraform(struct?: GoogleVertexAiEndpointEncryptionSpecOutputReference | GoogleVertexAiEndpointEncryptionSpec): any;
export declare class GoogleVertexAiEndpointEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiEndpointEncryptionSpec | undefined;
    set internalValue(value: GoogleVertexAiEndpointEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleVertexAiEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#create GoogleVertexAiEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#delete GoogleVertexAiEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#update GoogleVertexAiEndpoint#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiEndpointTimeoutsToTerraform(struct?: GoogleVertexAiEndpointTimeouts | cdktf.IResolvable): any;
export declare function googleVertexAiEndpointTimeoutsToHclTerraform(struct?: GoogleVertexAiEndpointTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint google_vertex_ai_endpoint}
*/
export declare class GoogleVertexAiEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_endpoint";
    /**
    * Generates CDKTF code for importing a GoogleVertexAiEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVertexAiEndpoint to import
    * @param importFromId The id of the existing GoogleVertexAiEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVertexAiEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_endpoint google_vertex_ai_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiEndpointConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiEndpointConfig);
    get createTime(): string;
    private _deployedModels;
    get deployedModels(): GoogleVertexAiEndpointDeployedModelsList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get modelDeploymentMonitoringJob(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): GoogleVertexAiEndpointEncryptionSpecOutputReference;
    putEncryptionSpec(value: GoogleVertexAiEndpointEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): GoogleVertexAiEndpointEncryptionSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiEndpointTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
