/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeatureGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the FeatureGroup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#description GoogleVertexAiFeatureGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#id GoogleVertexAiFeatureGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels with user-defined metadata to organize your FeatureGroup.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#labels GoogleVertexAiFeatureGroup#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name of the Feature Group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#name GoogleVertexAiFeatureGroup#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#project GoogleVertexAiFeatureGroup#project}
    */
    readonly project?: string;
    /**
    * The region of feature group. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#region GoogleVertexAiFeatureGroup#region}
    */
    readonly region?: string;
    /**
    * big_query block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#big_query GoogleVertexAiFeatureGroup#big_query}
    */
    readonly bigQuery?: GoogleVertexAiFeatureGroupBigQuery;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#timeouts GoogleVertexAiFeatureGroup#timeouts}
    */
    readonly timeouts?: GoogleVertexAiFeatureGroupTimeouts;
}
export interface GoogleVertexAiFeatureGroupBigQueryBigQuerySource {
    /**
    * BigQuery URI to a table, up to 2000 characters long. For example: 'bq://projectId.bqDatasetId.bqTableId.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#input_uri GoogleVertexAiFeatureGroup#input_uri}
    */
    readonly inputUri: string;
}
export declare function googleVertexAiFeatureGroupBigQueryBigQuerySourceToTerraform(struct?: GoogleVertexAiFeatureGroupBigQueryBigQuerySourceOutputReference | GoogleVertexAiFeatureGroupBigQueryBigQuerySource): any;
export declare function googleVertexAiFeatureGroupBigQueryBigQuerySourceToHclTerraform(struct?: GoogleVertexAiFeatureGroupBigQueryBigQuerySourceOutputReference | GoogleVertexAiFeatureGroupBigQueryBigQuerySource): any;
export declare class GoogleVertexAiFeatureGroupBigQueryBigQuerySourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureGroupBigQueryBigQuerySource | undefined;
    set internalValue(value: GoogleVertexAiFeatureGroupBigQueryBigQuerySource | undefined);
    private _inputUri?;
    get inputUri(): string;
    set inputUri(value: string);
    get inputUriInput(): string | undefined;
}
export interface GoogleVertexAiFeatureGroupBigQuery {
    /**
    * Columns to construct entityId / row keys. Currently only supports 1 entity_id_column. If not provided defaults to entityId.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#entity_id_columns GoogleVertexAiFeatureGroup#entity_id_columns}
    */
    readonly entityIdColumns?: string[];
    /**
    * big_query_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#big_query_source GoogleVertexAiFeatureGroup#big_query_source}
    */
    readonly bigQuerySource: GoogleVertexAiFeatureGroupBigQueryBigQuerySource;
}
export declare function googleVertexAiFeatureGroupBigQueryToTerraform(struct?: GoogleVertexAiFeatureGroupBigQueryOutputReference | GoogleVertexAiFeatureGroupBigQuery): any;
export declare function googleVertexAiFeatureGroupBigQueryToHclTerraform(struct?: GoogleVertexAiFeatureGroupBigQueryOutputReference | GoogleVertexAiFeatureGroupBigQuery): any;
export declare class GoogleVertexAiFeatureGroupBigQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureGroupBigQuery | undefined;
    set internalValue(value: GoogleVertexAiFeatureGroupBigQuery | undefined);
    private _entityIdColumns?;
    get entityIdColumns(): string[];
    set entityIdColumns(value: string[]);
    resetEntityIdColumns(): void;
    get entityIdColumnsInput(): string[] | undefined;
    private _bigQuerySource;
    get bigQuerySource(): GoogleVertexAiFeatureGroupBigQueryBigQuerySourceOutputReference;
    putBigQuerySource(value: GoogleVertexAiFeatureGroupBigQueryBigQuerySource): void;
    get bigQuerySourceInput(): GoogleVertexAiFeatureGroupBigQueryBigQuerySource | undefined;
}
export interface GoogleVertexAiFeatureGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#create GoogleVertexAiFeatureGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#delete GoogleVertexAiFeatureGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#update GoogleVertexAiFeatureGroup#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiFeatureGroupTimeoutsToTerraform(struct?: GoogleVertexAiFeatureGroupTimeouts | cdktf.IResolvable): any;
export declare function googleVertexAiFeatureGroupTimeoutsToHclTerraform(struct?: GoogleVertexAiFeatureGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeatureGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeatureGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group google_vertex_ai_feature_group}
*/
export declare class GoogleVertexAiFeatureGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_feature_group";
    /**
    * Generates CDKTF code for importing a GoogleVertexAiFeatureGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVertexAiFeatureGroup to import
    * @param importFromId The id of the existing GoogleVertexAiFeatureGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVertexAiFeatureGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_group google_vertex_ai_feature_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeatureGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleVertexAiFeatureGroupConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _bigQuery;
    get bigQuery(): GoogleVertexAiFeatureGroupBigQueryOutputReference;
    putBigQuery(value: GoogleVertexAiFeatureGroupBigQuery): void;
    resetBigQuery(): void;
    get bigQueryInput(): GoogleVertexAiFeatureGroupBigQuery | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiFeatureGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiFeatureGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiFeatureGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
