/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the FeatureOnlineStore to use for the featureview.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#feature_online_store GoogleVertexAiFeatureOnlineStoreFeatureview#feature_online_store}
    */
    readonly featureOnlineStore: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#id GoogleVertexAiFeatureOnlineStoreFeatureview#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this FeatureView.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#labels GoogleVertexAiFeatureOnlineStoreFeatureview#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#name GoogleVertexAiFeatureOnlineStoreFeatureview#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#project GoogleVertexAiFeatureOnlineStoreFeatureview#project}
    */
    readonly project?: string;
    /**
    * The region for the resource. It should be the same as the featureonlinestore region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#region GoogleVertexAiFeatureOnlineStoreFeatureview#region}
    */
    readonly region: string;
    /**
    * big_query_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#big_query_source GoogleVertexAiFeatureOnlineStoreFeatureview#big_query_source}
    */
    readonly bigQuerySource?: GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource;
    /**
    * feature_registry_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#feature_registry_source GoogleVertexAiFeatureOnlineStoreFeatureview#feature_registry_source}
    */
    readonly featureRegistrySource?: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource;
    /**
    * sync_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#sync_config GoogleVertexAiFeatureOnlineStoreFeatureview#sync_config}
    */
    readonly syncConfig?: GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#timeouts GoogleVertexAiFeatureOnlineStoreFeatureview#timeouts}
    */
    readonly timeouts?: GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts;
    /**
    * vector_search_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#vector_search_config GoogleVertexAiFeatureOnlineStoreFeatureview#vector_search_config}
    */
    readonly vectorSearchConfig?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource {
    /**
    * Columns to construct entityId / row keys. Start by supporting 1 only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#entity_id_columns GoogleVertexAiFeatureOnlineStoreFeatureview#entity_id_columns}
    */
    readonly entityIdColumns: string[];
    /**
    * The BigQuery view URI that will be materialized on each sync trigger based on FeatureView.SyncConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#uri GoogleVertexAiFeatureOnlineStoreFeatureview#uri}
    */
    readonly uri: string;
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewBigQuerySourceToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySourceOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewBigQuerySourceToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySourceOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource | undefined);
    private _entityIdColumns?;
    get entityIdColumns(): string[];
    set entityIdColumns(value: string[]);
    get entityIdColumnsInput(): string[] | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups {
    /**
    * Identifier of the feature group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#feature_group_id GoogleVertexAiFeatureOnlineStoreFeatureview#feature_group_id}
    */
    readonly featureGroupId: string;
    /**
    * Identifiers of features under the feature group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#feature_ids GoogleVertexAiFeatureOnlineStoreFeatureview#feature_ids}
    */
    readonly featureIds: string[];
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupsToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups | cdktf.IResolvable): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupsToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups | cdktf.IResolvable | undefined);
    private _featureGroupId?;
    get featureGroupId(): string;
    set featureGroupId(value: string);
    get featureGroupIdInput(): string | undefined;
    private _featureIds?;
    get featureIds(): string[];
    set featureIds(value: string[]);
    get featureIdsInput(): string[] | undefined;
}
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupsOutputReference;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource {
    /**
    * feature_groups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#feature_groups GoogleVertexAiFeatureOnlineStoreFeatureview#feature_groups}
    */
    readonly featureGroups: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups[] | cdktf.IResolvable;
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource | undefined);
    private _featureGroups;
    get featureGroups(): GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroupsList;
    putFeatureGroups(value: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups[] | cdktf.IResolvable): void;
    get featureGroupsInput(): cdktf.IResolvable | GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceFeatureGroups[] | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig {
    /**
    * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
    * To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#cron GoogleVertexAiFeatureOnlineStoreFeatureview#cron}
    */
    readonly cron?: string;
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewSyncConfigToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewSyncConfigToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig | undefined);
    private _cron?;
    get cron(): string;
    set cron(value: string);
    resetCron(): void;
    get cronInput(): string | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#create GoogleVertexAiFeatureOnlineStoreFeatureview#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#delete GoogleVertexAiFeatureOnlineStoreFeatureview#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#update GoogleVertexAiFeatureOnlineStoreFeatureview#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewTimeoutsToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts | cdktf.IResolvable): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewTimeoutsToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig {
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig | undefined);
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig {
    /**
    * Number of embeddings on each leaf node. The default value is 1000 if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#leaf_node_embedding_count GoogleVertexAiFeatureOnlineStoreFeatureview#leaf_node_embedding_count}
    */
    readonly leafNodeEmbeddingCount?: string;
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig | undefined);
    private _leafNodeEmbeddingCount?;
    get leafNodeEmbeddingCount(): string;
    set leafNodeEmbeddingCount(value: string);
    resetLeafNodeEmbeddingCount(): void;
    get leafNodeEmbeddingCountInput(): string | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig {
    /**
    * Column of crowding. This column contains crowding attribute which is a constraint on a neighbor list produced by nearest neighbor search requiring that no more than some value k' of the k neighbors returned have the same value of crowdingAttribute.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#crowding_column GoogleVertexAiFeatureOnlineStoreFeatureview#crowding_column}
    */
    readonly crowdingColumn?: string;
    /**
    * The distance measure used in nearest neighbor search.
    * For details on allowed values, see the [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.featureOnlineStores.featureViews#DistanceMeasureType). Possible values: ["SQUARED_L2_DISTANCE", "COSINE_DISTANCE", "DOT_PRODUCT_DISTANCE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#distance_measure_type GoogleVertexAiFeatureOnlineStoreFeatureview#distance_measure_type}
    */
    readonly distanceMeasureType?: string;
    /**
    * Column of embedding. This column contains the source data to create index for vector search.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#embedding_column GoogleVertexAiFeatureOnlineStoreFeatureview#embedding_column}
    */
    readonly embeddingColumn: string;
    /**
    * The number of dimensions of the input embedding.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#embedding_dimension GoogleVertexAiFeatureOnlineStoreFeatureview#embedding_dimension}
    */
    readonly embeddingDimension?: number;
    /**
    * Columns of features that are used to filter vector search results.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#filter_columns GoogleVertexAiFeatureOnlineStoreFeatureview#filter_columns}
    */
    readonly filterColumns?: string[];
    /**
    * brute_force_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#brute_force_config GoogleVertexAiFeatureOnlineStoreFeatureview#brute_force_config}
    */
    readonly bruteForceConfig?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig;
    /**
    * tree_ah_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#tree_ah_config GoogleVertexAiFeatureOnlineStoreFeatureview#tree_ah_config}
    */
    readonly treeAhConfig?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig;
}
export declare function googleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig): any;
export declare function googleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigOutputReference | GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig): any;
export declare class GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig | undefined);
    private _crowdingColumn?;
    get crowdingColumn(): string;
    set crowdingColumn(value: string);
    resetCrowdingColumn(): void;
    get crowdingColumnInput(): string | undefined;
    private _distanceMeasureType?;
    get distanceMeasureType(): string;
    set distanceMeasureType(value: string);
    resetDistanceMeasureType(): void;
    get distanceMeasureTypeInput(): string | undefined;
    private _embeddingColumn?;
    get embeddingColumn(): string;
    set embeddingColumn(value: string);
    get embeddingColumnInput(): string | undefined;
    private _embeddingDimension?;
    get embeddingDimension(): number;
    set embeddingDimension(value: number);
    resetEmbeddingDimension(): void;
    get embeddingDimensionInput(): number | undefined;
    private _filterColumns?;
    get filterColumns(): string[];
    set filterColumns(value: string[]);
    resetFilterColumns(): void;
    get filterColumnsInput(): string[] | undefined;
    private _bruteForceConfig;
    get bruteForceConfig(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfigOutputReference;
    putBruteForceConfig(value: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig): void;
    resetBruteForceConfig(): void;
    get bruteForceConfigInput(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigBruteForceConfig | undefined;
    private _treeAhConfig;
    get treeAhConfig(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfigOutputReference;
    putTreeAhConfig(value: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig): void;
    resetTreeAhConfig(): void;
    get treeAhConfigInput(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigTreeAhConfig | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview google_vertex_ai_feature_online_store_featureview}
*/
export declare class GoogleVertexAiFeatureOnlineStoreFeatureview extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_feature_online_store_featureview";
    /**
    * Generates CDKTF code for importing a GoogleVertexAiFeatureOnlineStoreFeatureview resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVertexAiFeatureOnlineStoreFeatureview to import
    * @param importFromId The id of the existing GoogleVertexAiFeatureOnlineStoreFeatureview that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVertexAiFeatureOnlineStoreFeatureview to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store_featureview google_vertex_ai_feature_online_store_featureview} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeatureOnlineStoreFeatureviewConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiFeatureOnlineStoreFeatureviewConfig);
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _featureOnlineStore?;
    get featureOnlineStore(): string;
    set featureOnlineStore(value: string);
    get featureOnlineStoreInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _bigQuerySource;
    get bigQuerySource(): GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySourceOutputReference;
    putBigQuerySource(value: GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource): void;
    resetBigQuerySource(): void;
    get bigQuerySourceInput(): GoogleVertexAiFeatureOnlineStoreFeatureviewBigQuerySource | undefined;
    private _featureRegistrySource;
    get featureRegistrySource(): GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySourceOutputReference;
    putFeatureRegistrySource(value: GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource): void;
    resetFeatureRegistrySource(): void;
    get featureRegistrySourceInput(): GoogleVertexAiFeatureOnlineStoreFeatureviewFeatureRegistrySource | undefined;
    private _syncConfig;
    get syncConfig(): GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfigOutputReference;
    putSyncConfig(value: GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig): void;
    resetSyncConfig(): void;
    get syncConfigInput(): GoogleVertexAiFeatureOnlineStoreFeatureviewSyncConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiFeatureOnlineStoreFeatureviewTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiFeatureOnlineStoreFeatureviewTimeouts | undefined;
    private _vectorSearchConfig;
    get vectorSearchConfig(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfigOutputReference;
    putVectorSearchConfig(value: GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig): void;
    resetVectorSearchConfig(): void;
    get vectorSearchConfigInput(): GoogleVertexAiFeatureOnlineStoreFeatureviewVectorSearchConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
