/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeatureOnlineStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#force_destroy GoogleVertexAiFeatureOnlineStore#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#id GoogleVertexAiFeatureOnlineStore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels with user-defined metadata to organize your feature online stores.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#labels GoogleVertexAiFeatureOnlineStore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#name GoogleVertexAiFeatureOnlineStore#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#project GoogleVertexAiFeatureOnlineStore#project}
    */
    readonly project?: string;
    /**
    * The region of feature online store. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#region GoogleVertexAiFeatureOnlineStore#region}
    */
    readonly region?: string;
    /**
    * bigtable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#bigtable GoogleVertexAiFeatureOnlineStore#bigtable}
    */
    readonly bigtable?: GoogleVertexAiFeatureOnlineStoreBigtable;
    /**
    * dedicated_serving_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#dedicated_serving_endpoint GoogleVertexAiFeatureOnlineStore#dedicated_serving_endpoint}
    */
    readonly dedicatedServingEndpoint?: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint;
    /**
    * embedding_management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#embedding_management GoogleVertexAiFeatureOnlineStore#embedding_management}
    */
    readonly embeddingManagement?: GoogleVertexAiFeatureOnlineStoreEmbeddingManagement;
    /**
    * optimized block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#optimized GoogleVertexAiFeatureOnlineStore#optimized}
    */
    readonly optimized?: GoogleVertexAiFeatureOnlineStoreOptimized;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#timeouts GoogleVertexAiFeatureOnlineStore#timeouts}
    */
    readonly timeouts?: GoogleVertexAiFeatureOnlineStoreTimeouts;
}
export interface GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling {
    /**
    * A percentage of the cluster's CPU capacity. Can be from 10% to 80%. When a cluster's CPU utilization exceeds the target that you have set, Bigtable immediately adds nodes to the cluster. When CPU utilization is substantially lower than the target, Bigtable removes nodes. If not set will default to 50%.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#cpu_utilization_target GoogleVertexAiFeatureOnlineStore#cpu_utilization_target}
    */
    readonly cpuUtilizationTarget?: number;
    /**
    * The maximum number of nodes to scale up to. Must be greater than or equal to minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#max_node_count GoogleVertexAiFeatureOnlineStore#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * The minimum number of nodes to scale down to. Must be greater than or equal to 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#min_node_count GoogleVertexAiFeatureOnlineStore#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function googleVertexAiFeatureOnlineStoreBigtableAutoScalingToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreBigtableAutoScalingOutputReference | GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling): any;
export declare function googleVertexAiFeatureOnlineStoreBigtableAutoScalingToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreBigtableAutoScalingOutputReference | GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling): any;
export declare class GoogleVertexAiFeatureOnlineStoreBigtableAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling | undefined);
    private _cpuUtilizationTarget?;
    get cpuUtilizationTarget(): number;
    set cpuUtilizationTarget(value: number);
    resetCpuUtilizationTarget(): void;
    get cpuUtilizationTargetInput(): number | undefined;
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreBigtable {
    /**
    * auto_scaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#auto_scaling GoogleVertexAiFeatureOnlineStore#auto_scaling}
    */
    readonly autoScaling: GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling;
}
export declare function googleVertexAiFeatureOnlineStoreBigtableToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreBigtableOutputReference | GoogleVertexAiFeatureOnlineStoreBigtable): any;
export declare function googleVertexAiFeatureOnlineStoreBigtableToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreBigtableOutputReference | GoogleVertexAiFeatureOnlineStoreBigtable): any;
export declare class GoogleVertexAiFeatureOnlineStoreBigtableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreBigtable | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreBigtable | undefined);
    private _autoScaling;
    get autoScaling(): GoogleVertexAiFeatureOnlineStoreBigtableAutoScalingOutputReference;
    putAutoScaling(value: GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling): void;
    get autoScalingInput(): GoogleVertexAiFeatureOnlineStoreBigtableAutoScaling | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig {
    /**
    * If set to true, customers will use private service connection to send request. Otherwise, the connection will set to public endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#enable_private_service_connect GoogleVertexAiFeatureOnlineStore#enable_private_service_connect}
    */
    readonly enablePrivateServiceConnect: boolean | cdktf.IResolvable;
    /**
    * A list of Projects from which the forwarding rule will target the service attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#project_allowlist GoogleVertexAiFeatureOnlineStore#project_allowlist}
    */
    readonly projectAllowlist?: string[];
}
export declare function googleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigOutputReference | GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig): any;
export declare function googleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigOutputReference | GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig): any;
export declare class GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig | undefined);
    private _enablePrivateServiceConnect?;
    get enablePrivateServiceConnect(): boolean | cdktf.IResolvable;
    set enablePrivateServiceConnect(value: boolean | cdktf.IResolvable);
    get enablePrivateServiceConnectInput(): boolean | cdktf.IResolvable | undefined;
    private _projectAllowlist?;
    get projectAllowlist(): string[];
    set projectAllowlist(value: string[]);
    resetProjectAllowlist(): void;
    get projectAllowlistInput(): string[] | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint {
    /**
    * private_service_connect_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#private_service_connect_config GoogleVertexAiFeatureOnlineStore#private_service_connect_config}
    */
    readonly privateServiceConnectConfig?: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig;
}
export declare function googleVertexAiFeatureOnlineStoreDedicatedServingEndpointToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointOutputReference | GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint): any;
export declare function googleVertexAiFeatureOnlineStoreDedicatedServingEndpointToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointOutputReference | GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint): any;
export declare class GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint | undefined);
    get publicEndpointDomainName(): string;
    get serviceAttachment(): string;
    private _privateServiceConnectConfig;
    get privateServiceConnectConfig(): GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfigOutputReference;
    putPrivateServiceConnectConfig(value: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig): void;
    resetPrivateServiceConnectConfig(): void;
    get privateServiceConnectConfigInput(): GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointPrivateServiceConnectConfig | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreEmbeddingManagement {
    /**
    * Enable embedding management.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#enabled GoogleVertexAiFeatureOnlineStore#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleVertexAiFeatureOnlineStoreEmbeddingManagementToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreEmbeddingManagementOutputReference | GoogleVertexAiFeatureOnlineStoreEmbeddingManagement): any;
export declare function googleVertexAiFeatureOnlineStoreEmbeddingManagementToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreEmbeddingManagementOutputReference | GoogleVertexAiFeatureOnlineStoreEmbeddingManagement): any;
export declare class GoogleVertexAiFeatureOnlineStoreEmbeddingManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreEmbeddingManagement | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreEmbeddingManagement | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleVertexAiFeatureOnlineStoreOptimized {
}
export declare function googleVertexAiFeatureOnlineStoreOptimizedToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreOptimizedOutputReference | GoogleVertexAiFeatureOnlineStoreOptimized): any;
export declare function googleVertexAiFeatureOnlineStoreOptimizedToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreOptimizedOutputReference | GoogleVertexAiFeatureOnlineStoreOptimized): any;
export declare class GoogleVertexAiFeatureOnlineStoreOptimizedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreOptimized | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreOptimized | undefined);
}
export interface GoogleVertexAiFeatureOnlineStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#create GoogleVertexAiFeatureOnlineStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#delete GoogleVertexAiFeatureOnlineStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#update GoogleVertexAiFeatureOnlineStore#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiFeatureOnlineStoreTimeoutsToTerraform(struct?: GoogleVertexAiFeatureOnlineStoreTimeouts | cdktf.IResolvable): any;
export declare function googleVertexAiFeatureOnlineStoreTimeoutsToHclTerraform(struct?: GoogleVertexAiFeatureOnlineStoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeatureOnlineStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeatureOnlineStoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeatureOnlineStoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store google_vertex_ai_feature_online_store}
*/
export declare class GoogleVertexAiFeatureOnlineStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_feature_online_store";
    /**
    * Generates CDKTF code for importing a GoogleVertexAiFeatureOnlineStore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVertexAiFeatureOnlineStore to import
    * @param importFromId The id of the existing GoogleVertexAiFeatureOnlineStore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVertexAiFeatureOnlineStore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_feature_online_store google_vertex_ai_feature_online_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeatureOnlineStoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiFeatureOnlineStoreConfig);
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _bigtable;
    get bigtable(): GoogleVertexAiFeatureOnlineStoreBigtableOutputReference;
    putBigtable(value: GoogleVertexAiFeatureOnlineStoreBigtable): void;
    resetBigtable(): void;
    get bigtableInput(): GoogleVertexAiFeatureOnlineStoreBigtable | undefined;
    private _dedicatedServingEndpoint;
    get dedicatedServingEndpoint(): GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpointOutputReference;
    putDedicatedServingEndpoint(value: GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint): void;
    resetDedicatedServingEndpoint(): void;
    get dedicatedServingEndpointInput(): GoogleVertexAiFeatureOnlineStoreDedicatedServingEndpoint | undefined;
    private _embeddingManagement;
    get embeddingManagement(): GoogleVertexAiFeatureOnlineStoreEmbeddingManagementOutputReference;
    putEmbeddingManagement(value: GoogleVertexAiFeatureOnlineStoreEmbeddingManagement): void;
    resetEmbeddingManagement(): void;
    get embeddingManagementInput(): GoogleVertexAiFeatureOnlineStoreEmbeddingManagement | undefined;
    private _optimized;
    get optimized(): GoogleVertexAiFeatureOnlineStoreOptimizedOutputReference;
    putOptimized(value: GoogleVertexAiFeatureOnlineStoreOptimized): void;
    resetOptimized(): void;
    get optimizedInput(): GoogleVertexAiFeatureOnlineStoreOptimized | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiFeatureOnlineStoreTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiFeatureOnlineStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiFeatureOnlineStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
