/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeaturestoreEntitytypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Description of the EntityType.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#description GoogleVertexAiFeaturestoreEntitytype#description}
    */
    readonly description?: string;
    /**
    * The name of the Featurestore to use, in the format projects/{project}/locations/{location}/featurestores/{featurestore}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#featurestore GoogleVertexAiFeaturestoreEntitytype#featurestore}
    */
    readonly featurestore: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#id GoogleVertexAiFeaturestoreEntitytype#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this EntityType.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#labels GoogleVertexAiFeaturestoreEntitytype#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the EntityType. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#name GoogleVertexAiFeaturestoreEntitytype#name}
    */
    readonly name?: string;
    /**
    * Config for data retention policy in offline storage. TTL in days for feature values that will be stored in offline storage. The Feature Store offline storage periodically removes obsolete feature values older than offlineStorageTtlDays since the feature generation time. If unset (or explicitly set to 0), default to 4000 days TTL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#offline_storage_ttl_days GoogleVertexAiFeaturestoreEntitytype#offline_storage_ttl_days}
    */
    readonly offlineStorageTtlDays?: number;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#monitoring_config GoogleVertexAiFeaturestoreEntitytype#monitoring_config}
    */
    readonly monitoringConfig?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#timeouts GoogleVertexAiFeaturestoreEntitytype#timeouts}
    */
    readonly timeouts?: GoogleVertexAiFeaturestoreEntitytypeTimeouts;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig {
    /**
    * Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#value GoogleVertexAiFeaturestoreEntitytype#value}
    */
    readonly value: number;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig): any;
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigToHclTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig | undefined);
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis {
    /**
    * Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
    * * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
    * * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
    * * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#anomaly_detection_baseline GoogleVertexAiFeaturestoreEntitytype#anomaly_detection_baseline}
    */
    readonly anomalyDetectionBaseline?: string;
    /**
    * Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
    * * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
    * * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
    * * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#state GoogleVertexAiFeaturestoreEntitytype#state}
    */
    readonly state?: string;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis): any;
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisToHclTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis | undefined);
    private _anomalyDetectionBaseline?;
    get anomalyDetectionBaseline(): string;
    set anomalyDetectionBaseline(value: string);
    resetAnomalyDetectionBaseline(): void;
    get anomalyDetectionBaselineInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig {
    /**
    * Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#value GoogleVertexAiFeaturestoreEntitytype#value}
    */
    readonly value: number;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig): any;
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigToHclTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig | undefined);
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis {
    /**
    * The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#disabled GoogleVertexAiFeaturestoreEntitytype#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Configuration of the snapshot analysis based monitoring pipeline running interval. The value is rolled up to full day.
    *
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#monitoring_interval GoogleVertexAiFeaturestoreEntitytype#monitoring_interval}
    */
    readonly monitoringInterval?: string;
    /**
    * Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
    * If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#monitoring_interval_days GoogleVertexAiFeaturestoreEntitytype#monitoring_interval_days}
    */
    readonly monitoringIntervalDays?: number;
    /**
    * Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#staleness_days GoogleVertexAiFeaturestoreEntitytype#staleness_days}
    */
    readonly stalenessDays?: number;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): any;
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisToHclTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoringInterval?;
    get monitoringInterval(): string;
    set monitoringInterval(value: string);
    resetMonitoringInterval(): void;
    get monitoringIntervalInput(): string | undefined;
    private _monitoringIntervalDays?;
    get monitoringIntervalDays(): number;
    set monitoringIntervalDays(value: number);
    resetMonitoringIntervalDays(): void;
    get monitoringIntervalDaysInput(): number | undefined;
    private _stalenessDays?;
    get stalenessDays(): number;
    set stalenessDays(value: number);
    resetStalenessDays(): void;
    get stalenessDaysInput(): number | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig {
    /**
    * categorical_threshold_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#categorical_threshold_config GoogleVertexAiFeaturestoreEntitytype#categorical_threshold_config}
    */
    readonly categoricalThresholdConfig?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig;
    /**
    * import_features_analysis block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#import_features_analysis GoogleVertexAiFeaturestoreEntitytype#import_features_analysis}
    */
    readonly importFeaturesAnalysis?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis;
    /**
    * numerical_threshold_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#numerical_threshold_config GoogleVertexAiFeaturestoreEntitytype#numerical_threshold_config}
    */
    readonly numericalThresholdConfig?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig;
    /**
    * snapshot_analysis block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#snapshot_analysis GoogleVertexAiFeaturestoreEntitytype#snapshot_analysis}
    */
    readonly snapshotAnalysis?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig): any;
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigToHclTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig | undefined);
    private _categoricalThresholdConfig;
    get categoricalThresholdConfig(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfigOutputReference;
    putCategoricalThresholdConfig(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig): void;
    resetCategoricalThresholdConfig(): void;
    get categoricalThresholdConfigInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigCategoricalThresholdConfig | undefined;
    private _importFeaturesAnalysis;
    get importFeaturesAnalysis(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysisOutputReference;
    putImportFeaturesAnalysis(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis): void;
    resetImportFeaturesAnalysis(): void;
    get importFeaturesAnalysisInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigImportFeaturesAnalysis | undefined;
    private _numericalThresholdConfig;
    get numericalThresholdConfig(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfigOutputReference;
    putNumericalThresholdConfig(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig): void;
    resetNumericalThresholdConfig(): void;
    get numericalThresholdConfigInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigNumericalThresholdConfig | undefined;
    private _snapshotAnalysis;
    get snapshotAnalysis(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference;
    putSnapshotAnalysis(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): void;
    resetSnapshotAnalysis(): void;
    get snapshotAnalysisInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#create GoogleVertexAiFeaturestoreEntitytype#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#delete GoogleVertexAiFeaturestoreEntitytype#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#update GoogleVertexAiFeaturestoreEntitytype#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiFeaturestoreEntitytypeTimeoutsToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable): any;
export declare function googleVertexAiFeaturestoreEntitytypeTimeoutsToHclTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype google_vertex_ai_featurestore_entitytype}
*/
export declare class GoogleVertexAiFeaturestoreEntitytype extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore_entitytype";
    /**
    * Generates CDKTF code for importing a GoogleVertexAiFeaturestoreEntitytype resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVertexAiFeaturestoreEntitytype to import
    * @param importFromId The id of the existing GoogleVertexAiFeaturestoreEntitytype that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVertexAiFeaturestoreEntitytype to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_featurestore_entitytype google_vertex_ai_featurestore_entitytype} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeaturestoreEntitytypeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiFeaturestoreEntitytypeConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _featurestore?;
    get featurestore(): string;
    set featurestore(value: string);
    get featurestoreInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _offlineStorageTtlDays?;
    get offlineStorageTtlDays(): number;
    set offlineStorageTtlDays(value: number);
    resetOfflineStorageTtlDays(): void;
    get offlineStorageTtlDaysInput(): number | undefined;
    get region(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _monitoringConfig;
    get monitoringConfig(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference;
    putMonitoringConfig(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiFeaturestoreEntitytypeTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiFeaturestoreEntitytypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiFeaturestoreEntitytypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
