/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiIndexEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the Index.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#description GoogleVertexAiIndexEndpoint#description}
    */
    readonly description?: string;
    /**
    * The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#display_name GoogleVertexAiIndexEndpoint#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#id GoogleVertexAiIndexEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels with user-defined metadata to organize your Indexes.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#labels GoogleVertexAiIndexEndpoint#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The full name of the Google Compute Engine [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks) to which the index endpoint should be peered.
    * Private services access must already be configured for the network. If left unspecified, the index endpoint is not peered with any network.
    * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert): 'projects/{project}/global/networks/{network}'.
    * Where '{project}' is a project number, as in '12345', and '{network}' is network name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#network GoogleVertexAiIndexEndpoint#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#project GoogleVertexAiIndexEndpoint#project}
    */
    readonly project?: string;
    /**
    * If true, the deployed index will be accessible through public endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#public_endpoint_enabled GoogleVertexAiIndexEndpoint#public_endpoint_enabled}
    */
    readonly publicEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * The region of the index endpoint. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#region GoogleVertexAiIndexEndpoint#region}
    */
    readonly region?: string;
    /**
    * private_service_connect_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#private_service_connect_config GoogleVertexAiIndexEndpoint#private_service_connect_config}
    */
    readonly privateServiceConnectConfig?: GoogleVertexAiIndexEndpointPrivateServiceConnectConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#timeouts GoogleVertexAiIndexEndpoint#timeouts}
    */
    readonly timeouts?: GoogleVertexAiIndexEndpointTimeouts;
}
export interface GoogleVertexAiIndexEndpointPrivateServiceConnectConfig {
    /**
    * If set to true, the IndexEndpoint is created without private service access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#enable_private_service_connect GoogleVertexAiIndexEndpoint#enable_private_service_connect}
    */
    readonly enablePrivateServiceConnect: boolean | cdktf.IResolvable;
    /**
    * A list of Projects from which the forwarding rule will target the service attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#project_allowlist GoogleVertexAiIndexEndpoint#project_allowlist}
    */
    readonly projectAllowlist?: string[];
}
export declare function googleVertexAiIndexEndpointPrivateServiceConnectConfigToTerraform(struct?: GoogleVertexAiIndexEndpointPrivateServiceConnectConfigOutputReference | GoogleVertexAiIndexEndpointPrivateServiceConnectConfig): any;
export declare function googleVertexAiIndexEndpointPrivateServiceConnectConfigToHclTerraform(struct?: GoogleVertexAiIndexEndpointPrivateServiceConnectConfigOutputReference | GoogleVertexAiIndexEndpointPrivateServiceConnectConfig): any;
export declare class GoogleVertexAiIndexEndpointPrivateServiceConnectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexEndpointPrivateServiceConnectConfig | undefined;
    set internalValue(value: GoogleVertexAiIndexEndpointPrivateServiceConnectConfig | undefined);
    private _enablePrivateServiceConnect?;
    get enablePrivateServiceConnect(): boolean | cdktf.IResolvable;
    set enablePrivateServiceConnect(value: boolean | cdktf.IResolvable);
    get enablePrivateServiceConnectInput(): boolean | cdktf.IResolvable | undefined;
    private _projectAllowlist?;
    get projectAllowlist(): string[];
    set projectAllowlist(value: string[]);
    resetProjectAllowlist(): void;
    get projectAllowlistInput(): string[] | undefined;
}
export interface GoogleVertexAiIndexEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#create GoogleVertexAiIndexEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#delete GoogleVertexAiIndexEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#update GoogleVertexAiIndexEndpoint#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiIndexEndpointTimeoutsToTerraform(struct?: GoogleVertexAiIndexEndpointTimeouts | cdktf.IResolvable): any;
export declare function googleVertexAiIndexEndpointTimeoutsToHclTerraform(struct?: GoogleVertexAiIndexEndpointTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiIndexEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiIndexEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint google_vertex_ai_index_endpoint}
*/
export declare class GoogleVertexAiIndexEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_index_endpoint";
    /**
    * Generates CDKTF code for importing a GoogleVertexAiIndexEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVertexAiIndexEndpoint to import
    * @param importFromId The id of the existing GoogleVertexAiIndexEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVertexAiIndexEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vertex_ai_index_endpoint google_vertex_ai_index_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiIndexEndpointConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiIndexEndpointConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicEndpointDomainName(): string;
    private _publicEndpointEnabled?;
    get publicEndpointEnabled(): boolean | cdktf.IResolvable;
    set publicEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetPublicEndpointEnabled(): void;
    get publicEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _privateServiceConnectConfig;
    get privateServiceConnectConfig(): GoogleVertexAiIndexEndpointPrivateServiceConnectConfigOutputReference;
    putPrivateServiceConnectConfig(value: GoogleVertexAiIndexEndpointPrivateServiceConnectConfig): void;
    resetPrivateServiceConnectConfig(): void;
    get privateServiceConnectConfigInput(): GoogleVertexAiIndexEndpointPrivateServiceConnectConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiIndexEndpointTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiIndexEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiIndexEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
