/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareengineClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#id GoogleVmwareengineCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#name GoogleVmwareengineCluster#name}
    */
    readonly name: string;
    /**
    * The resource name of the private cloud to create a new cluster in.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-west1-a/privateClouds/my-cloud
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#parent GoogleVmwareengineCluster#parent}
    */
    readonly parent: string;
    /**
    * node_type_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#node_type_configs GoogleVmwareengineCluster#node_type_configs}
    */
    readonly nodeTypeConfigs?: GoogleVmwareengineClusterNodeTypeConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#timeouts GoogleVmwareengineCluster#timeouts}
    */
    readonly timeouts?: GoogleVmwareengineClusterTimeouts;
}
export interface GoogleVmwareengineClusterNodeTypeConfigs {
    /**
    * Customized number of cores available to each node of the type.
    * This number must always be one of 'nodeType.availableCustomCoreCounts'.
    * If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
    * Once the customer is created then corecount cannot be changed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#custom_core_count GoogleVmwareengineCluster#custom_core_count}
    */
    readonly customCoreCount?: number;
    /**
    * The number of nodes of this type in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#node_count GoogleVmwareengineCluster#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#node_type_id GoogleVmwareengineCluster#node_type_id}
    */
    readonly nodeTypeId: string;
}
export declare function googleVmwareengineClusterNodeTypeConfigsToTerraform(struct?: GoogleVmwareengineClusterNodeTypeConfigs | cdktf.IResolvable): any;
export declare function googleVmwareengineClusterNodeTypeConfigsToHclTerraform(struct?: GoogleVmwareengineClusterNodeTypeConfigs | cdktf.IResolvable): any;
export declare class GoogleVmwareengineClusterNodeTypeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareengineClusterNodeTypeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineClusterNodeTypeConfigs | cdktf.IResolvable | undefined);
    private _customCoreCount?;
    get customCoreCount(): number;
    set customCoreCount(value: number);
    resetCustomCoreCount(): void;
    get customCoreCountInput(): number | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    get nodeTypeIdInput(): string | undefined;
}
export declare class GoogleVmwareengineClusterNodeTypeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleVmwareengineClusterNodeTypeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareengineClusterNodeTypeConfigsOutputReference;
}
export interface GoogleVmwareengineClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#create GoogleVmwareengineCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#delete GoogleVmwareengineCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#update GoogleVmwareengineCluster#update}
    */
    readonly update?: string;
}
export declare function googleVmwareengineClusterTimeoutsToTerraform(struct?: GoogleVmwareengineClusterTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareengineClusterTimeoutsToHclTerraform(struct?: GoogleVmwareengineClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareengineClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster google_vmwareengine_cluster}
*/
export declare class GoogleVmwareengineCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_cluster";
    /**
    * Generates CDKTF code for importing a GoogleVmwareengineCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareengineCluster to import
    * @param importFromId The id of the existing GoogleVmwareengineCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareengineCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_cluster google_vmwareengine_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareengineClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareengineClusterConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get management(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get state(): string;
    get uid(): string;
    private _nodeTypeConfigs;
    get nodeTypeConfigs(): GoogleVmwareengineClusterNodeTypeConfigsList;
    putNodeTypeConfigs(value: GoogleVmwareengineClusterNodeTypeConfigs[] | cdktf.IResolvable): void;
    resetNodeTypeConfigs(): void;
    get nodeTypeConfigsInput(): cdktf.IResolvable | GoogleVmwareengineClusterNodeTypeConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleVmwareengineClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareengineClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareengineClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
