/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareengineExternalAccessRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The action that the external access rule performs. Possible values: ["ALLOW", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#action GoogleVmwareengineExternalAccessRule#action}
    */
    readonly action: string;
    /**
    * User-provided description for the external access rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#description GoogleVmwareengineExternalAccessRule#description}
    */
    readonly description?: string;
    /**
    * A list of destination ports to which the external access rule applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#destination_ports GoogleVmwareengineExternalAccessRule#destination_ports}
    */
    readonly destinationPorts: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#id GoogleVmwareengineExternalAccessRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The IP protocol to which the external access rule applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#ip_protocol GoogleVmwareengineExternalAccessRule#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * The ID of the external access rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#name GoogleVmwareengineExternalAccessRule#name}
    */
    readonly name: string;
    /**
    * The resource name of the network policy.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#parent GoogleVmwareengineExternalAccessRule#parent}
    */
    readonly parent: string;
    /**
    * External access rule priority, which determines the external access rule to use when multiple rules apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#priority GoogleVmwareengineExternalAccessRule#priority}
    */
    readonly priority: number;
    /**
    * A list of source ports to which the external access rule applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#source_ports GoogleVmwareengineExternalAccessRule#source_ports}
    */
    readonly sourcePorts: string[];
    /**
    * destination_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#destination_ip_ranges GoogleVmwareengineExternalAccessRule#destination_ip_ranges}
    */
    readonly destinationIpRanges: GoogleVmwareengineExternalAccessRuleDestinationIpRanges[] | cdktf.IResolvable;
    /**
    * source_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#source_ip_ranges GoogleVmwareengineExternalAccessRule#source_ip_ranges}
    */
    readonly sourceIpRanges: GoogleVmwareengineExternalAccessRuleSourceIpRanges[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#timeouts GoogleVmwareengineExternalAccessRule#timeouts}
    */
    readonly timeouts?: GoogleVmwareengineExternalAccessRuleTimeouts;
}
export interface GoogleVmwareengineExternalAccessRuleDestinationIpRanges {
    /**
    * The name of an 'ExternalAddress' resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#external_address GoogleVmwareengineExternalAccessRule#external_address}
    */
    readonly externalAddress?: string;
    /**
    * An IP address range in the CIDR format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#ip_address_range GoogleVmwareengineExternalAccessRule#ip_address_range}
    */
    readonly ipAddressRange?: string;
}
export declare function googleVmwareengineExternalAccessRuleDestinationIpRangesToTerraform(struct?: GoogleVmwareengineExternalAccessRuleDestinationIpRanges | cdktf.IResolvable): any;
export declare function googleVmwareengineExternalAccessRuleDestinationIpRangesToHclTerraform(struct?: GoogleVmwareengineExternalAccessRuleDestinationIpRanges | cdktf.IResolvable): any;
export declare class GoogleVmwareengineExternalAccessRuleDestinationIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareengineExternalAccessRuleDestinationIpRanges | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineExternalAccessRuleDestinationIpRanges | cdktf.IResolvable | undefined);
    private _externalAddress?;
    get externalAddress(): string;
    set externalAddress(value: string);
    resetExternalAddress(): void;
    get externalAddressInput(): string | undefined;
    private _ipAddressRange?;
    get ipAddressRange(): string;
    set ipAddressRange(value: string);
    resetIpAddressRange(): void;
    get ipAddressRangeInput(): string | undefined;
}
export declare class GoogleVmwareengineExternalAccessRuleDestinationIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleVmwareengineExternalAccessRuleDestinationIpRanges[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareengineExternalAccessRuleDestinationIpRangesOutputReference;
}
export interface GoogleVmwareengineExternalAccessRuleSourceIpRanges {
    /**
    * A single IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#ip_address GoogleVmwareengineExternalAccessRule#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * An IP address range in the CIDR format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#ip_address_range GoogleVmwareengineExternalAccessRule#ip_address_range}
    */
    readonly ipAddressRange?: string;
}
export declare function googleVmwareengineExternalAccessRuleSourceIpRangesToTerraform(struct?: GoogleVmwareengineExternalAccessRuleSourceIpRanges | cdktf.IResolvable): any;
export declare function googleVmwareengineExternalAccessRuleSourceIpRangesToHclTerraform(struct?: GoogleVmwareengineExternalAccessRuleSourceIpRanges | cdktf.IResolvable): any;
export declare class GoogleVmwareengineExternalAccessRuleSourceIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareengineExternalAccessRuleSourceIpRanges | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineExternalAccessRuleSourceIpRanges | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipAddressRange?;
    get ipAddressRange(): string;
    set ipAddressRange(value: string);
    resetIpAddressRange(): void;
    get ipAddressRangeInput(): string | undefined;
}
export declare class GoogleVmwareengineExternalAccessRuleSourceIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleVmwareengineExternalAccessRuleSourceIpRanges[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareengineExternalAccessRuleSourceIpRangesOutputReference;
}
export interface GoogleVmwareengineExternalAccessRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#create GoogleVmwareengineExternalAccessRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#delete GoogleVmwareengineExternalAccessRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#update GoogleVmwareengineExternalAccessRule#update}
    */
    readonly update?: string;
}
export declare function googleVmwareengineExternalAccessRuleTimeoutsToTerraform(struct?: GoogleVmwareengineExternalAccessRuleTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareengineExternalAccessRuleTimeoutsToHclTerraform(struct?: GoogleVmwareengineExternalAccessRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareengineExternalAccessRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineExternalAccessRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineExternalAccessRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule google_vmwareengine_external_access_rule}
*/
export declare class GoogleVmwareengineExternalAccessRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_external_access_rule";
    /**
    * Generates CDKTF code for importing a GoogleVmwareengineExternalAccessRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareengineExternalAccessRule to import
    * @param importFromId The id of the existing GoogleVmwareengineExternalAccessRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareengineExternalAccessRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_access_rule google_vmwareengine_external_access_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareengineExternalAccessRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareengineExternalAccessRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationPorts?;
    get destinationPorts(): string[];
    set destinationPorts(value: string[]);
    get destinationPortsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _sourcePorts?;
    get sourcePorts(): string[];
    set sourcePorts(value: string[]);
    get sourcePortsInput(): string[] | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _destinationIpRanges;
    get destinationIpRanges(): GoogleVmwareengineExternalAccessRuleDestinationIpRangesList;
    putDestinationIpRanges(value: GoogleVmwareengineExternalAccessRuleDestinationIpRanges[] | cdktf.IResolvable): void;
    get destinationIpRangesInput(): cdktf.IResolvable | GoogleVmwareengineExternalAccessRuleDestinationIpRanges[] | undefined;
    private _sourceIpRanges;
    get sourceIpRanges(): GoogleVmwareengineExternalAccessRuleSourceIpRangesList;
    putSourceIpRanges(value: GoogleVmwareengineExternalAccessRuleSourceIpRanges[] | cdktf.IResolvable): void;
    get sourceIpRangesInput(): cdktf.IResolvable | GoogleVmwareengineExternalAccessRuleSourceIpRanges[] | undefined;
    private _timeouts;
    get timeouts(): GoogleVmwareengineExternalAccessRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareengineExternalAccessRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareengineExternalAccessRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
