/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareengineExternalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-provided description for this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#description GoogleVmwareengineExternalAddress#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#id GoogleVmwareengineExternalAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The internal IP address of a workload VM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#internal_ip GoogleVmwareengineExternalAddress#internal_ip}
    */
    readonly internalIp: string;
    /**
    * The ID of the external IP Address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#name GoogleVmwareengineExternalAddress#name}
    */
    readonly name: string;
    /**
    * The resource name of the private cloud to create a new external address in.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-west1-a/privateClouds/my-cloud
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#parent GoogleVmwareengineExternalAddress#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#timeouts GoogleVmwareengineExternalAddress#timeouts}
    */
    readonly timeouts?: GoogleVmwareengineExternalAddressTimeouts;
}
export interface GoogleVmwareengineExternalAddressTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#create GoogleVmwareengineExternalAddress#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#delete GoogleVmwareengineExternalAddress#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#update GoogleVmwareengineExternalAddress#update}
    */
    readonly update?: string;
}
export declare function googleVmwareengineExternalAddressTimeoutsToTerraform(struct?: GoogleVmwareengineExternalAddressTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareengineExternalAddressTimeoutsToHclTerraform(struct?: GoogleVmwareengineExternalAddressTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareengineExternalAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineExternalAddressTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineExternalAddressTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address google_vmwareengine_external_address}
*/
export declare class GoogleVmwareengineExternalAddress extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_external_address";
    /**
    * Generates CDKTF code for importing a GoogleVmwareengineExternalAddress resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareengineExternalAddress to import
    * @param importFromId The id of the existing GoogleVmwareengineExternalAddress that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareengineExternalAddress to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_external_address google_vmwareengine_external_address} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareengineExternalAddressConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareengineExternalAddressConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get externalIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internalIp?;
    get internalIp(): string;
    set internalIp(value: string);
    get internalIpInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleVmwareengineExternalAddressTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareengineExternalAddressTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareengineExternalAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
