/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareengineNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-provided description for this network peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#description GoogleVmwareengineNetworkPeering#description}
    */
    readonly description?: string;
    /**
    * True if custom routes are exported to the peered network; false otherwise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#export_custom_routes GoogleVmwareengineNetworkPeering#export_custom_routes}
    */
    readonly exportCustomRoutes?: boolean | cdktf.IResolvable;
    /**
    * True if all subnet routes with a public IP address range are exported; false otherwise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#export_custom_routes_with_public_ip GoogleVmwareengineNetworkPeering#export_custom_routes_with_public_ip}
    */
    readonly exportCustomRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#id GoogleVmwareengineNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * True if custom routes are imported from the peered network; false otherwise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#import_custom_routes GoogleVmwareengineNetworkPeering#import_custom_routes}
    */
    readonly importCustomRoutes?: boolean | cdktf.IResolvable;
    /**
    * True if custom routes are imported from the peered network; false otherwise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#import_custom_routes_with_public_ip GoogleVmwareengineNetworkPeering#import_custom_routes_with_public_ip}
    */
    readonly importCustomRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Network Peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#name GoogleVmwareengineNetworkPeering#name}
    */
    readonly name: string;
    /**
    * The relative resource name of the network to peer with a standard VMware Engine network.
    * The provided network can be a consumer VPC network or another standard VMware Engine network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#peer_network GoogleVmwareengineNetworkPeering#peer_network}
    */
    readonly peerNetwork: string;
    /**
    * The type of the network to peer with the VMware Engine network. Possible values: ["STANDARD", "VMWARE_ENGINE_NETWORK", "PRIVATE_SERVICES_ACCESS", "NETAPP_CLOUD_VOLUMES", "THIRD_PARTY_SERVICE", "DELL_POWERSCALE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#peer_network_type GoogleVmwareengineNetworkPeering#peer_network_type}
    */
    readonly peerNetworkType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#project GoogleVmwareengineNetworkPeering#project}
    */
    readonly project?: string;
    /**
    * The relative resource name of the VMware Engine network. Specify the name in the following form:
    * projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
    * can either be a project number or a project ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#vmware_engine_network GoogleVmwareengineNetworkPeering#vmware_engine_network}
    */
    readonly vmwareEngineNetwork: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#timeouts GoogleVmwareengineNetworkPeering#timeouts}
    */
    readonly timeouts?: GoogleVmwareengineNetworkPeeringTimeouts;
}
export interface GoogleVmwareengineNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#create GoogleVmwareengineNetworkPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#delete GoogleVmwareengineNetworkPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#update GoogleVmwareengineNetworkPeering#update}
    */
    readonly update?: string;
}
export declare function googleVmwareengineNetworkPeeringTimeoutsToTerraform(struct?: GoogleVmwareengineNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareengineNetworkPeeringTimeoutsToHclTerraform(struct?: GoogleVmwareengineNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareengineNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering google_vmwareengine_network_peering}
*/
export declare class GoogleVmwareengineNetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_network_peering";
    /**
    * Generates CDKTF code for importing a GoogleVmwareengineNetworkPeering resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareengineNetworkPeering to import
    * @param importFromId The id of the existing GoogleVmwareengineNetworkPeering that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareengineNetworkPeering to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_peering google_vmwareengine_network_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareengineNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareengineNetworkPeeringConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _exportCustomRoutes?;
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    resetExportCustomRoutes(): void;
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _exportCustomRoutesWithPublicIp?;
    get exportCustomRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    set exportCustomRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    resetExportCustomRoutesWithPublicIp(): void;
    get exportCustomRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importCustomRoutes?;
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    resetImportCustomRoutes(): void;
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _importCustomRoutesWithPublicIp?;
    get importCustomRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    set importCustomRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    resetImportCustomRoutesWithPublicIp(): void;
    get importCustomRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerNetwork?;
    get peerNetwork(): string;
    set peerNetwork(value: string);
    get peerNetworkInput(): string | undefined;
    private _peerNetworkType?;
    get peerNetworkType(): string;
    set peerNetworkType(value: string);
    get peerNetworkTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get stateDetails(): string;
    get uid(): string;
    get updateTime(): string;
    private _vmwareEngineNetwork?;
    get vmwareEngineNetwork(): string;
    set vmwareEngineNetwork(value: string);
    get vmwareEngineNetworkInput(): string | undefined;
    get vmwareEngineNetworkCanonical(): string;
    private _timeouts;
    get timeouts(): GoogleVmwareengineNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareengineNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareengineNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
