/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareengineNetworkPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-provided description for this network policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#description GoogleVmwareengineNetworkPolicy#description}
    */
    readonly description?: string;
    /**
    * IP address range in CIDR notation used to create internet access and external IP access.
    * An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
    * prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#edge_services_cidr GoogleVmwareengineNetworkPolicy#edge_services_cidr}
    */
    readonly edgeServicesCidr: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#id GoogleVmwareengineNetworkPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the location (region) to create the new network policy in.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#location GoogleVmwareengineNetworkPolicy#location}
    */
    readonly location: string;
    /**
    * The ID of the Network Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#name GoogleVmwareengineNetworkPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#project GoogleVmwareengineNetworkPolicy#project}
    */
    readonly project?: string;
    /**
    * The relative resource name of the VMware Engine network. Specify the name in the following form:
    * projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
    * can either be a project number or a project ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#vmware_engine_network GoogleVmwareengineNetworkPolicy#vmware_engine_network}
    */
    readonly vmwareEngineNetwork: string;
    /**
    * external_ip block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#external_ip GoogleVmwareengineNetworkPolicy#external_ip}
    */
    readonly externalIp?: GoogleVmwareengineNetworkPolicyExternalIp;
    /**
    * internet_access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#internet_access GoogleVmwareengineNetworkPolicy#internet_access}
    */
    readonly internetAccess?: GoogleVmwareengineNetworkPolicyInternetAccess;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#timeouts GoogleVmwareengineNetworkPolicy#timeouts}
    */
    readonly timeouts?: GoogleVmwareengineNetworkPolicyTimeouts;
}
export interface GoogleVmwareengineNetworkPolicyExternalIp {
    /**
    * True if the service is enabled; false otherwise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#enabled GoogleVmwareengineNetworkPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleVmwareengineNetworkPolicyExternalIpToTerraform(struct?: GoogleVmwareengineNetworkPolicyExternalIpOutputReference | GoogleVmwareengineNetworkPolicyExternalIp): any;
export declare function googleVmwareengineNetworkPolicyExternalIpToHclTerraform(struct?: GoogleVmwareengineNetworkPolicyExternalIpOutputReference | GoogleVmwareengineNetworkPolicyExternalIp): any;
export declare class GoogleVmwareengineNetworkPolicyExternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineNetworkPolicyExternalIp | undefined;
    set internalValue(value: GoogleVmwareengineNetworkPolicyExternalIp | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get state(): string;
}
export interface GoogleVmwareengineNetworkPolicyInternetAccess {
    /**
    * True if the service is enabled; false otherwise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#enabled GoogleVmwareengineNetworkPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleVmwareengineNetworkPolicyInternetAccessToTerraform(struct?: GoogleVmwareengineNetworkPolicyInternetAccessOutputReference | GoogleVmwareengineNetworkPolicyInternetAccess): any;
export declare function googleVmwareengineNetworkPolicyInternetAccessToHclTerraform(struct?: GoogleVmwareengineNetworkPolicyInternetAccessOutputReference | GoogleVmwareengineNetworkPolicyInternetAccess): any;
export declare class GoogleVmwareengineNetworkPolicyInternetAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineNetworkPolicyInternetAccess | undefined;
    set internalValue(value: GoogleVmwareengineNetworkPolicyInternetAccess | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get state(): string;
}
export interface GoogleVmwareengineNetworkPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#create GoogleVmwareengineNetworkPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#delete GoogleVmwareengineNetworkPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#update GoogleVmwareengineNetworkPolicy#update}
    */
    readonly update?: string;
}
export declare function googleVmwareengineNetworkPolicyTimeoutsToTerraform(struct?: GoogleVmwareengineNetworkPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareengineNetworkPolicyTimeoutsToHclTerraform(struct?: GoogleVmwareengineNetworkPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareengineNetworkPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineNetworkPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineNetworkPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy google_vmwareengine_network_policy}
*/
export declare class GoogleVmwareengineNetworkPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_network_policy";
    /**
    * Generates CDKTF code for importing a GoogleVmwareengineNetworkPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareengineNetworkPolicy to import
    * @param importFromId The id of the existing GoogleVmwareengineNetworkPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareengineNetworkPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_network_policy google_vmwareengine_network_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareengineNetworkPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareengineNetworkPolicyConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _edgeServicesCidr?;
    get edgeServicesCidr(): string;
    set edgeServicesCidr(value: string);
    get edgeServicesCidrInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _vmwareEngineNetwork?;
    get vmwareEngineNetwork(): string;
    set vmwareEngineNetwork(value: string);
    get vmwareEngineNetworkInput(): string | undefined;
    get vmwareEngineNetworkCanonical(): string;
    private _externalIp;
    get externalIp(): GoogleVmwareengineNetworkPolicyExternalIpOutputReference;
    putExternalIp(value: GoogleVmwareengineNetworkPolicyExternalIp): void;
    resetExternalIp(): void;
    get externalIpInput(): GoogleVmwareengineNetworkPolicyExternalIp | undefined;
    private _internetAccess;
    get internetAccess(): GoogleVmwareengineNetworkPolicyInternetAccessOutputReference;
    putInternetAccess(value: GoogleVmwareengineNetworkPolicyInternetAccess): void;
    resetInternetAccess(): void;
    get internetAccessInput(): GoogleVmwareengineNetworkPolicyInternetAccess | undefined;
    private _timeouts;
    get timeouts(): GoogleVmwareengineNetworkPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareengineNetworkPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareengineNetworkPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
