/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareenginePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-provided description for this private cloud.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#description GoogleVmwareenginePrivateCloud#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#id GoogleVmwareenginePrivateCloud#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location where the PrivateCloud should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#location GoogleVmwareenginePrivateCloud#location}
    */
    readonly location: string;
    /**
    * The ID of the PrivateCloud.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#name GoogleVmwareenginePrivateCloud#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#project GoogleVmwareenginePrivateCloud#project}
    */
    readonly project?: string;
    /**
    * Initial type of the private cloud. Possible values: ["STANDARD", "TIME_LIMITED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#type GoogleVmwareenginePrivateCloud#type}
    */
    readonly type?: string;
    /**
    * management_cluster block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#management_cluster GoogleVmwareenginePrivateCloud#management_cluster}
    */
    readonly managementCluster: GoogleVmwareenginePrivateCloudManagementCluster;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#network_config GoogleVmwareenginePrivateCloud#network_config}
    */
    readonly networkConfig: GoogleVmwareenginePrivateCloudNetworkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#timeouts GoogleVmwareenginePrivateCloud#timeouts}
    */
    readonly timeouts?: GoogleVmwareenginePrivateCloudTimeouts;
}
export interface GoogleVmwareenginePrivateCloudHcx {
}
export declare function googleVmwareenginePrivateCloudHcxToTerraform(struct?: GoogleVmwareenginePrivateCloudHcx): any;
export declare function googleVmwareenginePrivateCloudHcxToHclTerraform(struct?: GoogleVmwareenginePrivateCloudHcx): any;
export declare class GoogleVmwareenginePrivateCloudHcxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareenginePrivateCloudHcx | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudHcx | undefined);
    get fqdn(): string;
    get internalIp(): string;
    get state(): string;
    get version(): string;
}
export declare class GoogleVmwareenginePrivateCloudHcxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareenginePrivateCloudHcxOutputReference;
}
export interface GoogleVmwareenginePrivateCloudNsx {
}
export declare function googleVmwareenginePrivateCloudNsxToTerraform(struct?: GoogleVmwareenginePrivateCloudNsx): any;
export declare function googleVmwareenginePrivateCloudNsxToHclTerraform(struct?: GoogleVmwareenginePrivateCloudNsx): any;
export declare class GoogleVmwareenginePrivateCloudNsxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareenginePrivateCloudNsx | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudNsx | undefined);
    get fqdn(): string;
    get internalIp(): string;
    get state(): string;
    get version(): string;
}
export declare class GoogleVmwareenginePrivateCloudNsxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareenginePrivateCloudNsxOutputReference;
}
export interface GoogleVmwareenginePrivateCloudVcenter {
}
export declare function googleVmwareenginePrivateCloudVcenterToTerraform(struct?: GoogleVmwareenginePrivateCloudVcenter): any;
export declare function googleVmwareenginePrivateCloudVcenterToHclTerraform(struct?: GoogleVmwareenginePrivateCloudVcenter): any;
export declare class GoogleVmwareenginePrivateCloudVcenterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareenginePrivateCloudVcenter | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudVcenter | undefined);
    get fqdn(): string;
    get internalIp(): string;
    get state(): string;
    get version(): string;
}
export declare class GoogleVmwareenginePrivateCloudVcenterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareenginePrivateCloudVcenterOutputReference;
}
export interface GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs {
    /**
    * Customized number of cores available to each node of the type.
    * This number must always be one of 'nodeType.availableCustomCoreCounts'.
    * If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
    * This cannot be changed once the PrivateCloud is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#custom_core_count GoogleVmwareenginePrivateCloud#custom_core_count}
    */
    readonly customCoreCount?: number;
    /**
    * The number of nodes of this type in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#node_count GoogleVmwareenginePrivateCloud#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#node_type_id GoogleVmwareenginePrivateCloud#node_type_id}
    */
    readonly nodeTypeId: string;
}
export declare function googleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsToTerraform(struct?: GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs | cdktf.IResolvable): any;
export declare function googleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsToHclTerraform(struct?: GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs | cdktf.IResolvable): any;
export declare class GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs | cdktf.IResolvable | undefined);
    private _customCoreCount?;
    get customCoreCount(): number;
    set customCoreCount(value: number);
    resetCustomCoreCount(): void;
    get customCoreCountInput(): number | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    get nodeTypeIdInput(): string | undefined;
}
export declare class GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsOutputReference;
}
export interface GoogleVmwareenginePrivateCloudManagementCluster {
    /**
    * The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
    *   * Only contains 1-63 alphanumeric characters and hyphens
    *   * Begins with an alphabetical character
    *   * Ends with a non-hyphen character
    *   * Not formatted as a UUID
    *   * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#cluster_id GoogleVmwareenginePrivateCloud#cluster_id}
    */
    readonly clusterId: string;
    /**
    * node_type_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#node_type_configs GoogleVmwareenginePrivateCloud#node_type_configs}
    */
    readonly nodeTypeConfigs?: GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs[] | cdktf.IResolvable;
}
export declare function googleVmwareenginePrivateCloudManagementClusterToTerraform(struct?: GoogleVmwareenginePrivateCloudManagementClusterOutputReference | GoogleVmwareenginePrivateCloudManagementCluster): any;
export declare function googleVmwareenginePrivateCloudManagementClusterToHclTerraform(struct?: GoogleVmwareenginePrivateCloudManagementClusterOutputReference | GoogleVmwareenginePrivateCloudManagementCluster): any;
export declare class GoogleVmwareenginePrivateCloudManagementClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareenginePrivateCloudManagementCluster | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudManagementCluster | undefined);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _nodeTypeConfigs;
    get nodeTypeConfigs(): GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigsList;
    putNodeTypeConfigs(value: GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs[] | cdktf.IResolvable): void;
    resetNodeTypeConfigs(): void;
    get nodeTypeConfigsInput(): cdktf.IResolvable | GoogleVmwareenginePrivateCloudManagementClusterNodeTypeConfigs[] | undefined;
}
export interface GoogleVmwareenginePrivateCloudNetworkConfig {
    /**
    * Management CIDR used by VMware management appliances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#management_cidr GoogleVmwareenginePrivateCloud#management_cidr}
    */
    readonly managementCidr: string;
    /**
    * The relative resource name of the VMware Engine network attached to the private cloud.
    * Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
    * where {project} can either be a project number or a project ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#vmware_engine_network GoogleVmwareenginePrivateCloud#vmware_engine_network}
    */
    readonly vmwareEngineNetwork?: string;
}
export declare function googleVmwareenginePrivateCloudNetworkConfigToTerraform(struct?: GoogleVmwareenginePrivateCloudNetworkConfigOutputReference | GoogleVmwareenginePrivateCloudNetworkConfig): any;
export declare function googleVmwareenginePrivateCloudNetworkConfigToHclTerraform(struct?: GoogleVmwareenginePrivateCloudNetworkConfigOutputReference | GoogleVmwareenginePrivateCloudNetworkConfig): any;
export declare class GoogleVmwareenginePrivateCloudNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareenginePrivateCloudNetworkConfig | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudNetworkConfig | undefined);
    get dnsServerIp(): string;
    private _managementCidr?;
    get managementCidr(): string;
    set managementCidr(value: string);
    get managementCidrInput(): string | undefined;
    get managementIpAddressLayoutVersion(): number;
    private _vmwareEngineNetwork?;
    get vmwareEngineNetwork(): string;
    set vmwareEngineNetwork(value: string);
    resetVmwareEngineNetwork(): void;
    get vmwareEngineNetworkInput(): string | undefined;
    get vmwareEngineNetworkCanonical(): string;
}
export interface GoogleVmwareenginePrivateCloudTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#create GoogleVmwareenginePrivateCloud#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#delete GoogleVmwareenginePrivateCloud#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#update GoogleVmwareenginePrivateCloud#update}
    */
    readonly update?: string;
}
export declare function googleVmwareenginePrivateCloudTimeoutsToTerraform(struct?: GoogleVmwareenginePrivateCloudTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareenginePrivateCloudTimeoutsToHclTerraform(struct?: GoogleVmwareenginePrivateCloudTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareenginePrivateCloudTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareenginePrivateCloudTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareenginePrivateCloudTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud google_vmwareengine_private_cloud}
*/
export declare class GoogleVmwareenginePrivateCloud extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_private_cloud";
    /**
    * Generates CDKTF code for importing a GoogleVmwareenginePrivateCloud resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareenginePrivateCloud to import
    * @param importFromId The id of the existing GoogleVmwareenginePrivateCloud that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareenginePrivateCloud to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_private_cloud google_vmwareengine_private_cloud} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareenginePrivateCloudConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareenginePrivateCloudConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hcx;
    get hcx(): GoogleVmwareenginePrivateCloudHcxList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nsx;
    get nsx(): GoogleVmwareenginePrivateCloudNsxList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get uid(): string;
    private _vcenter;
    get vcenter(): GoogleVmwareenginePrivateCloudVcenterList;
    private _managementCluster;
    get managementCluster(): GoogleVmwareenginePrivateCloudManagementClusterOutputReference;
    putManagementCluster(value: GoogleVmwareenginePrivateCloudManagementCluster): void;
    get managementClusterInput(): GoogleVmwareenginePrivateCloudManagementCluster | undefined;
    private _networkConfig;
    get networkConfig(): GoogleVmwareenginePrivateCloudNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleVmwareenginePrivateCloudNetworkConfig): void;
    get networkConfigInput(): GoogleVmwareenginePrivateCloudNetworkConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleVmwareenginePrivateCloudTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareenginePrivateCloudTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareenginePrivateCloudTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
