/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVmwareengineSubnetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#id GoogleVmwareengineSubnet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The IP address range of the subnet in CIDR format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#ip_cidr_range GoogleVmwareengineSubnet#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * The ID of the subnet. For userDefined subnets, this name should be in the format of "service-n",
    * where n ranges from 1 to 5.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#name GoogleVmwareengineSubnet#name}
    */
    readonly name: string;
    /**
    * The resource name of the private cloud to create a new subnet in.
    * Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
    * For example: projects/my-project/locations/us-west1-a/privateClouds/my-cloud
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#parent GoogleVmwareengineSubnet#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#timeouts GoogleVmwareengineSubnet#timeouts}
    */
    readonly timeouts?: GoogleVmwareengineSubnetTimeouts;
}
export interface GoogleVmwareengineSubnetDhcpAddressRanges {
}
export declare function googleVmwareengineSubnetDhcpAddressRangesToTerraform(struct?: GoogleVmwareengineSubnetDhcpAddressRanges): any;
export declare function googleVmwareengineSubnetDhcpAddressRangesToHclTerraform(struct?: GoogleVmwareengineSubnetDhcpAddressRanges): any;
export declare class GoogleVmwareengineSubnetDhcpAddressRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVmwareengineSubnetDhcpAddressRanges | undefined;
    set internalValue(value: GoogleVmwareengineSubnetDhcpAddressRanges | undefined);
    get firstAddress(): string;
    get lastAddress(): string;
}
export declare class GoogleVmwareengineSubnetDhcpAddressRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVmwareengineSubnetDhcpAddressRangesOutputReference;
}
export interface GoogleVmwareengineSubnetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#create GoogleVmwareengineSubnet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#delete GoogleVmwareengineSubnet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#update GoogleVmwareengineSubnet#update}
    */
    readonly update?: string;
}
export declare function googleVmwareengineSubnetTimeoutsToTerraform(struct?: GoogleVmwareengineSubnetTimeouts | cdktf.IResolvable): any;
export declare function googleVmwareengineSubnetTimeoutsToHclTerraform(struct?: GoogleVmwareengineSubnetTimeouts | cdktf.IResolvable): any;
export declare class GoogleVmwareengineSubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVmwareengineSubnetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVmwareengineSubnetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet google_vmwareengine_subnet}
*/
export declare class GoogleVmwareengineSubnet extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vmwareengine_subnet";
    /**
    * Generates CDKTF code for importing a GoogleVmwareengineSubnet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVmwareengineSubnet to import
    * @param importFromId The id of the existing GoogleVmwareengineSubnet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVmwareengineSubnet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vmwareengine_subnet google_vmwareengine_subnet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVmwareengineSubnetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVmwareengineSubnetConfig);
    get createTime(): string;
    private _dhcpAddressRanges;
    get dhcpAddressRanges(): GoogleVmwareengineSubnetDhcpAddressRangesList;
    get gatewayId(): string;
    get gatewayIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get standardConfig(): cdktf.IResolvable;
    get state(): string;
    get type(): string;
    get uid(): string;
    get updateTime(): string;
    get vlanId(): number;
    private _timeouts;
    get timeouts(): GoogleVmwareengineSubnetTimeoutsOutputReference;
    putTimeouts(value: GoogleVmwareengineSubnetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVmwareengineSubnetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
