/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVpcAccessConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#id GoogleVpcAccessConnector#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The range of internal addresses that follows RFC 4632 notation. Example: '10.132.0.0/28'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#ip_cidr_range GoogleVpcAccessConnector#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Machine type of VM Instance underlying connector. Default is e2-micro
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#machine_type GoogleVpcAccessConnector#machine_type}
    */
    readonly machineType?: string;
    /**
    * Maximum value of instances in autoscaling group underlying the connector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#max_instances GoogleVpcAccessConnector#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * Maximum throughput of the connector in Mbps, must be greater than 'min_throughput'. Default is 300.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#max_throughput GoogleVpcAccessConnector#max_throughput}
    */
    readonly maxThroughput?: number;
    /**
    * Minimum value of instances in autoscaling group underlying the connector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#min_instances GoogleVpcAccessConnector#min_instances}
    */
    readonly minInstances?: number;
    /**
    * Minimum throughput of the connector in Mbps. Default and min is 200.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#min_throughput GoogleVpcAccessConnector#min_throughput}
    */
    readonly minThroughput?: number;
    /**
    * The name of the resource (Max 25 characters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#name GoogleVpcAccessConnector#name}
    */
    readonly name: string;
    /**
    * Name or self_link of the VPC network. Required if 'ip_cidr_range' is set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#network GoogleVpcAccessConnector#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#project GoogleVpcAccessConnector#project}
    */
    readonly project?: string;
    /**
    * Region where the VPC Access connector resides. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#region GoogleVpcAccessConnector#region}
    */
    readonly region?: string;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#subnet GoogleVpcAccessConnector#subnet}
    */
    readonly subnet?: GoogleVpcAccessConnectorSubnet;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#timeouts GoogleVpcAccessConnector#timeouts}
    */
    readonly timeouts?: GoogleVpcAccessConnectorTimeouts;
}
export interface GoogleVpcAccessConnectorSubnet {
    /**
    * Subnet name (relative, not fully qualified). E.g. if the full subnet selfLink is
    * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName} the correct input for this field would be {subnetName}"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#name GoogleVpcAccessConnector#name}
    */
    readonly name?: string;
    /**
    * Project in which the subnet exists. If not set, this project is assumed to be the project for which the connector create request was issued.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#project_id GoogleVpcAccessConnector#project_id}
    */
    readonly projectId?: string;
}
export declare function googleVpcAccessConnectorSubnetToTerraform(struct?: GoogleVpcAccessConnectorSubnetOutputReference | GoogleVpcAccessConnectorSubnet): any;
export declare function googleVpcAccessConnectorSubnetToHclTerraform(struct?: GoogleVpcAccessConnectorSubnetOutputReference | GoogleVpcAccessConnectorSubnet): any;
export declare class GoogleVpcAccessConnectorSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVpcAccessConnectorSubnet | undefined;
    set internalValue(value: GoogleVpcAccessConnectorSubnet | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface GoogleVpcAccessConnectorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#create GoogleVpcAccessConnector#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#delete GoogleVpcAccessConnector#delete}
    */
    readonly delete?: string;
}
export declare function googleVpcAccessConnectorTimeoutsToTerraform(struct?: GoogleVpcAccessConnectorTimeouts | cdktf.IResolvable): any;
export declare function googleVpcAccessConnectorTimeoutsToHclTerraform(struct?: GoogleVpcAccessConnectorTimeouts | cdktf.IResolvable): any;
export declare class GoogleVpcAccessConnectorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVpcAccessConnectorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVpcAccessConnectorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector google_vpc_access_connector}
*/
export declare class GoogleVpcAccessConnector extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vpc_access_connector";
    /**
    * Generates CDKTF code for importing a GoogleVpcAccessConnector resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleVpcAccessConnector to import
    * @param importFromId The id of the existing GoogleVpcAccessConnector that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleVpcAccessConnector to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_vpc_access_connector google_vpc_access_connector} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVpcAccessConnectorConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVpcAccessConnectorConfig);
    get connectedProjects(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _minThroughput?;
    get minThroughput(): number;
    set minThroughput(value: number);
    resetMinThroughput(): void;
    get minThroughputInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get state(): string;
    private _subnet;
    get subnet(): GoogleVpcAccessConnectorSubnetOutputReference;
    putSubnet(value: GoogleVpcAccessConnectorSubnet): void;
    resetSubnet(): void;
    get subnetInput(): GoogleVpcAccessConnectorSubnet | undefined;
    private _timeouts;
    get timeouts(): GoogleVpcAccessConnectorTimeoutsOutputReference;
    putTimeouts(value: GoogleVpcAccessConnectorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVpcAccessConnectorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
