/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleWorkbenchInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Desired state of the Workbench Instance. Set this field to 'ACTIVE' to start the Instance, and 'STOPPED' to stop the Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#desired_state GoogleWorkbenchInstance#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Optional. If true, the workbench instance will not register with the proxy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disable_proxy_access GoogleWorkbenchInstance#disable_proxy_access}
    */
    readonly disableProxyAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#id GoogleWorkbenchInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Required. User-defined unique ID of this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#instance_id GoogleWorkbenchInstance#instance_id}
    */
    readonly instanceId?: string;
    /**
    * 'Optional. Input only. The owner of this instance after creation. Format:
    * 'alias@example.com' Currently supports one owner only. If not specified, all of
    * the service account users of your VM instance''s service account can use the instance.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#instance_owners GoogleWorkbenchInstance#instance_owners}
    */
    readonly instanceOwners?: string[];
    /**
    * Optional. Labels to apply to this instance. These can be later modified
    * by the UpdateInstance method.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#labels GoogleWorkbenchInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Part of 'parent'. See documentation of 'projectsId'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#location GoogleWorkbenchInstance#location}
    */
    readonly location: string;
    /**
    * The name of this workbench instance. Format: 'projects/{project_id}/locations/{location}/instances/{instance_id}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#name GoogleWorkbenchInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#project GoogleWorkbenchInstance#project}
    */
    readonly project?: string;
    /**
    * gce_setup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#gce_setup GoogleWorkbenchInstance#gce_setup}
    */
    readonly gceSetup?: GoogleWorkbenchInstanceGceSetup;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#timeouts GoogleWorkbenchInstance#timeouts}
    */
    readonly timeouts?: GoogleWorkbenchInstanceTimeouts;
}
export interface GoogleWorkbenchInstanceHealthInfo {
}
export declare function googleWorkbenchInstanceHealthInfoToTerraform(struct?: GoogleWorkbenchInstanceHealthInfo): any;
export declare function googleWorkbenchInstanceHealthInfoToHclTerraform(struct?: GoogleWorkbenchInstanceHealthInfo): any;
export declare class GoogleWorkbenchInstanceHealthInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkbenchInstanceHealthInfo | undefined;
    set internalValue(value: GoogleWorkbenchInstanceHealthInfo | undefined);
}
export declare class GoogleWorkbenchInstanceHealthInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkbenchInstanceHealthInfoOutputReference;
}
export interface GoogleWorkbenchInstanceUpgradeHistory {
}
export declare function googleWorkbenchInstanceUpgradeHistoryToTerraform(struct?: GoogleWorkbenchInstanceUpgradeHistory): any;
export declare function googleWorkbenchInstanceUpgradeHistoryToHclTerraform(struct?: GoogleWorkbenchInstanceUpgradeHistory): any;
export declare class GoogleWorkbenchInstanceUpgradeHistoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkbenchInstanceUpgradeHistory | undefined;
    set internalValue(value: GoogleWorkbenchInstanceUpgradeHistory | undefined);
    get action(): string;
    get containerImage(): string;
    get createTime(): string;
    get framework(): string;
    get snapshot(): string;
    get state(): string;
    get targetVersion(): string;
    get version(): string;
    get vmImage(): string;
}
export declare class GoogleWorkbenchInstanceUpgradeHistoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkbenchInstanceUpgradeHistoryOutputReference;
}
export interface GoogleWorkbenchInstanceGceSetupAcceleratorConfigs {
    /**
    * Optional. Count of cores of this accelerator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#core_count GoogleWorkbenchInstance#core_count}
    */
    readonly coreCount?: string;
    /**
    * Optional. Type of this accelerator. Possible values: ["NVIDIA_TESLA_P100", "NVIDIA_TESLA_V100", "NVIDIA_TESLA_P4", "NVIDIA_TESLA_T4", "NVIDIA_TESLA_A100", "NVIDIA_A100_80GB", "NVIDIA_L4", "NVIDIA_TESLA_T4_VWS", "NVIDIA_TESLA_P100_VWS", "NVIDIA_TESLA_P4_VWS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#type GoogleWorkbenchInstance#type}
    */
    readonly type?: string;
}
export declare function googleWorkbenchInstanceGceSetupAcceleratorConfigsToTerraform(struct?: GoogleWorkbenchInstanceGceSetupAcceleratorConfigs | cdktf.IResolvable): any;
export declare function googleWorkbenchInstanceGceSetupAcceleratorConfigsToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupAcceleratorConfigs | cdktf.IResolvable): any;
export declare class GoogleWorkbenchInstanceGceSetupAcceleratorConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkbenchInstanceGceSetupAcceleratorConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupAcceleratorConfigs | cdktf.IResolvable | undefined);
    private _coreCount?;
    get coreCount(): string;
    set coreCount(value: string);
    resetCoreCount(): void;
    get coreCountInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleWorkbenchInstanceGceSetupAcceleratorConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkbenchInstanceGceSetupAcceleratorConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkbenchInstanceGceSetupAcceleratorConfigsOutputReference;
}
export interface GoogleWorkbenchInstanceGceSetupBootDisk {
    /**
    * Optional. Input only. Disk encryption method used on the boot and
    * data disks, defaults to GMEK. Possible values: ["GMEK", "CMEK"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disk_encryption GoogleWorkbenchInstance#disk_encryption}
    */
    readonly diskEncryption?: string;
    /**
    * Optional. The size of the boot disk in GB attached to this instance,
    * up to a maximum of 64000 GB (64 TB). If not specified, this defaults to the
    * recommended value of 150GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disk_size_gb GoogleWorkbenchInstance#disk_size_gb}
    */
    readonly diskSizeGb?: string;
    /**
    * Optional. Indicates the type of the disk. Possible values: ["PD_STANDARD", "PD_SSD", "PD_BALANCED", "PD_EXTREME"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disk_type GoogleWorkbenchInstance#disk_type}
    */
    readonly diskType?: string;
    /**
    * 'Optional. The KMS key used to encrypt the disks, only
    * applicable if disk_encryption is CMEK. Format: 'projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}'
    * Learn more about using your own encryption keys.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#kms_key GoogleWorkbenchInstance#kms_key}
    */
    readonly kmsKey?: string;
}
export declare function googleWorkbenchInstanceGceSetupBootDiskToTerraform(struct?: GoogleWorkbenchInstanceGceSetupBootDiskOutputReference | GoogleWorkbenchInstanceGceSetupBootDisk): any;
export declare function googleWorkbenchInstanceGceSetupBootDiskToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupBootDiskOutputReference | GoogleWorkbenchInstanceGceSetupBootDisk): any;
export declare class GoogleWorkbenchInstanceGceSetupBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceGceSetupBootDisk | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupBootDisk | undefined);
    private _diskEncryption?;
    get diskEncryption(): string;
    set diskEncryption(value: string);
    resetDiskEncryption(): void;
    get diskEncryptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): string;
    set diskSizeGb(value: string);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): string | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
}
export interface GoogleWorkbenchInstanceGceSetupContainerImage {
    /**
    * The path to the container image repository.
    * For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#repository GoogleWorkbenchInstance#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#tag GoogleWorkbenchInstance#tag}
    */
    readonly tag?: string;
}
export declare function googleWorkbenchInstanceGceSetupContainerImageToTerraform(struct?: GoogleWorkbenchInstanceGceSetupContainerImageOutputReference | GoogleWorkbenchInstanceGceSetupContainerImage): any;
export declare function googleWorkbenchInstanceGceSetupContainerImageToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupContainerImageOutputReference | GoogleWorkbenchInstanceGceSetupContainerImage): any;
export declare class GoogleWorkbenchInstanceGceSetupContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceGceSetupContainerImage | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupContainerImage | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface GoogleWorkbenchInstanceGceSetupDataDisks {
    /**
    * Optional. Input only. Disk encryption method used on the boot
    * and data disks, defaults to GMEK. Possible values: ["GMEK", "CMEK"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disk_encryption GoogleWorkbenchInstance#disk_encryption}
    */
    readonly diskEncryption?: string;
    /**
    * Optional. The size of the disk in GB attached to this VM instance,
    * up to a maximum of 64000 GB (64 TB). If not specified, this defaults to
    * 100.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disk_size_gb GoogleWorkbenchInstance#disk_size_gb}
    */
    readonly diskSizeGb?: string;
    /**
    * Optional. Input only. Indicates the type of the disk. Possible values: ["PD_STANDARD", "PD_SSD", "PD_BALANCED", "PD_EXTREME"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disk_type GoogleWorkbenchInstance#disk_type}
    */
    readonly diskType?: string;
    /**
    * 'Optional. The KMS key used to encrypt the disks,
    * only applicable if disk_encryption is CMEK. Format: 'projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}'
    * Learn more about using your own encryption keys.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#kms_key GoogleWorkbenchInstance#kms_key}
    */
    readonly kmsKey?: string;
}
export declare function googleWorkbenchInstanceGceSetupDataDisksToTerraform(struct?: GoogleWorkbenchInstanceGceSetupDataDisksOutputReference | GoogleWorkbenchInstanceGceSetupDataDisks): any;
export declare function googleWorkbenchInstanceGceSetupDataDisksToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupDataDisksOutputReference | GoogleWorkbenchInstanceGceSetupDataDisks): any;
export declare class GoogleWorkbenchInstanceGceSetupDataDisksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceGceSetupDataDisks | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupDataDisks | undefined);
    private _diskEncryption?;
    get diskEncryption(): string;
    set diskEncryption(value: string);
    resetDiskEncryption(): void;
    get diskEncryptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): string;
    set diskSizeGb(value: string);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): string | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
}
export interface GoogleWorkbenchInstanceGceSetupNetworkInterfaces {
    /**
    * Optional. The name of the VPC that this VM instance is in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#network GoogleWorkbenchInstance#network}
    */
    readonly network?: string;
    /**
    * Optional. The type of vNIC to be used on this interface. This
    * may be gVNIC or VirtioNet. Possible values: ["VIRTIO_NET", "GVNIC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#nic_type GoogleWorkbenchInstance#nic_type}
    */
    readonly nicType?: string;
    /**
    * Optional. The name of the subnet that this VM instance is in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#subnet GoogleWorkbenchInstance#subnet}
    */
    readonly subnet?: string;
}
export declare function googleWorkbenchInstanceGceSetupNetworkInterfacesToTerraform(struct?: GoogleWorkbenchInstanceGceSetupNetworkInterfaces | cdktf.IResolvable): any;
export declare function googleWorkbenchInstanceGceSetupNetworkInterfacesToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupNetworkInterfaces | cdktf.IResolvable): any;
export declare class GoogleWorkbenchInstanceGceSetupNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkbenchInstanceGceSetupNetworkInterfaces | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupNetworkInterfaces | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
}
export declare class GoogleWorkbenchInstanceGceSetupNetworkInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkbenchInstanceGceSetupNetworkInterfaces[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkbenchInstanceGceSetupNetworkInterfacesOutputReference;
}
export interface GoogleWorkbenchInstanceGceSetupServiceAccounts {
    /**
    * Optional. Email address of the service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#email GoogleWorkbenchInstance#email}
    */
    readonly email?: string;
}
export declare function googleWorkbenchInstanceGceSetupServiceAccountsToTerraform(struct?: GoogleWorkbenchInstanceGceSetupServiceAccounts | cdktf.IResolvable): any;
export declare function googleWorkbenchInstanceGceSetupServiceAccountsToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupServiceAccounts | cdktf.IResolvable): any;
export declare class GoogleWorkbenchInstanceGceSetupServiceAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkbenchInstanceGceSetupServiceAccounts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupServiceAccounts | cdktf.IResolvable | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    get scopes(): string[];
}
export declare class GoogleWorkbenchInstanceGceSetupServiceAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkbenchInstanceGceSetupServiceAccounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkbenchInstanceGceSetupServiceAccountsOutputReference;
}
export interface GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig {
    /**
    * Optional. Defines whether the VM instance has integrity monitoring
    * enabled. Enables monitoring and attestation of the boot integrity of the VM
    * instance. The attestation is performed against the integrity policy baseline.
    * This baseline is initially derived from the implicitly trusted boot image
    * when the VM instance is created. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#enable_integrity_monitoring GoogleWorkbenchInstance#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Optional. Defines whether the VM instance has Secure Boot enabled.
    * Secure Boot helps ensure that the system only runs authentic software by verifying
    * the digital signature of all boot components, and halting the boot process
    * if signature verification fails. Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#enable_secure_boot GoogleWorkbenchInstance#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Optional. Defines whether the VM instance has the vTPM enabled.
    * Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#enable_vtpm GoogleWorkbenchInstance#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleWorkbenchInstanceGceSetupShieldedInstanceConfigToTerraform(struct?: GoogleWorkbenchInstanceGceSetupShieldedInstanceConfigOutputReference | GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig): any;
export declare function googleWorkbenchInstanceGceSetupShieldedInstanceConfigToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupShieldedInstanceConfigOutputReference | GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig): any;
export declare class GoogleWorkbenchInstanceGceSetupShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleWorkbenchInstanceGceSetupVmImage {
    /**
    * Optional. Use this VM image family to find the image; the newest
    * image in this family will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#family GoogleWorkbenchInstance#family}
    */
    readonly family?: string;
    /**
    * Optional. Use VM image name to find the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#name GoogleWorkbenchInstance#name}
    */
    readonly name?: string;
    /**
    * The name of the Google Cloud project that this VM image belongs to.
    * Format: {project_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#project GoogleWorkbenchInstance#project}
    */
    readonly project?: string;
}
export declare function googleWorkbenchInstanceGceSetupVmImageToTerraform(struct?: GoogleWorkbenchInstanceGceSetupVmImageOutputReference | GoogleWorkbenchInstanceGceSetupVmImage): any;
export declare function googleWorkbenchInstanceGceSetupVmImageToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupVmImageOutputReference | GoogleWorkbenchInstanceGceSetupVmImage): any;
export declare class GoogleWorkbenchInstanceGceSetupVmImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceGceSetupVmImage | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetupVmImage | undefined);
    private _family?;
    get family(): string;
    set family(value: string);
    resetFamily(): void;
    get familyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface GoogleWorkbenchInstanceGceSetup {
    /**
    * Optional. If true, no external IP will be assigned to this VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#disable_public_ip GoogleWorkbenchInstance#disable_public_ip}
    */
    readonly disablePublicIp?: boolean | cdktf.IResolvable;
    /**
    * Optional. Flag to enable ip forwarding or not, default false/off.
    * https://cloud.google.com/vpc/docs/using-routes#canipforward
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#enable_ip_forwarding GoogleWorkbenchInstance#enable_ip_forwarding}
    */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
    * Optional. The machine type of the VM instance. https://cloud.google.com/compute/docs/machine-resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#machine_type GoogleWorkbenchInstance#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Custom metadata to apply to this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#metadata GoogleWorkbenchInstance#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Optional. The Compute Engine tags to add to instance (see [Tagging
    * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#tags GoogleWorkbenchInstance#tags}
    */
    readonly tags?: string[];
    /**
    * accelerator_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#accelerator_configs GoogleWorkbenchInstance#accelerator_configs}
    */
    readonly acceleratorConfigs?: GoogleWorkbenchInstanceGceSetupAcceleratorConfigs[] | cdktf.IResolvable;
    /**
    * boot_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#boot_disk GoogleWorkbenchInstance#boot_disk}
    */
    readonly bootDisk?: GoogleWorkbenchInstanceGceSetupBootDisk;
    /**
    * container_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#container_image GoogleWorkbenchInstance#container_image}
    */
    readonly containerImage?: GoogleWorkbenchInstanceGceSetupContainerImage;
    /**
    * data_disks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#data_disks GoogleWorkbenchInstance#data_disks}
    */
    readonly dataDisks?: GoogleWorkbenchInstanceGceSetupDataDisks;
    /**
    * network_interfaces block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#network_interfaces GoogleWorkbenchInstance#network_interfaces}
    */
    readonly networkInterfaces?: GoogleWorkbenchInstanceGceSetupNetworkInterfaces[] | cdktf.IResolvable;
    /**
    * service_accounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#service_accounts GoogleWorkbenchInstance#service_accounts}
    */
    readonly serviceAccounts?: GoogleWorkbenchInstanceGceSetupServiceAccounts[] | cdktf.IResolvable;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#shielded_instance_config GoogleWorkbenchInstance#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig;
    /**
    * vm_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#vm_image GoogleWorkbenchInstance#vm_image}
    */
    readonly vmImage?: GoogleWorkbenchInstanceGceSetupVmImage;
}
export declare function googleWorkbenchInstanceGceSetupToTerraform(struct?: GoogleWorkbenchInstanceGceSetupOutputReference | GoogleWorkbenchInstanceGceSetup): any;
export declare function googleWorkbenchInstanceGceSetupToHclTerraform(struct?: GoogleWorkbenchInstanceGceSetupOutputReference | GoogleWorkbenchInstanceGceSetup): any;
export declare class GoogleWorkbenchInstanceGceSetupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceGceSetup | undefined;
    set internalValue(value: GoogleWorkbenchInstanceGceSetup | undefined);
    private _disablePublicIp?;
    get disablePublicIp(): boolean | cdktf.IResolvable;
    set disablePublicIp(value: boolean | cdktf.IResolvable);
    resetDisablePublicIp(): void;
    get disablePublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIpForwarding?;
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    resetEnableIpForwarding(): void;
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _acceleratorConfigs;
    get acceleratorConfigs(): GoogleWorkbenchInstanceGceSetupAcceleratorConfigsList;
    putAcceleratorConfigs(value: GoogleWorkbenchInstanceGceSetupAcceleratorConfigs[] | cdktf.IResolvable): void;
    resetAcceleratorConfigs(): void;
    get acceleratorConfigsInput(): cdktf.IResolvable | GoogleWorkbenchInstanceGceSetupAcceleratorConfigs[] | undefined;
    private _bootDisk;
    get bootDisk(): GoogleWorkbenchInstanceGceSetupBootDiskOutputReference;
    putBootDisk(value: GoogleWorkbenchInstanceGceSetupBootDisk): void;
    resetBootDisk(): void;
    get bootDiskInput(): GoogleWorkbenchInstanceGceSetupBootDisk | undefined;
    private _containerImage;
    get containerImage(): GoogleWorkbenchInstanceGceSetupContainerImageOutputReference;
    putContainerImage(value: GoogleWorkbenchInstanceGceSetupContainerImage): void;
    resetContainerImage(): void;
    get containerImageInput(): GoogleWorkbenchInstanceGceSetupContainerImage | undefined;
    private _dataDisks;
    get dataDisks(): GoogleWorkbenchInstanceGceSetupDataDisksOutputReference;
    putDataDisks(value: GoogleWorkbenchInstanceGceSetupDataDisks): void;
    resetDataDisks(): void;
    get dataDisksInput(): GoogleWorkbenchInstanceGceSetupDataDisks | undefined;
    private _networkInterfaces;
    get networkInterfaces(): GoogleWorkbenchInstanceGceSetupNetworkInterfacesList;
    putNetworkInterfaces(value: GoogleWorkbenchInstanceGceSetupNetworkInterfaces[] | cdktf.IResolvable): void;
    resetNetworkInterfaces(): void;
    get networkInterfacesInput(): cdktf.IResolvable | GoogleWorkbenchInstanceGceSetupNetworkInterfaces[] | undefined;
    private _serviceAccounts;
    get serviceAccounts(): GoogleWorkbenchInstanceGceSetupServiceAccountsList;
    putServiceAccounts(value: GoogleWorkbenchInstanceGceSetupServiceAccounts[] | cdktf.IResolvable): void;
    resetServiceAccounts(): void;
    get serviceAccountsInput(): cdktf.IResolvable | GoogleWorkbenchInstanceGceSetupServiceAccounts[] | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleWorkbenchInstanceGceSetupShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleWorkbenchInstanceGceSetupShieldedInstanceConfig | undefined;
    private _vmImage;
    get vmImage(): GoogleWorkbenchInstanceGceSetupVmImageOutputReference;
    putVmImage(value: GoogleWorkbenchInstanceGceSetupVmImage): void;
    resetVmImage(): void;
    get vmImageInput(): GoogleWorkbenchInstanceGceSetupVmImage | undefined;
}
export interface GoogleWorkbenchInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#create GoogleWorkbenchInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#delete GoogleWorkbenchInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#update GoogleWorkbenchInstance#update}
    */
    readonly update?: string;
}
export declare function googleWorkbenchInstanceTimeoutsToTerraform(struct?: GoogleWorkbenchInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleWorkbenchInstanceTimeoutsToHclTerraform(struct?: GoogleWorkbenchInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleWorkbenchInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkbenchInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkbenchInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance google_workbench_instance}
*/
export declare class GoogleWorkbenchInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_workbench_instance";
    /**
    * Generates CDKTF code for importing a GoogleWorkbenchInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleWorkbenchInstance to import
    * @param importFromId The id of the existing GoogleWorkbenchInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleWorkbenchInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workbench_instance google_workbench_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleWorkbenchInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleWorkbenchInstanceConfig);
    get createTime(): string;
    get creator(): string;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _disableProxyAccess?;
    get disableProxyAccess(): boolean | cdktf.IResolvable;
    set disableProxyAccess(value: boolean | cdktf.IResolvable);
    resetDisableProxyAccess(): void;
    get disableProxyAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _healthInfo;
    get healthInfo(): GoogleWorkbenchInstanceHealthInfoList;
    get healthState(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _instanceOwners?;
    get instanceOwners(): string[];
    set instanceOwners(value: string[]);
    resetInstanceOwners(): void;
    get instanceOwnersInput(): string[] | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get proxyUri(): string;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _upgradeHistory;
    get upgradeHistory(): GoogleWorkbenchInstanceUpgradeHistoryList;
    private _gceSetup;
    get gceSetup(): GoogleWorkbenchInstanceGceSetupOutputReference;
    putGceSetup(value: GoogleWorkbenchInstanceGceSetup): void;
    resetGceSetup(): void;
    get gceSetupInput(): GoogleWorkbenchInstanceGceSetup | undefined;
    private _timeouts;
    get timeouts(): GoogleWorkbenchInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleWorkbenchInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleWorkbenchInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
