/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleWorkflowsWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Describes the level of platform logging to apply to calls and call responses during
    * executions of this workflow. If both the workflow and the execution specify a logging level,
    * the execution level takes precedence. Possible values: ["CALL_LOG_LEVEL_UNSPECIFIED", "LOG_ALL_CALLS", "LOG_ERRORS_ONLY", "LOG_NONE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#call_log_level GoogleWorkflowsWorkflow#call_log_level}
    */
    readonly callLogLevel?: string;
    /**
    * The KMS key used to encrypt workflow and execution data.
    *
    * Format: projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#crypto_key_name GoogleWorkflowsWorkflow#crypto_key_name}
    */
    readonly cryptoKeyName?: string;
    /**
    * Description of the workflow provided by the user. Must be at most 1000 unicode characters long.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#description GoogleWorkflowsWorkflow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#id GoogleWorkflowsWorkflow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this Workflow.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#labels GoogleWorkflowsWorkflow#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the Workflow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#name GoogleWorkflowsWorkflow#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#name_prefix GoogleWorkflowsWorkflow#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#project GoogleWorkflowsWorkflow#project}
    */
    readonly project?: string;
    /**
    * The region of the workflow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#region GoogleWorkflowsWorkflow#region}
    */
    readonly region?: string;
    /**
    * Name of the service account associated with the latest workflow version. This service
    * account represents the identity of the workflow and determines what permissions the workflow has.
    * Format: projects/{project}/serviceAccounts/{account} or {account}.
    * Using - as a wildcard for the {project} or not providing one at all will infer the project from the account.
    * The {account} value can be the email address or the unique_id of the service account.
    * If not provided, workflow will use the project's default service account.
    * Modifying this field for an existing workflow results in a new workflow revision.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#service_account GoogleWorkflowsWorkflow#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Workflow code to be executed. The size limit is 128KB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#source_contents GoogleWorkflowsWorkflow#source_contents}
    */
    readonly sourceContents?: string;
    /**
    * User-defined environment variables associated with this workflow revision. This map has a maximum length of 20. Each string can take up to 4KiB. Keys cannot be empty strings and cannot start with “GOOGLE” or “WORKFLOWS".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#user_env_vars GoogleWorkflowsWorkflow#user_env_vars}
    */
    readonly userEnvVars?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#timeouts GoogleWorkflowsWorkflow#timeouts}
    */
    readonly timeouts?: GoogleWorkflowsWorkflowTimeouts;
}
export interface GoogleWorkflowsWorkflowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#create GoogleWorkflowsWorkflow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#delete GoogleWorkflowsWorkflow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#update GoogleWorkflowsWorkflow#update}
    */
    readonly update?: string;
}
export declare function googleWorkflowsWorkflowTimeoutsToTerraform(struct?: GoogleWorkflowsWorkflowTimeouts | cdktf.IResolvable): any;
export declare function googleWorkflowsWorkflowTimeoutsToHclTerraform(struct?: GoogleWorkflowsWorkflowTimeouts | cdktf.IResolvable): any;
export declare class GoogleWorkflowsWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkflowsWorkflowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkflowsWorkflowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow google_workflows_workflow}
*/
export declare class GoogleWorkflowsWorkflow extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_workflows_workflow";
    /**
    * Generates CDKTF code for importing a GoogleWorkflowsWorkflow resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleWorkflowsWorkflow to import
    * @param importFromId The id of the existing GoogleWorkflowsWorkflow that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleWorkflowsWorkflow to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workflows_workflow google_workflows_workflow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleWorkflowsWorkflowConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleWorkflowsWorkflowConfig);
    private _callLogLevel?;
    get callLogLevel(): string;
    set callLogLevel(value: string);
    resetCallLogLevel(): void;
    get callLogLevelInput(): string | undefined;
    get createTime(): string;
    private _cryptoKeyName?;
    get cryptoKeyName(): string;
    set cryptoKeyName(value: string);
    resetCryptoKeyName(): void;
    get cryptoKeyNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get revisionId(): string;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _sourceContents?;
    get sourceContents(): string;
    set sourceContents(value: string);
    resetSourceContents(): void;
    get sourceContentsInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _userEnvVars?;
    get userEnvVars(): {
        [key: string]: string;
    };
    set userEnvVars(value: {
        [key: string]: string;
    });
    resetUserEnvVars(): void;
    get userEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): GoogleWorkflowsWorkflowTimeoutsOutputReference;
    putTimeouts(value: GoogleWorkflowsWorkflowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleWorkflowsWorkflowTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
