/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleWorkstationsWorkstationConfigAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Client-specified annotations. This is distinct from labels.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#annotations GoogleWorkstationsWorkstationConfigA#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Disables support for plain TCP connections in the workstation. By default the service supports TCP connections via a websocket relay. Setting this option to true disables that relay, which prevents the usage of services that require plain tcp connections, such as ssh. When enabled, all communication must occur over https or wss.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#disable_tcp_connections GoogleWorkstationsWorkstationConfigA#disable_tcp_connections}
    */
    readonly disableTcpConnections?: boolean | cdktf.IResolvable;
    /**
    * Human-readable name for this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#display_name GoogleWorkstationsWorkstationConfigA#display_name}
    */
    readonly displayName?: string;
    /**
    * Whether to enable Linux 'auditd' logging on the workstation. When enabled, a service account must also be specified that has 'logging.buckets.write' permission on the project. Operating system audit logging is distinct from Cloud Audit Logs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#enable_audit_agent GoogleWorkstationsWorkstationConfigA#enable_audit_agent}
    */
    readonly enableAuditAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#id GoogleWorkstationsWorkstationConfigA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#idle_timeout GoogleWorkstationsWorkstationConfigA#idle_timeout}
    */
    readonly idleTimeout?: string;
    /**
    * Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#labels GoogleWorkstationsWorkstationConfigA#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the workstation cluster config should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#location GoogleWorkstationsWorkstationConfigA#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#project GoogleWorkstationsWorkstationConfigA#project}
    */
    readonly project?: string;
    /**
    * Specifies the zones used to replicate the VM and disk resources within the region. If set, exactly two zones within the workstation cluster's region must be specified—for example, '['us-central1-a', 'us-central1-f']'.
    * If this field is empty, two default zones within the region are used. Immutable after the workstation configuration is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#replica_zones GoogleWorkstationsWorkstationConfigA#replica_zones}
    */
    readonly replicaZones?: string[];
    /**
    * How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if 'encryption_key' is set. Defaults to 12 hours.
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#running_timeout GoogleWorkstationsWorkstationConfigA#running_timeout}
    */
    readonly runningTimeout?: string;
    /**
    * The ID of the parent workstation cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#workstation_cluster_id GoogleWorkstationsWorkstationConfigA#workstation_cluster_id}
    */
    readonly workstationClusterId: string;
    /**
    * The ID to be assigned to the workstation cluster config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#workstation_config_id GoogleWorkstationsWorkstationConfigA#workstation_config_id}
    */
    readonly workstationConfigId: string;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#container GoogleWorkstationsWorkstationConfigA#container}
    */
    readonly container?: GoogleWorkstationsWorkstationConfigContainer;
    /**
    * encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#encryption_key GoogleWorkstationsWorkstationConfigA#encryption_key}
    */
    readonly encryptionKey?: GoogleWorkstationsWorkstationConfigEncryptionKey;
    /**
    * ephemeral_directories block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#ephemeral_directories GoogleWorkstationsWorkstationConfigA#ephemeral_directories}
    */
    readonly ephemeralDirectories?: GoogleWorkstationsWorkstationConfigEphemeralDirectories[] | cdktf.IResolvable;
    /**
    * host block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#host GoogleWorkstationsWorkstationConfigA#host}
    */
    readonly host?: GoogleWorkstationsWorkstationConfigHost;
    /**
    * persistent_directories block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#persistent_directories GoogleWorkstationsWorkstationConfigA#persistent_directories}
    */
    readonly persistentDirectories?: GoogleWorkstationsWorkstationConfigPersistentDirectories[] | cdktf.IResolvable;
    /**
    * readiness_checks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#readiness_checks GoogleWorkstationsWorkstationConfigA#readiness_checks}
    */
    readonly readinessChecks?: GoogleWorkstationsWorkstationConfigReadinessChecks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#timeouts GoogleWorkstationsWorkstationConfigA#timeouts}
    */
    readonly timeouts?: GoogleWorkstationsWorkstationConfigTimeouts;
}
export interface GoogleWorkstationsWorkstationConfigConditions {
}
export declare function googleWorkstationsWorkstationConfigConditionsToTerraform(struct?: GoogleWorkstationsWorkstationConfigConditions): any;
export declare function googleWorkstationsWorkstationConfigConditionsToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigConditions): any;
export declare class GoogleWorkstationsWorkstationConfigConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigConditions | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigConditions | undefined);
    get code(): number;
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
}
export declare class GoogleWorkstationsWorkstationConfigConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigConditionsOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigContainer {
    /**
    * Arguments passed to the entrypoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#args GoogleWorkstationsWorkstationConfigA#args}
    */
    readonly args?: string[];
    /**
    * If set, overrides the default ENTRYPOINT specified by the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#command GoogleWorkstationsWorkstationConfigA#command}
    */
    readonly command?: string[];
    /**
    * Environment variables passed to the container.
    * The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#env GoogleWorkstationsWorkstationConfigA#env}
    */
    readonly env?: {
        [key: string]: string;
    };
    /**
    * Docker image defining the container. This image must be accessible by the config's service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#image GoogleWorkstationsWorkstationConfigA#image}
    */
    readonly image?: string;
    /**
    * If set, overrides the USER specified in the image with the given uid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#run_as_user GoogleWorkstationsWorkstationConfigA#run_as_user}
    */
    readonly runAsUser?: number;
    /**
    * If set, overrides the default DIR specified by the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#working_dir GoogleWorkstationsWorkstationConfigA#working_dir}
    */
    readonly workingDir?: string;
}
export declare function googleWorkstationsWorkstationConfigContainerToTerraform(struct?: GoogleWorkstationsWorkstationConfigContainerOutputReference | GoogleWorkstationsWorkstationConfigContainer): any;
export declare function googleWorkstationsWorkstationConfigContainerToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigContainerOutputReference | GoogleWorkstationsWorkstationConfigContainer): any;
export declare class GoogleWorkstationsWorkstationConfigContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigContainer | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigContainer | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _env?;
    get env(): {
        [key: string]: string;
    };
    set env(value: {
        [key: string]: string;
    });
    resetEnv(): void;
    get envInput(): {
        [key: string]: string;
    } | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _runAsUser?;
    get runAsUser(): number;
    set runAsUser(value: number);
    resetRunAsUser(): void;
    get runAsUserInput(): number | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
}
export interface GoogleWorkstationsWorkstationConfigEncryptionKey {
    /**
    * The name of the Google Cloud KMS encryption key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#kms_key GoogleWorkstationsWorkstationConfigA#kms_key}
    */
    readonly kmsKey: string;
    /**
    * The service account to use with the specified KMS key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#kms_key_service_account GoogleWorkstationsWorkstationConfigA#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount: string;
}
export declare function googleWorkstationsWorkstationConfigEncryptionKeyToTerraform(struct?: GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference | GoogleWorkstationsWorkstationConfigEncryptionKey): any;
export declare function googleWorkstationsWorkstationConfigEncryptionKeyToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference | GoogleWorkstationsWorkstationConfigEncryptionKey): any;
export declare class GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigEncryptionKey | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigEncryptionKey | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    get kmsKeyInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    get kmsKeyServiceAccountInput(): string | undefined;
}
export interface GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd {
    /**
    * Type of the disk to use. Defaults to '"pd-standard"'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#disk_type GoogleWorkstationsWorkstationConfigA#disk_type}
    */
    readonly diskType?: string;
    /**
    * Whether the disk is read only. If true, the disk may be shared by multiple VMs and 'sourceSnapshot' must be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#read_only GoogleWorkstationsWorkstationConfigA#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Name of the disk image to use as the source for the disk.
    *
    * Must be empty 'sourceSnapshot' is set.
    * Updating 'sourceImage' will update content in the ephemeral directory after the workstation is restarted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#source_image GoogleWorkstationsWorkstationConfigA#source_image}
    */
    readonly sourceImage?: string;
    /**
    * Name of the snapshot to use as the source for the disk.
    *
    * Must be empty if 'sourceImage' is set.
    * Must be empty if 'read_only' is false.
    * Updating 'source_snapshot' will update content in the ephemeral directory after the workstation is restarted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#source_snapshot GoogleWorkstationsWorkstationConfigA#source_snapshot}
    */
    readonly sourceSnapshot?: string;
}
export declare function googleWorkstationsWorkstationConfigEphemeralDirectoriesGcePdToTerraform(struct?: GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePdOutputReference | GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd): any;
export declare function googleWorkstationsWorkstationConfigEphemeralDirectoriesGcePdToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePdOutputReference | GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd): any;
export declare class GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd | undefined);
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _sourceSnapshot?;
    get sourceSnapshot(): string;
    set sourceSnapshot(value: string);
    resetSourceSnapshot(): void;
    get sourceSnapshotInput(): string | undefined;
}
export interface GoogleWorkstationsWorkstationConfigEphemeralDirectories {
    /**
    * Location of this directory in the running workstation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#mount_path GoogleWorkstationsWorkstationConfigA#mount_path}
    */
    readonly mountPath?: string;
    /**
    * gce_pd block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#gce_pd GoogleWorkstationsWorkstationConfigA#gce_pd}
    */
    readonly gcePd?: GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd;
}
export declare function googleWorkstationsWorkstationConfigEphemeralDirectoriesToTerraform(struct?: GoogleWorkstationsWorkstationConfigEphemeralDirectories | cdktf.IResolvable): any;
export declare function googleWorkstationsWorkstationConfigEphemeralDirectoriesToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigEphemeralDirectories | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigEphemeralDirectoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigEphemeralDirectories | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigEphemeralDirectories | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _gcePd;
    get gcePd(): GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePdOutputReference;
    putGcePd(value: GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd): void;
    resetGcePd(): void;
    get gcePdInput(): GoogleWorkstationsWorkstationConfigEphemeralDirectoriesGcePd | undefined;
}
export declare class GoogleWorkstationsWorkstationConfigEphemeralDirectoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkstationsWorkstationConfigEphemeralDirectories[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigEphemeralDirectoriesOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators {
    /**
    * Number of accelerator cards exposed to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#count GoogleWorkstationsWorkstationConfigA#count}
    */
    readonly count: number;
    /**
    * Type of accelerator resource to attach to the instance, for example, "nvidia-tesla-p100".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#type GoogleWorkstationsWorkstationConfigA#type}
    */
    readonly type: string;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceAcceleratorsToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators | cdktf.IResolvable): any;
export declare function googleWorkstationsWorkstationConfigHostGceInstanceAcceleratorsToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigHostGceInstanceAcceleratorsOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig {
    /**
    * Whether the instance has confidential compute enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#enable_confidential_compute GoogleWorkstationsWorkstationConfigA#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig): any;
export declare function googleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig {
    /**
    * Whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#enable_integrity_monitoring GoogleWorkstationsWorkstationConfigA#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#enable_secure_boot GoogleWorkstationsWorkstationConfigA#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance has the vTPM enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#enable_vtpm GoogleWorkstationsWorkstationConfigA#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig): any;
export declare function googleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstance {
    /**
    * Size of the boot disk in GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#boot_disk_size_gb GoogleWorkstationsWorkstationConfigA#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Whether instances have no public IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#disable_public_ip_addresses GoogleWorkstationsWorkstationConfigA#disable_public_ip_addresses}
    */
    readonly disablePublicIpAddresses?: boolean | cdktf.IResolvable;
    /**
    * Whether to disable SSH access to the VM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#disable_ssh GoogleWorkstationsWorkstationConfigA#disable_ssh}
    */
    readonly disableSsh?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable nested virtualization on the Compute Engine VMs backing the Workstations.
    *
    * See https://cloud.google.com/workstations/docs/reference/rest/v1beta/projects.locations.workstationClusters.workstationConfigs#GceInstance.FIELDS.enable_nested_virtualization
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#enable_nested_virtualization GoogleWorkstationsWorkstationConfigA#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The name of a Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#machine_type GoogleWorkstationsWorkstationConfigA#machine_type}
    */
    readonly machineType?: string;
    /**
    * Number of instances to pool for faster workstation startup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#pool_size GoogleWorkstationsWorkstationConfigA#pool_size}
    */
    readonly poolSize?: number;
    /**
    * Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#service_account GoogleWorkstationsWorkstationConfigA#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Scopes to grant to the service_account. Various scopes are automatically added based on feature usage. When specified, users of workstations under this configuration must have 'iam.serviceAccounts.actAs' on the service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#service_account_scopes GoogleWorkstationsWorkstationConfigA#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * Network tags to add to the Compute Engine machines backing the Workstations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#tags GoogleWorkstationsWorkstationConfigA#tags}
    */
    readonly tags?: string[];
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#accelerators GoogleWorkstationsWorkstationConfigA#accelerators}
    */
    readonly accelerators?: GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators[] | cdktf.IResolvable;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#confidential_instance_config GoogleWorkstationsWorkstationConfigA#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#shielded_instance_config GoogleWorkstationsWorkstationConfigA#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstance): any;
export declare function googleWorkstationsWorkstationConfigHostGceInstanceToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstance): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstance | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstance | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _disablePublicIpAddresses?;
    get disablePublicIpAddresses(): boolean | cdktf.IResolvable;
    set disablePublicIpAddresses(value: boolean | cdktf.IResolvable);
    resetDisablePublicIpAddresses(): void;
    get disablePublicIpAddressesInput(): boolean | cdktf.IResolvable | undefined;
    private _disableSsh?;
    get disableSsh(): boolean | cdktf.IResolvable;
    set disableSsh(value: boolean | cdktf.IResolvable);
    resetDisableSsh(): void;
    get disableSshInput(): boolean | cdktf.IResolvable | undefined;
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _poolSize?;
    get poolSize(): number;
    set poolSize(value: number);
    resetPoolSize(): void;
    get poolSizeInput(): number | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _accelerators;
    get accelerators(): GoogleWorkstationsWorkstationConfigHostGceInstanceAcceleratorsList;
    putAccelerators(value: GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigHostGceInstanceAccelerators[] | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHost {
    /**
    * gce_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#gce_instance GoogleWorkstationsWorkstationConfigA#gce_instance}
    */
    readonly gceInstance?: GoogleWorkstationsWorkstationConfigHostGceInstance;
}
export declare function googleWorkstationsWorkstationConfigHostToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostOutputReference | GoogleWorkstationsWorkstationConfigHost): any;
export declare function googleWorkstationsWorkstationConfigHostToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigHostOutputReference | GoogleWorkstationsWorkstationConfigHost): any;
export declare class GoogleWorkstationsWorkstationConfigHostOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHost | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHost | undefined);
    private _gceInstance;
    get gceInstance(): GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference;
    putGceInstance(value: GoogleWorkstationsWorkstationConfigHostGceInstance): void;
    resetGceInstance(): void;
    get gceInstanceInput(): GoogleWorkstationsWorkstationConfigHostGceInstance | undefined;
}
export interface GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd {
    /**
    * The type of the persistent disk for the home directory. Defaults to 'pd-standard'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#disk_type GoogleWorkstationsWorkstationConfigA#disk_type}
    */
    readonly diskType?: string;
    /**
    * Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if 'sourceSnapshot' is set. Defaults to 'ext4'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#fs_type GoogleWorkstationsWorkstationConfigA#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether the persistent disk should be deleted when the workstation is deleted. Valid values are 'DELETE' and 'RETAIN'. Defaults to 'DELETE'. Possible values: ["DELETE", "RETAIN"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#reclaim_policy GoogleWorkstationsWorkstationConfigA#reclaim_policy}
    */
    readonly reclaimPolicy?: string;
    /**
    * The GB capacity of a persistent home directory for each workstation created with this configuration. Must be empty if 'sourceSnapshot' is set.
    * Valid values are '10', '50', '100', '200', '500', or '1000'. Defaults to '200'. If less than '200' GB, the 'diskType' must be 'pd-balanced' or 'pd-ssd'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#size_gb GoogleWorkstationsWorkstationConfigA#size_gb}
    */
    readonly sizeGb?: number;
    /**
    * Name of the snapshot to use as the source for the disk. This can be the snapshot's 'self_link', 'id', or a string in the format of 'projects/{project}/global/snapshots/{snapshot}'. If set, 'sizeGb' and 'fsType' must be empty. Can only be updated if it has an existing value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#source_snapshot GoogleWorkstationsWorkstationConfigA#source_snapshot}
    */
    readonly sourceSnapshot?: string;
}
export declare function googleWorkstationsWorkstationConfigPersistentDirectoriesGcePdToTerraform(struct?: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference | GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd): any;
export declare function googleWorkstationsWorkstationConfigPersistentDirectoriesGcePdToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference | GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd): any;
export declare class GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd | undefined);
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _reclaimPolicy?;
    get reclaimPolicy(): string;
    set reclaimPolicy(value: string);
    resetReclaimPolicy(): void;
    get reclaimPolicyInput(): string | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    resetSizeGb(): void;
    get sizeGbInput(): number | undefined;
    private _sourceSnapshot?;
    get sourceSnapshot(): string;
    set sourceSnapshot(value: string);
    resetSourceSnapshot(): void;
    get sourceSnapshotInput(): string | undefined;
}
export interface GoogleWorkstationsWorkstationConfigPersistentDirectories {
    /**
    * Location of this directory in the running workstation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#mount_path GoogleWorkstationsWorkstationConfigA#mount_path}
    */
    readonly mountPath?: string;
    /**
    * gce_pd block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#gce_pd GoogleWorkstationsWorkstationConfigA#gce_pd}
    */
    readonly gcePd?: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd;
}
export declare function googleWorkstationsWorkstationConfigPersistentDirectoriesToTerraform(struct?: GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable): any;
export declare function googleWorkstationsWorkstationConfigPersistentDirectoriesToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigPersistentDirectoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _gcePd;
    get gcePd(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference;
    putGcePd(value: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd): void;
    resetGcePd(): void;
    get gcePdInput(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd | undefined;
}
export declare class GoogleWorkstationsWorkstationConfigPersistentDirectoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkstationsWorkstationConfigPersistentDirectories[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigPersistentDirectoriesOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigReadinessChecks {
    /**
    * Path to which the request should be sent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#path GoogleWorkstationsWorkstationConfigA#path}
    */
    readonly path: string;
    /**
    * Port to which the request should be sent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#port GoogleWorkstationsWorkstationConfigA#port}
    */
    readonly port: number;
}
export declare function googleWorkstationsWorkstationConfigReadinessChecksToTerraform(struct?: GoogleWorkstationsWorkstationConfigReadinessChecks | cdktf.IResolvable): any;
export declare function googleWorkstationsWorkstationConfigReadinessChecksToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigReadinessChecks | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigReadinessChecksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigReadinessChecks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigReadinessChecks | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export declare class GoogleWorkstationsWorkstationConfigReadinessChecksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkstationsWorkstationConfigReadinessChecks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigReadinessChecksOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#create GoogleWorkstationsWorkstationConfigA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#delete GoogleWorkstationsWorkstationConfigA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#update GoogleWorkstationsWorkstationConfigA#update}
    */
    readonly update?: string;
}
export declare function googleWorkstationsWorkstationConfigTimeoutsToTerraform(struct?: GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable): any;
export declare function googleWorkstationsWorkstationConfigTimeoutsToHclTerraform(struct?: GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config google_workstations_workstation_config}
*/
export declare class GoogleWorkstationsWorkstationConfigA extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_workstations_workstation_config";
    /**
    * Generates CDKTF code for importing a GoogleWorkstationsWorkstationConfigA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleWorkstationsWorkstationConfigA to import
    * @param importFromId The id of the existing GoogleWorkstationsWorkstationConfigA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleWorkstationsWorkstationConfigA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation_config google_workstations_workstation_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleWorkstationsWorkstationConfigAConfig
    */
    constructor(scope: Construct, id: string, config: GoogleWorkstationsWorkstationConfigAConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _conditions;
    get conditions(): GoogleWorkstationsWorkstationConfigConditionsList;
    get createTime(): string;
    get degraded(): cdktf.IResolvable;
    private _disableTcpConnections?;
    get disableTcpConnections(): boolean | cdktf.IResolvable;
    set disableTcpConnections(value: boolean | cdktf.IResolvable);
    resetDisableTcpConnections(): void;
    get disableTcpConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableAuditAgent?;
    get enableAuditAgent(): boolean | cdktf.IResolvable;
    set enableAuditAgent(value: boolean | cdktf.IResolvable);
    resetEnableAuditAgent(): void;
    get enableAuditAgentInput(): boolean | cdktf.IResolvable | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleTimeout?;
    get idleTimeout(): string;
    set idleTimeout(value: string);
    resetIdleTimeout(): void;
    get idleTimeoutInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _replicaZones?;
    get replicaZones(): string[];
    set replicaZones(value: string[]);
    resetReplicaZones(): void;
    get replicaZonesInput(): string[] | undefined;
    private _runningTimeout?;
    get runningTimeout(): string;
    set runningTimeout(value: string);
    resetRunningTimeout(): void;
    get runningTimeoutInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    private _workstationClusterId?;
    get workstationClusterId(): string;
    set workstationClusterId(value: string);
    get workstationClusterIdInput(): string | undefined;
    private _workstationConfigId?;
    get workstationConfigId(): string;
    set workstationConfigId(value: string);
    get workstationConfigIdInput(): string | undefined;
    private _container;
    get container(): GoogleWorkstationsWorkstationConfigContainerOutputReference;
    putContainer(value: GoogleWorkstationsWorkstationConfigContainer): void;
    resetContainer(): void;
    get containerInput(): GoogleWorkstationsWorkstationConfigContainer | undefined;
    private _encryptionKey;
    get encryptionKey(): GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference;
    putEncryptionKey(value: GoogleWorkstationsWorkstationConfigEncryptionKey): void;
    resetEncryptionKey(): void;
    get encryptionKeyInput(): GoogleWorkstationsWorkstationConfigEncryptionKey | undefined;
    private _ephemeralDirectories;
    get ephemeralDirectories(): GoogleWorkstationsWorkstationConfigEphemeralDirectoriesList;
    putEphemeralDirectories(value: GoogleWorkstationsWorkstationConfigEphemeralDirectories[] | cdktf.IResolvable): void;
    resetEphemeralDirectories(): void;
    get ephemeralDirectoriesInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigEphemeralDirectories[] | undefined;
    private _host;
    get host(): GoogleWorkstationsWorkstationConfigHostOutputReference;
    putHost(value: GoogleWorkstationsWorkstationConfigHost): void;
    resetHost(): void;
    get hostInput(): GoogleWorkstationsWorkstationConfigHost | undefined;
    private _persistentDirectories;
    get persistentDirectories(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesList;
    putPersistentDirectories(value: GoogleWorkstationsWorkstationConfigPersistentDirectories[] | cdktf.IResolvable): void;
    resetPersistentDirectories(): void;
    get persistentDirectoriesInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigPersistentDirectories[] | undefined;
    private _readinessChecks;
    get readinessChecks(): GoogleWorkstationsWorkstationConfigReadinessChecksList;
    putReadinessChecks(value: GoogleWorkstationsWorkstationConfigReadinessChecks[] | cdktf.IResolvable): void;
    resetReadinessChecks(): void;
    get readinessChecksInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigReadinessChecks[] | undefined;
    private _timeouts;
    get timeouts(): GoogleWorkstationsWorkstationConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleWorkstationsWorkstationConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
