/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleWorkstationsWorkstationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Client-specified annotations. This is distinct from labels.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#annotations GoogleWorkstationsWorkstation#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Human-readable name for this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#display_name GoogleWorkstationsWorkstation#display_name}
    */
    readonly displayName?: string;
    /**
    * 'Client-specified environment variables passed to the workstation container's entrypoint.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#env GoogleWorkstationsWorkstation#env}
    */
    readonly env?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#id GoogleWorkstationsWorkstation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#labels GoogleWorkstationsWorkstation#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the workstation parent resources reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#location GoogleWorkstationsWorkstation#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#project GoogleWorkstationsWorkstation#project}
    */
    readonly project?: string;
    /**
    * The ID of the parent workstation cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#workstation_cluster_id GoogleWorkstationsWorkstation#workstation_cluster_id}
    */
    readonly workstationClusterId: string;
    /**
    * The ID of the parent workstation cluster config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#workstation_config_id GoogleWorkstationsWorkstation#workstation_config_id}
    */
    readonly workstationConfigId: string;
    /**
    * ID to use for the workstation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#workstation_id GoogleWorkstationsWorkstation#workstation_id}
    */
    readonly workstationId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#timeouts GoogleWorkstationsWorkstation#timeouts}
    */
    readonly timeouts?: GoogleWorkstationsWorkstationTimeouts;
}
export interface GoogleWorkstationsWorkstationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#create GoogleWorkstationsWorkstation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#delete GoogleWorkstationsWorkstation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#update GoogleWorkstationsWorkstation#update}
    */
    readonly update?: string;
}
export declare function googleWorkstationsWorkstationTimeoutsToTerraform(struct?: GoogleWorkstationsWorkstationTimeouts | cdktf.IResolvable): any;
export declare function googleWorkstationsWorkstationTimeoutsToHclTerraform(struct?: GoogleWorkstationsWorkstationTimeouts | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation google_workstations_workstation}
*/
export declare class GoogleWorkstationsWorkstation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_workstations_workstation";
    /**
    * Generates CDKTF code for importing a GoogleWorkstationsWorkstation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleWorkstationsWorkstation to import
    * @param importFromId The id of the existing GoogleWorkstationsWorkstation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleWorkstationsWorkstation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_workstations_workstation google_workstations_workstation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleWorkstationsWorkstationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleWorkstationsWorkstationConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _env?;
    get env(): {
        [key: string]: string;
    };
    set env(value: {
        [key: string]: string;
    });
    resetEnv(): void;
    get envInput(): {
        [key: string]: string;
    } | undefined;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    private _workstationClusterId?;
    get workstationClusterId(): string;
    set workstationClusterId(value: string);
    get workstationClusterIdInput(): string | undefined;
    private _workstationConfigId?;
    get workstationConfigId(): string;
    set workstationConfigId(value: string);
    get workstationConfigIdInput(): string | undefined;
    private _workstationId?;
    get workstationId(): string;
    set workstationId(value: string);
    get workstationIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleWorkstationsWorkstationTimeoutsOutputReference;
    putTimeouts(value: GoogleWorkstationsWorkstationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
