# klug-secrets

CLI tool for managing secrets and environments via KLUG Autocloud API.

## Installation

```bash
pip install klug-secrets
```

## Configuration

Set the API key as an environment variable or in a `.env` file:

**Option 1: Environment variable**
```bash
export KLUG_AUTOCLOUD_API_KEY=your-api-key-here
```

**Option 2: .env file (recommended for development)**
```bash
# Copy the example file
cp .env.example .env

# Edit .env and add your API key
# KLUG_AUTOCLOUD_API_KEY=your-api-key-here
```

Optionally, set a custom API endpoint:

```bash
export KLUG_AUTOCLOUD_API_ENDPOINT=https://your-api-endpoint.com/prod
# Or in .env:
# KLUG_AUTOCLOUD_API_ENDPOINT=https://your-api-endpoint.com/prod
```

## Usage

### Secrets Management

```bash
# List all secrets
klug-secrets secrets list

# Get a secret
klug-secrets secrets get my-secret

# Add a secret
klug-secrets secrets add my-secret "secret-value"

# Update a secret
klug-secrets secrets update my-secret --value "new-value"

# Delete a secret
klug-secrets secrets delete my-secret
```

### Environment Management

```bash
# List all environments
klug-secrets envs list

# List environments for a specific system
klug-secrets envs list --system main

# Get an environment
klug-secrets envs get --system main --env dev

# Add environment from .env file
klug-secrets envs add --system main --env dev --file .env

# Add environment from stdin (pipe .env file)
cat .env | klug-secrets envs --system main --env dev

# Add environment with individual variables
klug-secrets envs add --system main --env dev --var DATABASE_URL=postgres://... --var API_KEY=secret

# Update environment
klug-secrets envs update --system main --env dev --file .env

# Delete environment
klug-secrets envs delete --system main --env dev

# Dump environment to file
klug-secrets envs dump --system main --env dev
# Saves to ./.env.dev
```

## Examples

### Upload .env file from stdin

```bash
cat .env | klug-secrets envs --system main --env production
```

### Upload .env file from file

```bash
klug-secrets envs add --system main --env production --file .env.production
```

### Add secret with metadata

```bash
klug-secrets secrets add my-secret "secret-value" --metadata '{"env": "production", "team": "backend"}'
```

## License

MIT License

