# pylint: disable=too-many-lines

# Default colorscales from matplotlib and https://www.fabiocrameri.ch/colourmaps/
default_color_tables = [
    {
        "name": "viridis (Seq)",
        "colors": [
            (0.0, 68, 1, 84, 255),
            (0.05263157894736842, 71, 20, 102, 255),
            (0.10526315789473684, 71, 37, 117, 255),
            (0.15789473684210525, 69, 54, 129, 255),
            (0.21052631578947367, 63, 69, 135, 255),
            (0.2631578947368421, 57, 85, 139, 255),
            (0.3157894736842105, 50, 98, 141, 255),
            (0.3684210526315789, 44, 112, 142, 255),
            (0.42105263157894735, 39, 124, 142, 255),
            (0.47368421052631576, 34, 137, 141, 255),
            (0.5263157894736842, 31, 150, 139, 255),
            (0.5789473684210527, 31, 163, 134, 255),
            (0.631578947368421, 41, 175, 127, 255),
            (0.6842105263157894, 61, 187, 116, 255),
            (0.7368421052631579, 85, 198, 102, 255),
            (0.7894736842105263, 116, 208, 84, 255),
            (0.8421052631578947, 149, 215, 63, 255),
            (0.894736842105263, 186, 222, 39, 255),
            (0.9473684210526315, 220, 226, 24, 255),
            (1.0, 253, 231, 36, 255),
        ],
        "discrete": False,
    },
    {
        "name": "inferno (Seq)",
        "colors": [
            (0.0, 0, 0, 3, 255),
            (0.05263157894736842, 7, 5, 29, 255),
            (0.10526315789473684, 23, 11, 59, 255),
            (0.15789473684210525, 46, 10, 90, 255),
            (0.21052631578947367, 69, 10, 105, 255),
            (0.2631578947368421, 91, 17, 110, 255),
            (0.3157894736842105, 112, 25, 110, 255),
            (0.3684210526315789, 134, 33, 106, 255),
            (0.42105263157894735, 155, 40, 100, 255),
            (0.47368421052631576, 177, 49, 90, 255),
            (0.5263157894736842, 196, 60, 78, 255),
            (0.5789473684210527, 214, 74, 63, 255),
            (0.631578947368421, 229, 91, 48, 255),
            (0.6842105263157894, 240, 112, 30, 255),
            (0.7368421052631579, 248, 135, 13, 255),
            (0.7894736842105263, 251, 160, 7, 255),
            (0.8421052631578947, 251, 185, 30, 255),
            (0.894736842105263, 246, 213, 66, 255),
            (0.9473684210526315, 241, 237, 112, 255),
            (1.0, 252, 254, 164, 255),
        ],
        "discrete": False,
    },
    {
        "name": "cividis (Seq)",
        "colors": [
            (0.0, 0, 34, 77, 255),
            (0.05263157894736842, 0, 43, 100, 255),
            (0.10526315789473684, 11, 51, 112, 255),
            (0.15789473684210525, 39, 61, 109, 255),
            (0.21052631578947367, 55, 70, 108, 255),
            (0.2631578947368421, 70, 80, 107, 255),
            (0.3157894736842105, 82, 89, 108, 255),
            (0.3684210526315789, 95, 99, 110, 255),
            (0.42105263157894735, 106, 108, 113, 255),
            (0.47368421052631576, 118, 118, 118, 255),
            (0.5263157894736842, 130, 128, 120, 255),
            (0.5789473684210527, 143, 138, 119, 255),
            (0.631578947368421, 156, 148, 118, 255),
            (0.6842105263157894, 170, 159, 114, 255),
            (0.7368421052631579, 183, 170, 109, 255),
            (0.7894736842105263, 198, 181, 103, 255),
            (0.8421052631578947, 212, 193, 94, 255),
            (0.894736842105263, 227, 205, 82, 255),
            (0.9473684210526315, 242, 218, 67, 255),
            (1.0, 253, 231, 55, 255),
        ],
        "discrete": False,
    },
    {
        "name": "turbo (Seq)",
        "colors": [
            (0.0, 48, 18, 59, 255),
            (0.05263157894736842, 61, 55, 145, 255),
            (0.10526315789473684, 69, 91, 206, 255),
            (0.15789473684210525, 70, 127, 246, 255),
            (0.21052631578947367, 59, 160, 252, 255),
            (0.2631578947368421, 35, 194, 228, 255),
            (0.3157894736842105, 23, 220, 194, 255),
            (0.3684210526315789, 44, 239, 157, 255),
            (0.42105263157894735, 89, 251, 114, 255),
            (0.47368421052631576, 142, 254, 72, 255),
            (0.5263157894736842, 179, 248, 53, 255),
            (0.5789473684210527, 214, 229, 53, 255),
            (0.631578947368421, 239, 205, 57, 255),
            (0.6842105263157894, 252, 174, 52, 255),
            (0.7368421052631579, 252, 137, 38, 255),
            (0.7894736842105263, 242, 96, 20, 255),
            (0.8421052631578947, 224, 64, 8, 255),
            (0.894736842105263, 197, 38, 2, 255),
            (0.9473684210526315, 163, 18, 1, 255),
            (1.0, 122, 4, 2, 255),
        ],
        "discrete": False,
    },
    {
        "name": "acton (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 46, 33, 76],
            [0.00392156862745098, 47, 34, 77],
            [0.00784313725490196, 48, 34, 78],
            [0.011764705882352941, 49, 35, 79],
            [0.01568627450980392, 50, 36, 80],
            [0.0196078431372549, 51, 37, 81],
            [0.023529411764705882, 52, 38, 82],
            [0.027450980392156862, 53, 39, 82],
            [0.03137254901960784, 54, 40, 83],
            [0.03529411764705882, 55, 41, 84],
            [0.0392156862745098, 56, 42, 85],
            [0.043137254901960784, 57, 42, 86],
            [0.047058823529411764, 58, 43, 87],
            [0.050980392156862744, 59, 44, 88],
            [0.054901960784313725, 60, 45, 89],
            [0.058823529411764705, 61, 46, 90],
            [0.06274509803921569, 62, 47, 91],
            [0.06666666666666667, 63, 48, 92],
            [0.07058823529411765, 64, 49, 93],
            [0.07450980392156863, 65, 50, 93],
            [0.0784313725490196, 66, 51, 94],
            [0.08235294117647059, 67, 52, 95],
            [0.08627450980392157, 68, 53, 96],
            [0.09019607843137255, 69, 54, 97],
            [0.09411764705882353, 70, 54, 98],
            [0.09803921568627451, 71, 55, 99],
            [0.10196078431372549, 73, 56, 100],
            [0.10588235294117647, 74, 57, 101],
            [0.10980392156862745, 75, 58, 102],
            [0.11372549019607843, 76, 59, 103],
            [0.11764705882352941, 77, 60, 104],
            [0.12156862745098039, 78, 61, 105],
            [0.12549019607843137, 79, 62, 106],
            [0.12941176470588234, 80, 63, 107],
            [0.13333333333333333, 81, 64, 107],
            [0.13725490196078433, 83, 65, 108],
            [0.1411764705882353, 84, 66, 109],
            [0.14509803921568626, 85, 67, 110],
            [0.14901960784313725, 86, 67, 111],
            [0.15294117647058825, 87, 68, 112],
            [0.1568627450980392, 88, 69, 113],
            [0.16078431372549018, 90, 70, 114],
            [0.16470588235294117, 91, 71, 115],
            [0.16862745098039217, 92, 72, 116],
            [0.17254901960784313, 93, 73, 117],
            [0.1764705882352941, 94, 74, 118],
            [0.1803921568627451, 96, 75, 118],
            [0.1843137254901961, 97, 76, 119],
            [0.18823529411764706, 98, 76, 120],
            [0.19215686274509802, 99, 77, 121],
            [0.19607843137254902, 101, 78, 122],
            [0.2, 102, 79, 123],
            [0.20392156862745098, 103, 80, 124],
            [0.20784313725490194, 104, 81, 125],
            [0.21176470588235294, 106, 82, 125],
            [0.21568627450980393, 107, 82, 126],
            [0.2196078431372549, 108, 83, 127],
            [0.22352941176470587, 110, 84, 128],
            [0.22745098039215686, 111, 85, 129],
            [0.23137254901960785, 112, 85, 129],
            [0.23529411764705882, 113, 86, 130],
            [0.2392156862745098, 115, 87, 131],
            [0.24313725490196078, 116, 88, 132],
            [0.24705882352941178, 117, 88, 132],
            [0.25098039215686274, 119, 89, 133],
            [0.2549019607843137, 120, 90, 134],
            [0.2588235294117647, 121, 90, 134],
            [0.2627450980392157, 123, 91, 135],
            [0.26666666666666666, 124, 92, 136],
            [0.27058823529411763, 125, 92, 136],
            [0.27450980392156865, 127, 93, 137],
            [0.2784313725490196, 128, 93, 138],
            [0.2823529411764706, 129, 94, 138],
            [0.28627450980392155, 131, 94, 139],
            [0.2901960784313725, 132, 95, 139],
            [0.29411764705882354, 133, 95, 140],
            [0.2980392156862745, 135, 96, 140],
            [0.30196078431372547, 136, 96, 141],
            [0.3058823529411765, 137, 97, 141],
            [0.30980392156862746, 138, 97, 141],
            [0.3137254901960784, 140, 97, 142],
            [0.3176470588235294, 141, 98, 142],
            [0.32156862745098036, 142, 98, 143],
            [0.3254901960784314, 143, 98, 143],
            [0.32941176470588235, 145, 99, 143],
            [0.3333333333333333, 146, 99, 144],
            [0.33725490196078434, 147, 99, 144],
            [0.3411764705882353, 148, 99, 144],
            [0.34509803921568627, 149, 100, 144],
            [0.34901960784313724, 151, 100, 145],
            [0.3529411764705882, 152, 100, 145],
            [0.3568627450980392, 153, 100, 145],
            [0.3607843137254902, 154, 100, 145],
            [0.36470588235294116, 155, 100, 146],
            [0.3686274509803922, 156, 101, 146],
            [0.37254901960784315, 158, 101, 146],
            [0.3764705882352941, 159, 101, 146],
            [0.3803921568627451, 160, 101, 146],
            [0.38431372549019605, 161, 101, 146],
            [0.38823529411764707, 162, 101, 147],
            [0.39215686274509803, 163, 101, 147],
            [0.396078431372549, 164, 101, 147],
            [0.4, 165, 101, 147],
            [0.403921568627451, 166, 101, 147],
            [0.40784313725490196, 167, 102, 147],
            [0.4117647058823529, 169, 102, 147],
            [0.4156862745098039, 170, 102, 148],
            [0.4196078431372549, 171, 102, 148],
            [0.4235294117647059, 172, 102, 148],
            [0.42745098039215684, 173, 102, 148],
            [0.43137254901960786, 174, 102, 148],
            [0.43529411764705883, 175, 102, 148],
            [0.4392156862745098, 176, 103, 149],
            [0.44313725490196076, 177, 103, 149],
            [0.44705882352941173, 179, 103, 149],
            [0.45098039215686275, 180, 103, 149],
            [0.4549019607843137, 181, 103, 149],
            [0.4588235294117647, 182, 104, 150],
            [0.4627450980392157, 183, 104, 150],
            [0.4666666666666667, 184, 104, 150],
            [0.47058823529411764, 186, 105, 151],
            [0.4745098039215686, 187, 105, 151],
            [0.4784313725490196, 188, 106, 151],
            [0.4823529411764706, 189, 106, 152],
            [0.48627450980392156, 190, 107, 152],
            [0.49019607843137253, 192, 107, 153],
            [0.49411764705882355, 193, 108, 153],
            [0.4980392156862745, 194, 109, 154],
            [0.5019607843137255, 195, 109, 154],
            [0.5058823529411764, 196, 110, 155],
            [0.5098039215686274, 198, 111, 156],
            [0.5137254901960784, 199, 112, 156],
            [0.5176470588235293, 200, 113, 157],
            [0.5215686274509804, 201, 114, 158],
            [0.5254901960784314, 202, 115, 159],
            [0.5294117647058824, 203, 116, 159],
            [0.5333333333333333, 204, 117, 160],
            [0.5372549019607843, 205, 118, 161],
            [0.5411764705882353, 206, 119, 162],
            [0.5450980392156862, 206, 120, 162],
            [0.5490196078431373, 207, 121, 163],
            [0.5529411764705883, 208, 122, 164],
            [0.5568627450980392, 208, 123, 165],
            [0.5607843137254902, 209, 124, 165],
            [0.5647058823529412, 209, 125, 166],
            [0.5686274509803921, 210, 126, 167],
            [0.5725490196078431, 210, 127, 168],
            [0.5764705882352941, 211, 128, 168],
            [0.580392156862745, 211, 129, 169],
            [0.5843137254901961, 211, 130, 170],
            [0.5882352941176471, 211, 131, 171],
            [0.592156862745098, 212, 132, 171],
            [0.596078431372549, 212, 133, 172],
            [0.6, 212, 134, 173],
            [0.6039215686274509, 212, 135, 173],
            [0.6078431372549019, 212, 136, 174],
            [0.611764705882353, 212, 136, 175],
            [0.615686274509804, 212, 137, 175],
            [0.6196078431372549, 212, 138, 176],
            [0.6235294117647059, 212, 139, 176],
            [0.6274509803921569, 212, 140, 177],
            [0.6313725490196078, 212, 141, 178],
            [0.6352941176470588, 212, 142, 178],
            [0.6392156862745098, 212, 142, 179],
            [0.6431372549019607, 212, 143, 180],
            [0.6470588235294118, 212, 144, 180],
            [0.6509803921568628, 212, 145, 181],
            [0.6549019607843137, 212, 146, 181],
            [0.6588235294117647, 212, 147, 182],
            [0.6627450980392157, 212, 147, 182],
            [0.6666666666666666, 212, 148, 183],
            [0.6705882352941176, 212, 149, 184],
            [0.6745098039215687, 211, 150, 184],
            [0.6784313725490196, 211, 151, 185],
            [0.6823529411764706, 211, 151, 185],
            [0.6862745098039216, 211, 152, 186],
            [0.6901960784313725, 211, 153, 187],
            [0.6941176470588235, 211, 154, 187],
            [0.6980392156862745, 211, 155, 188],
            [0.7019607843137254, 211, 156, 188],
            [0.7058823529411764, 211, 156, 189],
            [0.7098039215686275, 211, 157, 190],
            [0.7137254901960784, 211, 158, 190],
            [0.7176470588235294, 211, 159, 191],
            [0.7215686274509804, 211, 160, 191],
            [0.7254901960784313, 211, 161, 192],
            [0.7294117647058823, 211, 162, 193],
            [0.7333333333333333, 211, 162, 193],
            [0.7372549019607844, 211, 163, 194],
            [0.7411764705882353, 211, 164, 194],
            [0.7450980392156863, 211, 165, 195],
            [0.7490196078431373, 211, 166, 196],
            [0.7529411764705882, 211, 167, 196],
            [0.7568627450980392, 211, 168, 197],
            [0.7607843137254902, 211, 169, 198],
            [0.7647058823529411, 211, 169, 198],
            [0.7686274509803921, 211, 170, 199],
            [0.7725490196078432, 212, 171, 199],
            [0.7764705882352941, 212, 172, 200],
            [0.7803921568627451, 212, 173, 201],
            [0.7843137254901961, 212, 174, 201],
            [0.788235294117647, 212, 175, 202],
            [0.792156862745098, 212, 176, 203],
            [0.796078431372549, 212, 177, 203],
            [0.8, 213, 178, 204],
            [0.803921568627451, 213, 179, 205],
            [0.807843137254902, 213, 180, 205],
            [0.8117647058823529, 213, 181, 206],
            [0.8156862745098039, 213, 182, 207],
            [0.8196078431372549, 214, 182, 207],
            [0.8235294117647058, 214, 183, 208],
            [0.8274509803921568, 214, 184, 209],
            [0.8313725490196078, 214, 185, 209],
            [0.8352941176470589, 214, 186, 210],
            [0.8392156862745098, 215, 187, 211],
            [0.8431372549019608, 215, 188, 211],
            [0.8470588235294118, 215, 189, 212],
            [0.8509803921568627, 216, 190, 213],
            [0.8549019607843137, 216, 191, 213],
            [0.8588235294117647, 216, 192, 214],
            [0.8627450980392157, 216, 193, 215],
            [0.8666666666666667, 217, 194, 215],
            [0.8705882352941177, 217, 195, 216],
            [0.8745098039215686, 217, 196, 217],
            [0.8784313725490196, 218, 197, 217],
            [0.8823529411764706, 218, 198, 218],
            [0.8862745098039215, 218, 199, 219],
            [0.8901960784313725, 219, 200, 220],
            [0.8941176470588235, 219, 201, 220],
            [0.8980392156862745, 219, 202, 221],
            [0.9019607843137255, 220, 203, 222],
            [0.9058823529411765, 220, 204, 222],
            [0.9098039215686274, 220, 205, 223],
            [0.9137254901960784, 221, 206, 224],
            [0.9176470588235294, 221, 207, 224],
            [0.9215686274509803, 221, 208, 225],
            [0.9254901960784314, 222, 209, 226],
            [0.9294117647058824, 222, 210, 227],
            [0.9333333333333333, 223, 211, 227],
            [0.9372549019607843, 223, 212, 228],
            [0.9411764705882353, 223, 213, 229],
            [0.9450980392156862, 224, 215, 229],
            [0.9490196078431372, 224, 216, 230],
            [0.9529411764705882, 224, 217, 231],
            [0.9568627450980391, 225, 218, 231],
            [0.9607843137254902, 225, 219, 232],
            [0.9647058823529412, 226, 220, 233],
            [0.9686274509803922, 226, 221, 234],
            [0.9725490196078431, 226, 222, 234],
            [0.9764705882352941, 227, 223, 235],
            [0.9803921568627451, 227, 224, 236],
            [0.984313725490196, 228, 225, 236],
            [0.9882352941176471, 228, 226, 237],
            [0.9921568627450981, 228, 227, 238],
            [0.996078431372549, 229, 228, 239],
            [1.0, 229, 229, 239],
        ],
    },
    {
        "name": "bam (Div)",
        "discrete": False,
        "colors": [
            [0.0, 101, 2, 75],
            [0.00392156862745098, 103, 4, 77],
            [0.00784313725490196, 105, 7, 79],
            [0.011764705882352941, 107, 10, 82],
            [0.01568627450980392, 110, 13, 84],
            [0.0196078431372549, 112, 15, 86],
            [0.023529411764705882, 114, 18, 88],
            [0.027450980392156862, 116, 20, 90],
            [0.03137254901960784, 118, 22, 93],
            [0.03529411764705882, 120, 24, 95],
            [0.0392156862745098, 123, 26, 97],
            [0.043137254901960784, 125, 28, 99],
            [0.047058823529411764, 127, 30, 101],
            [0.050980392156862744, 129, 32, 103],
            [0.054901960784313725, 131, 34, 105],
            [0.058823529411764705, 133, 36, 107],
            [0.06274509803921569, 135, 38, 109],
            [0.06666666666666667, 137, 40, 111],
            [0.07058823529411765, 139, 42, 113],
            [0.07450980392156863, 141, 44, 115],
            [0.0784313725490196, 143, 45, 117],
            [0.08235294117647059, 145, 47, 119],
            [0.08627450980392157, 147, 49, 121],
            [0.09019607843137255, 149, 51, 123],
            [0.09411764705882353, 151, 52, 125],
            [0.09803921568627451, 153, 54, 127],
            [0.10196078431372549, 154, 56, 129],
            [0.10588235294117647, 156, 58, 131],
            [0.10980392156862745, 158, 59, 132],
            [0.11372549019607843, 160, 61, 134],
            [0.11764705882352941, 161, 63, 136],
            [0.12156862745098039, 163, 64, 138],
            [0.12549019607843137, 165, 66, 139],
            [0.12941176470588234, 167, 68, 141],
            [0.13333333333333333, 168, 70, 143],
            [0.13725490196078433, 170, 71, 144],
            [0.1411764705882353, 171, 73, 146],
            [0.14509803921568626, 173, 75, 148],
            [0.14901960784313725, 174, 76, 149],
            [0.15294117647058825, 176, 78, 151],
            [0.1568627450980392, 177, 80, 152],
            [0.16078431372549018, 179, 81, 154],
            [0.16470588235294117, 180, 83, 155],
            [0.16862745098039217, 182, 85, 157],
            [0.17254901960784313, 183, 86, 158],
            [0.1764705882352941, 185, 88, 160],
            [0.1803921568627451, 186, 90, 161],
            [0.1843137254901961, 187, 92, 163],
            [0.18823529411764706, 189, 94, 164],
            [0.19215686274509802, 190, 95, 166],
            [0.19607843137254902, 191, 97, 167],
            [0.2, 193, 99, 169],
            [0.20392156862745098, 194, 101, 170],
            [0.20784313725490194, 195, 103, 172],
            [0.21176470588235294, 197, 105, 173],
            [0.21568627450980393, 198, 107, 174],
            [0.2196078431372549, 199, 109, 176],
            [0.22352941176470587, 200, 111, 177],
            [0.22745098039215686, 202, 113, 179],
            [0.23137254901960785, 203, 115, 180],
            [0.23529411764705882, 204, 117, 182],
            [0.2392156862745098, 205, 120, 183],
            [0.24313725490196078, 206, 122, 184],
            [0.24705882352941178, 207, 124, 186],
            [0.25098039215686274, 208, 126, 187],
            [0.2549019607843137, 209, 128, 188],
            [0.2588235294117647, 211, 130, 190],
            [0.2627450980392157, 212, 133, 191],
            [0.26666666666666666, 213, 135, 192],
            [0.27058823529411763, 214, 137, 194],
            [0.27450980392156865, 215, 139, 195],
            [0.2784313725490196, 216, 142, 196],
            [0.2823529411764706, 217, 144, 198],
            [0.28627450980392155, 218, 146, 199],
            [0.2901960784313725, 218, 149, 200],
            [0.29411764705882354, 219, 151, 202],
            [0.2980392156862745, 220, 153, 203],
            [0.30196078431372547, 221, 155, 204],
            [0.3058823529411765, 222, 158, 205],
            [0.30980392156862746, 223, 160, 207],
            [0.3137254901960784, 224, 162, 208],
            [0.3176470588235294, 225, 165, 209],
            [0.32156862745098036, 225, 167, 210],
            [0.3254901960784314, 226, 169, 211],
            [0.32941176470588235, 227, 171, 212],
            [0.3333333333333333, 228, 174, 214],
            [0.33725490196078434, 229, 176, 215],
            [0.3411764705882353, 229, 178, 216],
            [0.34509803921568627, 230, 180, 217],
            [0.34901960784313724, 231, 183, 218],
            [0.3529411764705882, 232, 185, 219],
            [0.3568627450980392, 232, 187, 220],
            [0.3607843137254902, 233, 189, 221],
            [0.36470588235294116, 234, 191, 223],
            [0.3686274509803922, 234, 193, 224],
            [0.37254901960784315, 235, 195, 225],
            [0.3764705882352941, 236, 197, 226],
            [0.3803921568627451, 236, 199, 227],
            [0.38431372549019605, 237, 201, 228],
            [0.38823529411764707, 238, 203, 229],
            [0.39215686274509803, 238, 205, 229],
            [0.396078431372549, 239, 207, 230],
            [0.4, 239, 209, 231],
            [0.403921568627451, 240, 211, 232],
            [0.40784313725490196, 241, 213, 233],
            [0.4117647058823529, 241, 214, 234],
            [0.4156862745098039, 242, 216, 234],
            [0.4196078431372549, 242, 218, 235],
            [0.4235294117647059, 242, 219, 236],
            [0.42745098039215684, 243, 221, 236],
            [0.43137254901960786, 243, 222, 237],
            [0.43529411764705883, 244, 224, 238],
            [0.4392156862745098, 244, 225, 238],
            [0.44313725490196076, 244, 227, 239],
            [0.44705882352941173, 245, 228, 239],
            [0.45098039215686275, 245, 229, 240],
            [0.4549019607843137, 245, 231, 240],
            [0.4588235294117647, 245, 232, 240],
            [0.4627450980392157, 246, 233, 240],
            [0.4666666666666667, 246, 234, 241],
            [0.47058823529411764, 246, 235, 241],
            [0.4745098039215686, 246, 236, 241],
            [0.4784313725490196, 246, 237, 241],
            [0.4823529411764706, 246, 237, 241],
            [0.48627450980392156, 246, 238, 241],
            [0.49019607843137253, 246, 239, 241],
            [0.49411764705882355, 246, 240, 240],
            [0.4980392156862745, 245, 240, 240],
            [0.5019607843137255, 245, 241, 240],
            [0.5058823529411764, 245, 241, 240],
            [0.5098039215686274, 245, 241, 239],
            [0.5137254901960784, 245, 242, 239],
            [0.5176470588235293, 244, 242, 238],
            [0.5215686274509804, 244, 242, 238],
            [0.5254901960784314, 243, 242, 237],
            [0.5294117647058824, 243, 243, 236],
            [0.5333333333333333, 242, 243, 235],
            [0.5372549019607843, 242, 243, 234],
            [0.5411764705882353, 241, 243, 233],
            [0.5450980392156862, 240, 243, 232],
            [0.5490196078431373, 240, 242, 231],
            [0.5529411764705883, 239, 242, 230],
            [0.5568627450980392, 238, 242, 228],
            [0.5607843137254902, 237, 242, 227],
            [0.5647058823529412, 236, 242, 226],
            [0.5686274509803921, 235, 241, 224],
            [0.5725490196078431, 234, 241, 222],
            [0.5764705882352941, 233, 240, 221],
            [0.580392156862745, 232, 240, 219],
            [0.5843137254901961, 231, 239, 217],
            [0.5882352941176471, 229, 239, 215],
            [0.592156862745098, 228, 238, 213],
            [0.596078431372549, 227, 237, 211],
            [0.6, 225, 237, 208],
            [0.6039215686274509, 224, 236, 206],
            [0.6078431372549019, 222, 235, 204],
            [0.611764705882353, 221, 234, 201],
            [0.615686274509804, 219, 233, 199],
            [0.6196078431372549, 217, 232, 196],
            [0.6235294117647059, 216, 231, 194],
            [0.6274509803921569, 214, 230, 191],
            [0.6313725490196078, 212, 229, 188],
            [0.6352941176470588, 210, 228, 185],
            [0.6392156862745098, 208, 227, 182],
            [0.6431372549019607, 206, 226, 180],
            [0.6470588235294118, 204, 224, 177],
            [0.6509803921568628, 202, 223, 174],
            [0.6549019607843137, 199, 222, 171],
            [0.6588235294117647, 197, 220, 167],
            [0.6627450980392157, 195, 219, 164],
            [0.6666666666666666, 193, 217, 161],
            [0.6705882352941176, 190, 216, 158],
            [0.6745098039215687, 188, 214, 155],
            [0.6784313725490196, 185, 213, 152],
            [0.6823529411764706, 183, 211, 149],
            [0.6862745098039216, 181, 209, 146],
            [0.6901960784313725, 178, 208, 142],
            [0.6941176470588235, 175, 206, 139],
            [0.6980392156862745, 173, 204, 136],
            [0.7019607843137254, 170, 202, 133],
            [0.7058823529411764, 168, 201, 130],
            [0.7098039215686275, 165, 199, 127],
            [0.7137254901960784, 163, 197, 124],
            [0.7176470588235294, 160, 195, 122],
            [0.7215686274509804, 158, 193, 119],
            [0.7254901960784313, 155, 192, 116],
            [0.7294117647058823, 153, 190, 113],
            [0.7333333333333333, 150, 188, 111],
            [0.7372549019607844, 148, 186, 108],
            [0.7411764705882353, 145, 184, 106],
            [0.7450980392156863, 143, 182, 103],
            [0.7490196078431373, 140, 181, 101],
            [0.7529411764705882, 138, 179, 98],
            [0.7568627450980392, 135, 177, 96],
            [0.7607843137254902, 133, 175, 94],
            [0.7647058823529411, 131, 173, 92],
            [0.7686274509803921, 128, 172, 90],
            [0.7725490196078432, 126, 170, 88],
            [0.7764705882352941, 124, 168, 86],
            [0.7803921568627451, 122, 166, 84],
            [0.7843137254901961, 120, 164, 82],
            [0.788235294117647, 117, 163, 80],
            [0.792156862745098, 115, 161, 78],
            [0.796078431372549, 113, 159, 76],
            [0.8, 111, 158, 75],
            [0.803921568627451, 109, 156, 73],
            [0.807843137254902, 107, 154, 71],
            [0.8117647058823529, 105, 153, 70],
            [0.8156862745098039, 103, 151, 68],
            [0.8196078431372549, 101, 149, 66],
            [0.8235294117647058, 99, 148, 65],
            [0.8274509803921568, 97, 146, 63],
            [0.8313725490196078, 95, 145, 62],
            [0.8352941176470589, 93, 143, 61],
            [0.8392156862745098, 92, 142, 59],
            [0.8431372549019608, 90, 140, 58],
            [0.8470588235294118, 88, 139, 56],
            [0.8509803921568627, 86, 137, 55],
            [0.8549019607843137, 84, 136, 54],
            [0.8588235294117647, 83, 134, 52],
            [0.8627450980392157, 81, 133, 51],
            [0.8666666666666667, 79, 131, 50],
            [0.8705882352941177, 77, 130, 48],
            [0.8745098039215686, 76, 128, 47],
            [0.8784313725490196, 74, 127, 46],
            [0.8823529411764706, 72, 125, 44],
            [0.8862745098039215, 71, 124, 43],
            [0.8901960784313725, 69, 122, 42],
            [0.8941176470588235, 67, 121, 40],
            [0.8980392156862745, 65, 119, 39],
            [0.9019607843137255, 64, 118, 38],
            [0.9058823529411765, 62, 116, 36],
            [0.9098039215686274, 60, 114, 35],
            [0.9137254901960784, 58, 113, 34],
            [0.9176470588235294, 56, 111, 32],
            [0.9215686274509803, 55, 110, 31],
            [0.9254901960784314, 53, 108, 29],
            [0.9294117647058824, 51, 106, 28],
            [0.9333333333333333, 49, 105, 26],
            [0.9372549019607843, 47, 103, 25],
            [0.9411764705882353, 45, 102, 23],
            [0.9450980392156862, 43, 100, 22],
            [0.9490196078431372, 41, 98, 20],
            [0.9529411764705882, 39, 96, 19],
            [0.9568627450980391, 37, 95, 17],
            [0.9607843137254902, 35, 93, 16],
            [0.9647058823529412, 33, 91, 14],
            [0.9686274509803922, 31, 90, 12],
            [0.9725490196078431, 29, 88, 10],
            [0.9764705882352941, 27, 86, 9],
            [0.9803921568627451, 25, 84, 7],
            [0.984313725490196, 22, 82, 5],
            [0.9882352941176471, 20, 81, 4],
            [0.9921568627450981, 17, 79, 2],
            [0.996078431372549, 15, 77, 1],
            [1.0, 12, 75, 0],
        ],
    },
    {
        "name": "bamako (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 0, 63, 76],
            [0.00392156862745098, 0, 64, 76],
            [0.00784313725490196, 1, 64, 75],
            [0.011764705882352941, 2, 64, 75],
            [0.01568627450980392, 3, 65, 75],
            [0.0196078431372549, 3, 65, 74],
            [0.023529411764705882, 4, 66, 74],
            [0.027450980392156862, 5, 66, 73],
            [0.03137254901960784, 5, 66, 73],
            [0.03529411764705882, 6, 67, 73],
            [0.0392156862745098, 7, 67, 72],
            [0.043137254901960784, 7, 67, 72],
            [0.047058823529411764, 8, 68, 72],
            [0.050980392156862744, 9, 68, 71],
            [0.054901960784313725, 9, 69, 71],
            [0.058823529411764705, 10, 69, 71],
            [0.06274509803921569, 11, 69, 70],
            [0.06666666666666667, 12, 70, 70],
            [0.07058823529411765, 12, 70, 69],
            [0.07450980392156863, 13, 71, 69],
            [0.0784313725490196, 13, 71, 69],
            [0.08235294117647059, 14, 71, 68],
            [0.08627450980392157, 15, 72, 68],
            [0.09019607843137255, 15, 72, 68],
            [0.09411764705882353, 16, 73, 67],
            [0.09803921568627451, 17, 73, 67],
            [0.10196078431372549, 17, 73, 66],
            [0.10588235294117647, 18, 74, 66],
            [0.10980392156862745, 18, 74, 66],
            [0.11372549019607843, 19, 75, 65],
            [0.11764705882352941, 20, 75, 65],
            [0.12156862745098039, 20, 76, 65],
            [0.12549019607843137, 21, 76, 64],
            [0.12941176470588234, 22, 76, 64],
            [0.13333333333333333, 22, 77, 63],
            [0.13725490196078433, 23, 77, 63],
            [0.1411764705882353, 23, 78, 63],
            [0.14509803921568626, 24, 78, 62],
            [0.14901960784313725, 25, 78, 62],
            [0.15294117647058825, 25, 79, 61],
            [0.1568627450980392, 26, 79, 61],
            [0.16078431372549018, 27, 80, 61],
            [0.16470588235294117, 27, 80, 60],
            [0.16862745098039217, 28, 81, 60],
            [0.17254901960784313, 29, 81, 59],
            [0.1764705882352941, 29, 81, 59],
            [0.1803921568627451, 30, 82, 59],
            [0.1843137254901961, 30, 82, 58],
            [0.18823529411764706, 31, 83, 58],
            [0.19215686274509802, 32, 83, 57],
            [0.19607843137254902, 32, 84, 57],
            [0.2, 33, 84, 57],
            [0.20392156862745098, 34, 85, 56],
            [0.20784313725490194, 35, 85, 56],
            [0.21176470588235294, 35, 85, 55],
            [0.21568627450980393, 36, 86, 55],
            [0.2196078431372549, 37, 86, 55],
            [0.22352941176470587, 37, 87, 54],
            [0.22745098039215686, 38, 87, 54],
            [0.23137254901960785, 39, 88, 53],
            [0.23529411764705882, 39, 88, 53],
            [0.2392156862745098, 40, 89, 52],
            [0.24313725490196078, 41, 89, 52],
            [0.24705882352941178, 41, 90, 52],
            [0.25098039215686274, 42, 90, 51],
            [0.2549019607843137, 43, 90, 51],
            [0.2588235294117647, 44, 91, 50],
            [0.2627450980392157, 44, 91, 50],
            [0.26666666666666666, 45, 92, 49],
            [0.27058823529411763, 46, 92, 49],
            [0.27450980392156865, 46, 93, 49],
            [0.2784313725490196, 47, 93, 48],
            [0.2823529411764706, 48, 94, 48],
            [0.28627450980392155, 49, 94, 47],
            [0.2901960784313725, 49, 95, 47],
            [0.29411764705882354, 50, 95, 46],
            [0.2980392156862745, 51, 96, 46],
            [0.30196078431372547, 52, 96, 45],
            [0.3058823529411765, 52, 97, 45],
            [0.30980392156862746, 53, 97, 45],
            [0.3137254901960784, 54, 98, 44],
            [0.3176470588235294, 55, 98, 44],
            [0.32156862745098036, 55, 99, 43],
            [0.3254901960784314, 56, 99, 43],
            [0.32941176470588235, 57, 100, 42],
            [0.3333333333333333, 58, 100, 42],
            [0.33725490196078434, 58, 101, 41],
            [0.3411764705882353, 59, 101, 41],
            [0.34509803921568627, 60, 102, 40],
            [0.34901960784313724, 61, 102, 40],
            [0.3529411764705882, 62, 103, 39],
            [0.3568627450980392, 62, 103, 39],
            [0.3607843137254902, 63, 104, 39],
            [0.36470588235294116, 64, 104, 38],
            [0.3686274509803922, 65, 105, 38],
            [0.37254901960784315, 66, 105, 37],
            [0.3764705882352941, 67, 106, 37],
            [0.3803921568627451, 67, 106, 36],
            [0.38431372549019605, 68, 107, 36],
            [0.38823529411764707, 69, 108, 35],
            [0.39215686274509803, 70, 108, 35],
            [0.396078431372549, 71, 109, 34],
            [0.4, 72, 109, 34],
            [0.403921568627451, 72, 110, 33],
            [0.40784313725490196, 73, 110, 33],
            [0.4117647058823529, 74, 111, 32],
            [0.4156862745098039, 75, 111, 32],
            [0.4196078431372549, 76, 112, 31],
            [0.4235294117647059, 77, 113, 31],
            [0.42745098039215684, 78, 113, 30],
            [0.43137254901960786, 79, 114, 30],
            [0.43529411764705883, 80, 114, 29],
            [0.4392156862745098, 81, 115, 28],
            [0.44313725490196076, 81, 116, 28],
            [0.44705882352941173, 82, 116, 27],
            [0.45098039215686275, 83, 117, 27],
            [0.4549019607843137, 84, 117, 26],
            [0.4588235294117647, 85, 118, 26],
            [0.4627450980392157, 86, 119, 25],
            [0.4666666666666667, 87, 119, 25],
            [0.47058823529411764, 88, 120, 24],
            [0.4745098039215686, 89, 121, 24],
            [0.4784313725490196, 90, 121, 23],
            [0.4823529411764706, 91, 122, 22],
            [0.48627450980392156, 92, 123, 22],
            [0.49019607843137253, 93, 123, 21],
            [0.49411764705882355, 94, 124, 21],
            [0.4980392156862745, 95, 125, 20],
            [0.5019607843137255, 97, 125, 19],
            [0.5058823529411764, 98, 126, 19],
            [0.5098039215686274, 99, 127, 18],
            [0.5137254901960784, 100, 127, 18],
            [0.5176470588235293, 101, 128, 17],
            [0.5215686274509804, 102, 129, 16],
            [0.5254901960784314, 103, 129, 16],
            [0.5294117647058824, 104, 130, 15],
            [0.5333333333333333, 106, 131, 14],
            [0.5372549019607843, 107, 131, 14],
            [0.5411764705882353, 108, 132, 13],
            [0.5450980392156862, 109, 133, 12],
            [0.5490196078431373, 110, 133, 12],
            [0.5529411764705883, 112, 134, 11],
            [0.5568627450980392, 113, 135, 10],
            [0.5607843137254902, 114, 135, 10],
            [0.5647058823529412, 115, 136, 9],
            [0.5686274509803921, 117, 136, 8],
            [0.5725490196078431, 118, 137, 8],
            [0.5764705882352941, 119, 137, 7],
            [0.580392156862745, 120, 138, 6],
            [0.5843137254901961, 122, 138, 6],
            [0.5882352941176471, 123, 139, 5],
            [0.592156862745098, 124, 139, 5],
            [0.596078431372549, 126, 140, 4],
            [0.6, 127, 140, 4],
            [0.6039215686274509, 128, 140, 3],
            [0.6078431372549019, 130, 141, 3],
            [0.611764705882353, 131, 141, 3],
            [0.615686274509804, 132, 141, 3],
            [0.6196078431372549, 134, 142, 2],
            [0.6235294117647059, 135, 142, 2],
            [0.6274509803921569, 136, 142, 2],
            [0.6313725490196078, 137, 142, 2],
            [0.6352941176470588, 139, 143, 2],
            [0.6392156862745098, 140, 143, 2],
            [0.6431372549019607, 141, 143, 3],
            [0.6470588235294118, 143, 143, 3],
            [0.6509803921568628, 144, 144, 3],
            [0.6549019607843137, 146, 144, 4],
            [0.6588235294117647, 147, 144, 4],
            [0.6627450980392157, 148, 145, 5],
            [0.6666666666666666, 150, 145, 6],
            [0.6705882352941176, 151, 146, 7],
            [0.6745098039215687, 153, 146, 8],
            [0.6784313725490196, 154, 147, 9],
            [0.6823529411764706, 156, 147, 10],
            [0.6862745098039216, 157, 148, 11],
            [0.6901960784313725, 159, 149, 13],
            [0.6941176470588235, 161, 150, 14],
            [0.6980392156862745, 162, 150, 15],
            [0.7019607843137254, 164, 151, 17],
            [0.7058823529411764, 166, 152, 18],
            [0.7098039215686275, 167, 153, 20],
            [0.7137254901960784, 169, 154, 21],
            [0.7176470588235294, 171, 155, 23],
            [0.7215686274509804, 173, 156, 25],
            [0.7254901960784313, 174, 157, 26],
            [0.7294117647058823, 176, 159, 28],
            [0.7333333333333333, 178, 160, 30],
            [0.7372549019607844, 179, 161, 31],
            [0.7411764705882353, 181, 162, 33],
            [0.7450980392156863, 183, 163, 35],
            [0.7490196078431373, 185, 165, 36],
            [0.7529411764705882, 186, 166, 38],
            [0.7568627450980392, 188, 167, 40],
            [0.7607843137254902, 190, 168, 42],
            [0.7647058823529411, 191, 170, 44],
            [0.7686274509803921, 193, 171, 46],
            [0.7725490196078432, 195, 172, 47],
            [0.7764705882352941, 196, 173, 49],
            [0.7803921568627451, 198, 175, 51],
            [0.7843137254901961, 199, 176, 53],
            [0.788235294117647, 201, 177, 55],
            [0.792156862745098, 202, 178, 57],
            [0.796078431372549, 204, 180, 59],
            [0.8, 205, 181, 61],
            [0.803921568627451, 206, 182, 63],
            [0.807843137254902, 208, 183, 65],
            [0.8117647058823529, 209, 184, 67],
            [0.8156862745098039, 210, 185, 69],
            [0.8196078431372549, 211, 187, 71],
            [0.8235294117647058, 213, 188, 72],
            [0.8274509803921568, 214, 189, 74],
            [0.8313725490196078, 215, 190, 76],
            [0.8352941176470589, 216, 191, 78],
            [0.8392156862745098, 217, 192, 80],
            [0.8431372549019608, 218, 193, 82],
            [0.8470588235294118, 219, 194, 84],
            [0.8509803921568627, 220, 195, 86],
            [0.8549019607843137, 221, 196, 88],
            [0.8588235294117647, 222, 197, 89],
            [0.8627450980392157, 223, 198, 91],
            [0.8666666666666667, 224, 199, 93],
            [0.8705882352941177, 225, 200, 95],
            [0.8745098039215686, 226, 201, 97],
            [0.8784313725490196, 227, 202, 98],
            [0.8823529411764706, 228, 203, 100],
            [0.8862745098039215, 229, 203, 102],
            [0.8901960784313725, 230, 204, 104],
            [0.8941176470588235, 231, 205, 106],
            [0.8980392156862745, 232, 206, 107],
            [0.9019607843137255, 233, 207, 109],
            [0.9058823529411765, 234, 208, 111],
            [0.9098039215686274, 235, 209, 113],
            [0.9137254901960784, 235, 210, 114],
            [0.9176470588235294, 236, 211, 116],
            [0.9215686274509803, 237, 212, 118],
            [0.9254901960784314, 238, 212, 120],
            [0.9294117647058824, 239, 213, 121],
            [0.9333333333333333, 240, 214, 123],
            [0.9372549019607843, 241, 215, 125],
            [0.9411764705882353, 242, 216, 127],
            [0.9450980392156862, 242, 217, 128],
            [0.9490196078431372, 243, 218, 130],
            [0.9529411764705882, 244, 219, 132],
            [0.9568627450980391, 245, 219, 134],
            [0.9607843137254902, 246, 220, 135],
            [0.9647058823529412, 247, 221, 137],
            [0.9686274509803922, 248, 222, 139],
            [0.9725490196078431, 249, 223, 140],
            [0.9764705882352941, 249, 224, 142],
            [0.9803921568627451, 250, 225, 144],
            [0.984313725490196, 251, 226, 146],
            [0.9882352941176471, 252, 226, 147],
            [0.9921568627450981, 253, 227, 149],
            [0.996078431372549, 254, 228, 151],
            [1.0, 254, 229, 152],
        ],
    },
    {
        "name": "batlow (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 1, 25, 89],
            [0.00392156862745098, 2, 26, 89],
            [0.00784313725490196, 3, 28, 89],
            [0.011764705882352941, 4, 29, 90],
            [0.01568627450980392, 5, 31, 90],
            [0.0196078431372549, 5, 32, 90],
            [0.023529411764705882, 6, 34, 90],
            [0.027450980392156862, 7, 35, 91],
            [0.03137254901960784, 8, 37, 91],
            [0.03529411764705882, 8, 38, 91],
            [0.0392156862745098, 9, 40, 91],
            [0.043137254901960784, 10, 41, 92],
            [0.047058823529411764, 10, 43, 92],
            [0.050980392156862744, 11, 44, 92],
            [0.054901960784313725, 11, 46, 92],
            [0.058823529411764705, 12, 47, 93],
            [0.06274509803921569, 12, 48, 93],
            [0.06666666666666667, 12, 50, 93],
            [0.07058823529411765, 13, 51, 93],
            [0.07450980392156863, 13, 52, 93],
            [0.0784313725490196, 13, 53, 94],
            [0.08235294117647059, 14, 55, 94],
            [0.08627450980392157, 14, 56, 94],
            [0.09019607843137255, 14, 57, 94],
            [0.09411764705882353, 15, 58, 94],
            [0.09803921568627451, 15, 59, 95],
            [0.10196078431372549, 15, 60, 95],
            [0.10588235294117647, 15, 61, 95],
            [0.10980392156862745, 16, 63, 95],
            [0.11372549019607843, 16, 64, 95],
            [0.11764705882352941, 16, 65, 95],
            [0.12156862745098039, 16, 66, 96],
            [0.12549019607843137, 17, 67, 96],
            [0.12941176470588234, 17, 68, 96],
            [0.13333333333333333, 17, 69, 96],
            [0.13725490196078433, 17, 70, 96],
            [0.1411764705882353, 18, 71, 96],
            [0.14509803921568626, 18, 71, 97],
            [0.14901960784313725, 18, 72, 97],
            [0.15294117647058825, 19, 73, 97],
            [0.1568627450980392, 19, 74, 97],
            [0.16078431372549018, 19, 75, 97],
            [0.16470588235294117, 20, 76, 97],
            [0.16862745098039217, 20, 77, 97],
            [0.17254901960784313, 20, 78, 97],
            [0.1764705882352941, 21, 79, 97],
            [0.1803921568627451, 21, 80, 97],
            [0.1843137254901961, 22, 81, 98],
            [0.18823529411764706, 22, 82, 98],
            [0.19215686274509802, 23, 83, 98],
            [0.19607843137254902, 23, 83, 98],
            [0.2, 24, 84, 98],
            [0.20392156862745098, 24, 85, 98],
            [0.20784313725490194, 25, 86, 98],
            [0.21176470588235294, 25, 87, 98],
            [0.21568627450980393, 26, 88, 98],
            [0.2196078431372549, 27, 89, 98],
            [0.22352941176470587, 27, 90, 97],
            [0.22745098039215686, 28, 90, 97],
            [0.23137254901960785, 29, 91, 97],
            [0.23529411764705882, 30, 92, 97],
            [0.2392156862745098, 31, 93, 97],
            [0.24313725490196078, 32, 94, 97],
            [0.24705882352941178, 33, 94, 96],
            [0.25098039215686274, 33, 95, 96],
            [0.2549019607843137, 34, 96, 96],
            [0.2588235294117647, 36, 97, 96],
            [0.2627450980392157, 37, 97, 95],
            [0.26666666666666666, 38, 98, 95],
            [0.27058823529411763, 39, 99, 95],
            [0.27450980392156865, 40, 100, 94],
            [0.2784313725490196, 41, 100, 94],
            [0.2823529411764706, 42, 101, 93],
            [0.28627450980392155, 44, 102, 93],
            [0.2901960784313725, 45, 102, 92],
            [0.29411764705882354, 46, 103, 92],
            [0.2980392156862745, 47, 104, 91],
            [0.30196078431372547, 49, 104, 91],
            [0.3058823529411765, 50, 105, 90],
            [0.30980392156862746, 51, 105, 89],
            [0.3137254901960784, 53, 106, 89],
            [0.3176470588235294, 54, 107, 88],
            [0.32156862745098036, 56, 107, 87],
            [0.3254901960784314, 57, 108, 87],
            [0.32941176470588235, 58, 108, 86],
            [0.3333333333333333, 60, 109, 85],
            [0.33725490196078434, 61, 109, 84],
            [0.3411764705882353, 63, 110, 84],
            [0.34509803921568627, 64, 110, 83],
            [0.34901960784313724, 66, 111, 82],
            [0.3529411764705882, 67, 111, 81],
            [0.3568627450980392, 69, 112, 80],
            [0.3607843137254902, 70, 112, 79],
            [0.36470588235294116, 72, 113, 79],
            [0.3686274509803922, 74, 113, 78],
            [0.37254901960784315, 75, 114, 77],
            [0.3764705882352941, 77, 114, 76],
            [0.3803921568627451, 78, 115, 75],
            [0.38431372549019605, 80, 115, 74],
            [0.38823529411764707, 81, 116, 73],
            [0.39215686274509803, 83, 116, 73],
            [0.396078431372549, 84, 117, 72],
            [0.4, 86, 117, 71],
            [0.403921568627451, 88, 118, 70],
            [0.40784313725490196, 89, 118, 69],
            [0.4117647058823529, 91, 119, 68],
            [0.4156862745098039, 92, 119, 67],
            [0.4196078431372549, 94, 120, 66],
            [0.4235294117647059, 96, 120, 65],
            [0.42745098039215684, 97, 121, 65],
            [0.43137254901960786, 99, 121, 64],
            [0.43529411764705883, 101, 122, 63],
            [0.4392156862745098, 102, 122, 62],
            [0.44313725490196076, 104, 122, 61],
            [0.44705882352941173, 106, 123, 60],
            [0.45098039215686275, 107, 123, 59],
            [0.4549019607843137, 109, 124, 58],
            [0.4588235294117647, 111, 124, 58],
            [0.4627450980392157, 112, 125, 57],
            [0.4666666666666667, 114, 125, 56],
            [0.47058823529411764, 116, 126, 55],
            [0.4745098039215686, 117, 126, 54],
            [0.4784313725490196, 119, 127, 53],
            [0.4823529411764706, 121, 127, 53],
            [0.48627450980392156, 123, 128, 52],
            [0.49019607843137253, 124, 128, 51],
            [0.49411764705882355, 126, 129, 50],
            [0.4980392156862745, 128, 129, 50],
            [0.5019607843137255, 130, 130, 49],
            [0.5058823529411764, 132, 130, 48],
            [0.5098039215686274, 134, 131, 47],
            [0.5137254901960784, 135, 131, 47],
            [0.5176470588235293, 137, 132, 46],
            [0.5215686274509804, 139, 132, 46],
            [0.5254901960784314, 141, 133, 45],
            [0.5294117647058824, 143, 133, 45],
            [0.5333333333333333, 145, 134, 44],
            [0.5372549019607843, 147, 134, 44],
            [0.5411764705882353, 149, 135, 43],
            [0.5450980392156862, 151, 135, 43],
            [0.5490196078431373, 153, 136, 43],
            [0.5529411764705883, 155, 136, 43],
            [0.5568627450980392, 157, 136, 43],
            [0.5607843137254902, 159, 137, 43],
            [0.5647058823529412, 161, 137, 43],
            [0.5686274509803921, 163, 138, 43],
            [0.5725490196078431, 165, 138, 43],
            [0.5764705882352941, 166, 139, 44],
            [0.580392156862745, 168, 139, 44],
            [0.5843137254901961, 170, 140, 44],
            [0.5882352941176471, 172, 140, 45],
            [0.592156862745098, 174, 140, 45],
            [0.596078431372549, 176, 141, 46],
            [0.6, 178, 141, 47],
            [0.6039215686274509, 180, 141, 48],
            [0.6078431372549019, 182, 142, 48],
            [0.611764705882353, 184, 142, 49],
            [0.615686274509804, 186, 143, 50],
            [0.6196078431372549, 188, 143, 51],
            [0.6235294117647059, 190, 143, 52],
            [0.6274509803921569, 192, 144, 53],
            [0.6313725490196078, 194, 144, 55],
            [0.6352941176470588, 196, 144, 56],
            [0.6392156862745098, 197, 145, 57],
            [0.6431372549019607, 199, 145, 58],
            [0.6470588235294118, 201, 145, 60],
            [0.6509803921568628, 203, 146, 61],
            [0.6549019607843137, 205, 146, 62],
            [0.6588235294117647, 206, 146, 64],
            [0.6627450980392157, 208, 146, 65],
            [0.6666666666666666, 210, 147, 67],
            [0.6705882352941176, 212, 147, 68],
            [0.6745098039215687, 213, 147, 70],
            [0.6784313725490196, 215, 148, 72],
            [0.6823529411764706, 217, 148, 73],
            [0.6862745098039216, 218, 149, 75],
            [0.6901960784313725, 220, 149, 77],
            [0.6941176470588235, 222, 149, 78],
            [0.6980392156862745, 223, 150, 80],
            [0.7019607843137254, 225, 150, 82],
            [0.7058823529411764, 226, 150, 84],
            [0.7098039215686275, 228, 151, 86],
            [0.7137254901960784, 229, 151, 88],
            [0.7176470588235294, 231, 152, 90],
            [0.7215686274509804, 232, 152, 92],
            [0.7254901960784313, 234, 153, 94],
            [0.7294117647058823, 235, 153, 96],
            [0.7333333333333333, 236, 154, 98],
            [0.7372549019607844, 237, 154, 100],
            [0.7411764705882353, 239, 155, 102],
            [0.7450980392156863, 240, 156, 104],
            [0.7490196078431373, 241, 156, 107],
            [0.7529411764705882, 242, 157, 109],
            [0.7568627450980392, 243, 157, 111],
            [0.7607843137254902, 244, 158, 113],
            [0.7647058823529411, 245, 159, 116],
            [0.7686274509803921, 246, 159, 118],
            [0.7725490196078432, 246, 160, 120],
            [0.7764705882352941, 247, 161, 123],
            [0.7803921568627451, 248, 161, 125],
            [0.7843137254901961, 248, 162, 127],
            [0.788235294117647, 249, 163, 130],
            [0.792156862745098, 249, 164, 132],
            [0.796078431372549, 250, 164, 135],
            [0.8, 250, 165, 137],
            [0.803921568627451, 251, 166, 139],
            [0.807843137254902, 251, 167, 142],
            [0.8117647058823529, 251, 167, 144],
            [0.8156862745098039, 252, 168, 146],
            [0.8196078431372549, 252, 169, 148],
            [0.8235294117647058, 252, 170, 151],
            [0.8274509803921568, 252, 170, 153],
            [0.8313725490196078, 252, 171, 155],
            [0.8352941176470589, 252, 172, 157],
            [0.8392156862745098, 253, 173, 160],
            [0.8431372549019608, 253, 173, 162],
            [0.8470588235294118, 253, 174, 164],
            [0.8509803921568627, 253, 175, 166],
            [0.8549019607843137, 253, 176, 168],
            [0.8588235294117647, 253, 176, 171],
            [0.8627450980392157, 253, 177, 173],
            [0.8666666666666667, 253, 178, 175],
            [0.8705882352941177, 253, 179, 177],
            [0.8745098039215686, 253, 179, 179],
            [0.8784313725490196, 253, 180, 181],
            [0.8823529411764706, 253, 181, 183],
            [0.8862745098039215, 253, 181, 185],
            [0.8901960784313725, 253, 182, 187],
            [0.8941176470588235, 252, 183, 190],
            [0.8980392156862745, 252, 184, 192],
            [0.9019607843137255, 252, 184, 194],
            [0.9058823529411765, 252, 185, 196],
            [0.9098039215686274, 252, 186, 198],
            [0.9137254901960784, 252, 187, 200],
            [0.9176470588235294, 252, 187, 202],
            [0.9215686274509803, 252, 188, 204],
            [0.9254901960784314, 252, 189, 207],
            [0.9294117647058824, 252, 189, 209],
            [0.9333333333333333, 252, 190, 211],
            [0.9372549019607843, 252, 191, 213],
            [0.9411764705882353, 252, 192, 215],
            [0.9450980392156862, 252, 193, 218],
            [0.9490196078431372, 251, 193, 220],
            [0.9529411764705882, 251, 194, 222],
            [0.9568627450980391, 251, 195, 224],
            [0.9607843137254902, 251, 196, 227],
            [0.9647058823529412, 251, 196, 229],
            [0.9686274509803922, 251, 197, 231],
            [0.9725490196078431, 251, 198, 233],
            [0.9764705882352941, 251, 199, 236],
            [0.9803921568627451, 251, 200, 238],
            [0.984313725490196, 250, 200, 240],
            [0.9882352941176471, 250, 201, 243],
            [0.9921568627450981, 250, 202, 245],
            [0.996078431372549, 250, 203, 247],
            [1.0, 250, 204, 250],
        ],
    },
    {
        "name": "berlin (Div)",
        "discrete": False,
        "colors": [
            [0.0, 158, 175, 254],
            [0.00392156862745098, 156, 175, 253],
            [0.00784313725490196, 153, 175, 252],
            [0.011764705882352941, 151, 175, 251],
            [0.01568627450980392, 149, 174, 250],
            [0.0196078431372549, 146, 174, 249],
            [0.023529411764705882, 144, 174, 248],
            [0.027450980392156862, 142, 174, 247],
            [0.03137254901960784, 139, 173, 246],
            [0.03529411764705882, 137, 173, 245],
            [0.0392156862745098, 135, 173, 244],
            [0.043137254901960784, 132, 173, 243],
            [0.047058823529411764, 130, 172, 241],
            [0.050980392156862744, 127, 172, 240],
            [0.054901960784313725, 125, 172, 239],
            [0.058823529411764705, 123, 171, 238],
            [0.06274509803921569, 120, 171, 237],
            [0.06666666666666667, 118, 170, 235],
            [0.07058823529411765, 115, 170, 234],
            [0.07450980392156863, 113, 169, 233],
            [0.0784313725490196, 110, 169, 231],
            [0.08235294117647059, 108, 168, 230],
            [0.08627450980392157, 105, 168, 228],
            [0.09019607843137255, 103, 167, 227],
            [0.09411764705882353, 100, 166, 225],
            [0.09803921568627451, 98, 166, 224],
            [0.10196078431372549, 95, 165, 222],
            [0.10588235294117647, 93, 164, 220],
            [0.10980392156862745, 90, 163, 218],
            [0.11372549019607843, 88, 162, 217],
            [0.11764705882352941, 85, 161, 215],
            [0.12156862745098039, 83, 160, 213],
            [0.12549019607843137, 81, 159, 211],
            [0.12941176470588234, 78, 158, 209],
            [0.13333333333333333, 76, 156, 206],
            [0.13725490196078433, 74, 155, 204],
            [0.1411764705882353, 72, 153, 202],
            [0.14509803921568626, 70, 152, 200],
            [0.14901960784313725, 68, 150, 197],
            [0.15294117647058825, 66, 149, 195],
            [0.1568627450980392, 64, 147, 192],
            [0.16078431372549018, 63, 145, 190],
            [0.16470588235294117, 61, 144, 187],
            [0.16862745098039217, 60, 142, 185],
            [0.17254901960784313, 58, 140, 182],
            [0.1764705882352941, 57, 138, 180],
            [0.1803921568627451, 55, 137, 177],
            [0.1843137254901961, 54, 135, 175],
            [0.18823529411764706, 53, 133, 172],
            [0.19215686274509802, 52, 131, 170],
            [0.19607843137254902, 51, 129, 167],
            [0.2, 50, 127, 165],
            [0.20392156862745098, 49, 125, 163],
            [0.20784313725490194, 48, 124, 160],
            [0.21176470588235294, 47, 122, 158],
            [0.21568627450980393, 46, 120, 155],
            [0.2196078431372549, 46, 118, 153],
            [0.22352941176470587, 45, 116, 150],
            [0.22745098039215686, 44, 114, 148],
            [0.23137254901960785, 43, 112, 145],
            [0.23529411764705882, 42, 110, 143],
            [0.2392156862745098, 42, 109, 141],
            [0.24313725490196078, 41, 107, 138],
            [0.24705882352941178, 40, 105, 136],
            [0.25098039215686274, 39, 103, 133],
            [0.2549019607843137, 39, 101, 131],
            [0.2588235294117647, 38, 99, 129],
            [0.2627450980392157, 37, 98, 126],
            [0.26666666666666666, 37, 96, 124],
            [0.27058823529411763, 36, 94, 122],
            [0.27450980392156865, 35, 92, 119],
            [0.2784313725490196, 35, 90, 117],
            [0.2823529411764706, 34, 89, 115],
            [0.28627450980392155, 33, 87, 112],
            [0.2901960784313725, 32, 85, 110],
            [0.29411764705882354, 32, 83, 108],
            [0.2980392156862745, 31, 81, 105],
            [0.30196078431372547, 30, 80, 103],
            [0.3058823529411765, 30, 78, 101],
            [0.30980392156862746, 29, 76, 99],
            [0.3137254901960784, 29, 74, 96],
            [0.3176470588235294, 28, 73, 94],
            [0.32156862745098036, 27, 71, 92],
            [0.3254901960784314, 27, 69, 90],
            [0.32941176470588235, 26, 68, 87],
            [0.3333333333333333, 25, 66, 85],
            [0.33725490196078434, 25, 64, 83],
            [0.3411764705882353, 24, 62, 81],
            [0.34509803921568627, 23, 61, 79],
            [0.34901960784313724, 23, 59, 76],
            [0.3529411764705882, 22, 57, 74],
            [0.3568627450980392, 22, 56, 72],
            [0.3607843137254902, 21, 54, 70],
            [0.36470588235294116, 21, 53, 68],
            [0.3686274509803922, 20, 51, 66],
            [0.37254901960784315, 20, 49, 64],
            [0.3764705882352941, 19, 48, 62],
            [0.3803921568627451, 19, 46, 60],
            [0.38431372549019605, 18, 45, 57],
            [0.38823529411764707, 18, 43, 55],
            [0.39215686274509803, 18, 42, 53],
            [0.396078431372549, 17, 40, 51],
            [0.4, 17, 39, 49],
            [0.403921568627451, 17, 37, 47],
            [0.40784313725490196, 16, 36, 46],
            [0.4117647058823529, 16, 34, 44],
            [0.4156862745098039, 16, 33, 42],
            [0.4196078431372549, 16, 31, 40],
            [0.4235294117647059, 16, 30, 38],
            [0.42745098039215684, 16, 29, 36],
            [0.43137254901960786, 16, 28, 34],
            [0.43529411764705883, 16, 26, 33],
            [0.4392156862745098, 16, 25, 31],
            [0.44313725490196076, 16, 24, 29],
            [0.44705882352941173, 16, 23, 28],
            [0.45098039215686275, 16, 22, 26],
            [0.4549019607843137, 16, 21, 25],
            [0.4588235294117647, 17, 20, 23],
            [0.4627450980392157, 17, 19, 22],
            [0.4666666666666667, 17, 18, 21],
            [0.47058823529411764, 18, 17, 19],
            [0.4745098039215686, 18, 16, 18],
            [0.4784313725490196, 19, 15, 16],
            [0.4823529411764706, 20, 14, 15],
            [0.48627450980392156, 21, 14, 14],
            [0.49019607843137253, 22, 13, 12],
            [0.49411764705882355, 23, 12, 11],
            [0.4980392156862745, 24, 12, 10],
            [0.5019607843137255, 25, 11, 8],
            [0.5058823529411764, 26, 11, 7],
            [0.5098039215686274, 27, 11, 6],
            [0.5137254901960784, 28, 11, 5],
            [0.5176470588235293, 29, 11, 4],
            [0.5215686274509804, 30, 11, 4],
            [0.5254901960784314, 31, 11, 3],
            [0.5294117647058824, 32, 11, 2],
            [0.5333333333333333, 33, 11, 2],
            [0.5372549019607843, 34, 11, 2],
            [0.5411764705882353, 35, 12, 1],
            [0.5450980392156862, 36, 12, 1],
            [0.5490196078431373, 38, 12, 1],
            [0.5529411764705883, 39, 13, 0],
            [0.5568627450980392, 40, 13, 0],
            [0.5607843137254902, 41, 13, 0],
            [0.5647058823529412, 42, 13, 0],
            [0.5686274509803921, 44, 14, 0],
            [0.5725490196078431, 45, 14, 0],
            [0.5764705882352941, 46, 14, 0],
            [0.580392156862745, 47, 14, 0],
            [0.5843137254901961, 49, 14, 0],
            [0.5882352941176471, 50, 15, 0],
            [0.592156862745098, 51, 15, 0],
            [0.596078431372549, 53, 15, 0],
            [0.6, 54, 15, 0],
            [0.6039215686274509, 56, 16, 0],
            [0.6078431372549019, 57, 16, 0],
            [0.611764705882353, 58, 16, 0],
            [0.615686274509804, 60, 17, 0],
            [0.6196078431372549, 61, 17, 0],
            [0.6235294117647059, 63, 17, 0],
            [0.6274509803921569, 64, 18, 0],
            [0.6313725490196078, 66, 18, 0],
            [0.6352941176470588, 67, 19, 1],
            [0.6392156862745098, 69, 19, 1],
            [0.6431372549019607, 70, 20, 1],
            [0.6470588235294118, 72, 20, 1],
            [0.6509803921568628, 73, 21, 1],
            [0.6549019607843137, 75, 21, 2],
            [0.6588235294117647, 76, 22, 2],
            [0.6627450980392157, 78, 22, 2],
            [0.6666666666666666, 80, 23, 3],
            [0.6705882352941176, 82, 24, 3],
            [0.6745098039215687, 83, 25, 4],
            [0.6784313725490196, 85, 25, 5],
            [0.6823529411764706, 87, 26, 5],
            [0.6862745098039216, 89, 27, 6],
            [0.6901960784313725, 91, 28, 7],
            [0.6941176470588235, 93, 29, 8],
            [0.6980392156862745, 95, 30, 9],
            [0.7019607843137254, 97, 32, 11],
            [0.7058823529411764, 99, 33, 12],
            [0.7098039215686275, 101, 34, 13],
            [0.7137254901960784, 103, 35, 14],
            [0.7176470588235294, 105, 37, 15],
            [0.7215686274509804, 107, 38, 17],
            [0.7254901960784313, 110, 40, 18],
            [0.7294117647058823, 112, 41, 20],
            [0.7333333333333333, 114, 43, 21],
            [0.7372549019607844, 116, 45, 23],
            [0.7411764705882353, 118, 46, 24],
            [0.7450980392156863, 121, 48, 26],
            [0.7490196078431373, 123, 50, 28],
            [0.7529411764705882, 125, 51, 30],
            [0.7568627450980392, 127, 53, 32],
            [0.7607843137254902, 129, 55, 33],
            [0.7647058823529411, 131, 57, 35],
            [0.7686274509803921, 133, 59, 37],
            [0.7725490196078432, 136, 60, 39],
            [0.7764705882352941, 138, 62, 41],
            [0.7803921568627451, 140, 64, 43],
            [0.7843137254901961, 142, 66, 46],
            [0.788235294117647, 144, 68, 48],
            [0.792156862745098, 146, 69, 50],
            [0.796078431372549, 148, 71, 52],
            [0.8, 150, 73, 54],
            [0.803921568627451, 152, 75, 56],
            [0.807843137254902, 154, 77, 58],
            [0.8117647058823529, 156, 79, 60],
            [0.8156862745098039, 158, 81, 63],
            [0.8196078431372549, 160, 82, 65],
            [0.8235294117647058, 162, 84, 67],
            [0.8274509803921568, 164, 86, 69],
            [0.8313725490196078, 165, 88, 71],
            [0.8352941176470589, 167, 90, 74],
            [0.8392156862745098, 169, 92, 76],
            [0.8431372549019608, 171, 94, 78],
            [0.8470588235294118, 173, 96, 80],
            [0.8509803921568627, 175, 97, 83],
            [0.8549019607843137, 177, 99, 85],
            [0.8588235294117647, 179, 101, 87],
            [0.8627450980392157, 181, 103, 89],
            [0.8666666666666667, 183, 105, 92],
            [0.8705882352941177, 185, 107, 94],
            [0.8745098039215686, 187, 109, 96],
            [0.8784313725490196, 189, 111, 99],
            [0.8823529411764706, 191, 113, 101],
            [0.8862745098039215, 194, 115, 103],
            [0.8901960784313725, 196, 117, 106],
            [0.8941176470588235, 198, 119, 108],
            [0.8980392156862745, 200, 120, 110],
            [0.9019607843137255, 202, 122, 113],
            [0.9058823529411765, 204, 124, 115],
            [0.9098039215686274, 206, 126, 117],
            [0.9137254901960784, 208, 128, 120],
            [0.9176470588235294, 210, 130, 122],
            [0.9215686274509803, 212, 132, 124],
            [0.9254901960784314, 214, 134, 127],
            [0.9294117647058824, 216, 136, 129],
            [0.9333333333333333, 218, 138, 131],
            [0.9372549019607843, 220, 140, 134],
            [0.9411764705882353, 223, 142, 136],
            [0.9450980392156862, 225, 144, 139],
            [0.9490196078431372, 227, 146, 141],
            [0.9529411764705882, 229, 148, 143],
            [0.9568627450980391, 231, 150, 146],
            [0.9607843137254902, 233, 152, 148],
            [0.9647058823529412, 235, 154, 151],
            [0.9686274509803922, 237, 156, 153],
            [0.9725490196078431, 239, 158, 156],
            [0.9764705882352941, 242, 161, 158],
            [0.9803921568627451, 244, 163, 161],
            [0.984313725490196, 246, 165, 163],
            [0.9882352941176471, 248, 167, 165],
            [0.9921568627450981, 250, 169, 168],
            [0.996078431372549, 252, 171, 170],
            [1.0, 254, 173, 173],
        ],
    },
    {
        "name": "bilbao (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 255, 255, 254],
            [0.00392156862745098, 253, 253, 253],
            [0.00784313725490196, 252, 252, 252],
            [0.011764705882352941, 251, 251, 251],
            [0.01568627450980392, 249, 249, 249],
            [0.0196078431372549, 248, 248, 248],
            [0.023529411764705882, 247, 247, 247],
            [0.027450980392156862, 245, 245, 245],
            [0.03137254901960784, 244, 244, 244],
            [0.03529411764705882, 243, 243, 243],
            [0.0392156862745098, 242, 241, 241],
            [0.043137254901960784, 240, 240, 240],
            [0.047058823529411764, 239, 239, 239],
            [0.050980392156862744, 238, 238, 237],
            [0.054901960784313725, 236, 236, 236],
            [0.058823529411764705, 235, 235, 235],
            [0.06274509803921569, 234, 234, 233],
            [0.06666666666666667, 233, 232, 232],
            [0.07058823529411765, 231, 231, 231],
            [0.07450980392156863, 230, 230, 229],
            [0.0784313725490196, 229, 229, 228],
            [0.08235294117647059, 228, 227, 226],
            [0.08627450980392157, 226, 226, 225],
            [0.09019607843137255, 225, 225, 224],
            [0.09411764705882353, 224, 224, 222],
            [0.09803921568627451, 223, 222, 221],
            [0.10196078431372549, 222, 221, 219],
            [0.10588235294117647, 221, 220, 218],
            [0.10980392156862745, 219, 219, 216],
            [0.11372549019607843, 218, 218, 215],
            [0.11764705882352941, 217, 216, 214],
            [0.12156862745098039, 216, 215, 212],
            [0.12549019607843137, 215, 214, 211],
            [0.12941176470588234, 214, 213, 209],
            [0.13333333333333333, 213, 212, 208],
            [0.13725490196078433, 212, 211, 206],
            [0.1411764705882353, 211, 210, 205],
            [0.14509803921568626, 210, 209, 203],
            [0.14901960784313725, 209, 208, 202],
            [0.15294117647058825, 208, 207, 200],
            [0.1568627450980392, 207, 206, 199],
            [0.16078431372549018, 206, 205, 197],
            [0.16470588235294117, 206, 204, 196],
            [0.16862745098039217, 205, 203, 194],
            [0.17254901960784313, 204, 202, 193],
            [0.1764705882352941, 203, 201, 192],
            [0.1803921568627451, 203, 200, 190],
            [0.1843137254901961, 202, 199, 189],
            [0.18823529411764706, 201, 198, 187],
            [0.19215686274509802, 201, 198, 186],
            [0.19607843137254902, 200, 197, 184],
            [0.2, 199, 196, 183],
            [0.20392156862745098, 199, 195, 182],
            [0.20784313725490194, 198, 195, 180],
            [0.21176470588235294, 198, 194, 179],
            [0.21568627450980393, 197, 193, 178],
            [0.2196078431372549, 197, 192, 176],
            [0.22352941176470587, 196, 192, 175],
            [0.22745098039215686, 196, 191, 173],
            [0.23137254901960785, 195, 190, 172],
            [0.23529411764705882, 195, 190, 171],
            [0.2392156862745098, 194, 189, 169],
            [0.24313725490196078, 194, 189, 168],
            [0.24705882352941178, 194, 188, 167],
            [0.25098039215686274, 193, 187, 166],
            [0.2549019607843137, 193, 187, 164],
            [0.2588235294117647, 192, 186, 163],
            [0.2627450980392157, 192, 186, 162],
            [0.26666666666666666, 192, 185, 160],
            [0.27058823529411763, 191, 184, 159],
            [0.27450980392156865, 191, 184, 158],
            [0.2784313725490196, 190, 183, 156],
            [0.2823529411764706, 190, 183, 155],
            [0.28627450980392155, 190, 182, 154],
            [0.2901960784313725, 189, 181, 152],
            [0.29411764705882354, 189, 181, 151],
            [0.2980392156862745, 188, 180, 150],
            [0.30196078431372547, 188, 180, 149],
            [0.3058823529411765, 188, 179, 147],
            [0.30980392156862746, 187, 178, 146],
            [0.3137254901960784, 187, 178, 145],
            [0.3176470588235294, 186, 177, 143],
            [0.32156862745098036, 186, 176, 142],
            [0.3254901960784314, 186, 176, 141],
            [0.32941176470588235, 185, 175, 139],
            [0.3333333333333333, 185, 174, 138],
            [0.33725490196078434, 184, 173, 137],
            [0.3411764705882353, 184, 173, 135],
            [0.34509803921568627, 184, 172, 134],
            [0.34901960784313724, 183, 171, 133],
            [0.3529411764705882, 183, 170, 132],
            [0.3568627450980392, 182, 169, 130],
            [0.3607843137254902, 182, 168, 129],
            [0.36470588235294116, 181, 168, 128],
            [0.3686274509803922, 181, 167, 126],
            [0.37254901960784315, 181, 166, 125],
            [0.3764705882352941, 180, 165, 124],
            [0.3803921568627451, 180, 164, 123],
            [0.38431372549019605, 179, 163, 122],
            [0.38823529411764707, 179, 162, 121],
            [0.39215686274509803, 178, 161, 119],
            [0.396078431372549, 178, 160, 118],
            [0.4, 178, 159, 117],
            [0.403921568627451, 177, 158, 116],
            [0.40784313725490196, 177, 157, 115],
            [0.4117647058823529, 176, 156, 114],
            [0.4156862745098039, 176, 155, 114],
            [0.4196078431372549, 176, 154, 113],
            [0.4235294117647059, 175, 153, 112],
            [0.42745098039215684, 175, 152, 111],
            [0.43137254901960786, 175, 151, 110],
            [0.43529411764705883, 174, 150, 110],
            [0.4392156862745098, 174, 149, 109],
            [0.44313725490196076, 174, 148, 108],
            [0.44705882352941173, 173, 147, 108],
            [0.45098039215686275, 173, 146, 107],
            [0.4549019607843137, 173, 145, 107],
            [0.4588235294117647, 172, 144, 106],
            [0.4627450980392157, 172, 143, 105],
            [0.4666666666666667, 172, 142, 105],
            [0.47058823529411764, 171, 141, 104],
            [0.4745098039215686, 171, 140, 104],
            [0.4784313725490196, 171, 139, 103],
            [0.4823529411764706, 171, 138, 103],
            [0.48627450980392156, 170, 137, 103],
            [0.49019607843137253, 170, 137, 102],
            [0.49411764705882355, 170, 136, 102],
            [0.4980392156862745, 170, 135, 101],
            [0.5019607843137255, 169, 134, 101],
            [0.5058823529411764, 169, 133, 101],
            [0.5098039215686274, 169, 132, 100],
            [0.5137254901960784, 168, 131, 100],
            [0.5176470588235293, 168, 130, 99],
            [0.5215686274509804, 168, 129, 99],
            [0.5254901960784314, 168, 129, 99],
            [0.5294117647058824, 167, 128, 98],
            [0.5333333333333333, 167, 127, 98],
            [0.5372549019607843, 167, 126, 97],
            [0.5411764705882353, 167, 125, 97],
            [0.5450980392156862, 166, 124, 97],
            [0.5490196078431373, 166, 123, 96],
            [0.5529411764705883, 166, 122, 96],
            [0.5568627450980392, 166, 122, 96],
            [0.5607843137254902, 165, 121, 95],
            [0.5647058823529412, 165, 120, 95],
            [0.5686274509803921, 165, 119, 94],
            [0.5725490196078431, 165, 118, 94],
            [0.5764705882352941, 164, 117, 94],
            [0.580392156862745, 164, 116, 93],
            [0.5843137254901961, 164, 115, 93],
            [0.5882352941176471, 164, 115, 92],
            [0.592156862745098, 163, 114, 92],
            [0.596078431372549, 163, 113, 92],
            [0.6, 163, 112, 91],
            [0.6039215686274509, 163, 111, 91],
            [0.6078431372549019, 162, 110, 91],
            [0.611764705882353, 162, 109, 90],
            [0.615686274509804, 162, 108, 90],
            [0.6196078431372549, 162, 108, 89],
            [0.6235294117647059, 161, 107, 89],
            [0.6274509803921569, 161, 106, 89],
            [0.6313725490196078, 161, 105, 88],
            [0.6352941176470588, 160, 104, 88],
            [0.6392156862745098, 160, 103, 87],
            [0.6431372549019607, 160, 102, 87],
            [0.6470588235294118, 160, 101, 87],
            [0.6509803921568628, 159, 100, 86],
            [0.6549019607843137, 159, 99, 86],
            [0.6588235294117647, 159, 98, 85],
            [0.6627450980392157, 158, 98, 85],
            [0.6666666666666666, 158, 97, 84],
            [0.6705882352941176, 158, 96, 84],
            [0.6745098039215687, 157, 95, 83],
            [0.6784313725490196, 157, 94, 83],
            [0.6823529411764706, 157, 93, 82],
            [0.6862745098039216, 156, 92, 82],
            [0.6901960784313725, 156, 91, 81],
            [0.6941176470588235, 155, 90, 81],
            [0.6980392156862745, 155, 89, 80],
            [0.7019607843137254, 154, 88, 80],
            [0.7058823529411764, 154, 87, 79],
            [0.7098039215686275, 153, 86, 78],
            [0.7137254901960784, 153, 85, 78],
            [0.7176470588235294, 152, 84, 77],
            [0.7215686274509804, 152, 83, 76],
            [0.7254901960784313, 151, 82, 76],
            [0.7294117647058823, 150, 80, 75],
            [0.7333333333333333, 150, 79, 74],
            [0.7372549019607844, 149, 78, 73],
            [0.7411764705882353, 148, 77, 73],
            [0.7450980392156863, 148, 76, 72],
            [0.7490196078431373, 147, 75, 71],
            [0.7529411764705882, 146, 74, 70],
            [0.7568627450980392, 145, 73, 69],
            [0.7607843137254902, 144, 71, 68],
            [0.7647058823529411, 144, 70, 67],
            [0.7686274509803921, 143, 69, 66],
            [0.7725490196078432, 142, 68, 65],
            [0.7764705882352941, 141, 67, 64],
            [0.7803921568627451, 140, 66, 64],
            [0.7843137254901961, 139, 65, 63],
            [0.788235294117647, 138, 63, 61],
            [0.792156862745098, 137, 62, 60],
            [0.796078431372549, 136, 61, 59],
            [0.8, 135, 60, 58],
            [0.803921568627451, 134, 59, 57],
            [0.807843137254902, 133, 58, 56],
            [0.8117647058823529, 132, 56, 55],
            [0.8156862745098039, 131, 55, 54],
            [0.8196078431372549, 130, 54, 53],
            [0.8235294117647058, 129, 53, 52],
            [0.8274509803921568, 128, 52, 51],
            [0.8313725490196078, 127, 51, 50],
            [0.8352941176470589, 125, 50, 49],
            [0.8392156862745098, 124, 48, 48],
            [0.8431372549019608, 123, 47, 47],
            [0.8470588235294118, 122, 46, 45],
            [0.8509803921568627, 121, 45, 44],
            [0.8549019607843137, 120, 44, 43],
            [0.8588235294117647, 119, 43, 42],
            [0.8627450980392157, 118, 42, 41],
            [0.8666666666666667, 117, 41, 40],
            [0.8705882352941177, 115, 39, 39],
            [0.8745098039215686, 114, 38, 38],
            [0.8784313725490196, 113, 37, 37],
            [0.8823529411764706, 112, 36, 36],
            [0.8862745098039215, 111, 35, 35],
            [0.8901960784313725, 110, 34, 34],
            [0.8941176470588235, 109, 33, 32],
            [0.8980392156862745, 107, 32, 31],
            [0.9019607843137255, 106, 30, 30],
            [0.9058823529411765, 105, 29, 29],
            [0.9098039215686274, 104, 28, 28],
            [0.9137254901960784, 103, 27, 27],
            [0.9176470588235294, 101, 26, 26],
            [0.9215686274509803, 100, 25, 25],
            [0.9254901960784314, 99, 24, 24],
            [0.9294117647058824, 98, 22, 23],
            [0.9333333333333333, 97, 21, 22],
            [0.9372549019607843, 95, 20, 21],
            [0.9411764705882353, 94, 19, 20],
            [0.9450980392156862, 93, 18, 19],
            [0.9490196078431372, 92, 16, 18],
            [0.9529411764705882, 90, 15, 17],
            [0.9568627450980391, 89, 14, 16],
            [0.9607843137254902, 88, 12, 15],
            [0.9647058823529412, 87, 11, 14],
            [0.9686274509803922, 86, 10, 13],
            [0.9725490196078431, 84, 8, 12],
            [0.9764705882352941, 83, 7, 10],
            [0.9803921568627451, 82, 6, 9],
            [0.984313725490196, 81, 4, 7],
            [0.9882352941176471, 80, 3, 6],
            [0.9921568627450981, 78, 2, 4],
            [0.996078431372549, 77, 1, 2],
            [1.0, 76, 0, 1],
        ],
    },
    {
        "name": "broc (Div)",
        "discrete": False,
        "colors": [
            [0.0, 43, 25, 76],
            [0.00392156862745098, 43, 27, 77],
            [0.00784313725490196, 43, 28, 79],
            [0.011764705882352941, 43, 30, 80],
            [0.01568627450980392, 43, 31, 82],
            [0.0196078431372549, 43, 33, 83],
            [0.023529411764705882, 43, 34, 85],
            [0.027450980392156862, 43, 36, 86],
            [0.03137254901960784, 42, 37, 88],
            [0.03529411764705882, 42, 39, 89],
            [0.0392156862745098, 42, 40, 91],
            [0.043137254901960784, 42, 42, 92],
            [0.047058823529411764, 42, 43, 94],
            [0.050980392156862744, 42, 44, 95],
            [0.054901960784313725, 42, 46, 97],
            [0.058823529411764705, 41, 47, 98],
            [0.06274509803921569, 41, 49, 100],
            [0.06666666666666667, 41, 50, 101],
            [0.07058823529411765, 41, 52, 103],
            [0.07450980392156863, 41, 54, 104],
            [0.0784313725490196, 41, 55, 106],
            [0.08235294117647059, 40, 57, 107],
            [0.08627450980392157, 40, 58, 109],
            [0.09019607843137255, 40, 60, 111],
            [0.09411764705882353, 40, 61, 112],
            [0.09803921568627451, 40, 63, 114],
            [0.10196078431372549, 40, 64, 115],
            [0.10588235294117647, 40, 66, 117],
            [0.10980392156862745, 40, 68, 118],
            [0.11372549019607843, 40, 69, 120],
            [0.11764705882352941, 40, 71, 122],
            [0.12156862745098039, 40, 73, 123],
            [0.12549019607843137, 40, 74, 125],
            [0.12941176470588234, 40, 76, 126],
            [0.13333333333333333, 41, 78, 128],
            [0.13725490196078433, 41, 79, 129],
            [0.1411764705882353, 42, 81, 131],
            [0.14509803921568626, 42, 83, 132],
            [0.14901960784313725, 43, 84, 134],
            [0.15294117647058825, 44, 86, 135],
            [0.1568627450980392, 45, 88, 137],
            [0.16078431372549018, 46, 90, 138],
            [0.16470588235294117, 47, 91, 140],
            [0.16862745098039217, 49, 93, 141],
            [0.17254901960784313, 50, 95, 143],
            [0.1764705882352941, 52, 97, 144],
            [0.1803921568627451, 53, 98, 146],
            [0.1843137254901961, 55, 100, 147],
            [0.18823529411764706, 57, 102, 148],
            [0.19215686274509802, 58, 104, 150],
            [0.19607843137254902, 60, 105, 151],
            [0.2, 62, 107, 152],
            [0.20392156862745098, 64, 109, 153],
            [0.20784313725490194, 66, 110, 155],
            [0.21176470588235294, 68, 112, 156],
            [0.21568627450980393, 71, 114, 157],
            [0.2196078431372549, 73, 116, 158],
            [0.22352941176470587, 75, 117, 160],
            [0.22745098039215686, 77, 119, 161],
            [0.23137254901960785, 79, 121, 162],
            [0.23529411764705882, 81, 123, 163],
            [0.2392156862745098, 84, 124, 164],
            [0.24313725490196078, 86, 126, 166],
            [0.24705882352941178, 88, 128, 167],
            [0.25098039215686274, 90, 130, 168],
            [0.2549019607843137, 92, 131, 169],
            [0.2588235294117647, 95, 133, 170],
            [0.2627450980392157, 97, 135, 172],
            [0.26666666666666666, 99, 136, 173],
            [0.27058823529411763, 101, 138, 174],
            [0.27450980392156865, 104, 140, 175],
            [0.2784313725490196, 106, 142, 177],
            [0.2823529411764706, 108, 143, 178],
            [0.28627450980392155, 111, 145, 179],
            [0.2901960784313725, 113, 147, 180],
            [0.29411764705882354, 115, 149, 181],
            [0.2980392156862745, 117, 150, 183],
            [0.30196078431372547, 120, 152, 184],
            [0.3058823529411765, 122, 154, 185],
            [0.30980392156862746, 124, 156, 186],
            [0.3137254901960784, 127, 158, 187],
            [0.3176470588235294, 129, 159, 189],
            [0.32156862745098036, 131, 161, 190],
            [0.3254901960784314, 134, 163, 191],
            [0.32941176470588235, 136, 165, 192],
            [0.3333333333333333, 138, 166, 194],
            [0.33725490196078434, 141, 168, 195],
            [0.3411764705882353, 143, 170, 196],
            [0.34509803921568627, 145, 172, 197],
            [0.34901960784313724, 148, 174, 199],
            [0.3529411764705882, 150, 175, 200],
            [0.3568627450980392, 152, 177, 201],
            [0.3607843137254902, 155, 179, 202],
            [0.36470588235294116, 157, 181, 203],
            [0.3686274509803922, 160, 183, 205],
            [0.37254901960784315, 162, 184, 206],
            [0.3764705882352941, 164, 186, 207],
            [0.3803921568627451, 167, 188, 208],
            [0.38431372549019605, 169, 190, 210],
            [0.38823529411764707, 171, 192, 211],
            [0.39215686274509803, 174, 193, 212],
            [0.396078431372549, 176, 195, 213],
            [0.4, 179, 197, 215],
            [0.403921568627451, 181, 199, 216],
            [0.40784313725490196, 183, 201, 217],
            [0.4117647058823529, 186, 202, 218],
            [0.4156862745098039, 188, 204, 220],
            [0.4196078431372549, 191, 206, 221],
            [0.4235294117647059, 193, 208, 222],
            [0.42745098039215684, 195, 210, 223],
            [0.43137254901960786, 198, 212, 225],
            [0.43529411764705883, 200, 213, 226],
            [0.4392156862745098, 203, 215, 227],
            [0.44313725490196076, 205, 217, 228],
            [0.44705882352941173, 207, 219, 229],
            [0.45098039215686275, 210, 220, 231],
            [0.4549019607843137, 212, 222, 232],
            [0.4588235294117647, 214, 224, 233],
            [0.4627450980392157, 217, 226, 233],
            [0.4666666666666667, 219, 227, 234],
            [0.47058823529411764, 221, 229, 235],
            [0.4745098039215686, 223, 230, 236],
            [0.4784313725490196, 225, 232, 236],
            [0.4823529411764706, 227, 233, 236],
            [0.48627450980392156, 229, 234, 237],
            [0.49019607843137253, 231, 236, 236],
            [0.49411764705882355, 232, 237, 236],
            [0.4980392156862745, 234, 237, 236],
            [0.5019607843137255, 235, 238, 235],
            [0.5058823529411764, 236, 238, 234],
            [0.5098039215686274, 237, 239, 233],
            [0.5137254901960784, 237, 239, 232],
            [0.5176470588235293, 237, 239, 230],
            [0.5215686274509804, 237, 239, 228],
            [0.5254901960784314, 237, 238, 227],
            [0.5294117647058824, 237, 238, 225],
            [0.5333333333333333, 236, 237, 223],
            [0.5372549019607843, 236, 236, 221],
            [0.5411764705882353, 235, 235, 218],
            [0.5450980392156862, 234, 235, 216],
            [0.5490196078431373, 234, 234, 214],
            [0.5529411764705883, 233, 233, 212],
            [0.5568627450980392, 232, 232, 209],
            [0.5607843137254902, 231, 230, 207],
            [0.5647058823529412, 229, 229, 205],
            [0.5686274509803921, 228, 228, 202],
            [0.5725490196078431, 227, 227, 200],
            [0.5764705882352941, 226, 226, 198],
            [0.580392156862745, 225, 225, 195],
            [0.5843137254901961, 224, 224, 193],
            [0.5882352941176471, 223, 222, 190],
            [0.592156862745098, 221, 221, 188],
            [0.596078431372549, 220, 220, 186],
            [0.6, 219, 219, 183],
            [0.6039215686274509, 218, 218, 181],
            [0.6078431372549019, 217, 216, 179],
            [0.611764705882353, 215, 215, 176],
            [0.615686274509804, 214, 214, 174],
            [0.6196078431372549, 213, 213, 171],
            [0.6235294117647059, 212, 212, 169],
            [0.6274509803921569, 210, 210, 167],
            [0.6313725490196078, 209, 209, 164],
            [0.6352941176470588, 208, 208, 162],
            [0.6392156862745098, 207, 206, 159],
            [0.6431372549019607, 205, 205, 157],
            [0.6470588235294118, 204, 204, 155],
            [0.6509803921568628, 202, 202, 152],
            [0.6549019607843137, 201, 201, 150],
            [0.6588235294117647, 199, 199, 147],
            [0.6627450980392157, 198, 198, 145],
            [0.6666666666666666, 196, 196, 142],
            [0.6705882352941176, 195, 194, 140],
            [0.6745098039215687, 193, 193, 137],
            [0.6784313725490196, 191, 191, 135],
            [0.6823529411764706, 189, 189, 133],
            [0.6862745098039216, 187, 187, 130],
            [0.6901960784313725, 185, 185, 128],
            [0.6941176470588235, 183, 183, 125],
            [0.6980392156862745, 181, 181, 123],
            [0.7019607843137254, 179, 179, 121],
            [0.7058823529411764, 177, 177, 119],
            [0.7098039215686275, 175, 175, 117],
            [0.7137254901960784, 173, 173, 114],
            [0.7176470588235294, 171, 171, 112],
            [0.7215686274509804, 169, 169, 110],
            [0.7254901960784313, 167, 167, 108],
            [0.7294117647058823, 165, 165, 106],
            [0.7333333333333333, 163, 163, 105],
            [0.7372549019607844, 161, 161, 103],
            [0.7411764705882353, 159, 159, 101],
            [0.7450980392156863, 157, 157, 99],
            [0.7490196078431373, 155, 155, 97],
            [0.7529411764705882, 153, 153, 95],
            [0.7568627450980392, 151, 151, 94],
            [0.7607843137254902, 149, 149, 92],
            [0.7647058823529411, 147, 147, 90],
            [0.7686274509803921, 145, 145, 89],
            [0.7725490196078432, 143, 143, 87],
            [0.7764705882352941, 141, 141, 85],
            [0.7803921568627451, 139, 139, 84],
            [0.7843137254901961, 137, 137, 82],
            [0.788235294117647, 135, 135, 80],
            [0.792156862745098, 133, 133, 79],
            [0.796078431372549, 131, 131, 77],
            [0.8, 129, 129, 75],
            [0.803921568627451, 127, 127, 74],
            [0.807843137254902, 125, 125, 72],
            [0.8117647058823529, 123, 123, 70],
            [0.8156862745098039, 121, 121, 69],
            [0.8196078431372549, 119, 119, 67],
            [0.8235294117647058, 117, 117, 65],
            [0.8274509803921568, 115, 115, 64],
            [0.8313725490196078, 113, 113, 62],
            [0.8352941176470589, 111, 111, 61],
            [0.8392156862745098, 109, 109, 59],
            [0.8431372549019608, 107, 107, 57],
            [0.8470588235294118, 105, 105, 56],
            [0.8509803921568627, 104, 104, 54],
            [0.8549019607843137, 102, 102, 53],
            [0.8588235294117647, 100, 100, 51],
            [0.8627450980392157, 98, 98, 50],
            [0.8666666666666667, 96, 96, 48],
            [0.8705882352941177, 94, 94, 46],
            [0.8745098039215686, 92, 92, 45],
            [0.8784313725490196, 90, 90, 43],
            [0.8823529411764706, 89, 89, 42],
            [0.8862745098039215, 87, 87, 40],
            [0.8901960784313725, 85, 85, 39],
            [0.8941176470588235, 83, 83, 37],
            [0.8980392156862745, 81, 81, 36],
            [0.9019607843137255, 79, 79, 34],
            [0.9058823529411765, 78, 78, 33],
            [0.9098039215686274, 76, 76, 31],
            [0.9137254901960784, 74, 74, 30],
            [0.9176470588235294, 72, 72, 29],
            [0.9215686274509803, 70, 70, 27],
            [0.9254901960784314, 69, 69, 26],
            [0.9294117647058824, 67, 67, 24],
            [0.9333333333333333, 65, 65, 23],
            [0.9372549019607843, 63, 64, 22],
            [0.9411764705882353, 62, 62, 20],
            [0.9450980392156862, 60, 60, 19],
            [0.9490196078431372, 58, 58, 18],
            [0.9529411764705882, 57, 57, 17],
            [0.9568627450980391, 55, 55, 16],
            [0.9607843137254902, 53, 54, 14],
            [0.9647058823529412, 52, 52, 13],
            [0.9686274509803922, 50, 50, 12],
            [0.9725490196078431, 48, 49, 11],
            [0.9764705882352941, 47, 47, 9],
            [0.9803921568627451, 45, 46, 8],
            [0.984313725490196, 44, 44, 6],
            [0.9882352941176471, 42, 42, 5],
            [0.9921568627450981, 41, 41, 3],
            [0.996078431372549, 39, 39, 2],
            [1.0, 38, 38, 0],
        ],
    },
    {
        "name": "buda (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 178, 0, 178],
            [0.00392156862745098, 178, 2, 177],
            [0.00784313725490196, 178, 4, 176],
            [0.011764705882352941, 178, 7, 176],
            [0.01568627450980392, 178, 9, 175],
            [0.0196078431372549, 178, 11, 174],
            [0.023529411764705882, 178, 13, 173],
            [0.027450980392156862, 178, 15, 172],
            [0.03137254901960784, 178, 16, 171],
            [0.03529411764705882, 178, 18, 171],
            [0.0392156862745098, 178, 20, 170],
            [0.043137254901960784, 178, 21, 169],
            [0.047058823529411764, 178, 22, 168],
            [0.050980392156862744, 178, 24, 167],
            [0.054901960784313725, 178, 25, 167],
            [0.058823529411764705, 178, 27, 166],
            [0.06274509803921569, 178, 28, 165],
            [0.06666666666666667, 178, 29, 165],
            [0.07058823529411765, 178, 30, 164],
            [0.07450980392156863, 178, 32, 163],
            [0.0784313725490196, 178, 33, 163],
            [0.08235294117647059, 178, 34, 162],
            [0.08627450980392157, 178, 35, 161],
            [0.09019607843137255, 178, 36, 161],
            [0.09411764705882353, 178, 38, 160],
            [0.09803921568627451, 178, 39, 159],
            [0.10196078431372549, 178, 40, 159],
            [0.10588235294117647, 178, 41, 158],
            [0.10980392156862745, 178, 42, 158],
            [0.11372549019607843, 179, 43, 157],
            [0.11764705882352941, 179, 44, 157],
            [0.12156862745098039, 179, 45, 156],
            [0.12549019607843137, 179, 46, 156],
            [0.12941176470588234, 179, 47, 155],
            [0.13333333333333333, 179, 48, 155],
            [0.13725490196078433, 179, 50, 154],
            [0.1411764705882353, 179, 51, 154],
            [0.14509803921568626, 180, 52, 153],
            [0.14901960784313725, 180, 53, 153],
            [0.15294117647058825, 180, 54, 152],
            [0.1568627450980392, 180, 55, 152],
            [0.16078431372549018, 180, 56, 151],
            [0.16470588235294117, 181, 57, 151],
            [0.16862745098039217, 181, 58, 151],
            [0.17254901960784313, 181, 59, 150],
            [0.1764705882352941, 181, 60, 150],
            [0.1803921568627451, 182, 61, 149],
            [0.1843137254901961, 182, 62, 149],
            [0.18823529411764706, 182, 63, 149],
            [0.19215686274509802, 182, 64, 148],
            [0.19607843137254902, 183, 65, 148],
            [0.2, 183, 66, 148],
            [0.20392156862745098, 183, 67, 147],
            [0.20784313725490194, 184, 67, 147],
            [0.21176470588235294, 184, 68, 147],
            [0.21568627450980393, 184, 69, 146],
            [0.2196078431372549, 185, 70, 146],
            [0.22352941176470587, 185, 71, 146],
            [0.22745098039215686, 185, 72, 145],
            [0.23137254901960785, 186, 73, 145],
            [0.23529411764705882, 186, 74, 145],
            [0.2392156862745098, 186, 75, 144],
            [0.24313725490196078, 186, 76, 144],
            [0.24705882352941178, 187, 77, 144],
            [0.25098039215686274, 187, 78, 144],
            [0.2549019607843137, 187, 79, 143],
            [0.2588235294117647, 188, 80, 143],
            [0.2627450980392157, 188, 80, 143],
            [0.26666666666666666, 188, 81, 142],
            [0.27058823529411763, 189, 82, 142],
            [0.27450980392156865, 189, 83, 142],
            [0.2784313725490196, 189, 84, 141],
            [0.2823529411764706, 189, 85, 141],
            [0.28627450980392155, 190, 86, 141],
            [0.2901960784313725, 190, 87, 141],
            [0.29411764705882354, 190, 88, 140],
            [0.2980392156862745, 191, 89, 140],
            [0.30196078431372547, 191, 89, 140],
            [0.3058823529411765, 191, 90, 139],
            [0.30980392156862746, 192, 91, 139],
            [0.3137254901960784, 192, 92, 139],
            [0.3176470588235294, 192, 93, 138],
            [0.32156862745098036, 192, 94, 138],
            [0.3254901960784314, 193, 95, 138],
            [0.32941176470588235, 193, 95, 138],
            [0.3333333333333333, 193, 96, 137],
            [0.33725490196078434, 194, 97, 137],
            [0.3411764705882353, 194, 98, 137],
            [0.34509803921568627, 194, 99, 136],
            [0.34901960784313724, 194, 100, 136],
            [0.3529411764705882, 195, 101, 136],
            [0.3568627450980392, 195, 101, 136],
            [0.3607843137254902, 195, 102, 135],
            [0.36470588235294116, 196, 103, 135],
            [0.3686274509803922, 196, 104, 135],
            [0.37254901960784315, 196, 105, 134],
            [0.3764705882352941, 196, 106, 134],
            [0.3803921568627451, 197, 107, 134],
            [0.38431372549019605, 197, 107, 134],
            [0.38823529411764707, 197, 108, 133],
            [0.39215686274509803, 198, 109, 133],
            [0.396078431372549, 198, 110, 133],
            [0.4, 198, 111, 132],
            [0.403921568627451, 198, 112, 132],
            [0.40784313725490196, 199, 112, 132],
            [0.4117647058823529, 199, 113, 132],
            [0.4156862745098039, 199, 114, 131],
            [0.4196078431372549, 200, 115, 131],
            [0.4235294117647059, 200, 116, 131],
            [0.42745098039215684, 200, 117, 131],
            [0.43137254901960786, 200, 118, 130],
            [0.43529411764705883, 201, 118, 130],
            [0.4392156862745098, 201, 119, 130],
            [0.44313725490196076, 201, 120, 129],
            [0.44705882352941173, 201, 121, 129],
            [0.45098039215686275, 202, 122, 129],
            [0.4549019607843137, 202, 123, 129],
            [0.4588235294117647, 202, 123, 128],
            [0.4627450980392157, 202, 124, 128],
            [0.4666666666666667, 203, 125, 128],
            [0.47058823529411764, 203, 126, 128],
            [0.4745098039215686, 203, 127, 127],
            [0.4784313725490196, 203, 128, 127],
            [0.4823529411764706, 204, 129, 127],
            [0.48627450980392156, 204, 129, 127],
            [0.49019607843137253, 204, 130, 126],
            [0.49411764705882355, 204, 131, 126],
            [0.4980392156862745, 205, 132, 126],
            [0.5019607843137255, 205, 133, 126],
            [0.5058823529411764, 205, 134, 125],
            [0.5098039215686274, 205, 135, 125],
            [0.5137254901960784, 206, 135, 125],
            [0.5176470588235293, 206, 136, 125],
            [0.5215686274509804, 206, 137, 125],
            [0.5254901960784314, 206, 138, 124],
            [0.5294117647058824, 206, 139, 124],
            [0.5333333333333333, 207, 140, 124],
            [0.5372549019607843, 207, 141, 124],
            [0.5411764705882353, 207, 141, 123],
            [0.5450980392156862, 207, 142, 123],
            [0.5490196078431373, 208, 143, 123],
            [0.5529411764705883, 208, 144, 123],
            [0.5568627450980392, 208, 145, 123],
            [0.5607843137254902, 208, 146, 122],
            [0.5647058823529412, 208, 147, 122],
            [0.5686274509803921, 209, 148, 122],
            [0.5725490196078431, 209, 148, 122],
            [0.5764705882352941, 209, 149, 122],
            [0.580392156862745, 209, 150, 121],
            [0.5843137254901961, 210, 151, 121],
            [0.5882352941176471, 210, 152, 121],
            [0.592156862745098, 210, 153, 121],
            [0.596078431372549, 210, 154, 120],
            [0.6, 210, 154, 120],
            [0.6039215686274509, 211, 155, 120],
            [0.6078431372549019, 211, 156, 120],
            [0.611764705882353, 211, 157, 120],
            [0.615686274509804, 211, 158, 119],
            [0.6196078431372549, 212, 159, 119],
            [0.6235294117647059, 212, 160, 119],
            [0.6274509803921569, 212, 161, 119],
            [0.6313725490196078, 212, 161, 118],
            [0.6352941176470588, 212, 162, 118],
            [0.6392156862745098, 213, 163, 118],
            [0.6431372549019607, 213, 164, 118],
            [0.6470588235294118, 213, 165, 118],
            [0.6509803921568628, 213, 166, 117],
            [0.6549019607843137, 213, 167, 117],
            [0.6588235294117647, 214, 168, 117],
            [0.6627450980392157, 214, 169, 117],
            [0.6666666666666666, 214, 169, 116],
            [0.6705882352941176, 214, 170, 116],
            [0.6745098039215687, 215, 171, 116],
            [0.6784313725490196, 215, 172, 116],
            [0.6823529411764706, 215, 173, 116],
            [0.6862745098039216, 215, 174, 115],
            [0.6901960784313725, 215, 175, 115],
            [0.6941176470588235, 216, 176, 115],
            [0.6980392156862745, 216, 177, 115],
            [0.7019607843137254, 216, 177, 114],
            [0.7058823529411764, 216, 178, 114],
            [0.7098039215686275, 217, 179, 114],
            [0.7137254901960784, 217, 180, 114],
            [0.7176470588235294, 217, 181, 114],
            [0.7215686274509804, 217, 182, 113],
            [0.7254901960784313, 218, 183, 113],
            [0.7294117647058823, 218, 184, 113],
            [0.7333333333333333, 218, 185, 113],
            [0.7372549019607844, 218, 185, 112],
            [0.7411764705882353, 218, 186, 112],
            [0.7450980392156863, 219, 187, 112],
            [0.7490196078431373, 219, 188, 112],
            [0.7529411764705882, 219, 189, 112],
            [0.7568627450980392, 219, 190, 111],
            [0.7607843137254902, 220, 191, 111],
            [0.7647058823529411, 220, 192, 111],
            [0.7686274509803921, 220, 193, 111],
            [0.7725490196078432, 220, 194, 110],
            [0.7764705882352941, 220, 195, 110],
            [0.7803921568627451, 221, 195, 110],
            [0.7843137254901961, 221, 196, 110],
            [0.788235294117647, 221, 197, 110],
            [0.792156862745098, 221, 198, 109],
            [0.796078431372549, 222, 199, 109],
            [0.8, 222, 200, 109],
            [0.803921568627451, 222, 201, 109],
            [0.807843137254902, 222, 202, 108],
            [0.8117647058823529, 223, 203, 108],
            [0.8156862745098039, 223, 204, 108],
            [0.8196078431372549, 223, 205, 108],
            [0.8235294117647058, 223, 206, 107],
            [0.8274509803921568, 223, 207, 107],
            [0.8313725490196078, 224, 208, 107],
            [0.8352941176470589, 224, 208, 107],
            [0.8392156862745098, 224, 209, 107],
            [0.8431372549019608, 224, 210, 106],
            [0.8470588235294118, 225, 211, 106],
            [0.8509803921568627, 225, 212, 106],
            [0.8549019607843137, 225, 213, 106],
            [0.8588235294117647, 226, 214, 105],
            [0.8627450980392157, 226, 215, 105],
            [0.8666666666666667, 226, 216, 105],
            [0.8705882352941177, 227, 217, 105],
            [0.8745098039215686, 227, 218, 105],
            [0.8784313725490196, 227, 219, 104],
            [0.8823529411764706, 228, 220, 104],
            [0.8862745098039215, 228, 221, 104],
            [0.8901960784313725, 229, 222, 104],
            [0.8941176470588235, 229, 223, 104],
            [0.8980392156862745, 229, 224, 103],
            [0.9019607843137255, 230, 225, 103],
            [0.9058823529411765, 231, 226, 103],
            [0.9098039215686274, 231, 227, 103],
            [0.9137254901960784, 232, 228, 103],
            [0.9176470588235294, 233, 230, 103],
            [0.9215686274509803, 233, 231, 102],
            [0.9254901960784314, 234, 232, 102],
            [0.9294117647058824, 235, 233, 102],
            [0.9333333333333333, 236, 234, 102],
            [0.9372549019607843, 237, 235, 102],
            [0.9411764705882353, 238, 236, 102],
            [0.9450980392156862, 239, 238, 102],
            [0.9490196078431372, 240, 239, 102],
            [0.9529411764705882, 241, 240, 102],
            [0.9568627450980391, 242, 241, 102],
            [0.9607843137254902, 243, 242, 102],
            [0.9647058823529412, 244, 244, 102],
            [0.9686274509803922, 245, 245, 102],
            [0.9725490196078431, 246, 246, 102],
            [0.9764705882352941, 247, 247, 102],
            [0.9803921568627451, 249, 248, 102],
            [0.984313725490196, 250, 250, 102],
            [0.9882352941176471, 251, 251, 102],
            [0.9921568627450981, 252, 252, 102],
            [0.996078431372549, 253, 253, 102],
            [1.0, 255, 255, 102],
        ],
    },
    {
        "name": "cork (Div)",
        "discrete": False,
        "colors": [
            [0.0, 43, 25, 76],
            [0.00392156862745098, 43, 27, 77],
            [0.00784313725490196, 43, 28, 79],
            [0.011764705882352941, 43, 30, 81],
            [0.01568627450980392, 43, 31, 82],
            [0.0196078431372549, 43, 33, 84],
            [0.023529411764705882, 43, 35, 85],
            [0.027450980392156862, 43, 36, 87],
            [0.03137254901960784, 42, 38, 88],
            [0.03529411764705882, 42, 39, 90],
            [0.0392156862745098, 42, 41, 92],
            [0.043137254901960784, 42, 42, 93],
            [0.047058823529411764, 42, 44, 95],
            [0.050980392156862744, 42, 45, 96],
            [0.054901960784313725, 41, 47, 98],
            [0.058823529411764705, 41, 48, 99],
            [0.06274509803921569, 41, 50, 101],
            [0.06666666666666667, 41, 52, 102],
            [0.07058823529411765, 41, 53, 104],
            [0.07450980392156863, 40, 55, 105],
            [0.0784313725490196, 40, 56, 107],
            [0.08235294117647059, 40, 58, 108],
            [0.08627450980392157, 40, 59, 110],
            [0.09019607843137255, 40, 61, 112],
            [0.09411764705882353, 40, 62, 113],
            [0.09803921568627451, 40, 64, 115],
            [0.10196078431372549, 39, 65, 116],
            [0.10588235294117647, 39, 67, 118],
            [0.10980392156862745, 39, 68, 119],
            [0.11372549019607843, 39, 70, 121],
            [0.11764705882352941, 39, 72, 122],
            [0.12156862745098039, 40, 73, 124],
            [0.12549019607843137, 40, 75, 125],
            [0.12941176470588234, 40, 76, 127],
            [0.13333333333333333, 40, 78, 128],
            [0.13725490196078433, 41, 80, 130],
            [0.1411764705882353, 41, 81, 131],
            [0.14509803921568626, 42, 83, 133],
            [0.14901960784313725, 43, 85, 134],
            [0.15294117647058825, 43, 86, 136],
            [0.1568627450980392, 44, 88, 137],
            [0.16078431372549018, 45, 90, 139],
            [0.16470588235294117, 47, 91, 140],
            [0.16862745098039217, 48, 93, 142],
            [0.17254901960784313, 49, 95, 143],
            [0.1764705882352941, 51, 96, 144],
            [0.1803921568627451, 52, 98, 146],
            [0.1843137254901961, 54, 100, 147],
            [0.18823529411764706, 56, 101, 148],
            [0.19215686274509802, 57, 103, 149],
            [0.19607843137254902, 59, 105, 151],
            [0.2, 61, 106, 152],
            [0.20392156862745098, 63, 108, 153],
            [0.20784313725490194, 65, 109, 154],
            [0.21176470588235294, 66, 111, 155],
            [0.21568627450980393, 68, 113, 156],
            [0.2196078431372549, 70, 114, 157],
            [0.22352941176470587, 72, 116, 158],
            [0.22745098039215686, 74, 117, 159],
            [0.23137254901960785, 76, 119, 161],
            [0.23529411764705882, 78, 120, 162],
            [0.2392156862745098, 80, 122, 163],
            [0.24313725490196078, 82, 123, 164],
            [0.24705882352941178, 84, 125, 165],
            [0.25098039215686274, 86, 126, 166],
            [0.2549019607843137, 88, 128, 167],
            [0.2588235294117647, 89, 129, 168],
            [0.2627450980392157, 91, 131, 169],
            [0.26666666666666666, 93, 132, 170],
            [0.27058823529411763, 95, 134, 171],
            [0.27450980392156865, 98, 135, 172],
            [0.2784313725490196, 100, 137, 173],
            [0.2823529411764706, 102, 139, 174],
            [0.28627450980392155, 104, 140, 175],
            [0.2901960784313725, 106, 142, 177],
            [0.29411764705882354, 108, 143, 178],
            [0.2980392156862745, 110, 145, 179],
            [0.30196078431372547, 112, 147, 180],
            [0.3058823529411765, 115, 148, 181],
            [0.30980392156862746, 117, 150, 182],
            [0.3137254901960784, 119, 152, 183],
            [0.3176470588235294, 121, 153, 185],
            [0.32156862745098036, 123, 155, 186],
            [0.3254901960784314, 126, 157, 187],
            [0.32941176470588235, 128, 159, 188],
            [0.3333333333333333, 130, 160, 189],
            [0.33725490196078434, 133, 162, 191],
            [0.3411764705882353, 135, 164, 192],
            [0.34509803921568627, 137, 166, 193],
            [0.34901960784313724, 140, 168, 194],
            [0.3529411764705882, 142, 169, 196],
            [0.3568627450980392, 145, 171, 197],
            [0.3607843137254902, 147, 173, 198],
            [0.36470588235294116, 150, 175, 200],
            [0.3686274509803922, 152, 177, 201],
            [0.37254901960784315, 155, 179, 202],
            [0.3764705882352941, 157, 181, 203],
            [0.3803921568627451, 160, 183, 205],
            [0.38431372549019605, 162, 185, 206],
            [0.38823529411764707, 165, 186, 207],
            [0.39215686274509803, 167, 188, 209],
            [0.396078431372549, 170, 190, 210],
            [0.4, 173, 192, 212],
            [0.403921568627451, 175, 194, 213],
            [0.40784313725490196, 178, 196, 214],
            [0.4117647058823529, 180, 198, 216],
            [0.4156862745098039, 183, 200, 217],
            [0.4196078431372549, 186, 202, 218],
            [0.4235294117647059, 188, 204, 220],
            [0.42745098039215684, 191, 206, 221],
            [0.43137254901960786, 194, 209, 223],
            [0.43529411764705883, 197, 211, 224],
            [0.4392156862745098, 199, 213, 225],
            [0.44313725490196076, 202, 215, 227],
            [0.44705882352941173, 205, 217, 228],
            [0.45098039215686275, 207, 219, 229],
            [0.4549019607843137, 210, 221, 231],
            [0.4588235294117647, 212, 223, 232],
            [0.4627450980392157, 215, 225, 233],
            [0.4666666666666667, 217, 226, 234],
            [0.47058823529411764, 220, 228, 235],
            [0.4745098039215686, 222, 230, 236],
            [0.4784313725490196, 224, 232, 236],
            [0.4823529411764706, 225, 233, 237],
            [0.48627450980392156, 227, 234, 237],
            [0.49019607843137253, 228, 235, 237],
            [0.49411764705882355, 229, 236, 237],
            [0.4980392156862745, 230, 237, 236],
            [0.5019607843137255, 230, 237, 235],
            [0.5058823529411764, 230, 237, 234],
            [0.5098039215686274, 229, 237, 233],
            [0.5137254901960784, 229, 237, 232],
            [0.5176470588235293, 228, 236, 230],
            [0.5215686274509804, 227, 235, 229],
            [0.5254901960784314, 225, 235, 227],
            [0.5294117647058824, 224, 234, 225],
            [0.5333333333333333, 222, 233, 223],
            [0.5372549019607843, 220, 231, 221],
            [0.5411764705882353, 218, 230, 218],
            [0.5450980392156862, 216, 229, 216],
            [0.5490196078431373, 214, 227, 214],
            [0.5529411764705883, 211, 226, 212],
            [0.5568627450980392, 209, 224, 209],
            [0.5607843137254902, 207, 223, 207],
            [0.5647058823529412, 205, 221, 205],
            [0.5686274509803921, 202, 220, 202],
            [0.5725490196078431, 200, 218, 200],
            [0.5764705882352941, 197, 216, 197],
            [0.580392156862745, 195, 215, 195],
            [0.5843137254901961, 193, 213, 193],
            [0.5882352941176471, 190, 212, 190],
            [0.592156862745098, 188, 210, 188],
            [0.596078431372549, 185, 208, 185],
            [0.6, 183, 207, 183],
            [0.6039215686274509, 180, 205, 180],
            [0.6078431372549019, 178, 203, 178],
            [0.611764705882353, 175, 202, 175],
            [0.615686274509804, 173, 200, 173],
            [0.6196078431372549, 171, 199, 170],
            [0.6235294117647059, 168, 197, 168],
            [0.6274509803921569, 166, 195, 165],
            [0.6313725490196078, 163, 194, 163],
            [0.6352941176470588, 161, 192, 160],
            [0.6392156862745098, 158, 190, 158],
            [0.6431372549019607, 156, 189, 156],
            [0.6470588235294118, 153, 187, 153],
            [0.6509803921568628, 151, 185, 151],
            [0.6549019607843137, 148, 184, 148],
            [0.6588235294117647, 146, 182, 146],
            [0.6627450980392157, 143, 180, 143],
            [0.6666666666666666, 141, 179, 141],
            [0.6705882352941176, 139, 177, 138],
            [0.6745098039215687, 136, 176, 136],
            [0.6784313725490196, 134, 174, 134],
            [0.6823529411764706, 131, 172, 131],
            [0.6862745098039216, 129, 171, 129],
            [0.6901960784313725, 127, 169, 126],
            [0.6941176470588235, 124, 168, 124],
            [0.6980392156862745, 122, 166, 122],
            [0.7019607843137254, 120, 165, 119],
            [0.7058823529411764, 117, 163, 117],
            [0.7098039215686275, 115, 161, 115],
            [0.7137254901960784, 113, 160, 112],
            [0.7176470588235294, 111, 158, 110],
            [0.7215686274509804, 108, 157, 108],
            [0.7254901960784313, 106, 155, 106],
            [0.7294117647058823, 104, 154, 103],
            [0.7333333333333333, 102, 152, 101],
            [0.7372549019607844, 99, 151, 99],
            [0.7411764705882353, 97, 149, 97],
            [0.7450980392156863, 95, 148, 95],
            [0.7490196078431373, 93, 147, 93],
            [0.7529411764705882, 91, 145, 90],
            [0.7568627450980392, 89, 144, 88],
            [0.7607843137254902, 87, 142, 86],
            [0.7647058823529411, 85, 141, 84],
            [0.7686274509803921, 82, 139, 82],
            [0.7725490196078432, 80, 138, 80],
            [0.7764705882352941, 78, 137, 78],
            [0.7803921568627451, 76, 135, 76],
            [0.7843137254901961, 74, 134, 74],
            [0.788235294117647, 72, 133, 72],
            [0.792156862745098, 70, 131, 70],
            [0.796078431372549, 68, 130, 68],
            [0.8, 66, 128, 66],
            [0.803921568627451, 64, 127, 64],
            [0.807843137254902, 62, 126, 62],
            [0.8117647058823529, 60, 124, 60],
            [0.8156862745098039, 58, 123, 58],
            [0.8196078431372549, 56, 121, 55],
            [0.8235294117647058, 54, 120, 53],
            [0.8274509803921568, 52, 118, 51],
            [0.8313725490196078, 50, 117, 49],
            [0.8352941176470589, 49, 115, 47],
            [0.8392156862745098, 47, 114, 45],
            [0.8431372549019608, 45, 112, 44],
            [0.8470588235294118, 43, 110, 42],
            [0.8509803921568627, 41, 109, 40],
            [0.8549019607843137, 39, 107, 38],
            [0.8588235294117647, 38, 105, 36],
            [0.8627450980392157, 36, 103, 34],
            [0.8666666666666667, 34, 102, 33],
            [0.8705882352941177, 33, 100, 31],
            [0.8745098039215686, 32, 98, 30],
            [0.8784313725490196, 30, 96, 28],
            [0.8823529411764706, 29, 95, 27],
            [0.8862745098039215, 28, 93, 25],
            [0.8901960784313725, 27, 91, 24],
            [0.8941176470588235, 26, 89, 23],
            [0.8980392156862745, 25, 87, 22],
            [0.9019607843137255, 24, 85, 21],
            [0.9058823529411765, 24, 83, 20],
            [0.9098039215686274, 23, 82, 19],
            [0.9137254901960784, 23, 80, 18],
            [0.9176470588235294, 22, 78, 17],
            [0.9215686274509803, 22, 76, 16],
            [0.9254901960784314, 21, 74, 16],
            [0.9294117647058824, 21, 72, 15],
            [0.9333333333333333, 20, 70, 14],
            [0.9372549019607843, 20, 69, 13],
            [0.9411764705882353, 19, 67, 13],
            [0.9450980392156862, 19, 65, 12],
            [0.9490196078431372, 19, 63, 12],
            [0.9529411764705882, 18, 61, 11],
            [0.9568627450980391, 18, 59, 11],
            [0.9607843137254902, 17, 58, 10],
            [0.9647058823529412, 17, 56, 9],
            [0.9686274509803922, 17, 54, 9],
            [0.9725490196078431, 17, 52, 8],
            [0.9764705882352941, 16, 51, 7],
            [0.9803921568627451, 16, 49, 6],
            [0.984313725490196, 16, 47, 6],
            [0.9882352941176471, 15, 46, 5],
            [0.9921568627450981, 15, 44, 4],
            [0.996078431372549, 15, 42, 3],
            [1.0, 15, 40, 3],
        ],
    },
    {
        "name": "davos (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 0, 5, 74],
            [0.00392156862745098, 0, 6, 75],
            [0.00784313725490196, 0, 8, 77],
            [0.011764705882352941, 0, 10, 78],
            [0.01568627450980392, 0, 12, 80],
            [0.0196078431372549, 1, 13, 81],
            [0.023529411764705882, 1, 14, 82],
            [0.027450980392156862, 2, 16, 84],
            [0.03137254901960784, 2, 17, 85],
            [0.03529411764705882, 3, 19, 87],
            [0.0392156862745098, 4, 20, 88],
            [0.043137254901960784, 4, 21, 89],
            [0.047058823529411764, 5, 23, 91],
            [0.050980392156862744, 6, 24, 92],
            [0.054901960784313725, 6, 25, 94],
            [0.058823529411764705, 7, 27, 95],
            [0.06274509803921569, 8, 28, 97],
            [0.06666666666666667, 8, 29, 98],
            [0.07058823529411765, 9, 31, 99],
            [0.07450980392156863, 10, 32, 101],
            [0.0784313725490196, 11, 33, 102],
            [0.08235294117647059, 12, 35, 103],
            [0.08627450980392157, 12, 36, 105],
            [0.09019607843137255, 13, 37, 106],
            [0.09411764705882353, 14, 39, 108],
            [0.09803921568627451, 15, 40, 109],
            [0.10196078431372549, 15, 41, 110],
            [0.10588235294117647, 16, 43, 112],
            [0.10980392156862745, 17, 44, 113],
            [0.11372549019607843, 18, 45, 114],
            [0.11764705882352941, 18, 46, 116],
            [0.12156862745098039, 19, 48, 117],
            [0.12549019607843137, 20, 49, 118],
            [0.12941176470588234, 21, 50, 119],
            [0.13333333333333333, 21, 52, 121],
            [0.13725490196078433, 22, 53, 122],
            [0.1411764705882353, 23, 54, 123],
            [0.14509803921568626, 24, 56, 124],
            [0.14901960784313725, 24, 57, 126],
            [0.15294117647058825, 25, 58, 127],
            [0.1568627450980392, 26, 60, 128],
            [0.16078431372549018, 27, 61, 129],
            [0.16470588235294117, 27, 62, 130],
            [0.16862745098039217, 28, 64, 131],
            [0.17254901960784313, 29, 65, 132],
            [0.1764705882352941, 30, 66, 133],
            [0.1803921568627451, 31, 68, 135],
            [0.1843137254901961, 31, 69, 136],
            [0.18823529411764706, 32, 70, 137],
            [0.19215686274509802, 33, 71, 138],
            [0.19607843137254902, 34, 73, 139],
            [0.2, 35, 74, 139],
            [0.20392156862745098, 36, 75, 140],
            [0.20784313725490194, 37, 76, 141],
            [0.21176470588235294, 37, 78, 142],
            [0.21568627450980393, 38, 79, 143],
            [0.2196078431372549, 39, 80, 144],
            [0.22352941176470587, 40, 81, 145],
            [0.22745098039215686, 41, 83, 145],
            [0.23137254901960785, 42, 84, 146],
            [0.23529411764705882, 43, 85, 147],
            [0.2392156862745098, 44, 86, 148],
            [0.24313725490196078, 45, 87, 148],
            [0.24705882352941178, 46, 89, 149],
            [0.25098039215686274, 47, 90, 150],
            [0.2549019607843137, 47, 91, 150],
            [0.2588235294117647, 48, 92, 151],
            [0.2627450980392157, 49, 93, 151],
            [0.26666666666666666, 50, 94, 152],
            [0.27058823529411763, 51, 95, 152],
            [0.27450980392156865, 52, 96, 153],
            [0.2784313725490196, 53, 97, 153],
            [0.2823529411764706, 54, 98, 154],
            [0.28627450980392155, 55, 100, 154],
            [0.2901960784313725, 56, 101, 154],
            [0.29411764705882354, 57, 102, 155],
            [0.2980392156862745, 58, 103, 155],
            [0.30196078431372547, 59, 104, 155],
            [0.3058823529411765, 60, 105, 155],
            [0.30980392156862746, 61, 106, 156],
            [0.3137254901960784, 62, 107, 156],
            [0.3176470588235294, 63, 107, 156],
            [0.32156862745098036, 64, 108, 156],
            [0.3254901960784314, 65, 109, 156],
            [0.32941176470588235, 66, 110, 156],
            [0.3333333333333333, 67, 111, 157],
            [0.33725490196078434, 68, 112, 157],
            [0.3411764705882353, 69, 113, 157],
            [0.34509803921568627, 70, 114, 157],
            [0.34901960784313724, 71, 115, 157],
            [0.3529411764705882, 72, 115, 157],
            [0.3568627450980392, 73, 116, 157],
            [0.3607843137254902, 74, 117, 157],
            [0.36470588235294116, 74, 118, 156],
            [0.3686274509803922, 75, 119, 156],
            [0.37254901960784315, 76, 119, 156],
            [0.3764705882352941, 77, 120, 156],
            [0.3803921568627451, 78, 121, 156],
            [0.38431372549019605, 79, 122, 156],
            [0.38823529411764707, 80, 122, 156],
            [0.39215686274509803, 81, 123, 155],
            [0.396078431372549, 82, 124, 155],
            [0.4, 83, 125, 155],
            [0.403921568627451, 84, 125, 155],
            [0.40784313725490196, 85, 126, 155],
            [0.4117647058823529, 86, 127, 154],
            [0.4156862745098039, 87, 127, 154],
            [0.4196078431372549, 88, 128, 154],
            [0.4235294117647059, 89, 129, 153],
            [0.42745098039215684, 90, 129, 153],
            [0.43137254901960786, 91, 130, 153],
            [0.43529411764705883, 92, 131, 153],
            [0.4392156862745098, 93, 131, 152],
            [0.44313725490196076, 94, 132, 152],
            [0.44705882352941173, 94, 133, 152],
            [0.45098039215686275, 95, 133, 151],
            [0.4549019607843137, 96, 134, 151],
            [0.4588235294117647, 97, 135, 150],
            [0.4627450980392157, 98, 135, 150],
            [0.4666666666666667, 99, 136, 150],
            [0.47058823529411764, 100, 136, 149],
            [0.4745098039215686, 101, 137, 149],
            [0.4784313725490196, 102, 138, 149],
            [0.4823529411764706, 103, 138, 148],
            [0.48627450980392156, 104, 139, 148],
            [0.49019607843137253, 105, 139, 147],
            [0.49411764705882355, 106, 140, 147],
            [0.4980392156862745, 107, 141, 147],
            [0.5019607843137255, 108, 141, 146],
            [0.5058823529411764, 108, 142, 146],
            [0.5098039215686274, 109, 142, 145],
            [0.5137254901960784, 110, 143, 145],
            [0.5176470588235293, 111, 144, 145],
            [0.5215686274509804, 112, 144, 144],
            [0.5254901960784314, 113, 145, 144],
            [0.5294117647058824, 114, 146, 143],
            [0.5333333333333333, 115, 146, 143],
            [0.5372549019607843, 116, 147, 143],
            [0.5411764705882353, 117, 147, 142],
            [0.5450980392156862, 118, 148, 142],
            [0.5490196078431373, 119, 149, 141],
            [0.5529411764705883, 120, 149, 141],
            [0.5568627450980392, 121, 150, 141],
            [0.5607843137254902, 122, 151, 140],
            [0.5647058823529412, 123, 151, 140],
            [0.5686274509803921, 124, 152, 139],
            [0.5725490196078431, 125, 153, 139],
            [0.5764705882352941, 126, 153, 139],
            [0.580392156862745, 127, 154, 138],
            [0.5843137254901961, 128, 155, 138],
            [0.5882352941176471, 129, 155, 138],
            [0.592156862745098, 130, 156, 137],
            [0.596078431372549, 131, 157, 137],
            [0.6, 132, 158, 137],
            [0.6039215686274509, 133, 158, 137],
            [0.6078431372549019, 134, 159, 136],
            [0.611764705882353, 135, 160, 136],
            [0.615686274509804, 136, 161, 136],
            [0.6196078431372549, 137, 161, 136],
            [0.6235294117647059, 139, 162, 136],
            [0.6274509803921569, 140, 163, 135],
            [0.6313725490196078, 141, 164, 135],
            [0.6352941176470588, 142, 165, 135],
            [0.6392156862745098, 143, 166, 135],
            [0.6431372549019607, 144, 166, 135],
            [0.6470588235294118, 146, 167, 135],
            [0.6509803921568628, 147, 168, 135],
            [0.6549019607843137, 148, 169, 135],
            [0.6588235294117647, 150, 170, 135],
            [0.6627450980392157, 151, 171, 135],
            [0.6666666666666666, 152, 172, 135],
            [0.6705882352941176, 154, 173, 135],
            [0.6745098039215687, 155, 174, 135],
            [0.6784313725490196, 156, 175, 135],
            [0.6823529411764706, 158, 176, 136],
            [0.6862745098039216, 159, 178, 136],
            [0.6901960784313725, 161, 179, 136],
            [0.6941176470588235, 162, 180, 137],
            [0.6980392156862745, 164, 181, 137],
            [0.7019607843137254, 166, 182, 138],
            [0.7058823529411764, 167, 184, 138],
            [0.7098039215686275, 169, 185, 139],
            [0.7137254901960784, 171, 186, 139],
            [0.7176470588235294, 172, 187, 140],
            [0.7215686274509804, 174, 189, 141],
            [0.7254901960784313, 176, 190, 142],
            [0.7294117647058823, 178, 192, 142],
            [0.7333333333333333, 179, 193, 143],
            [0.7372549019607844, 181, 194, 144],
            [0.7411764705882353, 183, 196, 145],
            [0.7450980392156863, 185, 197, 146],
            [0.7490196078431373, 187, 199, 147],
            [0.7529411764705882, 189, 200, 149],
            [0.7568627450980392, 191, 202, 150],
            [0.7607843137254902, 193, 203, 151],
            [0.7647058823529411, 195, 205, 153],
            [0.7686274509803921, 197, 206, 154],
            [0.7725490196078432, 198, 208, 156],
            [0.7764705882352941, 200, 209, 157],
            [0.7803921568627451, 202, 211, 159],
            [0.7843137254901961, 204, 212, 160],
            [0.788235294117647, 206, 214, 162],
            [0.792156862745098, 208, 215, 164],
            [0.796078431372549, 210, 217, 165],
            [0.8, 212, 218, 167],
            [0.803921568627451, 213, 220, 169],
            [0.807843137254902, 215, 221, 171],
            [0.8117647058823529, 217, 222, 173],
            [0.8156862745098039, 219, 224, 174],
            [0.8196078431372549, 220, 225, 176],
            [0.8235294117647058, 222, 226, 178],
            [0.8274509803921568, 223, 228, 180],
            [0.8313725490196078, 225, 229, 182],
            [0.8352941176470589, 226, 230, 184],
            [0.8392156862745098, 228, 231, 186],
            [0.8431372549019608, 229, 232, 188],
            [0.8470588235294118, 231, 233, 190],
            [0.8509803921568627, 232, 234, 191],
            [0.8549019607843137, 233, 235, 193],
            [0.8588235294117647, 234, 236, 195],
            [0.8627450980392157, 235, 237, 197],
            [0.8666666666666667, 236, 238, 199],
            [0.8705882352941177, 238, 239, 201],
            [0.8745098039215686, 239, 240, 203],
            [0.8784313725490196, 239, 241, 204],
            [0.8823529411764706, 240, 241, 206],
            [0.8862745098039215, 241, 242, 208],
            [0.8901960784313725, 242, 243, 210],
            [0.8941176470588235, 243, 243, 211],
            [0.8980392156862745, 244, 244, 213],
            [0.9019607843137255, 244, 245, 215],
            [0.9058823529411765, 245, 245, 217],
            [0.9098039215686274, 246, 246, 218],
            [0.9137254901960784, 246, 246, 220],
            [0.9176470588235294, 247, 247, 222],
            [0.9215686274509803, 247, 247, 223],
            [0.9254901960784314, 248, 248, 225],
            [0.9294117647058824, 248, 248, 227],
            [0.9333333333333333, 249, 249, 228],
            [0.9372549019607843, 249, 249, 230],
            [0.9411764705882353, 250, 249, 231],
            [0.9450980392156862, 250, 250, 233],
            [0.9490196078431372, 250, 250, 234],
            [0.9529411764705882, 251, 250, 236],
            [0.9568627450980391, 251, 251, 238],
            [0.9607843137254902, 251, 251, 239],
            [0.9647058823529412, 252, 251, 241],
            [0.9686274509803922, 252, 252, 242],
            [0.9725490196078431, 252, 252, 244],
            [0.9764705882352941, 253, 252, 245],
            [0.9803921568627451, 253, 253, 247],
            [0.984313725490196, 253, 253, 248],
            [0.9882352941176471, 253, 253, 250],
            [0.9921568627450981, 253, 253, 251],
            [0.996078431372549, 254, 254, 253],
            [1.0, 254, 254, 254],
        ],
    },
    {
        "name": "devon (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 43, 25, 76],
            [0.00392156862745098, 43, 26, 77],
            [0.00784313725490196, 43, 27, 78],
            [0.011764705882352941, 43, 28, 79],
            [0.01568627450980392, 43, 29, 80],
            [0.0196078431372549, 43, 30, 81],
            [0.023529411764705882, 43, 31, 81],
            [0.027450980392156862, 43, 32, 82],
            [0.03137254901960784, 43, 33, 83],
            [0.03529411764705882, 43, 34, 84],
            [0.0392156862745098, 42, 34, 85],
            [0.043137254901960784, 42, 35, 86],
            [0.047058823529411764, 42, 36, 87],
            [0.050980392156862744, 42, 37, 88],
            [0.054901960784313725, 42, 38, 89],
            [0.058823529411764705, 42, 39, 90],
            [0.06274509803921569, 42, 40, 91],
            [0.06666666666666667, 42, 41, 92],
            [0.07058823529411765, 42, 42, 93],
            [0.07450980392156863, 42, 43, 94],
            [0.0784313725490196, 41, 44, 95],
            [0.08235294117647059, 41, 45, 95],
            [0.08627450980392157, 41, 46, 96],
            [0.09019607843137255, 41, 47, 97],
            [0.09411764705882353, 41, 47, 98],
            [0.09803921568627451, 41, 48, 99],
            [0.10196078431372549, 41, 49, 100],
            [0.10588235294117647, 41, 50, 101],
            [0.10980392156862745, 41, 51, 102],
            [0.11372549019607843, 40, 52, 103],
            [0.11764705882352941, 40, 53, 104],
            [0.12156862745098039, 40, 54, 105],
            [0.12549019607843137, 40, 55, 106],
            [0.12941176470588234, 40, 56, 107],
            [0.13333333333333333, 40, 57, 108],
            [0.13725490196078433, 40, 58, 109],
            [0.1411764705882353, 40, 59, 110],
            [0.14509803921568626, 39, 60, 111],
            [0.14901960784313725, 39, 61, 112],
            [0.15294117647058825, 39, 62, 113],
            [0.1568627450980392, 39, 63, 114],
            [0.16078431372549018, 39, 64, 115],
            [0.16470588235294117, 39, 65, 116],
            [0.16862745098039217, 39, 66, 117],
            [0.17254901960784313, 39, 67, 118],
            [0.1764705882352941, 39, 68, 119],
            [0.1803921568627451, 39, 69, 120],
            [0.1843137254901961, 39, 70, 121],
            [0.18823529411764706, 38, 71, 122],
            [0.19215686274509802, 38, 72, 123],
            [0.19607843137254902, 38, 73, 125],
            [0.2, 38, 74, 126],
            [0.20392156862745098, 38, 75, 127],
            [0.20784313725490194, 38, 76, 128],
            [0.21176470588235294, 38, 77, 129],
            [0.21568627450980393, 38, 78, 131],
            [0.2196078431372549, 39, 79, 132],
            [0.22352941176470587, 39, 80, 133],
            [0.22745098039215686, 39, 81, 134],
            [0.23137254901960785, 39, 82, 136],
            [0.23529411764705882, 39, 83, 137],
            [0.2392156862745098, 39, 84, 138],
            [0.24313725490196078, 40, 85, 140],
            [0.24705882352941178, 40, 86, 141],
            [0.25098039215686274, 40, 87, 143],
            [0.2549019607843137, 41, 88, 144],
            [0.2588235294117647, 41, 89, 145],
            [0.2627450980392157, 41, 90, 147],
            [0.26666666666666666, 42, 91, 148],
            [0.27058823529411763, 42, 92, 150],
            [0.27450980392156865, 43, 93, 151],
            [0.2784313725490196, 43, 94, 153],
            [0.2823529411764706, 44, 95, 154],
            [0.28627450980392155, 45, 95, 155],
            [0.2901960784313725, 45, 96, 157],
            [0.29411764705882354, 46, 97, 158],
            [0.2980392156862745, 46, 98, 160],
            [0.30196078431372547, 47, 99, 161],
            [0.3058823529411765, 48, 99, 163],
            [0.30980392156862746, 48, 100, 164],
            [0.3137254901960784, 49, 101, 165],
            [0.3176470588235294, 50, 102, 167],
            [0.32156862745098036, 51, 102, 168],
            [0.3254901960784314, 52, 103, 170],
            [0.32941176470588235, 52, 104, 171],
            [0.3333333333333333, 53, 104, 172],
            [0.33725490196078434, 54, 105, 174],
            [0.3411764705882353, 55, 106, 175],
            [0.34509803921568627, 56, 107, 176],
            [0.34901960784313724, 57, 107, 178],
            [0.3529411764705882, 58, 108, 179],
            [0.3568627450980392, 59, 109, 181],
            [0.3607843137254902, 60, 110, 182],
            [0.36470588235294116, 62, 111, 183],
            [0.3686274509803922, 63, 111, 185],
            [0.37254901960784315, 64, 112, 186],
            [0.3764705882352941, 66, 113, 188],
            [0.3803921568627451, 67, 114, 189],
            [0.38431372549019605, 69, 115, 190],
            [0.38823529411764707, 70, 116, 192],
            [0.39215686274509803, 72, 117, 193],
            [0.396078431372549, 73, 117, 194],
            [0.4, 75, 118, 195],
            [0.403921568627451, 77, 119, 197],
            [0.40784313725490196, 79, 120, 198],
            [0.4117647058823529, 80, 121, 199],
            [0.4156862745098039, 82, 122, 200],
            [0.4196078431372549, 84, 123, 202],
            [0.4235294117647059, 86, 124, 203],
            [0.42745098039215684, 88, 125, 204],
            [0.43137254901960786, 90, 126, 205],
            [0.43529411764705883, 92, 127, 206],
            [0.4392156862745098, 94, 128, 207],
            [0.44313725490196076, 96, 129, 208],
            [0.44705882352941173, 98, 130, 209],
            [0.45098039215686275, 100, 130, 210],
            [0.4549019607843137, 102, 131, 211],
            [0.4588235294117647, 104, 132, 212],
            [0.4627450980392157, 106, 133, 213],
            [0.4666666666666667, 108, 134, 213],
            [0.47058823529411764, 110, 135, 214],
            [0.4745098039215686, 112, 136, 215],
            [0.4784313725490196, 114, 137, 216],
            [0.4823529411764706, 116, 138, 217],
            [0.48627450980392156, 118, 139, 217],
            [0.49019607843137253, 120, 139, 218],
            [0.49411764705882355, 122, 140, 219],
            [0.4980392156862745, 124, 141, 220],
            [0.5019607843137255, 126, 142, 221],
            [0.5058823529411764, 128, 143, 221],
            [0.5098039215686274, 130, 144, 222],
            [0.5137254901960784, 132, 145, 223],
            [0.5176470588235293, 134, 145, 223],
            [0.5215686274509804, 135, 146, 224],
            [0.5254901960784314, 137, 147, 225],
            [0.5294117647058824, 139, 148, 226],
            [0.5333333333333333, 141, 149, 226],
            [0.5372549019607843, 143, 150, 227],
            [0.5411764705882353, 145, 151, 228],
            [0.5450980392156862, 146, 151, 228],
            [0.5490196078431373, 148, 152, 229],
            [0.5529411764705883, 150, 153, 229],
            [0.5568627450980392, 151, 154, 230],
            [0.5607843137254902, 153, 155, 231],
            [0.5647058823529412, 155, 156, 231],
            [0.5686274509803921, 156, 157, 232],
            [0.5725490196078431, 158, 158, 232],
            [0.5764705882352941, 160, 159, 233],
            [0.580392156862745, 161, 159, 233],
            [0.5843137254901961, 162, 160, 234],
            [0.5882352941176471, 164, 161, 234],
            [0.592156862745098, 165, 162, 235],
            [0.596078431372549, 167, 163, 235],
            [0.6, 168, 164, 236],
            [0.6039215686274509, 169, 165, 236],
            [0.6078431372549019, 170, 166, 236],
            [0.611764705882353, 172, 167, 237],
            [0.615686274509804, 173, 168, 237],
            [0.6196078431372549, 174, 169, 237],
            [0.6235294117647059, 175, 169, 238],
            [0.6274509803921569, 176, 170, 238],
            [0.6313725490196078, 177, 171, 238],
            [0.6352941176470588, 178, 172, 238],
            [0.6392156862745098, 179, 173, 239],
            [0.6431372549019607, 180, 174, 239],
            [0.6470588235294118, 181, 175, 239],
            [0.6509803921568628, 182, 176, 239],
            [0.6549019607843137, 183, 176, 240],
            [0.6588235294117647, 183, 177, 240],
            [0.6627450980392157, 184, 178, 240],
            [0.6666666666666666, 185, 179, 240],
            [0.6705882352941176, 186, 180, 240],
            [0.6745098039215687, 187, 181, 241],
            [0.6784313725490196, 188, 182, 241],
            [0.6823529411764706, 188, 182, 241],
            [0.6862745098039216, 189, 183, 241],
            [0.6901960784313725, 190, 184, 241],
            [0.6941176470588235, 191, 185, 241],
            [0.6980392156862745, 192, 186, 242],
            [0.7019607843137254, 192, 187, 242],
            [0.7058823529411764, 193, 188, 242],
            [0.7098039215686275, 194, 188, 242],
            [0.7137254901960784, 195, 189, 242],
            [0.7176470588235294, 195, 190, 242],
            [0.7215686274509804, 196, 191, 243],
            [0.7254901960784313, 197, 192, 243],
            [0.7294117647058823, 198, 193, 243],
            [0.7333333333333333, 199, 194, 243],
            [0.7372549019607844, 199, 194, 243],
            [0.7411764705882353, 200, 195, 243],
            [0.7450980392156863, 201, 196, 244],
            [0.7490196078431373, 202, 197, 244],
            [0.7529411764705882, 203, 198, 244],
            [0.7568627450980392, 203, 199, 244],
            [0.7607843137254902, 204, 200, 244],
            [0.7647058823529411, 205, 201, 244],
            [0.7686274509803921, 206, 201, 244],
            [0.7725490196078432, 207, 202, 245],
            [0.7764705882352941, 207, 203, 245],
            [0.7803921568627451, 208, 204, 245],
            [0.7843137254901961, 209, 205, 245],
            [0.788235294117647, 210, 206, 245],
            [0.792156862745098, 211, 207, 245],
            [0.796078431372549, 211, 208, 246],
            [0.8, 212, 208, 246],
            [0.803921568627451, 213, 209, 246],
            [0.807843137254902, 214, 210, 246],
            [0.8117647058823529, 215, 211, 246],
            [0.8156862745098039, 215, 212, 246],
            [0.8196078431372549, 216, 213, 247],
            [0.8235294117647058, 217, 214, 247],
            [0.8274509803921568, 218, 215, 247],
            [0.8313725490196078, 219, 215, 247],
            [0.8352941176470589, 220, 216, 247],
            [0.8392156862745098, 220, 217, 247],
            [0.8431372549019608, 221, 218, 248],
            [0.8470588235294118, 222, 219, 248],
            [0.8509803921568627, 223, 220, 248],
            [0.8549019607843137, 224, 221, 248],
            [0.8588235294117647, 224, 222, 248],
            [0.8627450980392157, 225, 223, 249],
            [0.8666666666666667, 226, 223, 249],
            [0.8705882352941177, 227, 224, 249],
            [0.8745098039215686, 228, 225, 249],
            [0.8784313725490196, 229, 226, 249],
            [0.8823529411764706, 229, 227, 249],
            [0.8862745098039215, 230, 228, 250],
            [0.8901960784313725, 231, 229, 250],
            [0.8941176470588235, 232, 230, 250],
            [0.8980392156862745, 233, 231, 250],
            [0.9019607843137255, 234, 232, 250],
            [0.9058823529411765, 234, 233, 250],
            [0.9098039215686274, 235, 233, 251],
            [0.9137254901960784, 236, 234, 251],
            [0.9176470588235294, 237, 235, 251],
            [0.9215686274509803, 238, 236, 251],
            [0.9254901960784314, 239, 237, 251],
            [0.9294117647058824, 239, 238, 251],
            [0.9333333333333333, 240, 239, 252],
            [0.9372549019607843, 241, 240, 252],
            [0.9411764705882353, 242, 241, 252],
            [0.9450980392156862, 243, 242, 252],
            [0.9490196078431372, 244, 243, 252],
            [0.9529411764705882, 244, 243, 252],
            [0.9568627450980391, 245, 244, 253],
            [0.9607843137254902, 246, 245, 253],
            [0.9647058823529412, 247, 246, 253],
            [0.9686274509803922, 248, 247, 253],
            [0.9725490196078431, 249, 248, 253],
            [0.9764705882352941, 249, 249, 253],
            [0.9803921568627451, 250, 250, 254],
            [0.984313725490196, 251, 251, 254],
            [0.9882352941176471, 252, 252, 254],
            [0.9921568627450981, 253, 253, 254],
            [0.996078431372549, 254, 254, 254],
            [1.0, 254, 254, 254],
        ],
    },
    {
        "name": "grayC (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 254, 254, 254],
            [0.00392156862745098, 253, 253, 253],
            [0.00784313725490196, 252, 252, 252],
            [0.011764705882352941, 251, 251, 251],
            [0.01568627450980392, 250, 250, 250],
            [0.0196078431372549, 249, 249, 249],
            [0.023529411764705882, 248, 248, 248],
            [0.027450980392156862, 247, 247, 247],
            [0.03137254901960784, 245, 245, 245],
            [0.03529411764705882, 244, 244, 244],
            [0.0392156862745098, 243, 243, 243],
            [0.043137254901960784, 242, 242, 242],
            [0.047058823529411764, 241, 241, 241],
            [0.050980392156862744, 240, 240, 240],
            [0.054901960784313725, 239, 239, 239],
            [0.058823529411764705, 238, 238, 238],
            [0.06274509803921569, 236, 236, 236],
            [0.06666666666666667, 235, 235, 235],
            [0.07058823529411765, 234, 234, 234],
            [0.07450980392156863, 233, 233, 233],
            [0.0784313725490196, 232, 232, 232],
            [0.08235294117647059, 231, 231, 231],
            [0.08627450980392157, 230, 230, 230],
            [0.09019607843137255, 229, 229, 229],
            [0.09411764705882353, 227, 227, 227],
            [0.09803921568627451, 226, 226, 226],
            [0.10196078431372549, 225, 225, 225],
            [0.10588235294117647, 224, 224, 224],
            [0.10980392156862745, 223, 223, 223],
            [0.11372549019607843, 222, 222, 222],
            [0.11764705882352941, 221, 221, 221],
            [0.12156862745098039, 220, 220, 220],
            [0.12549019607843137, 219, 219, 219],
            [0.12941176470588234, 218, 218, 218],
            [0.13333333333333333, 216, 216, 216],
            [0.13725490196078433, 215, 215, 215],
            [0.1411764705882353, 214, 214, 214],
            [0.14509803921568626, 213, 213, 213],
            [0.14901960784313725, 212, 212, 212],
            [0.15294117647058825, 211, 211, 211],
            [0.1568627450980392, 210, 210, 210],
            [0.16078431372549018, 209, 209, 209],
            [0.16470588235294117, 208, 208, 208],
            [0.16862745098039217, 207, 207, 207],
            [0.17254901960784313, 205, 205, 205],
            [0.1764705882352941, 204, 204, 204],
            [0.1803921568627451, 203, 203, 203],
            [0.1843137254901961, 202, 202, 202],
            [0.18823529411764706, 201, 201, 201],
            [0.19215686274509802, 200, 200, 200],
            [0.19607843137254902, 199, 199, 199],
            [0.2, 198, 198, 198],
            [0.20392156862745098, 197, 197, 197],
            [0.20784313725490194, 196, 196, 196],
            [0.21176470588235294, 195, 195, 195],
            [0.21568627450980393, 194, 194, 194],
            [0.2196078431372549, 192, 192, 192],
            [0.22352941176470587, 191, 191, 191],
            [0.22745098039215686, 190, 190, 190],
            [0.23137254901960785, 189, 189, 189],
            [0.23529411764705882, 188, 188, 188],
            [0.2392156862745098, 187, 187, 187],
            [0.24313725490196078, 186, 186, 186],
            [0.24705882352941178, 185, 185, 185],
            [0.25098039215686274, 184, 184, 184],
            [0.2549019607843137, 183, 183, 183],
            [0.2588235294117647, 182, 182, 182],
            [0.2627450980392157, 181, 181, 181],
            [0.26666666666666666, 180, 180, 180],
            [0.27058823529411763, 178, 178, 178],
            [0.27450980392156865, 177, 177, 177],
            [0.2784313725490196, 176, 176, 176],
            [0.2823529411764706, 175, 175, 175],
            [0.28627450980392155, 174, 174, 174],
            [0.2901960784313725, 173, 173, 173],
            [0.29411764705882354, 172, 172, 172],
            [0.2980392156862745, 171, 171, 171],
            [0.30196078431372547, 170, 170, 170],
            [0.3058823529411765, 169, 169, 169],
            [0.30980392156862746, 168, 168, 168],
            [0.3137254901960784, 167, 167, 167],
            [0.3176470588235294, 166, 166, 166],
            [0.32156862745098036, 165, 165, 165],
            [0.3254901960784314, 164, 164, 164],
            [0.32941176470588235, 163, 163, 163],
            [0.3333333333333333, 162, 162, 162],
            [0.33725490196078434, 161, 161, 161],
            [0.3411764705882353, 160, 160, 160],
            [0.34509803921568627, 158, 158, 158],
            [0.34901960784313724, 157, 157, 157],
            [0.3529411764705882, 156, 156, 156],
            [0.3568627450980392, 155, 155, 155],
            [0.3607843137254902, 154, 154, 154],
            [0.36470588235294116, 153, 153, 153],
            [0.3686274509803922, 152, 152, 152],
            [0.37254901960784315, 151, 151, 151],
            [0.3764705882352941, 150, 150, 150],
            [0.3803921568627451, 149, 149, 149],
            [0.38431372549019605, 148, 148, 148],
            [0.38823529411764707, 147, 147, 147],
            [0.39215686274509803, 146, 146, 146],
            [0.396078431372549, 145, 145, 145],
            [0.4, 144, 144, 144],
            [0.403921568627451, 143, 143, 143],
            [0.40784313725490196, 142, 142, 142],
            [0.4117647058823529, 141, 141, 141],
            [0.4156862745098039, 140, 140, 140],
            [0.4196078431372549, 139, 139, 139],
            [0.4235294117647059, 138, 138, 138],
            [0.42745098039215684, 137, 137, 137],
            [0.43137254901960786, 136, 136, 136],
            [0.43529411764705883, 135, 135, 135],
            [0.4392156862745098, 134, 134, 134],
            [0.44313725490196076, 133, 133, 133],
            [0.44705882352941173, 132, 132, 132],
            [0.45098039215686275, 131, 131, 131],
            [0.4549019607843137, 130, 130, 130],
            [0.4588235294117647, 129, 129, 129],
            [0.4627450980392157, 128, 128, 128],
            [0.4666666666666667, 127, 127, 127],
            [0.47058823529411764, 126, 126, 126],
            [0.4745098039215686, 125, 125, 125],
            [0.4784313725490196, 124, 124, 124],
            [0.4823529411764706, 123, 123, 123],
            [0.48627450980392156, 122, 122, 122],
            [0.49019607843137253, 121, 121, 121],
            [0.49411764705882355, 120, 120, 120],
            [0.4980392156862745, 119, 119, 119],
            [0.5019607843137255, 118, 118, 118],
            [0.5058823529411764, 117, 117, 117],
            [0.5098039215686274, 116, 116, 116],
            [0.5137254901960784, 115, 115, 115],
            [0.5176470588235293, 114, 114, 114],
            [0.5215686274509804, 113, 113, 113],
            [0.5254901960784314, 112, 112, 112],
            [0.5294117647058824, 111, 111, 111],
            [0.5333333333333333, 110, 110, 110],
            [0.5372549019607843, 109, 109, 109],
            [0.5411764705882353, 108, 108, 108],
            [0.5450980392156862, 107, 107, 107],
            [0.5490196078431373, 106, 106, 106],
            [0.5529411764705883, 105, 105, 105],
            [0.5568627450980392, 104, 104, 104],
            [0.5607843137254902, 103, 103, 103],
            [0.5647058823529412, 102, 102, 102],
            [0.5686274509803921, 101, 101, 101],
            [0.5725490196078431, 100, 100, 100],
            [0.5764705882352941, 99, 99, 99],
            [0.580392156862745, 98, 98, 98],
            [0.5843137254901961, 98, 98, 98],
            [0.5882352941176471, 97, 97, 97],
            [0.592156862745098, 96, 96, 96],
            [0.596078431372549, 95, 95, 95],
            [0.6, 94, 94, 94],
            [0.6039215686274509, 93, 93, 93],
            [0.6078431372549019, 92, 92, 92],
            [0.611764705882353, 91, 91, 91],
            [0.615686274509804, 90, 90, 90],
            [0.6196078431372549, 89, 89, 89],
            [0.6235294117647059, 88, 88, 88],
            [0.6274509803921569, 87, 87, 87],
            [0.6313725490196078, 86, 86, 86],
            [0.6352941176470588, 85, 85, 85],
            [0.6392156862745098, 84, 84, 84],
            [0.6431372549019607, 83, 83, 83],
            [0.6470588235294118, 82, 82, 82],
            [0.6509803921568628, 82, 82, 82],
            [0.6549019607843137, 81, 81, 81],
            [0.6588235294117647, 80, 80, 80],
            [0.6627450980392157, 79, 79, 79],
            [0.6666666666666666, 78, 78, 78],
            [0.6705882352941176, 77, 77, 77],
            [0.6745098039215687, 76, 76, 76],
            [0.6784313725490196, 75, 75, 75],
            [0.6823529411764706, 74, 74, 74],
            [0.6862745098039216, 73, 73, 73],
            [0.6901960784313725, 72, 72, 72],
            [0.6941176470588235, 71, 71, 71],
            [0.6980392156862745, 71, 71, 71],
            [0.7019607843137254, 70, 70, 70],
            [0.7058823529411764, 69, 69, 69],
            [0.7098039215686275, 68, 68, 68],
            [0.7137254901960784, 67, 67, 67],
            [0.7176470588235294, 66, 66, 66],
            [0.7215686274509804, 65, 65, 65],
            [0.7254901960784313, 64, 64, 64],
            [0.7294117647058823, 63, 63, 63],
            [0.7333333333333333, 63, 63, 63],
            [0.7372549019607844, 62, 62, 62],
            [0.7411764705882353, 61, 61, 61],
            [0.7450980392156863, 60, 60, 60],
            [0.7490196078431373, 59, 59, 59],
            [0.7529411764705882, 58, 58, 58],
            [0.7568627450980392, 57, 57, 57],
            [0.7607843137254902, 56, 56, 56],
            [0.7647058823529411, 56, 56, 56],
            [0.7686274509803921, 55, 55, 55],
            [0.7725490196078432, 54, 54, 54],
            [0.7764705882352941, 53, 53, 53],
            [0.7803921568627451, 52, 52, 52],
            [0.7843137254901961, 51, 51, 51],
            [0.788235294117647, 50, 50, 50],
            [0.792156862745098, 49, 49, 49],
            [0.796078431372549, 49, 49, 49],
            [0.8, 48, 48, 48],
            [0.803921568627451, 47, 47, 47],
            [0.807843137254902, 46, 46, 46],
            [0.8117647058823529, 45, 45, 45],
            [0.8156862745098039, 44, 44, 44],
            [0.8196078431372549, 44, 44, 44],
            [0.8235294117647058, 43, 43, 43],
            [0.8274509803921568, 42, 42, 42],
            [0.8313725490196078, 41, 41, 41],
            [0.8352941176470589, 40, 40, 40],
            [0.8392156862745098, 39, 39, 39],
            [0.8431372549019608, 39, 39, 39],
            [0.8470588235294118, 38, 38, 38],
            [0.8509803921568627, 37, 37, 37],
            [0.8549019607843137, 36, 36, 36],
            [0.8588235294117647, 35, 35, 35],
            [0.8627450980392157, 35, 35, 35],
            [0.8666666666666667, 34, 34, 34],
            [0.8705882352941177, 33, 33, 33],
            [0.8745098039215686, 32, 32, 32],
            [0.8784313725490196, 31, 31, 31],
            [0.8823529411764706, 31, 31, 31],
            [0.8862745098039215, 30, 30, 30],
            [0.8901960784313725, 29, 29, 29],
            [0.8941176470588235, 28, 28, 28],
            [0.8980392156862745, 27, 27, 27],
            [0.9019607843137255, 27, 27, 27],
            [0.9058823529411765, 26, 26, 26],
            [0.9098039215686274, 25, 25, 25],
            [0.9137254901960784, 24, 24, 24],
            [0.9176470588235294, 23, 23, 23],
            [0.9215686274509803, 23, 23, 23],
            [0.9254901960784314, 22, 22, 22],
            [0.9294117647058824, 21, 21, 21],
            [0.9333333333333333, 20, 20, 20],
            [0.9372549019607843, 19, 19, 19],
            [0.9411764705882353, 18, 18, 18],
            [0.9450980392156862, 18, 18, 18],
            [0.9490196078431372, 17, 17, 17],
            [0.9529411764705882, 16, 16, 16],
            [0.9568627450980391, 14, 14, 14],
            [0.9607843137254902, 13, 13, 13],
            [0.9647058823529412, 12, 12, 12],
            [0.9686274509803922, 11, 11, 11],
            [0.9725490196078431, 10, 10, 10],
            [0.9764705882352941, 8, 8, 8],
            [0.9803921568627451, 7, 7, 7],
            [0.984313725490196, 5, 5, 5],
            [0.9882352941176471, 4, 4, 4],
            [0.9921568627450981, 2, 2, 2],
            [0.996078431372549, 1, 1, 1],
            [1.0, 0, 0, 0],
        ],
    },
    {
        "name": "hawaii (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 140, 1, 115],
            [0.00392156862745098, 140, 3, 114],
            [0.00784313725490196, 140, 6, 113],
            [0.011764705882352941, 141, 8, 112],
            [0.01568627450980392, 141, 10, 111],
            [0.0196078431372549, 141, 12, 110],
            [0.023529411764705882, 141, 14, 109],
            [0.027450980392156862, 141, 16, 108],
            [0.03137254901960784, 142, 17, 107],
            [0.03529411764705882, 142, 19, 106],
            [0.0392156862745098, 142, 20, 105],
            [0.043137254901960784, 142, 22, 104],
            [0.047058823529411764, 142, 23, 103],
            [0.050980392156862744, 143, 25, 102],
            [0.054901960784313725, 143, 26, 101],
            [0.058823529411764705, 143, 27, 100],
            [0.06274509803921569, 143, 28, 99],
            [0.06666666666666667, 143, 29, 98],
            [0.07058823529411765, 144, 31, 97],
            [0.07450980392156863, 144, 32, 96],
            [0.0784313725490196, 144, 33, 95],
            [0.08235294117647059, 144, 34, 94],
            [0.08627450980392157, 144, 35, 93],
            [0.09019607843137255, 144, 36, 93],
            [0.09411764705882353, 145, 37, 92],
            [0.09803921568627451, 145, 38, 91],
            [0.10196078431372549, 145, 39, 90],
            [0.10588235294117647, 145, 41, 89],
            [0.10980392156862745, 145, 42, 88],
            [0.11372549019607843, 145, 43, 87],
            [0.11764705882352941, 146, 44, 86],
            [0.12156862745098039, 146, 45, 86],
            [0.12549019607843137, 146, 46, 85],
            [0.12941176470588234, 146, 47, 84],
            [0.13333333333333333, 146, 48, 83],
            [0.13725490196078433, 146, 49, 82],
            [0.1411764705882353, 146, 50, 82],
            [0.14509803921568626, 147, 51, 81],
            [0.14901960784313725, 147, 52, 80],
            [0.15294117647058825, 147, 53, 79],
            [0.1568627450980392, 147, 54, 78],
            [0.16078431372549018, 147, 55, 78],
            [0.16470588235294117, 147, 56, 77],
            [0.16862745098039217, 147, 57, 76],
            [0.17254901960784313, 147, 58, 75],
            [0.1764705882352941, 148, 59, 75],
            [0.1803921568627451, 148, 60, 74],
            [0.1843137254901961, 148, 61, 73],
            [0.18823529411764706, 148, 62, 72],
            [0.19215686274509802, 148, 63, 72],
            [0.19607843137254902, 148, 63, 71],
            [0.2, 148, 64, 70],
            [0.20392156862745098, 149, 65, 70],
            [0.20784313725490194, 149, 66, 69],
            [0.21176470588235294, 149, 67, 68],
            [0.21568627450980393, 149, 68, 67],
            [0.2196078431372549, 149, 69, 67],
            [0.22352941176470587, 149, 70, 66],
            [0.22745098039215686, 149, 71, 65],
            [0.23137254901960785, 149, 72, 65],
            [0.23529411764705882, 150, 73, 64],
            [0.2392156862745098, 150, 74, 63],
            [0.24313725490196078, 150, 75, 63],
            [0.24705882352941178, 150, 76, 62],
            [0.25098039215686274, 150, 77, 61],
            [0.2549019607843137, 150, 78, 60],
            [0.2588235294117647, 150, 79, 60],
            [0.2627450980392157, 150, 80, 59],
            [0.26666666666666666, 151, 81, 58],
            [0.27058823529411763, 151, 82, 58],
            [0.27450980392156865, 151, 83, 57],
            [0.2784313725490196, 151, 84, 56],
            [0.2823529411764706, 151, 85, 56],
            [0.28627450980392155, 151, 86, 55],
            [0.2901960784313725, 151, 87, 54],
            [0.29411764705882354, 152, 88, 54],
            [0.2980392156862745, 152, 89, 53],
            [0.30196078431372547, 152, 90, 52],
            [0.3058823529411765, 152, 91, 52],
            [0.30980392156862746, 152, 92, 51],
            [0.3137254901960784, 152, 93, 50],
            [0.3176470588235294, 152, 94, 50],
            [0.32156862745098036, 152, 95, 49],
            [0.3254901960784314, 153, 96, 48],
            [0.32941176470588235, 153, 97, 48],
            [0.3333333333333333, 153, 98, 47],
            [0.33725490196078434, 153, 99, 46],
            [0.3411764705882353, 153, 100, 46],
            [0.34509803921568627, 153, 101, 45],
            [0.34901960784313724, 153, 102, 44],
            [0.3529411764705882, 154, 104, 44],
            [0.3568627450980392, 154, 105, 43],
            [0.3607843137254902, 154, 106, 42],
            [0.36470588235294116, 154, 107, 42],
            [0.3686274509803922, 154, 108, 41],
            [0.37254901960784315, 154, 109, 40],
            [0.3764705882352941, 154, 110, 40],
            [0.3803921568627451, 154, 111, 39],
            [0.38431372549019605, 155, 112, 39],
            [0.38823529411764707, 155, 113, 38],
            [0.39215686274509803, 155, 115, 37],
            [0.396078431372549, 155, 116, 37],
            [0.4, 155, 117, 36],
            [0.403921568627451, 155, 118, 35],
            [0.40784313725490196, 155, 119, 35],
            [0.4117647058823529, 155, 120, 34],
            [0.4156862745098039, 156, 122, 34],
            [0.4196078431372549, 156, 123, 33],
            [0.4235294117647059, 156, 124, 32],
            [0.42745098039215684, 156, 125, 32],
            [0.43137254901960786, 156, 126, 31],
            [0.43529411764705883, 156, 128, 31],
            [0.4392156862745098, 156, 129, 30],
            [0.44313725490196076, 156, 130, 30],
            [0.44705882352941173, 156, 131, 29],
            [0.45098039215686275, 156, 133, 29],
            [0.4549019607843137, 156, 134, 28],
            [0.4588235294117647, 156, 135, 28],
            [0.4627450980392157, 156, 137, 28],
            [0.4666666666666667, 156, 138, 28],
            [0.47058823529411764, 156, 139, 27],
            [0.4745098039215686, 156, 141, 27],
            [0.4784313725490196, 156, 142, 27],
            [0.4823529411764706, 156, 143, 27],
            [0.48627450980392156, 156, 145, 27],
            [0.49019607843137253, 156, 146, 27],
            [0.49411764705882355, 156, 147, 27],
            [0.4980392156862745, 156, 149, 28],
            [0.5019607843137255, 155, 150, 28],
            [0.5058823529411764, 155, 151, 28],
            [0.5098039215686274, 155, 153, 29],
            [0.5137254901960784, 155, 154, 29],
            [0.5176470588235293, 154, 155, 30],
            [0.5215686274509804, 154, 157, 31],
            [0.5254901960784314, 154, 158, 32],
            [0.5294117647058824, 153, 159, 33],
            [0.5333333333333333, 153, 161, 34],
            [0.5372549019607843, 153, 162, 35],
            [0.5411764705882353, 152, 163, 36],
            [0.5450980392156862, 152, 165, 37],
            [0.5490196078431373, 151, 166, 38],
            [0.5529411764705883, 151, 167, 40],
            [0.5568627450980392, 150, 168, 41],
            [0.5607843137254902, 150, 170, 43],
            [0.5647058823529412, 149, 171, 44],
            [0.5686274509803921, 148, 172, 46],
            [0.5725490196078431, 148, 173, 47],
            [0.5764705882352941, 147, 175, 49],
            [0.580392156862745, 146, 176, 51],
            [0.5843137254901961, 146, 177, 53],
            [0.5882352941176471, 145, 178, 54],
            [0.592156862745098, 144, 179, 56],
            [0.596078431372549, 143, 180, 58],
            [0.6, 142, 181, 60],
            [0.6039215686274509, 142, 182, 62],
            [0.6078431372549019, 141, 183, 64],
            [0.611764705882353, 140, 184, 66],
            [0.615686274509804, 139, 185, 68],
            [0.6196078431372549, 138, 186, 70],
            [0.6235294117647059, 137, 187, 72],
            [0.6274509803921569, 136, 188, 74],
            [0.6313725490196078, 136, 189, 76],
            [0.6352941176470588, 135, 190, 78],
            [0.6392156862745098, 134, 191, 80],
            [0.6431372549019607, 133, 192, 82],
            [0.6470588235294118, 132, 192, 84],
            [0.6509803921568628, 131, 193, 86],
            [0.6549019607843137, 130, 194, 88],
            [0.6588235294117647, 129, 195, 90],
            [0.6627450980392157, 128, 196, 92],
            [0.6666666666666666, 127, 196, 94],
            [0.6705882352941176, 126, 197, 97],
            [0.6745098039215687, 125, 198, 99],
            [0.6784313725490196, 124, 199, 101],
            [0.6823529411764706, 123, 199, 103],
            [0.6862745098039216, 122, 200, 105],
            [0.6901960784313725, 121, 201, 107],
            [0.6941176470588235, 120, 202, 109],
            [0.6980392156862745, 120, 202, 111],
            [0.7019607843137254, 119, 203, 114],
            [0.7058823529411764, 118, 204, 116],
            [0.7098039215686275, 117, 204, 118],
            [0.7137254901960784, 116, 205, 120],
            [0.7176470588235294, 115, 206, 122],
            [0.7215686274509804, 114, 207, 124],
            [0.7254901960784313, 113, 207, 127],
            [0.7294117647058823, 112, 208, 129],
            [0.7333333333333333, 111, 209, 131],
            [0.7372549019607844, 110, 209, 133],
            [0.7411764705882353, 109, 210, 135],
            [0.7450980392156863, 108, 211, 137],
            [0.7490196078431373, 107, 211, 140],
            [0.7529411764705882, 107, 212, 142],
            [0.7568627450980392, 106, 213, 144],
            [0.7607843137254902, 105, 213, 146],
            [0.7647058823529411, 104, 214, 149],
            [0.7686274509803921, 103, 215, 151],
            [0.7725490196078432, 102, 215, 153],
            [0.7764705882352941, 101, 216, 155],
            [0.7803921568627451, 101, 217, 157],
            [0.7843137254901961, 100, 217, 160],
            [0.788235294117647, 99, 218, 162],
            [0.792156862745098, 99, 219, 164],
            [0.796078431372549, 98, 219, 166],
            [0.8, 97, 220, 169],
            [0.803921568627451, 97, 221, 171],
            [0.807843137254902, 96, 221, 173],
            [0.8117647058823529, 96, 222, 175],
            [0.8156862745098039, 95, 223, 178],
            [0.8196078431372549, 95, 223, 180],
            [0.8235294117647058, 95, 224, 182],
            [0.8274509803921568, 95, 225, 184],
            [0.8313725490196078, 95, 225, 187],
            [0.8352941176470589, 95, 226, 189],
            [0.8392156862745098, 95, 226, 191],
            [0.8431372549019608, 95, 227, 193],
            [0.8470588235294118, 95, 228, 195],
            [0.8509803921568627, 96, 228, 198],
            [0.8549019607843137, 96, 229, 200],
            [0.8588235294117647, 97, 230, 202],
            [0.8627450980392157, 98, 230, 204],
            [0.8666666666666667, 99, 231, 206],
            [0.8705882352941177, 100, 231, 208],
            [0.8745098039215686, 101, 232, 210],
            [0.8784313725490196, 102, 232, 212],
            [0.8823529411764706, 104, 233, 214],
            [0.8862745098039215, 105, 234, 216],
            [0.8901960784313725, 107, 234, 218],
            [0.8941176470588235, 109, 235, 220],
            [0.8980392156862745, 111, 235, 222],
            [0.9019607843137255, 113, 235, 224],
            [0.9058823529411765, 115, 236, 225],
            [0.9098039215686274, 117, 236, 227],
            [0.9137254901960784, 119, 237, 229],
            [0.9176470588235294, 122, 237, 230],
            [0.9215686274509803, 124, 237, 232],
            [0.9254901960784314, 127, 238, 233],
            [0.9294117647058824, 129, 238, 235],
            [0.9333333333333333, 132, 238, 236],
            [0.9372549019607843, 135, 239, 237],
            [0.9411764705882353, 137, 239, 239],
            [0.9450980392156862, 140, 239, 240],
            [0.9490196078431372, 143, 240, 241],
            [0.9529411764705882, 146, 240, 242],
            [0.9568627450980391, 148, 240, 243],
            [0.9607843137254902, 151, 240, 244],
            [0.9647058823529412, 154, 240, 245],
            [0.9686274509803922, 157, 241, 246],
            [0.9725490196078431, 160, 241, 247],
            [0.9764705882352941, 162, 241, 248],
            [0.9803921568627451, 165, 241, 249],
            [0.984313725490196, 168, 241, 250],
            [0.9882352941176471, 171, 241, 251],
            [0.9921568627450981, 173, 241, 251],
            [0.996078431372549, 176, 241, 252],
            [1.0, 179, 241, 253],
        ],
    },
    {
        "name": "imola (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 25, 51, 178],
            [0.00392156862745098, 26, 51, 178],
            [0.00784313725490196, 26, 52, 177],
            [0.011764705882352941, 27, 53, 177],
            [0.01568627450980392, 27, 53, 177],
            [0.0196078431372549, 28, 54, 176],
            [0.023529411764705882, 28, 55, 176],
            [0.027450980392156862, 28, 56, 176],
            [0.03137254901960784, 29, 56, 175],
            [0.03529411764705882, 29, 57, 175],
            [0.0392156862745098, 29, 58, 175],
            [0.043137254901960784, 30, 58, 174],
            [0.047058823529411764, 30, 59, 174],
            [0.050980392156862744, 31, 60, 174],
            [0.054901960784313725, 31, 60, 173],
            [0.058823529411764705, 31, 61, 173],
            [0.06274509803921569, 32, 62, 172],
            [0.06666666666666667, 32, 62, 172],
            [0.07058823529411765, 32, 63, 172],
            [0.07450980392156863, 33, 64, 171],
            [0.0784313725490196, 33, 65, 171],
            [0.08235294117647059, 33, 65, 171],
            [0.08627450980392157, 34, 66, 170],
            [0.09019607843137255, 34, 67, 170],
            [0.09411764705882353, 34, 67, 170],
            [0.09803921568627451, 35, 68, 169],
            [0.10196078431372549, 35, 69, 169],
            [0.10588235294117647, 35, 69, 169],
            [0.10980392156862745, 36, 70, 168],
            [0.11372549019607843, 36, 71, 168],
            [0.11764705882352941, 36, 71, 168],
            [0.12156862745098039, 37, 72, 167],
            [0.12549019607843137, 37, 72, 167],
            [0.12941176470588234, 37, 73, 167],
            [0.13333333333333333, 38, 74, 166],
            [0.13725490196078433, 38, 74, 166],
            [0.1411764705882353, 38, 75, 166],
            [0.14509803921568626, 39, 76, 165],
            [0.14901960784313725, 39, 76, 165],
            [0.15294117647058825, 39, 77, 165],
            [0.1568627450980392, 40, 78, 164],
            [0.16078431372549018, 40, 78, 164],
            [0.16470588235294117, 40, 79, 164],
            [0.16862745098039217, 40, 80, 163],
            [0.17254901960784313, 41, 80, 163],
            [0.1764705882352941, 41, 81, 163],
            [0.1803921568627451, 41, 82, 162],
            [0.1843137254901961, 42, 82, 162],
            [0.18823529411764706, 42, 83, 162],
            [0.19215686274509802, 42, 84, 161],
            [0.19607843137254902, 43, 84, 161],
            [0.2, 43, 85, 161],
            [0.20392156862745098, 43, 86, 160],
            [0.20784313725490194, 44, 86, 160],
            [0.21176470588235294, 44, 87, 160],
            [0.21568627450980393, 44, 88, 159],
            [0.2196078431372549, 45, 88, 159],
            [0.22352941176470587, 45, 89, 159],
            [0.22745098039215686, 45, 90, 158],
            [0.23137254901960785, 46, 90, 158],
            [0.23529411764705882, 46, 91, 158],
            [0.2392156862745098, 46, 91, 157],
            [0.24313725490196078, 47, 92, 157],
            [0.24705882352941178, 47, 93, 157],
            [0.25098039215686274, 48, 93, 156],
            [0.2549019607843137, 48, 94, 156],
            [0.2588235294117647, 48, 95, 156],
            [0.2627450980392157, 49, 95, 155],
            [0.26666666666666666, 49, 96, 155],
            [0.27058823529411763, 49, 97, 154],
            [0.27450980392156865, 50, 97, 154],
            [0.2784313725490196, 50, 98, 154],
            [0.2823529411764706, 51, 98, 153],
            [0.28627450980392155, 51, 99, 153],
            [0.2901960784313725, 52, 100, 152],
            [0.29411764705882354, 52, 100, 152],
            [0.2980392156862745, 52, 101, 152],
            [0.30196078431372547, 53, 101, 151],
            [0.3058823529411765, 53, 102, 151],
            [0.30980392156862746, 54, 103, 150],
            [0.3137254901960784, 54, 103, 150],
            [0.3176470588235294, 55, 104, 149],
            [0.32156862745098036, 55, 104, 149],
            [0.3254901960784314, 56, 105, 148],
            [0.32941176470588235, 56, 106, 148],
            [0.3333333333333333, 57, 106, 147],
            [0.33725490196078434, 57, 107, 147],
            [0.3411764705882353, 58, 107, 146],
            [0.34509803921568627, 58, 108, 146],
            [0.34901960784313724, 59, 109, 145],
            [0.3529411764705882, 59, 109, 145],
            [0.3568627450980392, 60, 110, 144],
            [0.3607843137254902, 60, 110, 144],
            [0.36470588235294116, 61, 111, 143],
            [0.3686274509803922, 61, 111, 143],
            [0.37254901960784315, 62, 112, 142],
            [0.3764705882352941, 63, 112, 141],
            [0.3803921568627451, 63, 113, 141],
            [0.38431372549019605, 64, 114, 140],
            [0.38823529411764707, 64, 114, 140],
            [0.39215686274509803, 65, 115, 139],
            [0.396078431372549, 65, 115, 139],
            [0.4, 66, 116, 138],
            [0.403921568627451, 66, 117, 138],
            [0.40784313725490196, 67, 117, 137],
            [0.4117647058823529, 68, 118, 137],
            [0.4156862745098039, 68, 118, 136],
            [0.4196078431372549, 69, 119, 136],
            [0.4235294117647059, 69, 120, 135],
            [0.42745098039215684, 70, 120, 135],
            [0.43137254901960786, 71, 121, 134],
            [0.43529411764705883, 71, 121, 134],
            [0.4392156862745098, 72, 122, 133],
            [0.44313725490196076, 72, 123, 133],
            [0.44705882352941173, 73, 123, 132],
            [0.45098039215686275, 74, 124, 132],
            [0.4549019607843137, 74, 125, 131],
            [0.4588235294117647, 75, 125, 131],
            [0.4627450980392157, 76, 126, 130],
            [0.4666666666666667, 77, 127, 130],
            [0.47058823529411764, 77, 128, 129],
            [0.4745098039215686, 78, 128, 129],
            [0.4784313725490196, 79, 129, 129],
            [0.4823529411764706, 79, 130, 128],
            [0.48627450980392156, 80, 131, 128],
            [0.49019607843137253, 81, 131, 127],
            [0.49411764705882355, 82, 132, 127],
            [0.4980392156862745, 83, 133, 127],
            [0.5019607843137255, 83, 134, 126],
            [0.5058823529411764, 84, 135, 126],
            [0.5098039215686274, 85, 135, 126],
            [0.5137254901960784, 86, 136, 125],
            [0.5176470588235293, 87, 137, 125],
            [0.5215686274509804, 88, 138, 125],
            [0.5254901960784314, 88, 139, 125],
            [0.5294117647058824, 89, 140, 124],
            [0.5333333333333333, 90, 141, 124],
            [0.5372549019607843, 91, 141, 124],
            [0.5411764705882353, 92, 142, 123],
            [0.5450980392156862, 93, 143, 123],
            [0.5490196078431373, 94, 144, 123],
            [0.5529411764705883, 95, 145, 123],
            [0.5568627450980392, 96, 146, 122],
            [0.5607843137254902, 96, 147, 122],
            [0.5647058823529412, 97, 148, 122],
            [0.5686274509803921, 98, 149, 122],
            [0.5725490196078431, 99, 150, 121],
            [0.5764705882352941, 100, 151, 121],
            [0.580392156862745, 101, 152, 121],
            [0.5843137254901961, 102, 153, 121],
            [0.5882352941176471, 103, 153, 121],
            [0.592156862745098, 104, 154, 120],
            [0.596078431372549, 105, 155, 120],
            [0.6, 106, 156, 120],
            [0.6039215686274509, 107, 157, 120],
            [0.6078431372549019, 108, 158, 119],
            [0.611764705882353, 109, 159, 119],
            [0.615686274509804, 110, 160, 119],
            [0.6196078431372549, 111, 161, 119],
            [0.6235294117647059, 112, 162, 118],
            [0.6274509803921569, 113, 163, 118],
            [0.6313725490196078, 114, 164, 118],
            [0.6352941176470588, 115, 165, 118],
            [0.6392156862745098, 115, 166, 117],
            [0.6431372549019607, 116, 167, 117],
            [0.6470588235294118, 117, 168, 117],
            [0.6509803921568628, 118, 169, 117],
            [0.6549019607843137, 119, 170, 116],
            [0.6588235294117647, 120, 171, 116],
            [0.6627450980392157, 121, 172, 116],
            [0.6666666666666666, 122, 173, 116],
            [0.6705882352941176, 123, 174, 115],
            [0.6745098039215687, 124, 175, 115],
            [0.6784313725490196, 125, 176, 115],
            [0.6823529411764706, 126, 177, 115],
            [0.6862745098039216, 127, 178, 114],
            [0.6901960784313725, 128, 179, 114],
            [0.6941176470588235, 130, 180, 114],
            [0.6980392156862745, 131, 181, 114],
            [0.7019607843137254, 132, 182, 113],
            [0.7058823529411764, 133, 183, 113],
            [0.7098039215686275, 134, 184, 113],
            [0.7137254901960784, 135, 185, 113],
            [0.7176470588235294, 136, 186, 112],
            [0.7215686274509804, 137, 187, 112],
            [0.7254901960784313, 138, 189, 112],
            [0.7294117647058823, 139, 190, 112],
            [0.7333333333333333, 140, 191, 111],
            [0.7372549019607844, 141, 192, 111],
            [0.7411764705882353, 142, 193, 111],
            [0.7450980392156863, 143, 194, 111],
            [0.7490196078431373, 144, 195, 110],
            [0.7529411764705882, 145, 196, 110],
            [0.7568627450980392, 146, 197, 110],
            [0.7607843137254902, 147, 198, 109],
            [0.7647058823529411, 148, 199, 109],
            [0.7686274509803921, 150, 200, 109],
            [0.7725490196078432, 151, 201, 109],
            [0.7764705882352941, 152, 202, 108],
            [0.7803921568627451, 153, 204, 108],
            [0.7843137254901961, 154, 205, 108],
            [0.788235294117647, 155, 206, 108],
            [0.792156862745098, 156, 207, 107],
            [0.796078431372549, 158, 208, 107],
            [0.8, 159, 209, 107],
            [0.803921568627451, 160, 210, 107],
            [0.807843137254902, 161, 211, 106],
            [0.8117647058823529, 163, 212, 106],
            [0.8156862745098039, 164, 213, 106],
            [0.8196078431372549, 165, 215, 106],
            [0.8235294117647058, 167, 216, 105],
            [0.8274509803921568, 168, 217, 105],
            [0.8313725490196078, 170, 218, 105],
            [0.8352941176470589, 171, 219, 105],
            [0.8392156862745098, 173, 220, 104],
            [0.8431372549019608, 174, 221, 104],
            [0.8470588235294118, 176, 222, 104],
            [0.8509803921568627, 177, 223, 104],
            [0.8549019607843137, 179, 224, 104],
            [0.8588235294117647, 181, 225, 103],
            [0.8627450980392157, 183, 226, 103],
            [0.8666666666666667, 184, 227, 103],
            [0.8705882352941177, 186, 228, 103],
            [0.8745098039215686, 188, 229, 103],
            [0.8784313725490196, 190, 230, 103],
            [0.8823529411764706, 192, 231, 103],
            [0.8862745098039215, 194, 232, 102],
            [0.8901960784313725, 196, 233, 102],
            [0.8941176470588235, 198, 234, 102],
            [0.8980392156862745, 200, 235, 102],
            [0.9019607843137255, 202, 236, 102],
            [0.9058823529411765, 204, 237, 102],
            [0.9098039215686274, 206, 237, 102],
            [0.9137254901960784, 208, 238, 102],
            [0.9176470588235294, 210, 239, 102],
            [0.9215686274509803, 212, 240, 102],
            [0.9254901960784314, 214, 241, 102],
            [0.9294117647058824, 217, 241, 102],
            [0.9333333333333333, 219, 242, 102],
            [0.9372549019607843, 221, 243, 102],
            [0.9411764705882353, 223, 244, 102],
            [0.9450980392156862, 225, 245, 102],
            [0.9490196078431372, 227, 245, 102],
            [0.9529411764705882, 229, 246, 102],
            [0.9568627450980391, 231, 247, 102],
            [0.9607843137254902, 233, 247, 102],
            [0.9647058823529412, 236, 248, 102],
            [0.9686274509803922, 238, 249, 102],
            [0.9725490196078431, 240, 250, 102],
            [0.9764705882352941, 242, 250, 102],
            [0.9803921568627451, 244, 251, 102],
            [0.984313725490196, 246, 252, 102],
            [0.9882352941176471, 248, 252, 102],
            [0.9921568627450981, 250, 253, 102],
            [0.996078431372549, 252, 254, 102],
            [1.0, 255, 254, 102],
        ],
    },
    {
        "name": "lajolla (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 254, 254, 203],
            [0.00392156862745098, 254, 254, 202],
            [0.00784313725490196, 254, 253, 200],
            [0.011764705882352941, 254, 253, 198],
            [0.01568627450980392, 254, 252, 196],
            [0.0196078431372549, 254, 251, 195],
            [0.023529411764705882, 254, 251, 193],
            [0.027450980392156862, 254, 250, 191],
            [0.03137254901960784, 254, 249, 189],
            [0.03529411764705882, 254, 249, 187],
            [0.0392156862745098, 253, 248, 186],
            [0.043137254901960784, 253, 247, 184],
            [0.047058823529411764, 253, 247, 182],
            [0.050980392156862744, 253, 246, 180],
            [0.054901960784313725, 253, 245, 178],
            [0.058823529411764705, 253, 245, 177],
            [0.06274509803921569, 253, 244, 175],
            [0.06666666666666667, 253, 243, 173],
            [0.07058823529411765, 252, 243, 171],
            [0.07450980392156863, 252, 242, 170],
            [0.0784313725490196, 252, 241, 168],
            [0.08235294117647059, 252, 241, 166],
            [0.08627450980392157, 252, 240, 164],
            [0.09019607843137255, 252, 239, 162],
            [0.09411764705882353, 252, 239, 160],
            [0.09803921568627451, 251, 238, 159],
            [0.10196078431372549, 251, 237, 157],
            [0.10588235294117647, 251, 236, 155],
            [0.10980392156862745, 251, 235, 153],
            [0.11372549019607843, 251, 235, 151],
            [0.11764705882352941, 250, 234, 150],
            [0.12156862745098039, 250, 233, 148],
            [0.12549019607843137, 250, 232, 146],
            [0.12941176470588234, 250, 231, 144],
            [0.13333333333333333, 250, 230, 142],
            [0.13725490196078433, 249, 230, 140],
            [0.1411764705882353, 249, 229, 138],
            [0.14509803921568626, 249, 228, 137],
            [0.14901960784313725, 249, 227, 135],
            [0.15294117647058825, 249, 226, 133],
            [0.1568627450980392, 248, 225, 131],
            [0.16078431372549018, 248, 224, 129],
            [0.16470588235294117, 248, 223, 127],
            [0.16862745098039217, 248, 221, 126],
            [0.17254901960784313, 247, 220, 124],
            [0.1764705882352941, 247, 219, 122],
            [0.1803921568627451, 247, 218, 120],
            [0.1843137254901961, 247, 217, 119],
            [0.18823529411764706, 246, 216, 117],
            [0.19215686274509802, 246, 214, 115],
            [0.19607843137254902, 246, 213, 114],
            [0.2, 245, 212, 112],
            [0.20392156862745098, 245, 211, 110],
            [0.20784313725490194, 245, 209, 109],
            [0.21176470588235294, 244, 208, 107],
            [0.21568627450980393, 244, 207, 106],
            [0.2196078431372549, 244, 205, 105],
            [0.22352941176470587, 243, 204, 103],
            [0.22745098039215686, 243, 202, 102],
            [0.23137254901960785, 243, 201, 101],
            [0.23529411764705882, 243, 200, 99],
            [0.2392156862745098, 242, 198, 98],
            [0.24313725490196078, 242, 197, 97],
            [0.24705882352941178, 242, 196, 96],
            [0.25098039215686274, 241, 194, 95],
            [0.2549019607843137, 241, 193, 94],
            [0.2588235294117647, 241, 191, 93],
            [0.2627450980392157, 240, 190, 92],
            [0.26666666666666666, 240, 189, 92],
            [0.27058823529411763, 240, 187, 91],
            [0.27450980392156865, 239, 186, 90],
            [0.2784313725490196, 239, 185, 90],
            [0.2823529411764706, 239, 183, 89],
            [0.28627450980392155, 239, 182, 88],
            [0.2901960784313725, 238, 181, 88],
            [0.29411764705882354, 238, 180, 87],
            [0.2980392156862745, 238, 178, 87],
            [0.30196078431372547, 237, 177, 87],
            [0.3058823529411765, 237, 176, 86],
            [0.30980392156862746, 237, 175, 86],
            [0.3137254901960784, 237, 173, 85],
            [0.3176470588235294, 236, 172, 85],
            [0.32156862745098036, 236, 171, 85],
            [0.3254901960784314, 236, 170, 85],
            [0.32941176470588235, 236, 168, 84],
            [0.3333333333333333, 235, 167, 84],
            [0.33725490196078434, 235, 166, 84],
            [0.3411764705882353, 235, 165, 84],
            [0.34509803921568627, 235, 164, 83],
            [0.34901960784313724, 234, 162, 83],
            [0.3529411764705882, 234, 161, 83],
            [0.3568627450980392, 234, 160, 83],
            [0.3607843137254902, 234, 159, 83],
            [0.36470588235294116, 233, 158, 83],
            [0.3686274509803922, 233, 157, 82],
            [0.37254901960784315, 233, 155, 82],
            [0.3764705882352941, 233, 154, 82],
            [0.3803921568627451, 232, 153, 82],
            [0.38431372549019605, 232, 152, 82],
            [0.38823529411764707, 232, 151, 82],
            [0.39215686274509803, 232, 150, 82],
            [0.396078431372549, 231, 148, 82],
            [0.4, 231, 147, 82],
            [0.403921568627451, 231, 146, 81],
            [0.40784313725490196, 230, 145, 81],
            [0.4117647058823529, 230, 144, 81],
            [0.4156862745098039, 230, 143, 81],
            [0.4196078431372549, 230, 141, 81],
            [0.4235294117647059, 229, 140, 81],
            [0.42745098039215684, 229, 139, 81],
            [0.43137254901960786, 229, 138, 81],
            [0.43529411764705883, 228, 137, 81],
            [0.4392156862745098, 228, 135, 81],
            [0.44313725490196076, 228, 134, 80],
            [0.44705882352941173, 228, 133, 80],
            [0.45098039215686275, 227, 132, 80],
            [0.4549019607843137, 227, 131, 80],
            [0.4588235294117647, 226, 129, 80],
            [0.4627450980392157, 226, 128, 80],
            [0.4666666666666667, 226, 127, 80],
            [0.47058823529411764, 225, 126, 80],
            [0.4745098039215686, 225, 125, 80],
            [0.4784313725490196, 224, 123, 79],
            [0.4823529411764706, 224, 122, 79],
            [0.48627450980392156, 223, 121, 79],
            [0.49019607843137253, 223, 120, 79],
            [0.49411764705882355, 222, 118, 79],
            [0.4980392156862745, 222, 117, 79],
            [0.5019607843137255, 221, 116, 79],
            [0.5058823529411764, 221, 114, 79],
            [0.5098039215686274, 220, 113, 78],
            [0.5137254901960784, 219, 112, 78],
            [0.5176470588235293, 219, 111, 78],
            [0.5215686274509804, 218, 109, 78],
            [0.5254901960784314, 217, 108, 78],
            [0.5294117647058824, 216, 107, 78],
            [0.5333333333333333, 215, 105, 77],
            [0.5372549019607843, 214, 104, 77],
            [0.5411764705882353, 213, 103, 77],
            [0.5450980392156862, 212, 101, 77],
            [0.5490196078431373, 211, 100, 77],
            [0.5529411764705883, 210, 99, 76],
            [0.5568627450980392, 209, 98, 76],
            [0.5607843137254902, 208, 96, 76],
            [0.5647058823529412, 207, 95, 76],
            [0.5686274509803921, 205, 94, 75],
            [0.5725490196078431, 204, 92, 75],
            [0.5764705882352941, 203, 91, 75],
            [0.580392156862745, 201, 90, 75],
            [0.5843137254901961, 200, 89, 74],
            [0.5882352941176471, 198, 88, 74],
            [0.592156862745098, 197, 87, 74],
            [0.596078431372549, 195, 85, 73],
            [0.6, 194, 84, 73],
            [0.6039215686274509, 192, 83, 73],
            [0.6078431372549019, 190, 82, 72],
            [0.611764705882353, 189, 81, 72],
            [0.615686274509804, 187, 80, 72],
            [0.6196078431372549, 185, 79, 71],
            [0.6235294117647059, 184, 79, 71],
            [0.6274509803921569, 182, 78, 70],
            [0.6313725490196078, 180, 77, 70],
            [0.6352941176470588, 178, 76, 70],
            [0.6392156862745098, 177, 75, 69],
            [0.6431372549019607, 175, 74, 69],
            [0.6470588235294118, 173, 74, 68],
            [0.6509803921568628, 171, 73, 68],
            [0.6549019607843137, 170, 72, 67],
            [0.6588235294117647, 168, 72, 67],
            [0.6627450980392157, 166, 71, 66],
            [0.6666666666666666, 164, 70, 66],
            [0.6705882352941176, 162, 70, 65],
            [0.6745098039215687, 161, 69, 65],
            [0.6784313725490196, 159, 69, 64],
            [0.6823529411764706, 157, 68, 63],
            [0.6862745098039216, 155, 67, 63],
            [0.6901960784313725, 153, 67, 62],
            [0.6941176470588235, 152, 66, 62],
            [0.6980392156862745, 150, 66, 61],
            [0.7019607843137254, 148, 65, 60],
            [0.7058823529411764, 146, 65, 60],
            [0.7098039215686275, 144, 64, 59],
            [0.7137254901960784, 143, 64, 58],
            [0.7176470588235294, 141, 63, 58],
            [0.7215686274509804, 139, 63, 57],
            [0.7254901960784313, 137, 62, 56],
            [0.7294117647058823, 135, 62, 56],
            [0.7333333333333333, 134, 61, 55],
            [0.7372549019607844, 132, 61, 54],
            [0.7411764705882353, 130, 60, 53],
            [0.7450980392156863, 128, 59, 53],
            [0.7490196078431373, 127, 59, 52],
            [0.7529411764705882, 125, 58, 51],
            [0.7568627450980392, 123, 58, 50],
            [0.7607843137254902, 121, 57, 50],
            [0.7647058823529411, 119, 57, 49],
            [0.7686274509803921, 118, 56, 48],
            [0.7725490196078432, 116, 56, 47],
            [0.7764705882352941, 114, 55, 46],
            [0.7803921568627451, 112, 55, 46],
            [0.7843137254901961, 111, 54, 45],
            [0.788235294117647, 109, 54, 44],
            [0.792156862745098, 107, 53, 43],
            [0.796078431372549, 106, 53, 42],
            [0.8, 104, 52, 42],
            [0.803921568627451, 102, 52, 41],
            [0.807843137254902, 100, 51, 40],
            [0.8117647058823529, 99, 50, 39],
            [0.8156862745098039, 97, 50, 38],
            [0.8196078431372549, 95, 49, 38],
            [0.8235294117647058, 94, 49, 37],
            [0.8274509803921568, 92, 48, 36],
            [0.8313725490196078, 90, 48, 35],
            [0.8352941176470589, 89, 47, 34],
            [0.8392156862745098, 87, 47, 33],
            [0.8431372549019608, 85, 46, 33],
            [0.8470588235294118, 84, 46, 32],
            [0.8509803921568627, 82, 45, 31],
            [0.8549019607843137, 80, 45, 30],
            [0.8588235294117647, 79, 44, 30],
            [0.8627450980392157, 77, 43, 29],
            [0.8666666666666667, 75, 43, 28],
            [0.8705882352941177, 74, 42, 27],
            [0.8745098039215686, 72, 42, 27],
            [0.8784313725490196, 71, 41, 26],
            [0.8823529411764706, 69, 41, 25],
            [0.8862745098039215, 67, 40, 24],
            [0.8901960784313725, 66, 40, 24],
            [0.8941176470588235, 64, 39, 23],
            [0.8980392156862745, 63, 39, 22],
            [0.9019607843137255, 61, 38, 22],
            [0.9058823529411765, 59, 38, 21],
            [0.9098039215686274, 58, 37, 20],
            [0.9137254901960784, 56, 37, 20],
            [0.9176470588235294, 55, 36, 19],
            [0.9215686274509803, 53, 36, 18],
            [0.9254901960784314, 52, 35, 18],
            [0.9294117647058824, 50, 35, 17],
            [0.9333333333333333, 49, 34, 16],
            [0.9372549019607843, 47, 34, 15],
            [0.9411764705882353, 46, 33, 15],
            [0.9450980392156862, 44, 33, 14],
            [0.9490196078431372, 43, 32, 13],
            [0.9529411764705882, 41, 31, 12],
            [0.9568627450980391, 40, 31, 11],
            [0.9607843137254902, 39, 30, 10],
            [0.9647058823529412, 37, 30, 9],
            [0.9686274509803922, 36, 29, 8],
            [0.9725490196078431, 34, 29, 7],
            [0.9764705882352941, 33, 28, 6],
            [0.9803921568627451, 32, 28, 5],
            [0.984313725490196, 30, 27, 4],
            [0.9882352941176471, 29, 27, 3],
            [0.9921568627450981, 28, 26, 2],
            [0.996078431372549, 26, 26, 1],
            [1.0, 25, 25, 0],
        ],
    },
    {
        "name": "lapaz (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 26, 12, 100],
            [0.00392156862745098, 26, 13, 101],
            [0.00784313725490196, 27, 15, 101],
            [0.011764705882352941, 27, 16, 102],
            [0.01568627450980392, 27, 17, 103],
            [0.0196078431372549, 28, 19, 104],
            [0.023529411764705882, 28, 20, 105],
            [0.027450980392156862, 28, 21, 106],
            [0.03137254901960784, 29, 22, 106],
            [0.03529411764705882, 29, 24, 107],
            [0.0392156862745098, 29, 25, 108],
            [0.043137254901960784, 30, 26, 109],
            [0.047058823529411764, 30, 27, 110],
            [0.050980392156862744, 30, 28, 110],
            [0.054901960784313725, 30, 29, 111],
            [0.058823529411764705, 31, 31, 112],
            [0.06274509803921569, 31, 32, 113],
            [0.06666666666666667, 31, 33, 114],
            [0.07058823529411765, 32, 34, 115],
            [0.07450980392156863, 32, 35, 115],
            [0.0784313725490196, 32, 36, 116],
            [0.08235294117647059, 32, 37, 117],
            [0.08627450980392157, 33, 38, 118],
            [0.09019607843137255, 33, 40, 118],
            [0.09411764705882353, 33, 41, 119],
            [0.09803921568627451, 33, 42, 120],
            [0.10196078431372549, 34, 43, 121],
            [0.10588235294117647, 34, 44, 122],
            [0.10980392156862745, 34, 45, 122],
            [0.11372549019607843, 34, 46, 123],
            [0.11764705882352941, 35, 47, 124],
            [0.12156862745098039, 35, 48, 125],
            [0.12549019607843137, 35, 49, 125],
            [0.12941176470588234, 35, 50, 126],
            [0.13333333333333333, 36, 51, 127],
            [0.13725490196078433, 36, 52, 128],
            [0.1411764705882353, 36, 53, 128],
            [0.14509803921568626, 36, 55, 129],
            [0.14901960784313725, 37, 56, 130],
            [0.15294117647058825, 37, 57, 131],
            [0.1568627450980392, 37, 58, 131],
            [0.16078431372549018, 37, 59, 132],
            [0.16470588235294117, 38, 60, 133],
            [0.16862745098039217, 38, 61, 133],
            [0.17254901960784313, 38, 62, 134],
            [0.1764705882352941, 38, 63, 135],
            [0.1803921568627451, 39, 64, 135],
            [0.1843137254901961, 39, 65, 136],
            [0.18823529411764706, 39, 66, 137],
            [0.19215686274509802, 39, 67, 137],
            [0.19607843137254902, 40, 68, 138],
            [0.2, 40, 69, 139],
            [0.20392156862745098, 40, 70, 139],
            [0.20784313725490194, 41, 71, 140],
            [0.21176470588235294, 41, 72, 141],
            [0.21568627450980393, 41, 73, 141],
            [0.2196078431372549, 41, 74, 142],
            [0.22352941176470587, 42, 75, 142],
            [0.22745098039215686, 42, 76, 143],
            [0.23137254901960785, 42, 77, 144],
            [0.23529411764705882, 43, 78, 144],
            [0.2392156862745098, 43, 79, 145],
            [0.24313725490196078, 43, 80, 145],
            [0.24705882352941178, 44, 81, 146],
            [0.25098039215686274, 44, 82, 146],
            [0.2549019607843137, 44, 83, 147],
            [0.2588235294117647, 45, 84, 148],
            [0.2627450980392157, 45, 85, 148],
            [0.26666666666666666, 46, 86, 149],
            [0.27058823529411763, 46, 87, 149],
            [0.27450980392156865, 46, 88, 150],
            [0.2784313725490196, 47, 89, 150],
            [0.2823529411764706, 47, 90, 151],
            [0.28627450980392155, 48, 91, 151],
            [0.2901960784313725, 48, 92, 152],
            [0.29411764705882354, 48, 93, 152],
            [0.2980392156862745, 49, 94, 153],
            [0.30196078431372547, 49, 95, 153],
            [0.3058823529411765, 50, 96, 153],
            [0.30980392156862746, 50, 97, 154],
            [0.3137254901960784, 51, 98, 154],
            [0.3176470588235294, 51, 99, 155],
            [0.32156862745098036, 52, 100, 155],
            [0.3254901960784314, 52, 101, 155],
            [0.32941176470588235, 53, 102, 156],
            [0.3333333333333333, 53, 103, 156],
            [0.33725490196078434, 54, 104, 157],
            [0.3411764705882353, 55, 105, 157],
            [0.34509803921568627, 55, 105, 157],
            [0.34901960784313724, 56, 106, 158],
            [0.3529411764705882, 56, 107, 158],
            [0.3568627450980392, 57, 108, 158],
            [0.3607843137254902, 58, 109, 159],
            [0.36470588235294116, 58, 110, 159],
            [0.3686274509803922, 59, 111, 159],
            [0.37254901960784315, 60, 112, 160],
            [0.3764705882352941, 61, 113, 160],
            [0.3803921568627451, 61, 114, 160],
            [0.38431372549019605, 62, 115, 160],
            [0.38823529411764707, 63, 116, 161],
            [0.39215686274509803, 64, 117, 161],
            [0.396078431372549, 64, 117, 161],
            [0.4, 65, 118, 161],
            [0.403921568627451, 66, 119, 161],
            [0.40784313725490196, 67, 120, 162],
            [0.4117647058823529, 68, 121, 162],
            [0.4156862745098039, 69, 122, 162],
            [0.4196078431372549, 69, 123, 162],
            [0.4235294117647059, 70, 124, 162],
            [0.42745098039215684, 71, 124, 162],
            [0.43137254901960786, 72, 125, 163],
            [0.43529411764705883, 73, 126, 163],
            [0.4392156862745098, 74, 127, 163],
            [0.44313725490196076, 75, 128, 163],
            [0.44705882352941173, 76, 129, 163],
            [0.45098039215686275, 77, 130, 163],
            [0.4549019607843137, 78, 130, 163],
            [0.4588235294117647, 79, 131, 163],
            [0.4627450980392157, 80, 132, 163],
            [0.4666666666666667, 81, 133, 163],
            [0.47058823529411764, 82, 134, 163],
            [0.4745098039215686, 83, 134, 163],
            [0.4784313725490196, 85, 135, 163],
            [0.4823529411764706, 86, 136, 163],
            [0.48627450980392156, 87, 137, 163],
            [0.49019607843137253, 88, 137, 163],
            [0.49411764705882355, 89, 138, 163],
            [0.4980392156862745, 90, 139, 163],
            [0.5019607843137255, 92, 140, 163],
            [0.5058823529411764, 93, 140, 163],
            [0.5098039215686274, 94, 141, 163],
            [0.5137254901960784, 95, 142, 162],
            [0.5176470588235293, 96, 143, 162],
            [0.5215686274509804, 98, 143, 162],
            [0.5254901960784314, 99, 144, 162],
            [0.5294117647058824, 100, 145, 162],
            [0.5333333333333333, 101, 145, 162],
            [0.5372549019607843, 103, 146, 161],
            [0.5411764705882353, 104, 147, 161],
            [0.5450980392156862, 105, 147, 161],
            [0.5490196078431373, 107, 148, 161],
            [0.5529411764705883, 108, 148, 161],
            [0.5568627450980392, 109, 149, 160],
            [0.5607843137254902, 111, 150, 160],
            [0.5647058823529412, 112, 150, 160],
            [0.5686274509803921, 113, 151, 159],
            [0.5725490196078431, 114, 151, 159],
            [0.5764705882352941, 116, 152, 159],
            [0.580392156862745, 117, 152, 159],
            [0.5843137254901961, 118, 153, 158],
            [0.5882352941176471, 120, 153, 158],
            [0.592156862745098, 121, 154, 158],
            [0.596078431372549, 123, 154, 157],
            [0.6, 124, 155, 157],
            [0.6039215686274509, 125, 155, 157],
            [0.6078431372549019, 127, 156, 156],
            [0.611764705882353, 128, 156, 156],
            [0.615686274509804, 129, 157, 156],
            [0.6196078431372549, 131, 157, 155],
            [0.6235294117647059, 132, 158, 155],
            [0.6274509803921569, 133, 158, 155],
            [0.6313725490196078, 135, 158, 154],
            [0.6352941176470588, 136, 159, 154],
            [0.6392156862745098, 138, 159, 154],
            [0.6431372549019607, 139, 160, 153],
            [0.6470588235294118, 140, 160, 153],
            [0.6509803921568628, 142, 160, 153],
            [0.6549019607843137, 143, 161, 152],
            [0.6588235294117647, 144, 161, 152],
            [0.6627450980392157, 146, 162, 152],
            [0.6666666666666666, 147, 162, 151],
            [0.6705882352941176, 149, 162, 151],
            [0.6745098039215687, 150, 163, 151],
            [0.6784313725490196, 152, 163, 151],
            [0.6823529411764706, 153, 163, 150],
            [0.6862745098039216, 154, 164, 150],
            [0.6901960784313725, 156, 164, 150],
            [0.6941176470588235, 157, 165, 150],
            [0.6980392156862745, 159, 165, 149],
            [0.7019607843137254, 160, 165, 149],
            [0.7058823529411764, 162, 166, 149],
            [0.7098039215686275, 163, 166, 149],
            [0.7137254901960784, 165, 167, 149],
            [0.7176470588235294, 166, 167, 149],
            [0.7215686274509804, 168, 168, 149],
            [0.7254901960784313, 169, 168, 149],
            [0.7294117647058823, 171, 169, 149],
            [0.7333333333333333, 172, 169, 149],
            [0.7372549019607844, 174, 170, 149],
            [0.7411764705882353, 176, 170, 149],
            [0.7450980392156863, 177, 171, 149],
            [0.7490196078431373, 179, 172, 149],
            [0.7529411764705882, 181, 172, 150],
            [0.7568627450980392, 182, 173, 150],
            [0.7607843137254902, 184, 174, 150],
            [0.7647058823529411, 186, 174, 151],
            [0.7686274509803921, 187, 175, 151],
            [0.7725490196078432, 189, 176, 152],
            [0.7764705882352941, 191, 177, 152],
            [0.7803921568627451, 193, 178, 153],
            [0.7843137254901961, 194, 178, 153],
            [0.788235294117647, 196, 179, 154],
            [0.792156862745098, 198, 180, 155],
            [0.796078431372549, 200, 181, 156],
            [0.8, 202, 182, 157],
            [0.803921568627451, 204, 183, 158],
            [0.807843137254902, 205, 184, 159],
            [0.8117647058823529, 207, 185, 160],
            [0.8156862745098039, 209, 186, 161],
            [0.8196078431372549, 211, 188, 162],
            [0.8235294117647058, 213, 189, 164],
            [0.8274509803921568, 214, 190, 165],
            [0.8313725490196078, 216, 191, 166],
            [0.8352941176470589, 218, 192, 168],
            [0.8392156862745098, 220, 194, 169],
            [0.8431372549019608, 221, 195, 171],
            [0.8470588235294118, 223, 196, 172],
            [0.8509803921568627, 224, 197, 174],
            [0.8549019607843137, 226, 199, 176],
            [0.8588235294117647, 228, 200, 177],
            [0.8627450980392157, 229, 201, 179],
            [0.8666666666666667, 230, 203, 181],
            [0.8705882352941177, 232, 204, 183],
            [0.8745098039215686, 233, 205, 184],
            [0.8784313725490196, 235, 207, 186],
            [0.8823529411764706, 236, 208, 188],
            [0.8862745098039215, 237, 209, 190],
            [0.8901960784313725, 238, 210, 192],
            [0.8941176470588235, 239, 212, 194],
            [0.8980392156862745, 240, 213, 195],
            [0.9019607843137255, 241, 214, 197],
            [0.9058823529411765, 242, 215, 199],
            [0.9098039215686274, 243, 217, 201],
            [0.9137254901960784, 244, 218, 203],
            [0.9176470588235294, 245, 219, 205],
            [0.9215686274509803, 245, 220, 206],
            [0.9254901960784314, 246, 221, 208],
            [0.9294117647058824, 247, 222, 210],
            [0.9333333333333333, 247, 224, 212],
            [0.9372549019607843, 248, 225, 214],
            [0.9411764705882353, 249, 226, 216],
            [0.9450980392156862, 249, 227, 217],
            [0.9490196078431372, 250, 228, 219],
            [0.9529411764705882, 250, 229, 221],
            [0.9568627450980391, 251, 230, 223],
            [0.9607843137254902, 251, 231, 225],
            [0.9647058823529412, 251, 232, 226],
            [0.9686274509803922, 252, 233, 228],
            [0.9725490196078431, 252, 235, 230],
            [0.9764705882352941, 252, 236, 232],
            [0.9803921568627451, 253, 237, 233],
            [0.984313725490196, 253, 238, 235],
            [0.9882352941176471, 253, 239, 237],
            [0.9921568627450981, 253, 240, 239],
            [0.996078431372549, 254, 241, 240],
            [1.0, 254, 242, 242],
        ],
    },
    {
        "name": "lisbon (Div)",
        "discrete": False,
        "colors": [
            [0.0, 229, 229, 254],
            [0.00392156862745098, 226, 227, 253],
            [0.00784313725490196, 224, 225, 251],
            [0.011764705882352941, 221, 223, 250],
            [0.01568627450980392, 218, 221, 248],
            [0.0196078431372549, 216, 219, 246],
            [0.023529411764705882, 213, 217, 245],
            [0.027450980392156862, 210, 215, 243],
            [0.03137254901960784, 207, 213, 242],
            [0.03529411764705882, 205, 211, 240],
            [0.0392156862745098, 202, 209, 238],
            [0.043137254901960784, 199, 207, 237],
            [0.047058823529411764, 197, 205, 235],
            [0.050980392156862744, 194, 203, 234],
            [0.054901960784313725, 191, 201, 232],
            [0.058823529411764705, 189, 200, 231],
            [0.06274509803921569, 186, 198, 229],
            [0.06666666666666667, 183, 196, 227],
            [0.07058823529411765, 181, 194, 226],
            [0.07450980392156863, 178, 192, 224],
            [0.0784313725490196, 175, 190, 223],
            [0.08235294117647059, 173, 188, 221],
            [0.08627450980392157, 170, 186, 219],
            [0.09019607843137255, 168, 184, 218],
            [0.09411764705882353, 165, 182, 216],
            [0.09803921568627451, 162, 180, 215],
            [0.10196078431372549, 160, 178, 213],
            [0.10588235294117647, 157, 176, 212],
            [0.10980392156862745, 154, 174, 210],
            [0.11372549019607843, 152, 173, 208],
            [0.11764705882352941, 149, 171, 207],
            [0.12156862745098039, 147, 169, 205],
            [0.12549019607843137, 144, 167, 204],
            [0.12941176470588234, 141, 165, 202],
            [0.13333333333333333, 139, 163, 201],
            [0.13725490196078433, 136, 161, 199],
            [0.1411764705882353, 134, 159, 197],
            [0.14509803921568626, 131, 157, 196],
            [0.14901960784313725, 128, 155, 194],
            [0.15294117647058825, 126, 153, 193],
            [0.1568627450980392, 123, 151, 191],
            [0.16078431372549018, 121, 150, 190],
            [0.16470588235294117, 118, 148, 188],
            [0.16862745098039217, 116, 146, 186],
            [0.17254901960784313, 113, 144, 185],
            [0.1764705882352941, 111, 142, 183],
            [0.1803921568627451, 108, 140, 182],
            [0.1843137254901961, 106, 138, 180],
            [0.18823529411764706, 103, 136, 179],
            [0.19215686274509802, 100, 134, 177],
            [0.19607843137254902, 98, 132, 175],
            [0.2, 95, 130, 174],
            [0.20392156862745098, 93, 129, 172],
            [0.20784313725490194, 91, 127, 170],
            [0.21176470588235294, 88, 125, 169],
            [0.21568627450980393, 86, 123, 167],
            [0.2196078431372549, 83, 121, 165],
            [0.22352941176470587, 81, 119, 163],
            [0.22745098039215686, 78, 117, 162],
            [0.23137254901960785, 76, 115, 160],
            [0.23529411764705882, 74, 113, 158],
            [0.2392156862745098, 71, 111, 156],
            [0.24313725490196078, 69, 109, 154],
            [0.24705882352941178, 67, 107, 152],
            [0.25098039215686274, 64, 105, 150],
            [0.2549019607843137, 62, 103, 148],
            [0.2588235294117647, 60, 101, 146],
            [0.2627450980392157, 58, 99, 144],
            [0.26666666666666666, 56, 98, 142],
            [0.27058823529411763, 54, 96, 140],
            [0.27450980392156865, 52, 94, 138],
            [0.2784313725490196, 50, 92, 136],
            [0.2823529411764706, 48, 90, 133],
            [0.28627450980392155, 46, 88, 131],
            [0.2901960784313725, 44, 86, 129],
            [0.29411764705882354, 43, 84, 127],
            [0.2980392156862745, 41, 82, 125],
            [0.30196078431372547, 40, 81, 122],
            [0.3058823529411765, 38, 79, 120],
            [0.30980392156862746, 37, 77, 118],
            [0.3137254901960784, 35, 75, 115],
            [0.3176470588235294, 34, 74, 113],
            [0.32156862745098036, 33, 72, 111],
            [0.3254901960784314, 32, 70, 108],
            [0.32941176470588235, 30, 69, 106],
            [0.3333333333333333, 29, 67, 104],
            [0.33725490196078434, 28, 65, 101],
            [0.3411764705882353, 28, 64, 99],
            [0.34509803921568627, 27, 62, 97],
            [0.34901960784313724, 26, 61, 94],
            [0.3529411764705882, 25, 59, 92],
            [0.3568627450980392, 24, 58, 90],
            [0.3607843137254902, 24, 56, 88],
            [0.36470588235294116, 23, 55, 85],
            [0.3686274509803922, 22, 53, 83],
            [0.37254901960784315, 22, 52, 81],
            [0.3764705882352941, 21, 50, 79],
            [0.3803921568627451, 21, 49, 76],
            [0.38431372549019605, 20, 47, 74],
            [0.38823529411764707, 20, 46, 72],
            [0.39215686274509803, 19, 45, 70],
            [0.396078431372549, 19, 43, 68],
            [0.4, 18, 42, 65],
            [0.403921568627451, 18, 41, 63],
            [0.40784313725490196, 18, 39, 61],
            [0.4117647058823529, 18, 38, 59],
            [0.4156862745098039, 17, 37, 57],
            [0.4196078431372549, 17, 36, 55],
            [0.4235294117647059, 17, 35, 53],
            [0.42745098039215684, 17, 33, 51],
            [0.43137254901960786, 17, 32, 49],
            [0.43529411764705883, 17, 31, 47],
            [0.4392156862745098, 17, 30, 45],
            [0.44313725490196076, 17, 29, 43],
            [0.44705882352941173, 17, 29, 42],
            [0.45098039215686275, 17, 28, 40],
            [0.4549019607843137, 17, 27, 38],
            [0.4588235294117647, 17, 26, 37],
            [0.4627450980392157, 17, 26, 35],
            [0.4666666666666667, 18, 25, 34],
            [0.47058823529411764, 18, 25, 32],
            [0.4745098039215686, 18, 24, 31],
            [0.4784313725490196, 19, 24, 30],
            [0.4823529411764706, 19, 24, 29],
            [0.48627450980392156, 20, 24, 28],
            [0.49019607843137253, 20, 24, 27],
            [0.49411764705882355, 21, 24, 26],
            [0.4980392156862745, 22, 24, 25],
            [0.5019607843137255, 22, 24, 25],
            [0.5058823529411764, 23, 25, 24],
            [0.5098039215686274, 24, 25, 24],
            [0.5137254901960784, 25, 26, 23],
            [0.5176470588235293, 26, 26, 23],
            [0.5215686274509804, 27, 27, 23],
            [0.5254901960784314, 28, 28, 23],
            [0.5294117647058824, 29, 29, 23],
            [0.5333333333333333, 30, 30, 23],
            [0.5372549019607843, 32, 31, 23],
            [0.5411764705882353, 33, 32, 23],
            [0.5450980392156862, 34, 33, 24],
            [0.5490196078431373, 36, 34, 24],
            [0.5529411764705883, 37, 35, 25],
            [0.5568627450980392, 38, 37, 25],
            [0.5607843137254902, 40, 38, 26],
            [0.5647058823529412, 41, 39, 26],
            [0.5686274509803921, 43, 41, 27],
            [0.5725490196078431, 44, 42, 28],
            [0.5764705882352941, 46, 44, 29],
            [0.580392156862745, 48, 45, 29],
            [0.5843137254901961, 49, 46, 30],
            [0.5882352941176471, 51, 48, 31],
            [0.592156862745098, 53, 50, 32],
            [0.596078431372549, 54, 51, 33],
            [0.6, 56, 53, 34],
            [0.6039215686274509, 58, 54, 35],
            [0.6078431372549019, 59, 56, 36],
            [0.611764705882353, 61, 57, 37],
            [0.615686274509804, 63, 59, 38],
            [0.6196078431372549, 64, 61, 39],
            [0.6235294117647059, 66, 62, 40],
            [0.6274509803921569, 68, 64, 41],
            [0.6313725490196078, 70, 66, 42],
            [0.6352941176470588, 72, 67, 43],
            [0.6392156862745098, 73, 69, 44],
            [0.6431372549019607, 75, 71, 45],
            [0.6470588235294118, 77, 72, 46],
            [0.6509803921568628, 79, 74, 47],
            [0.6549019607843137, 81, 76, 48],
            [0.6588235294117647, 82, 77, 49],
            [0.6627450980392157, 84, 79, 50],
            [0.6666666666666666, 86, 81, 51],
            [0.6705882352941176, 88, 83, 52],
            [0.6745098039215687, 90, 84, 54],
            [0.6784313725490196, 92, 86, 55],
            [0.6823529411764706, 94, 88, 56],
            [0.6862745098039216, 95, 90, 57],
            [0.6901960784313725, 97, 92, 58],
            [0.6941176470588235, 99, 93, 59],
            [0.6980392156862745, 101, 95, 60],
            [0.7019607843137254, 103, 97, 61],
            [0.7058823529411764, 105, 99, 63],
            [0.7098039215686275, 107, 101, 64],
            [0.7137254901960784, 109, 102, 65],
            [0.7176470588235294, 111, 104, 66],
            [0.7215686274509804, 113, 106, 67],
            [0.7254901960784313, 115, 108, 69],
            [0.7294117647058823, 117, 110, 70],
            [0.7333333333333333, 119, 112, 71],
            [0.7372549019607844, 121, 113, 72],
            [0.7411764705882353, 123, 115, 73],
            [0.7450980392156863, 125, 117, 75],
            [0.7490196078431373, 127, 119, 76],
            [0.7529411764705882, 129, 121, 77],
            [0.7568627450980392, 131, 123, 79],
            [0.7607843137254902, 133, 125, 80],
            [0.7647058823529411, 135, 127, 81],
            [0.7686274509803921, 137, 129, 83],
            [0.7725490196078432, 139, 131, 84],
            [0.7764705882352941, 141, 133, 86],
            [0.7803921568627451, 143, 135, 87],
            [0.7843137254901961, 145, 137, 89],
            [0.788235294117647, 147, 139, 90],
            [0.792156862745098, 149, 141, 92],
            [0.796078431372549, 151, 143, 93],
            [0.8, 153, 145, 95],
            [0.803921568627451, 155, 147, 97],
            [0.807843137254902, 157, 149, 99],
            [0.8117647058823529, 160, 151, 100],
            [0.8156862745098039, 162, 153, 102],
            [0.8196078431372549, 164, 155, 104],
            [0.8235294117647058, 166, 158, 106],
            [0.8274509803921568, 168, 160, 108],
            [0.8313725490196078, 170, 162, 110],
            [0.8352941176470589, 172, 164, 112],
            [0.8392156862745098, 174, 166, 114],
            [0.8431372549019608, 176, 168, 116],
            [0.8470588235294118, 178, 170, 118],
            [0.8509803921568627, 180, 172, 120],
            [0.8549019607843137, 182, 175, 123],
            [0.8588235294117647, 184, 177, 125],
            [0.8627450980392157, 187, 179, 127],
            [0.8666666666666667, 189, 181, 129],
            [0.8705882352941177, 191, 183, 132],
            [0.8745098039215686, 193, 185, 134],
            [0.8784313725490196, 195, 188, 136],
            [0.8823529411764706, 197, 190, 139],
            [0.8862745098039215, 199, 192, 141],
            [0.8901960784313725, 200, 194, 144],
            [0.8941176470588235, 202, 196, 146],
            [0.8980392156862745, 204, 198, 149],
            [0.9019607843137255, 206, 200, 151],
            [0.9058823529411765, 208, 203, 154],
            [0.9098039215686274, 210, 205, 156],
            [0.9137254901960784, 212, 207, 159],
            [0.9176470588235294, 214, 209, 161],
            [0.9215686274509803, 216, 211, 164],
            [0.9254901960784314, 218, 213, 166],
            [0.9294117647058824, 220, 215, 169],
            [0.9333333333333333, 222, 218, 171],
            [0.9372549019607843, 224, 220, 174],
            [0.9411764705882353, 226, 222, 177],
            [0.9450980392156862, 228, 224, 179],
            [0.9490196078431372, 229, 226, 182],
            [0.9529411764705882, 231, 228, 184],
            [0.9568627450980391, 233, 231, 187],
            [0.9607843137254902, 235, 233, 190],
            [0.9647058823529412, 237, 235, 192],
            [0.9686274509803922, 239, 237, 195],
            [0.9725490196078431, 241, 239, 198],
            [0.9764705882352941, 243, 241, 200],
            [0.9803921568627451, 245, 244, 203],
            [0.984313725490196, 247, 246, 206],
            [0.9882352941176471, 249, 248, 208],
            [0.9921568627450981, 251, 250, 211],
            [0.996078431372549, 253, 252, 214],
            [1.0, 254, 254, 216],
        ],
    },
    {
        "name": "nuuk (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 4, 89, 140],
            [0.00392156862745098, 6, 89, 140],
            [0.00784313725490196, 8, 89, 139],
            [0.011764705882352941, 10, 90, 139],
            [0.01568627450980392, 12, 90, 138],
            [0.0196078431372549, 14, 90, 138],
            [0.023529411764705882, 15, 91, 138],
            [0.027450980392156862, 17, 91, 137],
            [0.03137254901960784, 18, 91, 137],
            [0.03529411764705882, 20, 91, 137],
            [0.0392156862745098, 21, 92, 136],
            [0.043137254901960784, 22, 92, 136],
            [0.047058823529411764, 23, 92, 136],
            [0.050980392156862744, 25, 93, 135],
            [0.054901960784313725, 26, 93, 135],
            [0.058823529411764705, 27, 93, 135],
            [0.06274509803921569, 28, 93, 134],
            [0.06666666666666667, 29, 94, 134],
            [0.07058823529411765, 30, 94, 134],
            [0.07450980392156863, 31, 94, 133],
            [0.0784313725490196, 32, 95, 133],
            [0.08235294117647059, 33, 95, 133],
            [0.08627450980392157, 34, 95, 133],
            [0.09019607843137255, 35, 96, 132],
            [0.09411764705882353, 36, 96, 132],
            [0.09803921568627451, 37, 97, 132],
            [0.10196078431372549, 38, 97, 132],
            [0.10588235294117647, 40, 97, 131],
            [0.10980392156862745, 41, 98, 131],
            [0.11372549019607843, 42, 98, 131],
            [0.11764705882352941, 43, 99, 131],
            [0.12156862745098039, 44, 99, 131],
            [0.12549019607843137, 45, 99, 130],
            [0.12941176470588234, 46, 100, 130],
            [0.13333333333333333, 47, 100, 130],
            [0.13725490196078433, 48, 101, 130],
            [0.1411764705882353, 49, 101, 130],
            [0.14509803921568626, 50, 102, 130],
            [0.14901960784313725, 51, 102, 130],
            [0.15294117647058825, 52, 103, 129],
            [0.1568627450980392, 53, 103, 129],
            [0.16078431372549018, 55, 104, 129],
            [0.16470588235294117, 56, 104, 129],
            [0.16862745098039217, 57, 105, 129],
            [0.17254901960784313, 58, 105, 129],
            [0.1764705882352941, 59, 106, 129],
            [0.1803921568627451, 60, 107, 129],
            [0.1843137254901961, 62, 107, 129],
            [0.18823529411764706, 63, 108, 129],
            [0.19215686274509802, 64, 108, 130],
            [0.19607843137254902, 65, 109, 130],
            [0.2, 66, 110, 130],
            [0.20392156862745098, 68, 110, 130],
            [0.20784313725490194, 69, 111, 130],
            [0.21176470588235294, 70, 111, 130],
            [0.21568627450980393, 71, 112, 130],
            [0.2196078431372549, 72, 113, 130],
            [0.22352941176470587, 74, 113, 131],
            [0.22745098039215686, 75, 114, 131],
            [0.23137254901960785, 76, 115, 131],
            [0.23529411764705882, 78, 115, 131],
            [0.2392156862745098, 79, 116, 132],
            [0.24313725490196078, 80, 117, 132],
            [0.24705882352941178, 81, 118, 132],
            [0.25098039215686274, 83, 118, 132],
            [0.2549019607843137, 84, 119, 133],
            [0.2588235294117647, 85, 120, 133],
            [0.2627450980392157, 87, 120, 133],
            [0.26666666666666666, 88, 121, 134],
            [0.27058823529411763, 89, 122, 134],
            [0.27450980392156865, 91, 123, 134],
            [0.2784313725490196, 92, 123, 135],
            [0.2823529411764706, 93, 124, 135],
            [0.28627450980392155, 95, 125, 135],
            [0.2901960784313725, 96, 126, 136],
            [0.29411764705882354, 97, 126, 136],
            [0.2980392156862745, 99, 127, 137],
            [0.30196078431372547, 100, 128, 137],
            [0.3058823529411765, 101, 129, 137],
            [0.30980392156862746, 103, 130, 138],
            [0.3137254901960784, 104, 130, 138],
            [0.3176470588235294, 105, 131, 139],
            [0.32156862745098036, 107, 132, 139],
            [0.3254901960784314, 108, 133, 140],
            [0.32941176470588235, 109, 133, 140],
            [0.3333333333333333, 110, 134, 140],
            [0.33725490196078434, 112, 135, 141],
            [0.3411764705882353, 113, 136, 141],
            [0.34509803921568627, 114, 136, 142],
            [0.34901960784313724, 116, 137, 142],
            [0.3529411764705882, 117, 138, 142],
            [0.3568627450980392, 118, 139, 143],
            [0.3607843137254902, 120, 140, 143],
            [0.36470588235294116, 121, 140, 144],
            [0.3686274509803922, 122, 141, 144],
            [0.37254901960784315, 124, 142, 144],
            [0.3764705882352941, 125, 143, 145],
            [0.3803921568627451, 126, 143, 145],
            [0.38431372549019605, 127, 144, 146],
            [0.38823529411764707, 129, 145, 146],
            [0.39215686274509803, 130, 146, 146],
            [0.396078431372549, 131, 146, 147],
            [0.4, 132, 147, 147],
            [0.403921568627451, 134, 148, 147],
            [0.40784313725490196, 135, 149, 148],
            [0.4117647058823529, 136, 149, 148],
            [0.4156862745098039, 137, 150, 148],
            [0.4196078431372549, 138, 151, 148],
            [0.4235294117647059, 140, 152, 149],
            [0.42745098039215684, 141, 152, 149],
            [0.43137254901960786, 142, 153, 149],
            [0.43529411764705883, 143, 154, 149],
            [0.4392156862745098, 144, 155, 150],
            [0.44313725490196076, 145, 155, 150],
            [0.44705882352941173, 146, 156, 150],
            [0.45098039215686275, 147, 157, 150],
            [0.4549019607843137, 149, 157, 150],
            [0.4588235294117647, 150, 158, 151],
            [0.4627450980392157, 151, 159, 151],
            [0.4666666666666667, 152, 159, 151],
            [0.47058823529411764, 153, 160, 151],
            [0.4745098039215686, 154, 161, 151],
            [0.4784313725490196, 155, 161, 151],
            [0.4823529411764706, 156, 162, 151],
            [0.48627450980392156, 157, 163, 151],
            [0.49019607843137253, 158, 163, 151],
            [0.49411764705882355, 158, 164, 151],
            [0.4980392156862745, 159, 164, 151],
            [0.5019607843137255, 160, 165, 151],
            [0.5058823529411764, 161, 166, 151],
            [0.5098039215686274, 162, 166, 151],
            [0.5137254901960784, 163, 167, 151],
            [0.5176470588235293, 164, 167, 151],
            [0.5215686274509804, 164, 168, 151],
            [0.5254901960784314, 165, 169, 151],
            [0.5294117647058824, 166, 169, 151],
            [0.5333333333333333, 167, 170, 151],
            [0.5372549019607843, 167, 170, 150],
            [0.5411764705882353, 168, 171, 150],
            [0.5450980392156862, 169, 171, 150],
            [0.5490196078431373, 170, 172, 150],
            [0.5529411764705883, 170, 172, 150],
            [0.5568627450980392, 171, 173, 149],
            [0.5607843137254902, 172, 173, 149],
            [0.5647058823529412, 172, 174, 149],
            [0.5686274509803921, 173, 174, 149],
            [0.5725490196078431, 173, 175, 149],
            [0.5764705882352941, 174, 175, 148],
            [0.580392156862745, 175, 176, 148],
            [0.5843137254901961, 175, 176, 148],
            [0.5882352941176471, 176, 177, 147],
            [0.592156862745098, 176, 177, 147],
            [0.596078431372549, 177, 177, 147],
            [0.6, 177, 178, 147],
            [0.6039215686274509, 178, 178, 146],
            [0.6078431372549019, 178, 179, 146],
            [0.611764705882353, 179, 179, 146],
            [0.615686274509804, 179, 180, 145],
            [0.6196078431372549, 180, 180, 145],
            [0.6235294117647059, 180, 180, 145],
            [0.6274509803921569, 181, 181, 144],
            [0.6313725490196078, 181, 181, 144],
            [0.6352941176470588, 182, 182, 143],
            [0.6392156862745098, 182, 182, 143],
            [0.6431372549019607, 183, 182, 143],
            [0.6470588235294118, 183, 183, 142],
            [0.6509803921568628, 183, 183, 142],
            [0.6549019607843137, 184, 184, 142],
            [0.6588235294117647, 184, 184, 141],
            [0.6627450980392157, 185, 184, 141],
            [0.6666666666666666, 185, 185, 140],
            [0.6705882352941176, 186, 185, 140],
            [0.6745098039215687, 186, 186, 140],
            [0.6784313725490196, 186, 186, 139],
            [0.6823529411764706, 187, 187, 139],
            [0.6862745098039216, 187, 187, 139],
            [0.6901960784313725, 188, 187, 138],
            [0.6941176470588235, 188, 188, 138],
            [0.6980392156862745, 189, 188, 137],
            [0.7019607843137254, 189, 189, 137],
            [0.7058823529411764, 189, 189, 137],
            [0.7098039215686275, 190, 189, 136],
            [0.7137254901960784, 190, 190, 136],
            [0.7176470588235294, 191, 190, 136],
            [0.7215686274509804, 191, 191, 135],
            [0.7254901960784313, 192, 191, 135],
            [0.7294117647058823, 192, 192, 135],
            [0.7333333333333333, 192, 192, 134],
            [0.7372549019607844, 193, 192, 134],
            [0.7411764705882353, 193, 193, 134],
            [0.7450980392156863, 194, 193, 133],
            [0.7490196078431373, 194, 194, 133],
            [0.7529411764705882, 195, 194, 133],
            [0.7568627450980392, 195, 195, 132],
            [0.7607843137254902, 196, 195, 132],
            [0.7647058823529411, 196, 196, 132],
            [0.7686274509803921, 197, 197, 132],
            [0.7725490196078432, 198, 197, 131],
            [0.7764705882352941, 198, 198, 131],
            [0.7803921568627451, 199, 198, 131],
            [0.7843137254901961, 199, 199, 131],
            [0.788235294117647, 200, 200, 131],
            [0.792156862745098, 201, 200, 131],
            [0.796078431372549, 201, 201, 131],
            [0.8, 202, 202, 131],
            [0.803921568627451, 203, 202, 131],
            [0.807843137254902, 203, 203, 131],
            [0.8117647058823529, 204, 204, 131],
            [0.8156862745098039, 205, 204, 131],
            [0.8196078431372549, 206, 205, 131],
            [0.8235294117647058, 206, 206, 131],
            [0.8274509803921568, 207, 207, 131],
            [0.8313725490196078, 208, 208, 132],
            [0.8352941176470589, 209, 209, 132],
            [0.8392156862745098, 210, 210, 132],
            [0.8431372549019608, 211, 211, 133],
            [0.8470588235294118, 212, 212, 133],
            [0.8509803921568627, 213, 213, 133],
            [0.8549019607843137, 214, 214, 134],
            [0.8588235294117647, 215, 215, 135],
            [0.8627450980392157, 216, 216, 135],
            [0.8666666666666667, 217, 217, 136],
            [0.8705882352941177, 218, 218, 137],
            [0.8745098039215686, 219, 219, 137],
            [0.8784313725490196, 220, 220, 138],
            [0.8823529411764706, 221, 221, 139],
            [0.8862745098039215, 223, 222, 140],
            [0.8901960784313725, 224, 223, 141],
            [0.8941176470588235, 225, 225, 142],
            [0.8980392156862745, 226, 226, 143],
            [0.9019607843137255, 227, 227, 144],
            [0.9058823529411765, 228, 228, 145],
            [0.9098039215686274, 230, 229, 146],
            [0.9137254901960784, 231, 230, 148],
            [0.9176470588235294, 232, 232, 149],
            [0.9215686274509803, 233, 233, 150],
            [0.9254901960784314, 234, 234, 151],
            [0.9294117647058824, 235, 235, 153],
            [0.9333333333333333, 236, 236, 154],
            [0.9372549019607843, 237, 237, 155],
            [0.9411764705882353, 239, 238, 157],
            [0.9450980392156862, 240, 239, 158],
            [0.9490196078431372, 241, 240, 159],
            [0.9529411764705882, 242, 242, 161],
            [0.9568627450980391, 243, 243, 162],
            [0.9607843137254902, 244, 244, 163],
            [0.9647058823529412, 245, 245, 165],
            [0.9686274509803922, 246, 246, 166],
            [0.9725490196078431, 247, 247, 168],
            [0.9764705882352941, 248, 248, 169],
            [0.9803921568627451, 249, 249, 171],
            [0.984313725490196, 250, 250, 172],
            [0.9882352941176471, 251, 251, 173],
            [0.9921568627450981, 252, 252, 175],
            [0.996078431372549, 253, 253, 176],
            [1.0, 254, 254, 178],
        ],
    },
    {
        "name": "oslo (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 0, 1, 0],
            [0.00392156862745098, 1, 2, 2],
            [0.00784313725490196, 1, 3, 4],
            [0.011764705882352941, 2, 4, 6],
            [0.01568627450980392, 3, 5, 9],
            [0.0196078431372549, 3, 6, 11],
            [0.023529411764705882, 4, 7, 13],
            [0.027450980392156862, 4, 9, 14],
            [0.03137254901960784, 5, 10, 16],
            [0.03529411764705882, 5, 11, 17],
            [0.0392156862745098, 6, 12, 19],
            [0.043137254901960784, 6, 13, 20],
            [0.047058823529411764, 7, 14, 21],
            [0.050980392156862744, 8, 15, 23],
            [0.054901960784313725, 8, 16, 24],
            [0.058823529411764705, 9, 16, 25],
            [0.06274509803921569, 10, 17, 26],
            [0.06666666666666667, 10, 18, 27],
            [0.07058823529411765, 11, 19, 28],
            [0.07450980392156863, 11, 20, 30],
            [0.0784313725490196, 11, 20, 31],
            [0.08235294117647059, 12, 21, 32],
            [0.08627450980392157, 12, 22, 33],
            [0.09019607843137255, 12, 23, 34],
            [0.09411764705882353, 12, 23, 36],
            [0.09803921568627451, 13, 24, 37],
            [0.10196078431372549, 13, 25, 38],
            [0.10588235294117647, 13, 25, 39],
            [0.10980392156862745, 13, 26, 41],
            [0.11372549019607843, 13, 27, 42],
            [0.11764705882352941, 13, 28, 43],
            [0.12156862745098039, 13, 28, 44],
            [0.12549019607843137, 13, 29, 46],
            [0.12941176470588234, 14, 30, 47],
            [0.13333333333333333, 14, 31, 48],
            [0.13725490196078433, 14, 31, 50],
            [0.1411764705882353, 14, 32, 51],
            [0.14509803921568626, 14, 33, 52],
            [0.14901960784313725, 14, 34, 54],
            [0.15294117647058825, 15, 35, 55],
            [0.1568627450980392, 15, 35, 56],
            [0.16078431372549018, 15, 36, 58],
            [0.16470588235294117, 15, 37, 59],
            [0.16862745098039217, 15, 38, 60],
            [0.17254901960784313, 15, 39, 62],
            [0.1764705882352941, 16, 40, 63],
            [0.1803921568627451, 16, 40, 65],
            [0.1843137254901961, 16, 41, 66],
            [0.18823529411764706, 16, 42, 67],
            [0.19215686274509802, 17, 43, 69],
            [0.19607843137254902, 17, 44, 70],
            [0.2, 17, 45, 72],
            [0.20392156862745098, 17, 45, 73],
            [0.20784313725490194, 18, 46, 75],
            [0.21176470588235294, 18, 47, 76],
            [0.21568627450980393, 18, 48, 77],
            [0.2196078431372549, 18, 49, 79],
            [0.22352941176470587, 19, 50, 80],
            [0.22745098039215686, 19, 51, 82],
            [0.23137254901960785, 19, 52, 83],
            [0.23529411764705882, 20, 53, 85],
            [0.2392156862745098, 20, 54, 86],
            [0.24313725490196078, 20, 54, 88],
            [0.24705882352941178, 21, 55, 89],
            [0.25098039215686274, 21, 56, 91],
            [0.2549019607843137, 21, 57, 92],
            [0.2588235294117647, 22, 58, 94],
            [0.2627450980392157, 22, 59, 95],
            [0.26666666666666666, 22, 60, 97],
            [0.27058823529411763, 23, 61, 98],
            [0.27450980392156865, 23, 62, 100],
            [0.2784313725490196, 24, 63, 101],
            [0.2823529411764706, 24, 64, 103],
            [0.28627450980392155, 24, 65, 104],
            [0.2901960784313725, 25, 65, 106],
            [0.29411764705882354, 25, 66, 107],
            [0.2980392156862745, 26, 67, 109],
            [0.30196078431372547, 26, 68, 110],
            [0.3058823529411765, 27, 69, 112],
            [0.30980392156862746, 27, 70, 113],
            [0.3137254901960784, 28, 71, 115],
            [0.3176470588235294, 28, 72, 116],
            [0.32156862745098036, 29, 73, 118],
            [0.3254901960784314, 29, 74, 120],
            [0.32941176470588235, 30, 75, 121],
            [0.3333333333333333, 30, 76, 123],
            [0.33725490196078434, 31, 77, 124],
            [0.3411764705882353, 32, 78, 126],
            [0.34509803921568627, 32, 79, 127],
            [0.34901960784313724, 33, 80, 129],
            [0.3529411764705882, 34, 80, 130],
            [0.3568627450980392, 34, 81, 132],
            [0.3607843137254902, 35, 82, 134],
            [0.36470588235294116, 36, 83, 135],
            [0.3686274509803922, 36, 84, 137],
            [0.37254901960784315, 37, 85, 138],
            [0.3764705882352941, 38, 86, 140],
            [0.3803921568627451, 39, 87, 141],
            [0.38431372549019605, 40, 88, 143],
            [0.38823529411764707, 40, 89, 145],
            [0.39215686274509803, 41, 90, 146],
            [0.396078431372549, 42, 91, 148],
            [0.4, 43, 92, 149],
            [0.403921568627451, 44, 93, 151],
            [0.40784313725490196, 45, 94, 153],
            [0.4117647058823529, 46, 95, 154],
            [0.4156862745098039, 47, 96, 156],
            [0.4196078431372549, 48, 97, 157],
            [0.4235294117647059, 50, 99, 159],
            [0.42745098039215684, 51, 100, 161],
            [0.43137254901960786, 52, 101, 162],
            [0.43529411764705883, 53, 102, 164],
            [0.4392156862745098, 55, 103, 165],
            [0.44313725490196076, 56, 104, 167],
            [0.44705882352941173, 57, 105, 169],
            [0.45098039215686275, 59, 106, 170],
            [0.4549019607843137, 60, 108, 172],
            [0.4588235294117647, 62, 109, 173],
            [0.4627450980392157, 63, 110, 175],
            [0.4666666666666667, 65, 111, 176],
            [0.47058823529411764, 66, 112, 178],
            [0.4745098039215686, 68, 114, 179],
            [0.4784313725490196, 69, 115, 180],
            [0.4823529411764706, 71, 116, 182],
            [0.48627450980392156, 72, 117, 183],
            [0.49019607843137253, 74, 119, 184],
            [0.49411764705882355, 76, 120, 185],
            [0.4980392156862745, 77, 121, 187],
            [0.5019607843137255, 79, 122, 188],
            [0.5058823529411764, 81, 123, 189],
            [0.5098039215686274, 82, 125, 190],
            [0.5137254901960784, 84, 126, 191],
            [0.5176470588235293, 86, 127, 192],
            [0.5215686274509804, 87, 128, 193],
            [0.5254901960784314, 89, 129, 193],
            [0.5294117647058824, 90, 130, 194],
            [0.5333333333333333, 92, 131, 195],
            [0.5372549019607843, 94, 133, 196],
            [0.5411764705882353, 95, 134, 196],
            [0.5450980392156862, 97, 135, 197],
            [0.5490196078431373, 98, 136, 197],
            [0.5529411764705883, 99, 137, 198],
            [0.5568627450980392, 101, 138, 198],
            [0.5607843137254902, 102, 139, 199],
            [0.5647058823529412, 104, 139, 199],
            [0.5686274509803921, 105, 140, 199],
            [0.5725490196078431, 106, 141, 200],
            [0.5764705882352941, 108, 142, 200],
            [0.580392156862745, 109, 143, 200],
            [0.5843137254901961, 110, 144, 200],
            [0.5882352941176471, 112, 145, 200],
            [0.592156862745098, 113, 146, 201],
            [0.596078431372549, 114, 146, 201],
            [0.6, 116, 147, 201],
            [0.6039215686274509, 117, 148, 201],
            [0.6078431372549019, 118, 149, 201],
            [0.611764705882353, 119, 150, 201],
            [0.615686274509804, 121, 150, 201],
            [0.6196078431372549, 122, 151, 201],
            [0.6235294117647059, 123, 152, 201],
            [0.6274509803921569, 124, 153, 201],
            [0.6313725490196078, 125, 153, 201],
            [0.6352941176470588, 127, 154, 201],
            [0.6392156862745098, 128, 155, 201],
            [0.6431372549019607, 129, 156, 201],
            [0.6470588235294118, 130, 156, 201],
            [0.6509803921568628, 131, 157, 201],
            [0.6549019607843137, 132, 158, 201],
            [0.6588235294117647, 134, 159, 201],
            [0.6627450980392157, 135, 159, 201],
            [0.6666666666666666, 136, 160, 201],
            [0.6705882352941176, 137, 161, 201],
            [0.6745098039215687, 138, 161, 201],
            [0.6784313725490196, 140, 162, 201],
            [0.6823529411764706, 141, 163, 201],
            [0.6862745098039216, 142, 164, 201],
            [0.6901960784313725, 143, 164, 201],
            [0.6941176470588235, 144, 165, 201],
            [0.6980392156862745, 145, 166, 201],
            [0.7019607843137254, 147, 167, 201],
            [0.7058823529411764, 148, 167, 201],
            [0.7098039215686275, 149, 168, 201],
            [0.7137254901960784, 150, 169, 201],
            [0.7176470588235294, 151, 170, 201],
            [0.7215686274509804, 153, 170, 201],
            [0.7254901960784313, 154, 171, 201],
            [0.7294117647058823, 155, 172, 201],
            [0.7333333333333333, 156, 173, 201],
            [0.7372549019607844, 157, 173, 201],
            [0.7411764705882353, 159, 174, 201],
            [0.7450980392156863, 160, 175, 201],
            [0.7490196078431373, 161, 176, 201],
            [0.7529411764705882, 162, 177, 201],
            [0.7568627450980392, 164, 177, 201],
            [0.7607843137254902, 165, 178, 201],
            [0.7647058823529411, 166, 179, 201],
            [0.7686274509803921, 167, 180, 202],
            [0.7725490196078432, 169, 181, 202],
            [0.7764705882352941, 170, 182, 202],
            [0.7803921568627451, 171, 182, 202],
            [0.7843137254901961, 172, 183, 202],
            [0.788235294117647, 174, 184, 202],
            [0.792156862745098, 175, 185, 203],
            [0.796078431372549, 176, 186, 203],
            [0.8, 178, 187, 203],
            [0.803921568627451, 179, 188, 203],
            [0.807843137254902, 180, 189, 204],
            [0.8117647058823529, 182, 190, 204],
            [0.8156862745098039, 183, 191, 205],
            [0.8196078431372549, 185, 192, 205],
            [0.8235294117647058, 186, 193, 205],
            [0.8274509803921568, 187, 194, 206],
            [0.8313725490196078, 189, 195, 206],
            [0.8352941176470589, 190, 196, 207],
            [0.8392156862745098, 192, 197, 208],
            [0.8431372549019608, 193, 199, 208],
            [0.8470588235294118, 195, 200, 209],
            [0.8509803921568627, 196, 201, 209],
            [0.8549019607843137, 198, 202, 210],
            [0.8588235294117647, 199, 203, 211],
            [0.8627450980392157, 200, 205, 212],
            [0.8666666666666667, 202, 206, 213],
            [0.8705882352941177, 203, 207, 213],
            [0.8745098039215686, 205, 208, 214],
            [0.8784313725490196, 207, 210, 215],
            [0.8823529411764706, 208, 211, 216],
            [0.8862745098039215, 210, 212, 217],
            [0.8901960784313725, 211, 214, 218],
            [0.8941176470588235, 213, 215, 219],
            [0.8980392156862745, 214, 216, 220],
            [0.9019607843137255, 216, 218, 221],
            [0.9058823529411765, 217, 219, 222],
            [0.9098039215686274, 219, 221, 224],
            [0.9137254901960784, 220, 222, 225],
            [0.9176470588235294, 222, 223, 226],
            [0.9215686274509803, 223, 225, 227],
            [0.9254901960784314, 225, 226, 228],
            [0.9294117647058824, 227, 228, 230],
            [0.9333333333333333, 228, 229, 231],
            [0.9372549019607843, 230, 231, 232],
            [0.9411764705882353, 231, 232, 233],
            [0.9450980392156862, 233, 234, 235],
            [0.9490196078431372, 234, 235, 236],
            [0.9529411764705882, 236, 236, 238],
            [0.9568627450980391, 237, 238, 239],
            [0.9607843137254902, 239, 239, 240],
            [0.9647058823529412, 241, 241, 242],
            [0.9686274509803922, 242, 242, 243],
            [0.9725490196078431, 244, 244, 244],
            [0.9764705882352941, 245, 245, 246],
            [0.9803921568627451, 247, 247, 247],
            [0.984313725490196, 248, 248, 249],
            [0.9882352941176471, 250, 250, 250],
            [0.9921568627450981, 251, 251, 252],
            [0.996078431372549, 253, 253, 253],
            [1.0, 254, 255, 254],
        ],
    },
    {
        "name": "roma (Div)",
        "discrete": False,
        "colors": [
            [0.0, 125, 23, 0],
            [0.00392156862745098, 126, 26, 0],
            [0.00784313725490196, 127, 29, 1],
            [0.011764705882352941, 128, 31, 2],
            [0.01568627450980392, 130, 34, 3],
            [0.0196078431372549, 131, 36, 4],
            [0.023529411764705882, 132, 39, 5],
            [0.027450980392156862, 133, 41, 5],
            [0.03137254901960784, 134, 43, 6],
            [0.03529411764705882, 135, 46, 7],
            [0.0392156862745098, 136, 48, 7],
            [0.043137254901960784, 137, 50, 8],
            [0.047058823529411764, 138, 52, 9],
            [0.050980392156862744, 139, 54, 9],
            [0.054901960784313725, 140, 56, 10],
            [0.058823529411764705, 141, 58, 11],
            [0.06274509803921569, 142, 60, 12],
            [0.06666666666666667, 143, 62, 13],
            [0.07058823529411765, 144, 64, 13],
            [0.07450980392156863, 145, 65, 14],
            [0.0784313725490196, 146, 67, 15],
            [0.08235294117647059, 147, 69, 16],
            [0.08627450980392157, 148, 71, 16],
            [0.09019607843137255, 149, 73, 17],
            [0.09411764705882353, 150, 74, 18],
            [0.09803921568627451, 150, 76, 19],
            [0.10196078431372549, 151, 78, 19],
            [0.10588235294117647, 152, 80, 20],
            [0.10980392156862745, 153, 81, 21],
            [0.11372549019607843, 154, 83, 21],
            [0.11764705882352941, 155, 85, 22],
            [0.12156862745098039, 156, 86, 23],
            [0.12549019607843137, 156, 88, 24],
            [0.12941176470588234, 157, 90, 24],
            [0.13333333333333333, 158, 91, 25],
            [0.13725490196078433, 159, 93, 26],
            [0.1411764705882353, 160, 94, 26],
            [0.14509803921568626, 160, 96, 27],
            [0.14901960784313725, 161, 98, 28],
            [0.15294117647058825, 162, 99, 28],
            [0.1568627450980392, 163, 101, 29],
            [0.16078431372549018, 164, 102, 30],
            [0.16470588235294117, 164, 104, 31],
            [0.16862745098039217, 165, 105, 31],
            [0.17254901960784313, 166, 107, 32],
            [0.1764705882352941, 167, 109, 33],
            [0.1803921568627451, 167, 110, 33],
            [0.1843137254901961, 168, 112, 34],
            [0.18823529411764706, 169, 113, 35],
            [0.19215686274509802, 170, 115, 36],
            [0.19607843137254902, 170, 117, 36],
            [0.2, 171, 118, 37],
            [0.20392156862745098, 172, 120, 38],
            [0.20784313725490194, 173, 121, 39],
            [0.21176470588235294, 174, 123, 40],
            [0.21568627450980393, 174, 125, 41],
            [0.2196078431372549, 175, 126, 41],
            [0.22352941176470587, 176, 128, 42],
            [0.22745098039215686, 177, 130, 43],
            [0.23137254901960785, 178, 131, 44],
            [0.23529411764705882, 178, 133, 45],
            [0.2392156862745098, 179, 135, 46],
            [0.24313725490196078, 180, 136, 47],
            [0.24705882352941178, 181, 138, 48],
            [0.25098039215686274, 182, 140, 49],
            [0.2549019607843137, 183, 142, 51],
            [0.2588235294117647, 183, 143, 52],
            [0.2627450980392157, 184, 145, 53],
            [0.26666666666666666, 185, 147, 54],
            [0.27058823529411763, 186, 149, 56],
            [0.27450980392156865, 187, 151, 57],
            [0.2784313725490196, 188, 153, 58],
            [0.2823529411764706, 189, 154, 60],
            [0.28627450980392155, 189, 156, 61],
            [0.2901960784313725, 190, 158, 63],
            [0.29411764705882354, 191, 160, 65],
            [0.2980392156862745, 192, 162, 66],
            [0.30196078431372547, 193, 164, 68],
            [0.3058823529411765, 194, 166, 70],
            [0.30980392156862746, 195, 168, 72],
            [0.3137254901960784, 196, 170, 74],
            [0.3176470588235294, 196, 172, 76],
            [0.32156862745098036, 197, 174, 78],
            [0.3254901960784314, 198, 176, 80],
            [0.32941176470588235, 199, 178, 82],
            [0.3333333333333333, 200, 180, 85],
            [0.33725490196078434, 201, 182, 87],
            [0.3411764705882353, 201, 184, 90],
            [0.34509803921568627, 202, 186, 92],
            [0.34901960784313724, 203, 188, 95],
            [0.3529411764705882, 204, 190, 97],
            [0.3568627450980392, 204, 192, 100],
            [0.3607843137254902, 205, 194, 103],
            [0.36470588235294116, 206, 196, 105],
            [0.3686274509803922, 206, 198, 108],
            [0.37254901960784315, 207, 199, 111],
            [0.3764705882352941, 207, 201, 114],
            [0.3803921568627451, 208, 203, 117],
            [0.38431372549019605, 208, 205, 120],
            [0.38823529411764707, 209, 207, 123],
            [0.39215686274509803, 209, 208, 126],
            [0.396078431372549, 209, 210, 129],
            [0.4, 210, 212, 132],
            [0.403921568627451, 210, 213, 134],
            [0.40784313725490196, 210, 215, 137],
            [0.4117647058823529, 210, 216, 140],
            [0.4156862745098039, 210, 218, 143],
            [0.4196078431372549, 210, 219, 146],
            [0.4235294117647059, 210, 220, 149],
            [0.42745098039215684, 209, 222, 152],
            [0.43137254901960786, 209, 223, 155],
            [0.43529411764705883, 209, 224, 157],
            [0.4392156862745098, 208, 225, 160],
            [0.44313725490196076, 208, 226, 163],
            [0.44705882352941173, 207, 227, 165],
            [0.45098039215686275, 206, 228, 168],
            [0.4549019607843137, 206, 229, 170],
            [0.4588235294117647, 205, 230, 173],
            [0.4627450980392157, 204, 230, 175],
            [0.4666666666666667, 203, 231, 177],
            [0.47058823529411764, 202, 231, 180],
            [0.4745098039215686, 201, 232, 182],
            [0.4784313725490196, 200, 232, 184],
            [0.4823529411764706, 199, 233, 186],
            [0.48627450980392156, 197, 233, 188],
            [0.49019607843137253, 196, 233, 190],
            [0.49411764705882355, 194, 234, 191],
            [0.4980392156862745, 193, 234, 193],
            [0.5019607843137255, 191, 234, 195],
            [0.5058823529411764, 190, 234, 196],
            [0.5098039215686274, 188, 234, 198],
            [0.5137254901960784, 186, 234, 199],
            [0.5176470588235293, 185, 234, 201],
            [0.5215686274509804, 183, 233, 202],
            [0.5254901960784314, 181, 233, 203],
            [0.5294117647058824, 179, 233, 204],
            [0.5333333333333333, 177, 232, 205],
            [0.5372549019607843, 175, 232, 206],
            [0.5411764705882353, 173, 231, 207],
            [0.5450980392156862, 170, 231, 208],
            [0.5490196078431373, 168, 230, 209],
            [0.5529411764705883, 166, 230, 210],
            [0.5568627450980392, 164, 229, 211],
            [0.5607843137254902, 161, 228, 211],
            [0.5647058823529412, 159, 227, 212],
            [0.5686274509803921, 156, 226, 212],
            [0.5725490196078431, 154, 226, 213],
            [0.5764705882352941, 152, 225, 213],
            [0.580392156862745, 149, 224, 214],
            [0.5843137254901961, 146, 223, 214],
            [0.5882352941176471, 144, 221, 214],
            [0.592156862745098, 141, 220, 214],
            [0.596078431372549, 139, 219, 214],
            [0.6, 136, 218, 215],
            [0.6039215686274509, 133, 217, 215],
            [0.6078431372549019, 131, 215, 215],
            [0.611764705882353, 128, 214, 215],
            [0.615686274509804, 126, 213, 215],
            [0.6196078431372549, 123, 211, 215],
            [0.6235294117647059, 120, 210, 214],
            [0.6274509803921569, 118, 208, 214],
            [0.6313725490196078, 115, 207, 214],
            [0.6352941176470588, 112, 205, 214],
            [0.6392156862745098, 110, 204, 213],
            [0.6431372549019607, 107, 202, 213],
            [0.6470588235294118, 105, 201, 213],
            [0.6509803921568628, 102, 199, 212],
            [0.6549019607843137, 100, 197, 212],
            [0.6588235294117647, 98, 196, 212],
            [0.6627450980392157, 95, 194, 211],
            [0.6666666666666666, 93, 192, 211],
            [0.6705882352941176, 91, 191, 210],
            [0.6745098039215687, 88, 189, 210],
            [0.6784313725490196, 86, 187, 209],
            [0.6823529411764706, 84, 186, 209],
            [0.6862745098039216, 82, 184, 208],
            [0.6901960784313725, 80, 182, 208],
            [0.6941176470588235, 78, 180, 207],
            [0.6980392156862745, 76, 179, 206],
            [0.7019607843137254, 74, 177, 206],
            [0.7058823529411764, 73, 175, 205],
            [0.7098039215686275, 71, 174, 205],
            [0.7137254901960784, 69, 172, 204],
            [0.7176470588235294, 68, 170, 203],
            [0.7215686274509804, 66, 168, 203],
            [0.7254901960784313, 65, 167, 202],
            [0.7294117647058823, 63, 165, 201],
            [0.7333333333333333, 62, 163, 201],
            [0.7372549019607844, 60, 162, 200],
            [0.7411764705882353, 59, 160, 199],
            [0.7450980392156863, 58, 158, 199],
            [0.7490196078431373, 57, 157, 198],
            [0.7529411764705882, 56, 155, 197],
            [0.7568627450980392, 55, 154, 197],
            [0.7607843137254902, 53, 152, 196],
            [0.7647058823529411, 52, 150, 195],
            [0.7686274509803921, 51, 149, 195],
            [0.7725490196078432, 50, 147, 194],
            [0.7764705882352941, 50, 145, 193],
            [0.7803921568627451, 49, 144, 193],
            [0.7843137254901961, 48, 142, 192],
            [0.788235294117647, 47, 141, 191],
            [0.792156862745098, 46, 139, 191],
            [0.796078431372549, 46, 138, 190],
            [0.8, 45, 136, 189],
            [0.803921568627451, 44, 134, 189],
            [0.807843137254902, 43, 133, 188],
            [0.8117647058823529, 43, 131, 188],
            [0.8156862745098039, 42, 130, 187],
            [0.8196078431372549, 41, 128, 186],
            [0.8235294117647058, 41, 127, 186],
            [0.8274509803921568, 40, 125, 185],
            [0.8313725490196078, 40, 123, 184],
            [0.8352941176470589, 39, 122, 184],
            [0.8392156862745098, 39, 120, 183],
            [0.8431372549019608, 38, 119, 182],
            [0.8470588235294118, 37, 117, 181],
            [0.8509803921568627, 37, 116, 181],
            [0.8549019607843137, 36, 114, 180],
            [0.8588235294117647, 36, 112, 179],
            [0.8627450980392157, 35, 111, 179],
            [0.8666666666666667, 35, 109, 178],
            [0.8705882352941177, 34, 108, 177],
            [0.8745098039215686, 34, 106, 177],
            [0.8784313725490196, 33, 104, 176],
            [0.8823529411764706, 33, 103, 175],
            [0.8862745098039215, 32, 101, 175],
            [0.8901960784313725, 32, 99, 174],
            [0.8941176470588235, 31, 98, 173],
            [0.8980392156862745, 30, 96, 172],
            [0.9019607843137255, 30, 94, 172],
            [0.9058823529411765, 29, 93, 171],
            [0.9098039215686274, 29, 91, 170],
            [0.9137254901960784, 28, 89, 169],
            [0.9176470588235294, 28, 87, 169],
            [0.9215686274509803, 27, 86, 168],
            [0.9254901960784314, 26, 84, 167],
            [0.9294117647058824, 25, 82, 166],
            [0.9333333333333333, 25, 80, 166],
            [0.9372549019607843, 24, 79, 165],
            [0.9411764705882353, 23, 77, 164],
            [0.9450980392156862, 22, 75, 163],
            [0.9490196078431372, 22, 73, 162],
            [0.9529411764705882, 21, 71, 162],
            [0.9568627450980391, 20, 70, 161],
            [0.9607843137254902, 19, 68, 160],
            [0.9647058823529412, 17, 66, 159],
            [0.9686274509803922, 16, 64, 158],
            [0.9725490196078431, 15, 62, 158],
            [0.9764705882352941, 14, 60, 157],
            [0.9803921568627451, 12, 58, 156],
            [0.984313725490196, 10, 56, 155],
            [0.9882352941176471, 8, 54, 154],
            [0.9921568627450981, 6, 52, 153],
            [0.996078431372549, 4, 50, 153],
            [1.0, 2, 48, 152],
        ],
    },
    {
        "name": "tofino (Div)",
        "discrete": False,
        "colors": [
            [0.0, 221, 216, 254],
            [0.00392156862745098, 219, 214, 253],
            [0.00784313725490196, 216, 212, 252],
            [0.011764705882352941, 213, 210, 251],
            [0.01568627450980392, 211, 209, 250],
            [0.0196078431372549, 208, 207, 249],
            [0.023529411764705882, 205, 205, 247],
            [0.027450980392156862, 203, 203, 246],
            [0.03137254901960784, 200, 201, 245],
            [0.03529411764705882, 197, 199, 244],
            [0.0392156862745098, 194, 197, 243],
            [0.043137254901960784, 192, 195, 242],
            [0.047058823529411764, 189, 194, 240],
            [0.050980392156862744, 186, 192, 239],
            [0.054901960784313725, 184, 190, 238],
            [0.058823529411764705, 181, 188, 237],
            [0.06274509803921569, 178, 186, 236],
            [0.06666666666666667, 176, 184, 235],
            [0.07058823529411765, 173, 182, 233],
            [0.07450980392156863, 170, 180, 232],
            [0.0784313725490196, 168, 179, 231],
            [0.08235294117647059, 165, 177, 230],
            [0.08627450980392157, 162, 175, 229],
            [0.09019607843137255, 160, 173, 228],
            [0.09411764705882353, 157, 171, 226],
            [0.09803921568627451, 154, 169, 225],
            [0.10196078431372549, 152, 167, 224],
            [0.10588235294117647, 149, 166, 223],
            [0.10980392156862745, 146, 164, 222],
            [0.11372549019607843, 144, 162, 221],
            [0.11764705882352941, 141, 160, 219],
            [0.12156862745098039, 139, 158, 218],
            [0.12549019607843137, 136, 156, 217],
            [0.12941176470588234, 133, 154, 216],
            [0.13333333333333333, 131, 152, 214],
            [0.13725490196078433, 128, 150, 213],
            [0.1411764705882353, 125, 149, 212],
            [0.14509803921568626, 123, 147, 210],
            [0.14901960784313725, 120, 145, 209],
            [0.15294117647058825, 117, 143, 207],
            [0.1568627450980392, 115, 141, 206],
            [0.16078431372549018, 112, 139, 204],
            [0.16470588235294117, 110, 137, 203],
            [0.16862745098039217, 107, 135, 201],
            [0.17254901960784313, 104, 133, 200],
            [0.1764705882352941, 102, 131, 198],
            [0.1803921568627451, 99, 129, 196],
            [0.1843137254901961, 97, 127, 194],
            [0.18823529411764706, 94, 125, 192],
            [0.19215686274509802, 92, 123, 190],
            [0.19607843137254902, 89, 121, 188],
            [0.2, 87, 119, 186],
            [0.20392156862745098, 85, 117, 184],
            [0.20784313725490194, 82, 115, 182],
            [0.21176470588235294, 80, 113, 179],
            [0.21568627450980393, 78, 111, 177],
            [0.2196078431372549, 76, 109, 174],
            [0.22352941176470587, 74, 107, 172],
            [0.22745098039215686, 72, 105, 169],
            [0.23137254901960785, 70, 103, 167],
            [0.23529411764705882, 68, 101, 164],
            [0.2392156862745098, 67, 99, 162],
            [0.24313725490196078, 65, 97, 159],
            [0.24705882352941178, 64, 95, 157],
            [0.25098039215686274, 62, 93, 154],
            [0.2549019607843137, 61, 92, 151],
            [0.2588235294117647, 59, 90, 149],
            [0.2627450980392157, 58, 88, 146],
            [0.26666666666666666, 57, 87, 143],
            [0.27058823529411763, 55, 85, 141],
            [0.27450980392156865, 54, 83, 138],
            [0.2784313725490196, 53, 82, 136],
            [0.2823529411764706, 52, 80, 133],
            [0.28627450980392155, 51, 78, 130],
            [0.2901960784313725, 50, 77, 128],
            [0.29411764705882354, 49, 75, 125],
            [0.2980392156862745, 47, 74, 123],
            [0.30196078431372547, 46, 72, 120],
            [0.3058823529411765, 45, 70, 118],
            [0.30980392156862746, 44, 69, 115],
            [0.3137254901960784, 43, 67, 113],
            [0.3176470588235294, 42, 66, 110],
            [0.32156862745098036, 41, 64, 108],
            [0.3254901960784314, 41, 63, 105],
            [0.32941176470588235, 40, 61, 103],
            [0.3333333333333333, 39, 60, 100],
            [0.33725490196078434, 38, 58, 98],
            [0.3411764705882353, 37, 57, 95],
            [0.34509803921568627, 36, 56, 93],
            [0.34901960784313724, 35, 54, 90],
            [0.3529411764705882, 34, 53, 88],
            [0.3568627450980392, 33, 51, 86],
            [0.3607843137254902, 32, 50, 83],
            [0.36470588235294116, 31, 48, 81],
            [0.3686274509803922, 30, 47, 79],
            [0.37254901960784315, 30, 46, 76],
            [0.3764705882352941, 29, 44, 74],
            [0.3803921568627451, 28, 43, 72],
            [0.38431372549019605, 27, 42, 69],
            [0.38823529411764707, 26, 40, 67],
            [0.39215686274509803, 26, 39, 65],
            [0.396078431372549, 25, 38, 62],
            [0.4, 24, 36, 60],
            [0.403921568627451, 23, 35, 58],
            [0.40784313725490196, 23, 34, 56],
            [0.4117647058823529, 22, 33, 54],
            [0.4156862745098039, 21, 32, 52],
            [0.4196078431372549, 21, 31, 50],
            [0.4235294117647059, 20, 29, 47],
            [0.42745098039215684, 19, 28, 45],
            [0.43137254901960786, 19, 27, 43],
            [0.43529411764705883, 18, 26, 42],
            [0.4392156862745098, 18, 26, 40],
            [0.44313725490196076, 17, 25, 38],
            [0.44705882352941173, 17, 24, 36],
            [0.45098039215686275, 16, 23, 34],
            [0.4549019607843137, 16, 23, 33],
            [0.4588235294117647, 16, 22, 31],
            [0.4627450980392157, 15, 21, 30],
            [0.4666666666666667, 15, 21, 28],
            [0.47058823529411764, 14, 21, 27],
            [0.4745098039215686, 14, 20, 26],
            [0.4784313725490196, 13, 20, 24],
            [0.4823529411764706, 13, 20, 23],
            [0.48627450980392156, 12, 20, 22],
            [0.49019607843137253, 12, 20, 21],
            [0.49411764705882355, 12, 20, 20],
            [0.4980392156862745, 12, 21, 20],
            [0.5019607843137255, 12, 21, 19],
            [0.5058823529411764, 12, 22, 18],
            [0.5098039215686274, 12, 22, 18],
            [0.5137254901960784, 13, 23, 17],
            [0.5176470588235293, 13, 24, 17],
            [0.5215686274509804, 13, 24, 17],
            [0.5254901960784314, 14, 25, 17],
            [0.5294117647058824, 14, 26, 17],
            [0.5333333333333333, 15, 27, 17],
            [0.5372549019607843, 15, 28, 17],
            [0.5411764705882353, 16, 29, 18],
            [0.5450980392156862, 16, 30, 18],
            [0.5490196078431373, 17, 31, 18],
            [0.5529411764705883, 17, 32, 19],
            [0.5568627450980392, 17, 34, 19],
            [0.5607843137254902, 18, 35, 20],
            [0.5647058823529412, 18, 36, 20],
            [0.5686274509803921, 19, 38, 21],
            [0.5725490196078431, 19, 39, 21],
            [0.5764705882352941, 20, 40, 22],
            [0.580392156862745, 20, 42, 22],
            [0.5843137254901961, 21, 43, 23],
            [0.5882352941176471, 21, 45, 24],
            [0.592156862745098, 22, 46, 24],
            [0.596078431372549, 23, 48, 25],
            [0.6, 23, 49, 26],
            [0.6039215686274509, 24, 51, 26],
            [0.6078431372549019, 25, 52, 27],
            [0.611764705882353, 25, 54, 28],
            [0.615686274509804, 26, 55, 29],
            [0.6196078431372549, 27, 57, 29],
            [0.6235294117647059, 27, 59, 30],
            [0.6274509803921569, 28, 60, 31],
            [0.6313725490196078, 29, 62, 32],
            [0.6352941176470588, 30, 63, 33],
            [0.6392156862745098, 30, 65, 34],
            [0.6431372549019607, 31, 67, 34],
            [0.6470588235294118, 32, 68, 35],
            [0.6509803921568628, 33, 70, 36],
            [0.6549019607843137, 33, 72, 37],
            [0.6588235294117647, 34, 73, 38],
            [0.6627450980392157, 35, 75, 39],
            [0.6666666666666666, 36, 77, 40],
            [0.6705882352941176, 36, 79, 40],
            [0.6745098039215687, 37, 80, 41],
            [0.6784313725490196, 38, 82, 42],
            [0.6823529411764706, 39, 84, 43],
            [0.6862745098039216, 40, 86, 44],
            [0.6901960784313725, 41, 87, 45],
            [0.6941176470588235, 41, 89, 46],
            [0.6980392156862745, 42, 91, 47],
            [0.7019607843137254, 43, 93, 48],
            [0.7058823529411764, 44, 94, 49],
            [0.7098039215686275, 45, 96, 50],
            [0.7137254901960784, 46, 98, 50],
            [0.7176470588235294, 46, 100, 51],
            [0.7215686274509804, 47, 102, 52],
            [0.7254901960784313, 48, 103, 53],
            [0.7294117647058823, 49, 105, 54],
            [0.7333333333333333, 50, 107, 55],
            [0.7372549019607844, 51, 109, 56],
            [0.7411764705882353, 52, 111, 57],
            [0.7450980392156863, 53, 113, 58],
            [0.7490196078431373, 54, 115, 59],
            [0.7529411764705882, 55, 117, 60],
            [0.7568627450980392, 56, 118, 61],
            [0.7607843137254902, 58, 120, 62],
            [0.7647058823529411, 59, 122, 64],
            [0.7686274509803921, 60, 124, 65],
            [0.7725490196078432, 61, 126, 66],
            [0.7764705882352941, 63, 128, 67],
            [0.7803921568627451, 64, 130, 68],
            [0.7843137254901961, 66, 132, 69],
            [0.788235294117647, 68, 134, 71],
            [0.792156862745098, 69, 136, 72],
            [0.796078431372549, 71, 138, 73],
            [0.8, 73, 141, 75],
            [0.803921568627451, 75, 143, 76],
            [0.807843137254902, 77, 145, 78],
            [0.8117647058823529, 79, 147, 79],
            [0.8156862745098039, 82, 149, 80],
            [0.8196078431372549, 84, 151, 82],
            [0.8235294117647058, 87, 153, 84],
            [0.8274509803921568, 89, 155, 85],
            [0.8313725490196078, 92, 157, 87],
            [0.8352941176470589, 94, 159, 88],
            [0.8392156862745098, 97, 161, 90],
            [0.8431372549019608, 100, 163, 91],
            [0.8470588235294118, 103, 165, 93],
            [0.8509803921568627, 105, 167, 95],
            [0.8549019607843137, 108, 169, 96],
            [0.8588235294117647, 111, 171, 98],
            [0.8627450980392157, 114, 173, 100],
            [0.8666666666666667, 117, 174, 101],
            [0.8705882352941177, 120, 176, 103],
            [0.8745098039215686, 123, 178, 105],
            [0.8784313725490196, 126, 180, 106],
            [0.8823529411764706, 129, 182, 108],
            [0.8862745098039215, 132, 183, 109],
            [0.8901960784313725, 135, 185, 111],
            [0.8941176470588235, 138, 187, 113],
            [0.8980392156862745, 141, 188, 114],
            [0.9019607843137255, 144, 190, 116],
            [0.9058823529411765, 147, 191, 117],
            [0.9098039215686274, 150, 193, 119],
            [0.9137254901960784, 153, 195, 121],
            [0.9176470588235294, 156, 196, 122],
            [0.9215686274509803, 159, 198, 124],
            [0.9254901960784314, 162, 199, 125],
            [0.9294117647058824, 165, 201, 127],
            [0.9333333333333333, 168, 203, 128],
            [0.9372549019607843, 171, 204, 130],
            [0.9411764705882353, 174, 206, 132],
            [0.9450980392156862, 177, 207, 133],
            [0.9490196078431372, 180, 209, 135],
            [0.9529411764705882, 183, 210, 136],
            [0.9568627450980391, 186, 212, 138],
            [0.9607843137254902, 189, 214, 139],
            [0.9647058823529412, 192, 215, 141],
            [0.9686274509803922, 195, 217, 143],
            [0.9725490196078431, 198, 218, 144],
            [0.9764705882352941, 201, 220, 146],
            [0.9803921568627451, 204, 221, 147],
            [0.984313725490196, 207, 223, 149],
            [0.9882352941176471, 210, 224, 150],
            [0.9921568627450981, 213, 226, 152],
            [0.996078431372549, 216, 227, 153],
            [1.0, 219, 229, 155],
        ],
    },
    {
        "name": "tokyo (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 26, 14, 51],
            [0.00392156862745098, 27, 15, 52],
            [0.00784313725490196, 29, 15, 53],
            [0.011764705882352941, 31, 16, 54],
            [0.01568627450980392, 32, 16, 54],
            [0.0196078431372549, 34, 17, 55],
            [0.023529411764705882, 35, 17, 56],
            [0.027450980392156862, 37, 18, 57],
            [0.03137254901960784, 38, 18, 58],
            [0.03529411764705882, 40, 19, 59],
            [0.0392156862745098, 41, 19, 59],
            [0.043137254901960784, 43, 20, 60],
            [0.047058823529411764, 44, 20, 61],
            [0.050980392156862744, 46, 21, 62],
            [0.054901960784313725, 47, 21, 63],
            [0.058823529411764705, 49, 22, 64],
            [0.06274509803921569, 50, 23, 65],
            [0.06666666666666667, 52, 23, 66],
            [0.07058823529411765, 53, 24, 66],
            [0.07450980392156863, 55, 24, 67],
            [0.0784313725490196, 56, 25, 68],
            [0.08235294117647059, 58, 26, 69],
            [0.08627450980392157, 59, 27, 70],
            [0.09019607843137255, 61, 27, 71],
            [0.09411764705882353, 62, 28, 72],
            [0.09803921568627451, 64, 29, 73],
            [0.10196078431372549, 65, 29, 74],
            [0.10588235294117647, 67, 30, 75],
            [0.10980392156862745, 68, 31, 76],
            [0.11372549019607843, 70, 32, 77],
            [0.11764705882352941, 72, 33, 78],
            [0.12156862745098039, 73, 34, 78],
            [0.12549019607843137, 75, 34, 79],
            [0.12941176470588234, 76, 35, 80],
            [0.13333333333333333, 78, 36, 81],
            [0.13725490196078433, 79, 37, 82],
            [0.1411764705882353, 81, 38, 83],
            [0.14509803921568626, 82, 39, 84],
            [0.14901960784313725, 84, 40, 85],
            [0.15294117647058825, 85, 41, 86],
            [0.1568627450980392, 87, 42, 87],
            [0.16078431372549018, 88, 43, 88],
            [0.16470588235294117, 90, 44, 89],
            [0.16862745098039217, 91, 45, 90],
            [0.17254901960784313, 93, 46, 91],
            [0.1764705882352941, 94, 48, 92],
            [0.1803921568627451, 96, 49, 93],
            [0.1843137254901961, 97, 50, 94],
            [0.18823529411764706, 98, 51, 95],
            [0.19215686274509802, 100, 52, 95],
            [0.19607843137254902, 101, 53, 96],
            [0.2, 102, 54, 97],
            [0.20392156862745098, 104, 56, 98],
            [0.20784313725490194, 105, 57, 99],
            [0.21176470588235294, 106, 58, 100],
            [0.21568627450980393, 107, 59, 101],
            [0.2196078431372549, 109, 60, 102],
            [0.22352941176470587, 110, 62, 102],
            [0.22745098039215686, 111, 63, 103],
            [0.23137254901960785, 112, 64, 104],
            [0.23529411764705882, 113, 65, 105],
            [0.2392156862745098, 114, 66, 106],
            [0.24313725490196078, 115, 68, 106],
            [0.24705882352941178, 116, 69, 107],
            [0.25098039215686274, 117, 70, 108],
            [0.2549019607843137, 118, 71, 108],
            [0.2588235294117647, 119, 72, 109],
            [0.2627450980392157, 120, 73, 110],
            [0.26666666666666666, 121, 75, 111],
            [0.27058823529411763, 122, 76, 111],
            [0.27450980392156865, 123, 77, 112],
            [0.2784313725490196, 124, 78, 112],
            [0.2823529411764706, 124, 79, 113],
            [0.28627450980392155, 125, 80, 114],
            [0.2901960784313725, 126, 82, 114],
            [0.29411764705882354, 126, 83, 115],
            [0.2980392156862745, 127, 84, 115],
            [0.30196078431372547, 128, 85, 116],
            [0.3058823529411765, 128, 86, 116],
            [0.30980392156862746, 129, 87, 117],
            [0.3137254901960784, 130, 88, 117],
            [0.3176470588235294, 130, 89, 118],
            [0.32156862745098036, 131, 90, 118],
            [0.3254901960784314, 131, 91, 119],
            [0.32941176470588235, 132, 93, 119],
            [0.3333333333333333, 132, 94, 120],
            [0.33725490196078434, 133, 95, 120],
            [0.3411764705882353, 133, 96, 121],
            [0.34509803921568627, 133, 97, 121],
            [0.34901960784313724, 134, 98, 121],
            [0.3529411764705882, 134, 99, 122],
            [0.3568627450980392, 135, 100, 122],
            [0.3607843137254902, 135, 101, 123],
            [0.36470588235294116, 135, 102, 123],
            [0.3686274509803922, 136, 103, 123],
            [0.37254901960784315, 136, 104, 124],
            [0.3764705882352941, 136, 105, 124],
            [0.3803921568627451, 137, 106, 124],
            [0.38431372549019605, 137, 107, 125],
            [0.38823529411764707, 137, 108, 125],
            [0.39215686274509803, 138, 109, 125],
            [0.396078431372549, 138, 110, 126],
            [0.4, 138, 111, 126],
            [0.403921568627451, 138, 111, 126],
            [0.40784313725490196, 139, 112, 127],
            [0.4117647058823529, 139, 113, 127],
            [0.4156862745098039, 139, 114, 127],
            [0.4196078431372549, 139, 115, 128],
            [0.4235294117647059, 139, 116, 128],
            [0.42745098039215684, 140, 117, 128],
            [0.43137254901960786, 140, 118, 129],
            [0.43529411764705883, 140, 119, 129],
            [0.4392156862745098, 140, 120, 129],
            [0.44313725490196076, 140, 121, 129],
            [0.44705882352941173, 141, 122, 130],
            [0.45098039215686275, 141, 123, 130],
            [0.4549019607843137, 141, 124, 130],
            [0.4588235294117647, 141, 125, 130],
            [0.4627450980392157, 141, 125, 131],
            [0.4666666666666667, 142, 126, 131],
            [0.47058823529411764, 142, 127, 131],
            [0.4745098039215686, 142, 128, 132],
            [0.4784313725490196, 142, 129, 132],
            [0.4823529411764706, 142, 130, 132],
            [0.48627450980392156, 142, 131, 132],
            [0.49019607843137253, 143, 132, 133],
            [0.49411764705882355, 143, 133, 133],
            [0.4980392156862745, 143, 134, 133],
            [0.5019607843137255, 143, 135, 133],
            [0.5058823529411764, 143, 135, 134],
            [0.5098039215686274, 143, 136, 134],
            [0.5137254901960784, 144, 137, 134],
            [0.5176470588235293, 144, 138, 134],
            [0.5215686274509804, 144, 139, 135],
            [0.5254901960784314, 144, 140, 135],
            [0.5294117647058824, 144, 141, 135],
            [0.5333333333333333, 144, 142, 135],
            [0.5372549019607843, 144, 143, 136],
            [0.5411764705882353, 145, 144, 136],
            [0.5450980392156862, 145, 145, 136],
            [0.5490196078431373, 145, 146, 136],
            [0.5529411764705883, 145, 146, 137],
            [0.5568627450980392, 145, 147, 137],
            [0.5607843137254902, 145, 148, 137],
            [0.5647058823529412, 146, 149, 137],
            [0.5686274509803921, 146, 150, 138],
            [0.5725490196078431, 146, 151, 138],
            [0.5764705882352941, 146, 152, 138],
            [0.580392156862745, 146, 153, 138],
            [0.5843137254901961, 146, 154, 139],
            [0.5882352941176471, 147, 155, 139],
            [0.592156862745098, 147, 156, 139],
            [0.596078431372549, 147, 157, 139],
            [0.6, 147, 157, 140],
            [0.6039215686274509, 147, 158, 140],
            [0.6078431372549019, 147, 159, 140],
            [0.611764705882353, 148, 160, 140],
            [0.615686274509804, 148, 161, 141],
            [0.6196078431372549, 148, 162, 141],
            [0.6235294117647059, 148, 163, 141],
            [0.6274509803921569, 148, 164, 142],
            [0.6313725490196078, 148, 165, 142],
            [0.6352941176470588, 149, 166, 142],
            [0.6392156862745098, 149, 167, 142],
            [0.6431372549019607, 149, 168, 143],
            [0.6470588235294118, 149, 169, 143],
            [0.6509803921568628, 150, 170, 143],
            [0.6549019607843137, 150, 171, 143],
            [0.6588235294117647, 150, 172, 144],
            [0.6627450980392157, 150, 173, 144],
            [0.6666666666666666, 151, 174, 144],
            [0.6705882352941176, 151, 175, 144],
            [0.6745098039215687, 151, 176, 145],
            [0.6784313725490196, 151, 177, 145],
            [0.6823529411764706, 152, 178, 145],
            [0.6862745098039216, 152, 179, 146],
            [0.6901960784313725, 152, 180, 146],
            [0.6941176470588235, 153, 181, 146],
            [0.6980392156862745, 153, 182, 147],
            [0.7019607843137254, 154, 183, 147],
            [0.7058823529411764, 154, 184, 147],
            [0.7098039215686275, 154, 185, 148],
            [0.7137254901960784, 155, 186, 148],
            [0.7176470588235294, 155, 187, 149],
            [0.7215686274509804, 156, 188, 149],
            [0.7254901960784313, 156, 189, 149],
            [0.7294117647058823, 157, 190, 150],
            [0.7333333333333333, 157, 192, 150],
            [0.7372549019607844, 158, 193, 151],
            [0.7411764705882353, 159, 194, 151],
            [0.7450980392156863, 159, 195, 152],
            [0.7490196078431373, 160, 196, 152],
            [0.7529411764705882, 161, 198, 153],
            [0.7568627450980392, 162, 199, 153],
            [0.7607843137254902, 163, 200, 154],
            [0.7647058823529411, 163, 201, 155],
            [0.7686274509803921, 164, 203, 155],
            [0.7725490196078432, 165, 204, 156],
            [0.7764705882352941, 166, 205, 157],
            [0.7803921568627451, 168, 206, 157],
            [0.7843137254901961, 169, 208, 158],
            [0.788235294117647, 170, 209, 159],
            [0.792156862745098, 171, 210, 160],
            [0.796078431372549, 172, 212, 161],
            [0.8, 174, 213, 162],
            [0.803921568627451, 175, 215, 163],
            [0.807843137254902, 176, 216, 163],
            [0.8117647058823529, 178, 217, 164],
            [0.8156862745098039, 179, 219, 165],
            [0.8196078431372549, 181, 220, 166],
            [0.8235294117647058, 183, 221, 168],
            [0.8274509803921568, 184, 223, 169],
            [0.8313725490196078, 186, 224, 170],
            [0.8352941176470589, 188, 226, 171],
            [0.8392156862745098, 189, 227, 172],
            [0.8431372549019608, 191, 228, 173],
            [0.8470588235294118, 193, 229, 174],
            [0.8509803921568627, 195, 231, 175],
            [0.8549019607843137, 196, 232, 177],
            [0.8588235294117647, 198, 233, 178],
            [0.8627450980392157, 200, 234, 179],
            [0.8666666666666667, 202, 235, 180],
            [0.8705882352941177, 204, 236, 181],
            [0.8745098039215686, 206, 237, 183],
            [0.8784313725490196, 207, 238, 184],
            [0.8823529411764706, 209, 239, 185],
            [0.8862745098039215, 211, 240, 186],
            [0.8901960784313725, 213, 241, 187],
            [0.8941176470588235, 215, 242, 189],
            [0.8980392156862745, 216, 243, 190],
            [0.9019607843137255, 218, 244, 191],
            [0.9058823529411765, 220, 244, 192],
            [0.9098039215686274, 221, 245, 193],
            [0.9137254901960784, 223, 246, 194],
            [0.9176470588235294, 225, 246, 195],
            [0.9215686274509803, 226, 247, 197],
            [0.9254901960784314, 228, 248, 198],
            [0.9294117647058824, 229, 248, 199],
            [0.9333333333333333, 231, 249, 200],
            [0.9372549019607843, 232, 249, 201],
            [0.9411764705882353, 234, 250, 202],
            [0.9450980392156862, 235, 250, 203],
            [0.9490196078431372, 237, 250, 204],
            [0.9529411764705882, 238, 251, 205],
            [0.9568627450980391, 240, 251, 206],
            [0.9607843137254902, 241, 251, 207],
            [0.9647058823529412, 242, 252, 208],
            [0.9686274509803922, 244, 252, 209],
            [0.9725490196078431, 245, 252, 210],
            [0.9764705882352941, 246, 253, 211],
            [0.9803921568627451, 247, 253, 211],
            [0.984313725490196, 249, 253, 212],
            [0.9882352941176471, 250, 253, 213],
            [0.9921568627450981, 251, 253, 214],
            [0.996078431372549, 253, 254, 215],
            [1.0, 254, 254, 216],
        ],
    },
    {
        "name": "turku (Seq)",
        "discrete": False,
        "colors": [
            [0.0, 0, 0, 0],
            [0.00392156862745098, 1, 1, 1],
            [0.00784313725490196, 3, 3, 3],
            [0.011764705882352941, 5, 5, 5],
            [0.01568627450980392, 7, 7, 6],
            [0.0196078431372549, 9, 9, 8],
            [0.023529411764705882, 11, 11, 10],
            [0.027450980392156862, 12, 12, 11],
            [0.03137254901960784, 14, 14, 13],
            [0.03529411764705882, 15, 15, 14],
            [0.0392156862745098, 17, 17, 15],
            [0.043137254901960784, 18, 18, 16],
            [0.047058823529411764, 19, 19, 18],
            [0.050980392156862744, 20, 20, 19],
            [0.054901960784313725, 21, 21, 20],
            [0.058823529411764705, 22, 22, 21],
            [0.06274509803921569, 23, 23, 22],
            [0.06666666666666667, 24, 24, 22],
            [0.07058823529411765, 25, 25, 23],
            [0.07450980392156863, 26, 26, 24],
            [0.0784313725490196, 27, 27, 25],
            [0.08235294117647059, 28, 28, 26],
            [0.08627450980392157, 29, 29, 27],
            [0.09019607843137255, 30, 30, 28],
            [0.09411764705882353, 31, 31, 28],
            [0.09803921568627451, 32, 32, 29],
            [0.10196078431372549, 33, 33, 30],
            [0.10588235294117647, 34, 34, 31],
            [0.10980392156862745, 35, 35, 32],
            [0.11372549019607843, 36, 36, 33],
            [0.11764705882352941, 38, 37, 33],
            [0.12156862745098039, 39, 38, 34],
            [0.12549019607843137, 40, 39, 35],
            [0.12941176470588234, 41, 41, 36],
            [0.13333333333333333, 42, 42, 37],
            [0.13725490196078433, 43, 43, 37],
            [0.1411764705882353, 44, 44, 38],
            [0.14509803921568626, 45, 45, 39],
            [0.14901960784313725, 46, 46, 40],
            [0.15294117647058825, 47, 47, 40],
            [0.1568627450980392, 48, 48, 41],
            [0.16078431372549018, 49, 49, 42],
            [0.16470588235294117, 50, 50, 43],
            [0.16862745098039217, 51, 51, 43],
            [0.17254901960784313, 52, 52, 44],
            [0.1764705882352941, 53, 53, 45],
            [0.1803921568627451, 54, 54, 46],
            [0.1843137254901961, 55, 55, 46],
            [0.18823529411764706, 56, 56, 47],
            [0.19215686274509802, 57, 57, 48],
            [0.19607843137254902, 58, 58, 48],
            [0.2, 60, 59, 49],
            [0.20392156862745098, 61, 60, 50],
            [0.20784313725490194, 62, 61, 50],
            [0.21176470588235294, 63, 62, 51],
            [0.21568627450980393, 64, 63, 52],
            [0.2196078431372549, 65, 64, 52],
            [0.22352941176470587, 66, 66, 53],
            [0.22745098039215686, 67, 67, 54],
            [0.23137254901960785, 68, 68, 54],
            [0.23529411764705882, 69, 69, 55],
            [0.2392156862745098, 70, 70, 55],
            [0.24313725490196078, 71, 71, 56],
            [0.24705882352941178, 72, 72, 57],
            [0.25098039215686274, 73, 73, 57],
            [0.2549019607843137, 74, 74, 58],
            [0.2588235294117647, 75, 75, 58],
            [0.2627450980392157, 76, 76, 59],
            [0.26666666666666666, 77, 77, 59],
            [0.27058823529411763, 78, 78, 60],
            [0.27450980392156865, 79, 79, 60],
            [0.2784313725490196, 80, 80, 61],
            [0.2823529411764706, 81, 81, 61],
            [0.28627450980392155, 82, 82, 62],
            [0.2901960784313725, 83, 83, 62],
            [0.29411764705882354, 84, 84, 63],
            [0.2980392156862745, 85, 85, 63],
            [0.30196078431372547, 86, 86, 64],
            [0.3058823529411765, 87, 87, 64],
            [0.30980392156862746, 88, 88, 65],
            [0.3137254901960784, 89, 89, 65],
            [0.3176470588235294, 90, 90, 66],
            [0.32156862745098036, 91, 91, 66],
            [0.3254901960784314, 92, 92, 67],
            [0.32941176470588235, 94, 93, 67],
            [0.3333333333333333, 95, 94, 68],
            [0.33725490196078434, 96, 95, 68],
            [0.3411764705882353, 97, 96, 69],
            [0.34509803921568627, 98, 97, 69],
            [0.34901960784313724, 99, 98, 70],
            [0.3529411764705882, 100, 99, 70],
            [0.3568627450980392, 101, 100, 71],
            [0.3607843137254902, 102, 101, 71],
            [0.36470588235294116, 103, 102, 71],
            [0.3686274509803922, 104, 103, 72],
            [0.37254901960784315, 105, 104, 72],
            [0.3764705882352941, 106, 105, 73],
            [0.3803921568627451, 107, 106, 73],
            [0.38431372549019605, 108, 107, 74],
            [0.38823529411764707, 109, 109, 74],
            [0.39215686274509803, 111, 110, 75],
            [0.396078431372549, 112, 111, 75],
            [0.4, 113, 112, 76],
            [0.403921568627451, 114, 113, 76],
            [0.40784313725490196, 115, 114, 77],
            [0.4117647058823529, 116, 115, 77],
            [0.4156862745098039, 117, 116, 78],
            [0.4196078431372549, 118, 117, 78],
            [0.4235294117647059, 120, 118, 79],
            [0.42745098039215684, 121, 119, 79],
            [0.43137254901960786, 122, 120, 80],
            [0.43529411764705883, 123, 121, 80],
            [0.4392156862745098, 124, 122, 81],
            [0.44313725490196076, 126, 123, 81],
            [0.44705882352941173, 127, 124, 82],
            [0.45098039215686275, 128, 125, 82],
            [0.4549019607843137, 130, 126, 83],
            [0.4588235294117647, 131, 128, 83],
            [0.4627450980392157, 132, 129, 84],
            [0.4666666666666667, 133, 130, 85],
            [0.47058823529411764, 135, 131, 85],
            [0.4745098039215686, 136, 132, 86],
            [0.4784313725490196, 138, 133, 86],
            [0.4823529411764706, 139, 134, 87],
            [0.48627450980392156, 140, 135, 88],
            [0.49019607843137253, 142, 136, 88],
            [0.49411764705882355, 143, 137, 89],
            [0.4980392156862745, 145, 138, 90],
            [0.5019607843137255, 146, 139, 90],
            [0.5058823529411764, 148, 140, 91],
            [0.5098039215686274, 149, 141, 92],
            [0.5137254901960784, 151, 142, 92],
            [0.5176470588235293, 152, 143, 93],
            [0.5215686274509804, 154, 144, 94],
            [0.5254901960784314, 155, 145, 95],
            [0.5294117647058824, 157, 146, 95],
            [0.5333333333333333, 158, 147, 96],
            [0.5372549019607843, 160, 148, 97],
            [0.5411764705882353, 162, 149, 98],
            [0.5450980392156862, 163, 150, 98],
            [0.5490196078431373, 165, 151, 99],
            [0.5529411764705883, 166, 151, 100],
            [0.5568627450980392, 168, 152, 101],
            [0.5607843137254902, 170, 153, 102],
            [0.5647058823529412, 171, 154, 102],
            [0.5686274509803921, 173, 155, 103],
            [0.5725490196078431, 174, 155, 104],
            [0.5764705882352941, 176, 156, 105],
            [0.580392156862745, 177, 157, 106],
            [0.5843137254901961, 179, 157, 106],
            [0.5882352941176471, 180, 158, 107],
            [0.592156862745098, 182, 159, 108],
            [0.596078431372549, 183, 159, 109],
            [0.6, 185, 160, 110],
            [0.6039215686274509, 186, 160, 110],
            [0.6078431372549019, 188, 161, 111],
            [0.611764705882353, 189, 161, 112],
            [0.615686274509804, 191, 162, 113],
            [0.6196078431372549, 192, 162, 114],
            [0.6235294117647059, 193, 162, 114],
            [0.6274509803921569, 195, 163, 115],
            [0.6313725490196078, 196, 163, 116],
            [0.6352941176470588, 197, 163, 117],
            [0.6392156862745098, 198, 164, 118],
            [0.6431372549019607, 200, 164, 118],
            [0.6470588235294118, 201, 164, 119],
            [0.6509803921568628, 202, 164, 120],
            [0.6549019607843137, 203, 165, 121],
            [0.6588235294117647, 204, 165, 121],
            [0.6627450980392157, 205, 165, 122],
            [0.6666666666666666, 207, 165, 123],
            [0.6705882352941176, 208, 165, 124],
            [0.6745098039215687, 209, 166, 125],
            [0.6784313725490196, 210, 166, 125],
            [0.6823529411764706, 211, 166, 126],
            [0.6862745098039216, 212, 166, 127],
            [0.6901960784313725, 213, 166, 128],
            [0.6941176470588235, 214, 166, 129],
            [0.6980392156862745, 215, 167, 130],
            [0.7019607843137254, 216, 167, 131],
            [0.7058823529411764, 217, 167, 131],
            [0.7098039215686275, 218, 167, 132],
            [0.7137254901960784, 219, 167, 133],
            [0.7176470588235294, 220, 167, 134],
            [0.7215686274509804, 221, 168, 135],
            [0.7254901960784313, 222, 168, 136],
            [0.7294117647058823, 223, 168, 137],
            [0.7333333333333333, 224, 168, 138],
            [0.7372549019607844, 225, 169, 139],
            [0.7411764705882353, 226, 169, 140],
            [0.7450980392156863, 227, 169, 142],
            [0.7490196078431373, 228, 170, 143],
            [0.7529411764705882, 228, 170, 144],
            [0.7568627450980392, 229, 170, 145],
            [0.7607843137254902, 230, 171, 146],
            [0.7647058823529411, 231, 171, 148],
            [0.7686274509803921, 232, 172, 149],
            [0.7725490196078432, 233, 172, 150],
            [0.7764705882352941, 234, 173, 152],
            [0.7803921568627451, 235, 173, 153],
            [0.7843137254901961, 236, 174, 154],
            [0.788235294117647, 236, 175, 156],
            [0.792156862745098, 237, 175, 157],
            [0.796078431372549, 238, 176, 159],
            [0.8, 239, 177, 160],
            [0.803921568627451, 240, 177, 161],
            [0.807843137254902, 240, 178, 163],
            [0.8117647058823529, 241, 179, 164],
            [0.8156862745098039, 242, 180, 166],
            [0.8196078431372549, 243, 181, 168],
            [0.8235294117647058, 243, 181, 169],
            [0.8274509803921568, 244, 182, 171],
            [0.8313725490196078, 245, 183, 172],
            [0.8352941176470589, 245, 184, 174],
            [0.8392156862745098, 246, 185, 175],
            [0.8431372549019608, 246, 186, 177],
            [0.8470588235294118, 247, 187, 178],
            [0.8509803921568627, 247, 188, 180],
            [0.8549019607843137, 248, 189, 181],
            [0.8588235294117647, 248, 190, 183],
            [0.8627450980392157, 249, 191, 184],
            [0.8666666666666667, 249, 192, 186],
            [0.8705882352941177, 250, 193, 187],
            [0.8745098039215686, 250, 194, 189],
            [0.8784313725490196, 251, 196, 190],
            [0.8823529411764706, 251, 197, 192],
            [0.8862745098039215, 251, 198, 193],
            [0.8901960784313725, 251, 199, 194],
            [0.8941176470588235, 252, 200, 196],
            [0.8980392156862745, 252, 201, 197],
            [0.9019607843137255, 252, 202, 198],
            [0.9058823529411765, 253, 203, 200],
            [0.9098039215686274, 253, 204, 201],
            [0.9137254901960784, 253, 205, 202],
            [0.9176470588235294, 253, 206, 204],
            [0.9215686274509803, 253, 208, 205],
            [0.9254901960784314, 253, 209, 206],
            [0.9294117647058824, 254, 210, 208],
            [0.9333333333333333, 254, 211, 209],
            [0.9372549019607843, 254, 212, 210],
            [0.9411764705882353, 254, 213, 211],
            [0.9450980392156862, 254, 214, 213],
            [0.9490196078431372, 254, 215, 214],
            [0.9529411764705882, 254, 216, 215],
            [0.9568627450980391, 254, 217, 216],
            [0.9607843137254902, 254, 219, 217],
            [0.9647058823529412, 254, 220, 219],
            [0.9686274509803922, 254, 221, 220],
            [0.9725490196078431, 254, 222, 221],
            [0.9764705882352941, 254, 223, 222],
            [0.9803921568627451, 254, 224, 223],
            [0.984313725490196, 254, 225, 224],
            [0.9882352941176471, 254, 226, 226],
            [0.9921568627450981, 255, 227, 227],
            [0.996078431372549, 255, 228, 228],
            [1.0, 255, 229, 229],
        ],
    },
    {
        "name": "vanimo (Div)",
        "discrete": False,
        "colors": [
            [0.0, 255, 204, 252],
            [0.00392156862745098, 253, 201, 250],
            [0.00784313725490196, 251, 199, 248],
            [0.011764705882352941, 250, 196, 246],
            [0.01568627450980392, 248, 193, 244],
            [0.0196078431372549, 247, 190, 242],
            [0.023529411764705882, 245, 187, 240],
            [0.027450980392156862, 244, 184, 238],
            [0.03137254901960784, 242, 181, 236],
            [0.03529411764705882, 241, 178, 233],
            [0.0392156862745098, 239, 176, 231],
            [0.043137254901960784, 237, 173, 229],
            [0.047058823529411764, 236, 170, 227],
            [0.050980392156862744, 234, 167, 225],
            [0.054901960784313725, 233, 165, 223],
            [0.058823529411764705, 231, 162, 221],
            [0.06274509803921569, 230, 159, 219],
            [0.06666666666666667, 228, 157, 217],
            [0.07058823529411765, 227, 154, 215],
            [0.07450980392156863, 225, 151, 213],
            [0.0784313725490196, 223, 149, 211],
            [0.08235294117647059, 222, 146, 209],
            [0.08627450980392157, 220, 144, 207],
            [0.09019607843137255, 219, 141, 205],
            [0.09411764705882353, 217, 139, 203],
            [0.09803921568627451, 216, 136, 202],
            [0.10196078431372549, 214, 134, 200],
            [0.10588235294117647, 212, 131, 198],
            [0.10980392156862745, 211, 129, 196],
            [0.11372549019607843, 209, 126, 194],
            [0.11764705882352941, 208, 124, 192],
            [0.12156862745098039, 206, 122, 190],
            [0.12549019607843137, 204, 119, 188],
            [0.12941176470588234, 203, 117, 186],
            [0.13333333333333333, 201, 115, 184],
            [0.13725490196078433, 200, 113, 183],
            [0.1411764705882353, 198, 111, 181],
            [0.14509803921568626, 196, 108, 179],
            [0.14901960784313725, 195, 106, 177],
            [0.15294117647058825, 193, 104, 175],
            [0.1568627450980392, 191, 102, 173],
            [0.16078431372549018, 190, 100, 172],
            [0.16470588235294117, 188, 98, 170],
            [0.16862745098039217, 186, 96, 168],
            [0.17254901960784313, 185, 95, 166],
            [0.1764705882352941, 183, 93, 164],
            [0.1803921568627451, 181, 91, 162],
            [0.1843137254901961, 180, 89, 161],
            [0.18823529411764706, 178, 87, 159],
            [0.19215686274509802, 176, 86, 157],
            [0.19607843137254902, 174, 84, 155],
            [0.2, 172, 82, 153],
            [0.20392156862745098, 171, 81, 152],
            [0.20784313725490194, 169, 79, 150],
            [0.21176470588235294, 167, 77, 148],
            [0.21568627450980393, 165, 76, 146],
            [0.2196078431372549, 163, 74, 144],
            [0.22352941176470587, 161, 73, 142],
            [0.22745098039215686, 159, 71, 140],
            [0.23137254901960785, 157, 69, 138],
            [0.23529411764705882, 154, 68, 136],
            [0.2392156862745098, 152, 66, 134],
            [0.24313725490196078, 150, 65, 132],
            [0.24705882352941178, 148, 63, 129],
            [0.25098039215686274, 145, 62, 127],
            [0.2549019607843137, 143, 60, 125],
            [0.2588235294117647, 141, 59, 123],
            [0.2627450980392157, 138, 58, 121],
            [0.26666666666666666, 136, 56, 118],
            [0.27058823529411763, 133, 55, 116],
            [0.27450980392156865, 131, 53, 114],
            [0.2784313725490196, 128, 52, 112],
            [0.2823529411764706, 126, 51, 109],
            [0.28627450980392155, 123, 50, 107],
            [0.2901960784313725, 121, 48, 105],
            [0.29411764705882354, 118, 47, 102],
            [0.2980392156862745, 115, 46, 100],
            [0.30196078431372547, 113, 45, 98],
            [0.3058823529411765, 110, 43, 95],
            [0.30980392156862746, 107, 42, 93],
            [0.3137254901960784, 105, 41, 90],
            [0.3176470588235294, 102, 40, 88],
            [0.32156862745098036, 99, 39, 86],
            [0.3254901960784314, 97, 38, 83],
            [0.32941176470588235, 94, 37, 81],
            [0.3333333333333333, 91, 36, 79],
            [0.33725490196078434, 89, 35, 76],
            [0.3411764705882353, 86, 34, 74],
            [0.34509803921568627, 83, 33, 72],
            [0.34901960784313724, 81, 32, 69],
            [0.3529411764705882, 78, 31, 67],
            [0.3568627450980392, 76, 30, 65],
            [0.3607843137254902, 73, 30, 63],
            [0.36470588235294116, 70, 29, 60],
            [0.3686274509803922, 68, 28, 58],
            [0.37254901960784315, 66, 27, 56],
            [0.3764705882352941, 63, 27, 54],
            [0.3803921568627451, 61, 26, 52],
            [0.38431372549019605, 59, 25, 50],
            [0.38823529411764707, 57, 25, 48],
            [0.39215686274509803, 55, 24, 47],
            [0.396078431372549, 53, 23, 45],
            [0.4, 51, 23, 43],
            [0.403921568627451, 49, 23, 41],
            [0.40784313725490196, 47, 22, 40],
            [0.4117647058823529, 45, 22, 38],
            [0.4156862745098039, 44, 21, 37],
            [0.4196078431372549, 42, 21, 35],
            [0.4235294117647059, 40, 21, 34],
            [0.42745098039215684, 39, 20, 33],
            [0.43137254901960786, 38, 20, 32],
            [0.43529411764705883, 36, 20, 30],
            [0.4392156862745098, 35, 20, 29],
            [0.44313725490196076, 34, 19, 28],
            [0.44705882352941173, 33, 19, 27],
            [0.45098039215686275, 32, 19, 26],
            [0.4549019607843137, 31, 19, 25],
            [0.4588235294117647, 30, 19, 25],
            [0.4627450980392157, 30, 19, 24],
            [0.4666666666666667, 29, 19, 23],
            [0.47058823529411764, 28, 19, 23],
            [0.4745098039215686, 28, 19, 22],
            [0.4784313725490196, 27, 19, 21],
            [0.4823529411764706, 27, 20, 21],
            [0.48627450980392156, 26, 20, 20],
            [0.49019607843137253, 26, 20, 20],
            [0.49411764705882355, 26, 20, 19],
            [0.4980392156862745, 25, 20, 19],
            [0.5019607843137255, 25, 21, 18],
            [0.5058823529411764, 25, 21, 18],
            [0.5098039215686274, 25, 21, 18],
            [0.5137254901960784, 25, 22, 18],
            [0.5176470588235293, 25, 22, 17],
            [0.5215686274509804, 25, 23, 17],
            [0.5254901960784314, 25, 23, 17],
            [0.5294117647058824, 25, 24, 17],
            [0.5333333333333333, 25, 25, 17],
            [0.5372549019607843, 25, 25, 17],
            [0.5411764705882353, 25, 26, 17],
            [0.5450980392156862, 26, 27, 17],
            [0.5490196078431373, 26, 28, 17],
            [0.5529411764705883, 26, 29, 17],
            [0.5568627450980392, 27, 29, 17],
            [0.5607843137254902, 27, 30, 17],
            [0.5647058823529412, 28, 32, 17],
            [0.5686274509803921, 28, 33, 17],
            [0.5725490196078431, 29, 34, 17],
            [0.5764705882352941, 29, 35, 18],
            [0.580392156862745, 30, 36, 18],
            [0.5843137254901961, 31, 38, 18],
            [0.5882352941176471, 32, 39, 18],
            [0.592156862745098, 32, 40, 18],
            [0.596078431372549, 33, 42, 19],
            [0.6, 34, 43, 19],
            [0.6039215686274509, 35, 45, 19],
            [0.6078431372549019, 36, 46, 20],
            [0.611764705882353, 37, 48, 20],
            [0.615686274509804, 38, 50, 20],
            [0.6196078431372549, 39, 51, 21],
            [0.6235294117647059, 40, 53, 21],
            [0.6274509803921569, 41, 55, 21],
            [0.6313725490196078, 42, 56, 22],
            [0.6352941176470588, 43, 58, 22],
            [0.6392156862745098, 45, 60, 23],
            [0.6431372549019607, 46, 62, 23],
            [0.6470588235294118, 47, 64, 23],
            [0.6509803921568628, 48, 65, 24],
            [0.6549019607843137, 49, 67, 24],
            [0.6588235294117647, 51, 69, 25],
            [0.6627450980392157, 52, 71, 25],
            [0.6666666666666666, 53, 73, 26],
            [0.6705882352941176, 54, 75, 26],
            [0.6745098039215687, 56, 77, 27],
            [0.6784313725490196, 57, 78, 27],
            [0.6823529411764706, 58, 80, 28],
            [0.6862745098039216, 60, 82, 28],
            [0.6901960784313725, 61, 84, 29],
            [0.6941176470588235, 62, 86, 30],
            [0.6980392156862745, 64, 88, 30],
            [0.7019607843137254, 65, 90, 31],
            [0.7058823529411764, 66, 91, 31],
            [0.7098039215686275, 68, 93, 32],
            [0.7137254901960784, 69, 95, 32],
            [0.7176470588235294, 70, 97, 33],
            [0.7215686274509804, 71, 99, 33],
            [0.7254901960784313, 73, 101, 34],
            [0.7294117647058823, 74, 103, 35],
            [0.7333333333333333, 75, 104, 35],
            [0.7372549019607844, 77, 106, 36],
            [0.7411764705882353, 78, 108, 36],
            [0.7450980392156863, 79, 110, 37],
            [0.7490196078431373, 81, 112, 38],
            [0.7529411764705882, 82, 113, 38],
            [0.7568627450980392, 83, 115, 39],
            [0.7607843137254902, 84, 117, 39],
            [0.7647058823529411, 86, 119, 40],
            [0.7686274509803921, 87, 120, 41],
            [0.7725490196078432, 88, 122, 41],
            [0.7764705882352941, 89, 124, 42],
            [0.7803921568627451, 91, 125, 43],
            [0.7843137254901961, 92, 127, 43],
            [0.788235294117647, 93, 129, 44],
            [0.792156862745098, 94, 131, 45],
            [0.796078431372549, 96, 132, 45],
            [0.8, 97, 134, 46],
            [0.803921568627451, 98, 136, 47],
            [0.807843137254902, 100, 138, 48],
            [0.8117647058823529, 101, 140, 49],
            [0.8156862745098039, 102, 141, 50],
            [0.8196078431372549, 104, 143, 50],
            [0.8235294117647058, 105, 145, 51],
            [0.8274509803921568, 106, 147, 52],
            [0.8313725490196078, 108, 149, 53],
            [0.8352941176470589, 109, 151, 54],
            [0.8392156862745098, 111, 153, 56],
            [0.8431372549019608, 112, 155, 57],
            [0.8470588235294118, 114, 157, 58],
            [0.8509803921568627, 115, 159, 59],
            [0.8549019607843137, 117, 161, 61],
            [0.8588235294117647, 119, 163, 62],
            [0.8627450980392157, 120, 165, 64],
            [0.8666666666666667, 122, 167, 65],
            [0.8705882352941177, 123, 169, 67],
            [0.8745098039215686, 125, 172, 68],
            [0.8784313725490196, 127, 174, 70],
            [0.8823529411764706, 129, 176, 72],
            [0.8862745098039215, 130, 178, 74],
            [0.8901960784313725, 132, 181, 76],
            [0.8941176470588235, 134, 183, 78],
            [0.8980392156862745, 136, 185, 80],
            [0.9019607843137255, 138, 188, 83],
            [0.9058823529411765, 140, 190, 85],
            [0.9098039215686274, 142, 192, 87],
            [0.9137254901960784, 143, 195, 90],
            [0.9176470588235294, 145, 197, 92],
            [0.9215686274509803, 147, 200, 95],
            [0.9254901960784314, 149, 202, 98],
            [0.9294117647058824, 151, 205, 101],
            [0.9333333333333333, 153, 207, 104],
            [0.9372549019607843, 156, 210, 107],
            [0.9411764705882353, 158, 212, 110],
            [0.9450980392156862, 160, 215, 113],
            [0.9490196078431372, 162, 217, 116],
            [0.9529411764705882, 164, 220, 120],
            [0.9568627450980391, 166, 223, 123],
            [0.9607843137254902, 168, 225, 127],
            [0.9647058823529412, 170, 228, 130],
            [0.9686274509803922, 172, 231, 134],
            [0.9725490196078431, 174, 233, 138],
            [0.9764705882352941, 177, 236, 141],
            [0.9803921568627451, 179, 239, 145],
            [0.984313725490196, 181, 241, 149],
            [0.9882352941176471, 183, 244, 153],
            [0.9921568627450981, 185, 247, 157],
            [0.996078431372549, 187, 250, 161],
            [1.0, 189, 252, 165],
        ],
    },
    {
        "name": "vik (Div)",
        "discrete": False,
        "colors": [
            [0.0, 0, 17, 96],
            [0.00392156862745098, 0, 19, 97],
            [0.00784313725490196, 0, 21, 98],
            [0.011764705882352941, 1, 22, 99],
            [0.01568627450980392, 1, 24, 100],
            [0.0196078431372549, 1, 26, 101],
            [0.023529411764705882, 1, 27, 102],
            [0.027450980392156862, 1, 29, 103],
            [0.03137254901960784, 1, 30, 104],
            [0.03529411764705882, 1, 32, 105],
            [0.0392156862745098, 2, 33, 106],
            [0.043137254901960784, 2, 35, 107],
            [0.047058823529411764, 2, 37, 108],
            [0.050980392156862744, 2, 38, 109],
            [0.054901960784313725, 2, 40, 110],
            [0.058823529411764705, 2, 41, 111],
            [0.06274509803921569, 2, 43, 112],
            [0.06666666666666667, 2, 44, 113],
            [0.07058823529411765, 2, 46, 114],
            [0.07450980392156863, 2, 47, 115],
            [0.0784313725490196, 2, 49, 116],
            [0.08235294117647059, 2, 50, 117],
            [0.08627450980392157, 2, 52, 118],
            [0.09019607843137255, 2, 53, 119],
            [0.09411764705882353, 2, 55, 120],
            [0.09803921568627451, 2, 56, 121],
            [0.10196078431372549, 2, 58, 122],
            [0.10588235294117647, 2, 59, 123],
            [0.10980392156862745, 2, 61, 124],
            [0.11372549019607843, 2, 63, 125],
            [0.11764705882352941, 2, 64, 126],
            [0.12156862745098039, 2, 66, 127],
            [0.12549019607843137, 2, 67, 128],
            [0.12941176470588234, 2, 69, 129],
            [0.13333333333333333, 2, 70, 130],
            [0.13725490196078433, 3, 72, 131],
            [0.1411764705882353, 3, 74, 132],
            [0.14509803921568626, 3, 75, 133],
            [0.14901960784313725, 3, 77, 134],
            [0.15294117647058825, 4, 79, 135],
            [0.1568627450980392, 4, 80, 137],
            [0.16078431372549018, 5, 82, 138],
            [0.16470588235294117, 5, 84, 139],
            [0.16862745098039217, 6, 85, 140],
            [0.17254901960784313, 7, 87, 141],
            [0.1764705882352941, 8, 89, 142],
            [0.1803921568627451, 9, 90, 143],
            [0.1843137254901961, 10, 92, 144],
            [0.18823529411764706, 12, 94, 145],
            [0.19215686274509802, 13, 96, 147],
            [0.19607843137254902, 15, 97, 148],
            [0.2, 17, 99, 149],
            [0.20392156862745098, 19, 101, 150],
            [0.20784313725490194, 21, 103, 151],
            [0.21176470588235294, 23, 105, 153],
            [0.21568627450980393, 25, 107, 154],
            [0.2196078431372549, 27, 109, 155],
            [0.22352941176470587, 30, 111, 157],
            [0.22745098039215686, 32, 113, 158],
            [0.23137254901960785, 34, 114, 159],
            [0.23529411764705882, 37, 116, 160],
            [0.2392156862745098, 39, 118, 162],
            [0.24313725490196078, 42, 120, 163],
            [0.24705882352941178, 45, 122, 165],
            [0.25098039215686274, 48, 124, 166],
            [0.2549019607843137, 50, 127, 167],
            [0.2588235294117647, 53, 129, 169],
            [0.2627450980392157, 56, 131, 170],
            [0.26666666666666666, 59, 133, 171],
            [0.27058823529411763, 62, 135, 173],
            [0.27450980392156865, 65, 137, 174],
            [0.2784313725490196, 68, 139, 176],
            [0.2823529411764706, 71, 141, 177],
            [0.28627450980392155, 74, 143, 178],
            [0.2901960784313725, 77, 145, 180],
            [0.29411764705882354, 80, 147, 181],
            [0.2980392156862745, 84, 149, 183],
            [0.30196078431372547, 87, 151, 184],
            [0.3058823529411765, 90, 153, 186],
            [0.30980392156862746, 93, 155, 187],
            [0.3137254901960784, 96, 157, 188],
            [0.3176470588235294, 99, 159, 190],
            [0.32156862745098036, 102, 161, 191],
            [0.3254901960784314, 106, 163, 192],
            [0.32941176470588235, 109, 165, 194],
            [0.3333333333333333, 112, 168, 195],
            [0.33725490196078434, 115, 170, 197],
            [0.3411764705882353, 118, 172, 198],
            [0.34509803921568627, 122, 173, 199],
            [0.34901960784313724, 125, 175, 201],
            [0.3529411764705882, 128, 177, 202],
            [0.3568627450980392, 131, 179, 203],
            [0.3607843137254902, 134, 181, 205],
            [0.36470588235294116, 137, 183, 206],
            [0.3686274509803922, 141, 185, 207],
            [0.37254901960784315, 144, 187, 209],
            [0.3764705882352941, 147, 189, 210],
            [0.3803921568627451, 150, 191, 211],
            [0.38431372549019605, 153, 193, 213],
            [0.38823529411764707, 157, 195, 214],
            [0.39215686274509803, 160, 197, 215],
            [0.396078431372549, 163, 199, 217],
            [0.4, 166, 201, 218],
            [0.403921568627451, 169, 203, 219],
            [0.40784313725490196, 172, 205, 220],
            [0.4117647058823529, 176, 206, 222],
            [0.4156862745098039, 179, 208, 223],
            [0.4196078431372549, 182, 210, 224],
            [0.4235294117647059, 185, 212, 225],
            [0.42745098039215684, 188, 214, 226],
            [0.43137254901960786, 191, 216, 227],
            [0.43529411764705883, 194, 217, 228],
            [0.4392156862745098, 198, 219, 229],
            [0.44313725490196076, 201, 221, 230],
            [0.44705882352941173, 204, 222, 231],
            [0.45098039215686275, 207, 224, 232],
            [0.4549019607843137, 210, 225, 232],
            [0.4588235294117647, 213, 226, 233],
            [0.4627450980392157, 216, 227, 233],
            [0.4666666666666667, 218, 228, 233],
            [0.47058823529411764, 221, 229, 233],
            [0.4745098039215686, 224, 230, 232],
            [0.4784313725490196, 226, 230, 232],
            [0.4823529411764706, 228, 230, 231],
            [0.48627450980392156, 230, 230, 230],
            [0.49019607843137253, 232, 230, 229],
            [0.49411764705882355, 233, 230, 227],
            [0.4980392156862745, 235, 229, 226],
            [0.5019607843137255, 236, 228, 224],
            [0.5058823529411764, 237, 227, 222],
            [0.5098039215686274, 237, 226, 220],
            [0.5137254901960784, 238, 225, 217],
            [0.5176470588235293, 238, 223, 215],
            [0.5215686274509804, 238, 222, 213],
            [0.5254901960784314, 238, 220, 210],
            [0.5294117647058824, 238, 218, 207],
            [0.5333333333333333, 237, 217, 205],
            [0.5372549019607843, 237, 215, 202],
            [0.5411764705882353, 236, 213, 199],
            [0.5450980392156862, 236, 211, 197],
            [0.5490196078431373, 235, 209, 194],
            [0.5529411764705883, 234, 207, 191],
            [0.5568627450980392, 234, 205, 189],
            [0.5607843137254902, 233, 203, 186],
            [0.5647058823529412, 232, 201, 183],
            [0.5686274509803921, 231, 199, 180],
            [0.5725490196078431, 230, 197, 178],
            [0.5764705882352941, 230, 195, 175],
            [0.580392156862745, 229, 193, 172],
            [0.5843137254901961, 228, 191, 170],
            [0.5882352941176471, 227, 189, 167],
            [0.592156862745098, 226, 187, 164],
            [0.596078431372549, 225, 185, 162],
            [0.6, 225, 183, 159],
            [0.6039215686274509, 224, 181, 156],
            [0.6078431372549019, 223, 179, 154],
            [0.611764705882353, 222, 177, 151],
            [0.615686274509804, 221, 175, 149],
            [0.6196078431372549, 220, 173, 146],
            [0.6235294117647059, 220, 171, 144],
            [0.6274509803921569, 219, 169, 141],
            [0.6313725490196078, 218, 168, 138],
            [0.6352941176470588, 217, 166, 136],
            [0.6392156862745098, 216, 164, 133],
            [0.6431372549019607, 216, 162, 131],
            [0.6470588235294118, 215, 160, 128],
            [0.6509803921568628, 214, 158, 126],
            [0.6549019607843137, 213, 156, 123],
            [0.6588235294117647, 212, 154, 121],
            [0.6627450980392157, 212, 153, 118],
            [0.6666666666666666, 211, 151, 116],
            [0.6705882352941176, 210, 149, 114],
            [0.6745098039215687, 209, 147, 111],
            [0.6784313725490196, 208, 145, 109],
            [0.6823529411764706, 208, 143, 106],
            [0.6862745098039216, 207, 142, 104],
            [0.6901960784313725, 206, 140, 101],
            [0.6941176470588235, 205, 138, 99],
            [0.6980392156862745, 205, 136, 97],
            [0.7019607843137254, 204, 134, 94],
            [0.7058823529411764, 203, 133, 92],
            [0.7098039215686275, 202, 131, 90],
            [0.7137254901960784, 202, 129, 87],
            [0.7176470588235294, 201, 127, 85],
            [0.7215686274509804, 200, 126, 83],
            [0.7254901960784313, 199, 124, 80],
            [0.7294117647058823, 199, 122, 78],
            [0.7333333333333333, 198, 120, 76],
            [0.7372549019607844, 197, 119, 74],
            [0.7411764705882353, 196, 117, 71],
            [0.7450980392156863, 196, 115, 69],
            [0.7490196078431373, 195, 113, 67],
            [0.7529411764705882, 194, 112, 64],
            [0.7568627450980392, 193, 110, 62],
            [0.7607843137254902, 192, 108, 60],
            [0.7647058823529411, 192, 106, 58],
            [0.7686274509803921, 191, 105, 55],
            [0.7725490196078432, 190, 103, 53],
            [0.7764705882352941, 189, 101, 51],
            [0.7803921568627451, 188, 99, 49],
            [0.7843137254901961, 187, 97, 46],
            [0.788235294117647, 186, 95, 44],
            [0.792156862745098, 185, 93, 42],
            [0.796078431372549, 184, 91, 40],
            [0.8, 183, 89, 37],
            [0.803921568627451, 182, 87, 35],
            [0.807843137254902, 180, 85, 33],
            [0.8117647058823529, 179, 83, 30],
            [0.8156862745098039, 177, 80, 28],
            [0.8196078431372549, 176, 78, 26],
            [0.8235294117647058, 174, 76, 24],
            [0.8274509803921568, 172, 73, 22],
            [0.8313725490196078, 170, 71, 20],
            [0.8352941176470589, 169, 69, 18],
            [0.8392156862745098, 167, 66, 16],
            [0.8431372549019608, 164, 64, 14],
            [0.8470588235294118, 162, 61, 12],
            [0.8509803921568627, 160, 59, 11],
            [0.8549019607843137, 158, 57, 10],
            [0.8588235294117647, 156, 54, 8],
            [0.8627450980392157, 154, 52, 7],
            [0.8666666666666667, 151, 50, 7],
            [0.8705882352941177, 149, 48, 6],
            [0.8745098039215686, 147, 46, 6],
            [0.8784313725490196, 145, 44, 5],
            [0.8823529411764706, 143, 42, 5],
            [0.8862745098039215, 141, 41, 5],
            [0.8901960784313725, 139, 39, 5],
            [0.8941176470588235, 137, 37, 5],
            [0.8980392156862745, 135, 36, 5],
            [0.9019607843137255, 133, 34, 5],
            [0.9058823529411765, 131, 32, 5],
            [0.9098039215686274, 129, 31, 5],
            [0.9137254901960784, 127, 29, 5],
            [0.9176470588235294, 125, 28, 5],
            [0.9215686274509803, 123, 27, 5],
            [0.9254901960784314, 121, 25, 5],
            [0.9294117647058824, 120, 24, 6],
            [0.9333333333333333, 118, 22, 6],
            [0.9372549019607843, 116, 21, 6],
            [0.9411764705882353, 114, 20, 6],
            [0.9450980392156862, 112, 18, 6],
            [0.9490196078431372, 111, 17, 6],
            [0.9529411764705882, 109, 15, 6],
            [0.9568627450980391, 107, 14, 6],
            [0.9607843137254902, 105, 13, 6],
            [0.9647058823529412, 104, 11, 7],
            [0.9686274509803922, 102, 10, 7],
            [0.9725490196078431, 100, 8, 7],
            [0.9764705882352941, 99, 7, 7],
            [0.9803921568627451, 97, 5, 7],
            [0.984313725490196, 95, 4, 7],
            [0.9882352941176471, 94, 3, 7],
            [0.9921568627450981, 92, 2, 7],
            [0.996078431372549, 90, 1, 7],
            [1.0, 89, 0, 7],
        ],
    },
]
