# This file was auto-generated by Fern from our API Definition.

import contextlib
import json
import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.internal_server_error import InternalServerError
from ...types.ad_hoc_execute_prompt_event import AdHocExecutePromptEvent
from ...types.ad_hoc_expand_meta import AdHocExpandMeta
from ...types.deprecated_prompt_request_input import DeprecatedPromptRequestInput
from ...types.function_definition import FunctionDefinition
from ...types.prompt_block import PromptBlock
from ...types.prompt_parameters import PromptParameters
from ...types.prompt_settings import PromptSettings
from ...types.vellum_variable import VellumVariable

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAdHocClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def adhoc_execute_prompt(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AdHocExecutePromptEvent]:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AdHocExecutePromptEvent]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ad-hoc/execute-prompt",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "ml_model": ml_model,
                "input_values": convert_and_respect_annotation_metadata(
                    object_=input_values, annotation=typing.Sequence[DeprecatedPromptRequestInput], direction="write"
                ),
                "input_variables": convert_and_respect_annotation_metadata(
                    object_=input_variables, annotation=typing.Sequence[VellumVariable], direction="write"
                ),
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=PromptParameters, direction="write"
                ),
                "settings": convert_and_respect_annotation_metadata(
                    object_=settings, annotation=typing.Optional[PromptSettings], direction="write"
                ),
                "blocks": convert_and_respect_annotation_metadata(
                    object_=blocks, annotation=typing.Sequence[PromptBlock], direction="write"
                ),
                "functions": convert_and_respect_annotation_metadata(
                    object_=functions,
                    annotation=typing.Optional[typing.Sequence[FunctionDefinition]],
                    direction="write",
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[AdHocExpandMeta], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AdHocExecutePromptEvent,
                    parse_obj_as(
                        type_=AdHocExecutePromptEvent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def adhoc_execute_prompt_stream(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[AdHocExecutePromptEvent]]]:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[HttpResponse[typing.Iterator[AdHocExecutePromptEvent]]]

        """
        with self._client_wrapper.httpx_client.stream(
            "v1/ad-hoc/execute-prompt-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "ml_model": ml_model,
                "input_values": convert_and_respect_annotation_metadata(
                    object_=input_values, annotation=typing.Sequence[DeprecatedPromptRequestInput], direction="write"
                ),
                "input_variables": convert_and_respect_annotation_metadata(
                    object_=input_variables, annotation=typing.Sequence[VellumVariable], direction="write"
                ),
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=PromptParameters, direction="write"
                ),
                "settings": convert_and_respect_annotation_metadata(
                    object_=settings, annotation=typing.Optional[PromptSettings], direction="write"
                ),
                "blocks": convert_and_respect_annotation_metadata(
                    object_=blocks, annotation=typing.Sequence[PromptBlock], direction="write"
                ),
                "functions": convert_and_respect_annotation_metadata(
                    object_=functions,
                    annotation=typing.Optional[typing.Sequence[FunctionDefinition]],
                    direction="write",
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[AdHocExpandMeta], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[AdHocExecutePromptEvent]]:
                try:
                    if 200 <= _response.status_code < 300:

                        def _iter():
                            for _text in _response.iter_lines():
                                try:
                                    if len(_text) == 0:
                                        continue
                                    yield typing.cast(
                                        AdHocExecutePromptEvent,
                                        parse_obj_as(
                                            type_=AdHocExecutePromptEvent,  # type: ignore
                                            object_=json.loads(_text),
                                        ),
                                    )
                                except Exception:
                                    pass
                            return

                        return HttpResponse(response=_response, data=_iter())
                    _response.read()
                    if _response.status_code == 400:
                        raise BadRequestError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    if _response.status_code == 403:
                        raise ForbiddenError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    if _response.status_code == 500:
                        raise InternalServerError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()


class AsyncRawAdHocClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def adhoc_execute_prompt(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AdHocExecutePromptEvent]:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AdHocExecutePromptEvent]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ad-hoc/execute-prompt",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "ml_model": ml_model,
                "input_values": convert_and_respect_annotation_metadata(
                    object_=input_values, annotation=typing.Sequence[DeprecatedPromptRequestInput], direction="write"
                ),
                "input_variables": convert_and_respect_annotation_metadata(
                    object_=input_variables, annotation=typing.Sequence[VellumVariable], direction="write"
                ),
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=PromptParameters, direction="write"
                ),
                "settings": convert_and_respect_annotation_metadata(
                    object_=settings, annotation=typing.Optional[PromptSettings], direction="write"
                ),
                "blocks": convert_and_respect_annotation_metadata(
                    object_=blocks, annotation=typing.Sequence[PromptBlock], direction="write"
                ),
                "functions": convert_and_respect_annotation_metadata(
                    object_=functions,
                    annotation=typing.Optional[typing.Sequence[FunctionDefinition]],
                    direction="write",
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[AdHocExpandMeta], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AdHocExecutePromptEvent,
                    parse_obj_as(
                        type_=AdHocExecutePromptEvent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def adhoc_execute_prompt_stream(
        self,
        *,
        ml_model: str,
        input_values: typing.Sequence[DeprecatedPromptRequestInput],
        input_variables: typing.Sequence[VellumVariable],
        parameters: PromptParameters,
        blocks: typing.Sequence[PromptBlock],
        settings: typing.Optional[PromptSettings] = OMIT,
        functions: typing.Optional[typing.Sequence[FunctionDefinition]] = OMIT,
        expand_meta: typing.Optional[AdHocExpandMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[AdHocExecutePromptEvent]]]:
        """
        Parameters
        ----------
        ml_model : str

        input_values : typing.Sequence[DeprecatedPromptRequestInput]

        input_variables : typing.Sequence[VellumVariable]

        parameters : PromptParameters

        blocks : typing.Sequence[PromptBlock]

        settings : typing.Optional[PromptSettings]

        functions : typing.Optional[typing.Sequence[FunctionDefinition]]

        expand_meta : typing.Optional[AdHocExpandMeta]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[AdHocExecutePromptEvent]]]

        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/ad-hoc/execute-prompt-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "ml_model": ml_model,
                "input_values": convert_and_respect_annotation_metadata(
                    object_=input_values, annotation=typing.Sequence[DeprecatedPromptRequestInput], direction="write"
                ),
                "input_variables": convert_and_respect_annotation_metadata(
                    object_=input_variables, annotation=typing.Sequence[VellumVariable], direction="write"
                ),
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=PromptParameters, direction="write"
                ),
                "settings": convert_and_respect_annotation_metadata(
                    object_=settings, annotation=typing.Optional[PromptSettings], direction="write"
                ),
                "blocks": convert_and_respect_annotation_metadata(
                    object_=blocks, annotation=typing.Sequence[PromptBlock], direction="write"
                ),
                "functions": convert_and_respect_annotation_metadata(
                    object_=functions,
                    annotation=typing.Optional[typing.Sequence[FunctionDefinition]],
                    direction="write",
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[AdHocExpandMeta], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[AdHocExecutePromptEvent]]:
                try:
                    if 200 <= _response.status_code < 300:

                        async def _iter():
                            async for _text in _response.aiter_lines():
                                try:
                                    if len(_text) == 0:
                                        continue
                                    yield typing.cast(
                                        AdHocExecutePromptEvent,
                                        parse_obj_as(
                                            type_=AdHocExecutePromptEvent,  # type: ignore
                                            object_=json.loads(_text),
                                        ),
                                    )
                                except Exception:
                                    pass
                            return

                        return AsyncHttpResponse(response=_response, data=_iter())
                    await _response.aread()
                    if _response.status_code == 400:
                        raise BadRequestError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    if _response.status_code == 403:
                        raise ForbiddenError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    if _response.status_code == 500:
                        raise InternalServerError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()
