# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.paginated_workflow_sandbox_example_list import PaginatedWorkflowSandboxExampleList
from ...types.workflow_deployment_read import WorkflowDeploymentRead
from .raw_client import AsyncRawWorkflowSandboxesClient, RawWorkflowSandboxesClient
from .types.list_workflow_sandbox_examples_request_tag import ListWorkflowSandboxExamplesRequestTag

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowSandboxesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowSandboxesClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawWorkflowSandboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowSandboxesClient
        """
        return self._raw_client

    def deploy_workflow(
        self,
        id: str,
        *,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        label: typing.Optional[str] = OMIT,
        release_tags: typing.Optional[typing.Sequence[str]] = OMIT,
        release_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowDeploymentRead:
        """
        Parameters
        ----------
        id : str
            A UUID string identifying this workflow sandbox.

        workflow_deployment_id : typing.Optional[str]
            The Vellum-generated ID of the Workflow Deployment you'd like to update. Cannot specify both this and workflow_deployment_name. Leave null to create a new Workflow Deployment.

        workflow_deployment_name : typing.Optional[str]
            The unique name of the Workflow Deployment you'd like to either create or update. Cannot specify both this and workflow_deployment_id. If provided and matches an existing Workflow Deployment, that Workflow Deployment will be updated. Otherwise, a new Prompt Deployment will be created.

        label : typing.Optional[str]
            In the event that a new Workflow Deployment is created, this will be the label it's given.

        release_tags : typing.Optional[typing.Sequence[str]]
            Optionally provide the release tags that you'd like to be associated with the latest release of the created/updated Prompt Deployment.

        release_description : typing.Optional[str]
            Optionally provide a description that details what's new in this Release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_sandboxes.deploy_workflow(
            id="id",
        )
        """
        _response = self._raw_client.deploy_workflow(
            id,
            workflow_deployment_id=workflow_deployment_id,
            workflow_deployment_name=workflow_deployment_name,
            label=label,
            release_tags=release_tags,
            release_description=release_description,
            request_options=request_options,
        )
        return _response.data

    def list_workflow_sandbox_examples(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        tag: typing.Optional[ListWorkflowSandboxExamplesRequestTag] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedWorkflowSandboxExampleList:
        """
        List Workflow Sandbox examples that were previously cloned into the User's Workspace

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        tag : typing.Optional[ListWorkflowSandboxExamplesRequestTag]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedWorkflowSandboxExampleList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_sandboxes.list_workflow_sandbox_examples()
        """
        _response = self._raw_client.list_workflow_sandbox_examples(
            limit=limit, offset=offset, ordering=ordering, tag=tag, request_options=request_options
        )
        return _response.data


class AsyncWorkflowSandboxesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowSandboxesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowSandboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowSandboxesClient
        """
        return self._raw_client

    async def deploy_workflow(
        self,
        id: str,
        *,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        label: typing.Optional[str] = OMIT,
        release_tags: typing.Optional[typing.Sequence[str]] = OMIT,
        release_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowDeploymentRead:
        """
        Parameters
        ----------
        id : str
            A UUID string identifying this workflow sandbox.

        workflow_deployment_id : typing.Optional[str]
            The Vellum-generated ID of the Workflow Deployment you'd like to update. Cannot specify both this and workflow_deployment_name. Leave null to create a new Workflow Deployment.

        workflow_deployment_name : typing.Optional[str]
            The unique name of the Workflow Deployment you'd like to either create or update. Cannot specify both this and workflow_deployment_id. If provided and matches an existing Workflow Deployment, that Workflow Deployment will be updated. Otherwise, a new Prompt Deployment will be created.

        label : typing.Optional[str]
            In the event that a new Workflow Deployment is created, this will be the label it's given.

        release_tags : typing.Optional[typing.Sequence[str]]
            Optionally provide the release tags that you'd like to be associated with the latest release of the created/updated Prompt Deployment.

        release_description : typing.Optional[str]
            Optionally provide a description that details what's new in this Release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_sandboxes.deploy_workflow(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deploy_workflow(
            id,
            workflow_deployment_id=workflow_deployment_id,
            workflow_deployment_name=workflow_deployment_name,
            label=label,
            release_tags=release_tags,
            release_description=release_description,
            request_options=request_options,
        )
        return _response.data

    async def list_workflow_sandbox_examples(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        tag: typing.Optional[ListWorkflowSandboxExamplesRequestTag] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedWorkflowSandboxExampleList:
        """
        List Workflow Sandbox examples that were previously cloned into the User's Workspace

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        tag : typing.Optional[ListWorkflowSandboxExamplesRequestTag]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedWorkflowSandboxExampleList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_sandboxes.list_workflow_sandbox_examples()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_workflow_sandbox_examples(
            limit=limit, offset=offset, ordering=ordering, tag=tag, request_options=request_options
        )
        return _response.data
