# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .auth_type_enum import AuthTypeEnum
from .integration_auth_config_integration import IntegrationAuthConfigIntegration
from .integration_auth_config_integration_credential import IntegrationAuthConfigIntegrationCredential
from .integration_credential_access_type import IntegrationCredentialAccessType


class SlimIntegrationAuthConfigRead(UniversalBaseModel):
    """
    A slim representation of an Integration Auth Config.
    """

    id: str
    integration: IntegrationAuthConfigIntegration
    auth_type: typing.Optional[AuthTypeEnum] = None
    integration_credentials: typing.Optional[typing.List[IntegrationAuthConfigIntegrationCredential]] = None
    system_credential_eligible: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not this auth config is eligible to use Vellum-managed system credentials to authenticate.
    """

    default_access_type: typing.Optional[IntegrationCredentialAccessType] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
