# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .vellum_variable_extensions import VellumVariableExtensions
from .vellum_variable_type import VellumVariableType


class VellumVariable(UniversalBaseModel):
    id: str
    key: str
    type: VellumVariableType
    required: typing.Optional[bool] = None
    default: typing.Optional["VellumValue"] = None
    extensions: typing.Optional[VellumVariableExtensions] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001
from .vellum_value import VellumValue  # noqa: E402, F401, I001

update_forward_refs(VellumVariable)
