# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .execution_vellum_value import ExecutionVellumValue
from .workflow_event_error import WorkflowEventError
from .workflow_output import WorkflowOutput
from .workflow_result_event_output_data import WorkflowResultEventOutputData
from .workflow_result_event_state import WorkflowResultEventState


class WorkflowResultEvent(UniversalBaseModel):
    id: str
    state: WorkflowResultEventState
    ts: dt.datetime
    output: typing.Optional[WorkflowResultEventOutputData] = None
    error: typing.Optional[WorkflowEventError] = None
    outputs: typing.Optional[typing.List[WorkflowOutput]] = None
    inputs: typing.Optional[typing.List[ExecutionVellumValue]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001

update_forward_refs(WorkflowResultEvent)
