# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.docker_registry_credentials import DockerRegistryCredentials
from perian.models.docker_run_parameters import DockerRunParameters
from perian.models.instance_type_query_input import InstanceTypeQueryInput
from perian.models.os_storage_config import OSStorageConfig
from typing import Optional, Set
from typing_extensions import Self

class CreateJobRequest(BaseModel):
    """
    JSON schema for the CreateJobRequest api request body.
    """ # noqa: E501
    instance_type_id: Optional[StrictStr] = None
    auto_failover_instance_type: Optional[StrictBool] = True
    timeout_seconds: Optional[StrictInt] = None
    os_storage_config: Optional[OSStorageConfig] = None
    requirements: Optional[InstanceTypeQueryInput] = None
    docker_run_parameters: Optional[DockerRunParameters] = None
    docker_registry_credentials: Optional[DockerRegistryCredentials] = None
    __properties: ClassVar[List[str]] = ["instance_type_id", "auto_failover_instance_type", "timeout_seconds", "os_storage_config", "requirements", "docker_run_parameters", "docker_registry_credentials"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateJobRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of os_storage_config
        if self.os_storage_config:
            _dict['os_storage_config'] = self.os_storage_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requirements
        if self.requirements:
            _dict['requirements'] = self.requirements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of docker_run_parameters
        if self.docker_run_parameters:
            _dict['docker_run_parameters'] = self.docker_run_parameters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of docker_registry_credentials
        if self.docker_registry_credentials:
            _dict['docker_registry_credentials'] = self.docker_registry_credentials.to_dict()
        # set to None if instance_type_id (nullable) is None
        # and model_fields_set contains the field
        if self.instance_type_id is None and "instance_type_id" in self.model_fields_set:
            _dict['instance_type_id'] = None

        # set to None if timeout_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.timeout_seconds is None and "timeout_seconds" in self.model_fields_set:
            _dict['timeout_seconds'] = None

        # set to None if requirements (nullable) is None
        # and model_fields_set contains the field
        if self.requirements is None and "requirements" in self.model_fields_set:
            _dict['requirements'] = None

        # set to None if docker_registry_credentials (nullable) is None
        # and model_fields_set contains the field
        if self.docker_registry_credentials is None and "docker_registry_credentials" in self.model_fields_set:
            _dict['docker_registry_credentials'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateJobRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "instance_type_id": obj.get("instance_type_id"),
            "auto_failover_instance_type": obj.get("auto_failover_instance_type") if obj.get("auto_failover_instance_type") is not None else True,
            "timeout_seconds": obj.get("timeout_seconds"),
            "os_storage_config": OSStorageConfig.from_dict(obj["os_storage_config"]) if obj.get("os_storage_config") is not None else None,
            "requirements": InstanceTypeQueryInput.from_dict(obj["requirements"]) if obj.get("requirements") is not None else None,
            "docker_run_parameters": DockerRunParameters.from_dict(obj["docker_run_parameters"]) if obj.get("docker_run_parameters") is not None else None,
            "docker_registry_credentials": DockerRegistryCredentials.from_dict(obj["docker_registry_credentials"]) if obj.get("docker_registry_credentials") is not None else None
        })
        return _obj


