# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from perian.models.gsm8_k_score import Gsm8KScore
from perian.models.hellaswag_score import HellaswagScore
from perian.models.humaneval_score import HumanevalScore
from perian.models.mmlu_score import MmluScore
from perian.models.model_supported_language_create import ModelSupportedLanguageCreate
from typing import Optional, Set
from typing_extensions import Self

class ModelMetadataCreate(BaseModel):
    """
    Data model for creating new model metadata (without auto-generated fields).
    """ # noqa: E501
    template_name: StrictStr = Field(description="Reference to model template name")
    display_name: StrictStr = Field(description="Human-readable model name")
    model_id: StrictStr = Field(description="Unique model identifier for API calls")
    version: Optional[StrictStr] = None
    provider: Optional[StrictStr] = None
    release_date: Optional[datetime] = None
    context_window: Optional[StrictInt] = None
    max_output_tokens: Optional[StrictInt] = None
    parameter_count: Optional[StrictStr] = None
    size_class: Optional[StrictStr] = None
    model_type: Optional[StrictStr] = None
    architecture: Optional[StrictStr] = None
    avg_latency_ms: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    max_throughput_rps: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    supports_function_calling: Optional[StrictBool] = False
    supports_json_mode: Optional[StrictBool] = False
    supports_streaming: Optional[StrictBool] = False
    supports_fine_tuning: Optional[StrictBool] = False
    supports_multimodal: Optional[StrictBool] = False
    has_content_filtering: Optional[StrictBool] = False
    safety_level: Optional[StrictStr] = None
    rate_limit_rpm: Optional[StrictInt] = None
    rate_limit_tpm: Optional[StrictInt] = None
    support_level: Optional[StrictStr] = None
    primary_use_cases: Optional[List[StrictStr]] = None
    strengths: Optional[StrictStr] = None
    limitations: Optional[StrictStr] = None
    recommended_for: Optional[StrictStr] = None
    mmlu_score: Optional[MmluScore] = None
    hellaswag_score: Optional[HellaswagScore] = None
    humaneval_score: Optional[HumanevalScore] = None
    gsm8k_score: Optional[Gsm8KScore] = None
    supported_languages: Optional[List[ModelSupportedLanguageCreate]] = None
    __properties: ClassVar[List[str]] = ["template_name", "display_name", "model_id", "version", "provider", "release_date", "context_window", "max_output_tokens", "parameter_count", "size_class", "model_type", "architecture", "avg_latency_ms", "max_throughput_rps", "supports_function_calling", "supports_json_mode", "supports_streaming", "supports_fine_tuning", "supports_multimodal", "has_content_filtering", "safety_level", "rate_limit_rpm", "rate_limit_tpm", "support_level", "primary_use_cases", "strengths", "limitations", "recommended_for", "mmlu_score", "hellaswag_score", "humaneval_score", "gsm8k_score", "supported_languages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelMetadataCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mmlu_score
        if self.mmlu_score:
            _dict['mmlu_score'] = self.mmlu_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hellaswag_score
        if self.hellaswag_score:
            _dict['hellaswag_score'] = self.hellaswag_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of humaneval_score
        if self.humaneval_score:
            _dict['humaneval_score'] = self.humaneval_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gsm8k_score
        if self.gsm8k_score:
            _dict['gsm8k_score'] = self.gsm8k_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in supported_languages (list)
        _items = []
        if self.supported_languages:
            for _item in self.supported_languages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['supported_languages'] = _items
        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if provider (nullable) is None
        # and model_fields_set contains the field
        if self.provider is None and "provider" in self.model_fields_set:
            _dict['provider'] = None

        # set to None if release_date (nullable) is None
        # and model_fields_set contains the field
        if self.release_date is None and "release_date" in self.model_fields_set:
            _dict['release_date'] = None

        # set to None if context_window (nullable) is None
        # and model_fields_set contains the field
        if self.context_window is None and "context_window" in self.model_fields_set:
            _dict['context_window'] = None

        # set to None if max_output_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.max_output_tokens is None and "max_output_tokens" in self.model_fields_set:
            _dict['max_output_tokens'] = None

        # set to None if parameter_count (nullable) is None
        # and model_fields_set contains the field
        if self.parameter_count is None and "parameter_count" in self.model_fields_set:
            _dict['parameter_count'] = None

        # set to None if size_class (nullable) is None
        # and model_fields_set contains the field
        if self.size_class is None and "size_class" in self.model_fields_set:
            _dict['size_class'] = None

        # set to None if model_type (nullable) is None
        # and model_fields_set contains the field
        if self.model_type is None and "model_type" in self.model_fields_set:
            _dict['model_type'] = None

        # set to None if architecture (nullable) is None
        # and model_fields_set contains the field
        if self.architecture is None and "architecture" in self.model_fields_set:
            _dict['architecture'] = None

        # set to None if avg_latency_ms (nullable) is None
        # and model_fields_set contains the field
        if self.avg_latency_ms is None and "avg_latency_ms" in self.model_fields_set:
            _dict['avg_latency_ms'] = None

        # set to None if max_throughput_rps (nullable) is None
        # and model_fields_set contains the field
        if self.max_throughput_rps is None and "max_throughput_rps" in self.model_fields_set:
            _dict['max_throughput_rps'] = None

        # set to None if safety_level (nullable) is None
        # and model_fields_set contains the field
        if self.safety_level is None and "safety_level" in self.model_fields_set:
            _dict['safety_level'] = None

        # set to None if rate_limit_rpm (nullable) is None
        # and model_fields_set contains the field
        if self.rate_limit_rpm is None and "rate_limit_rpm" in self.model_fields_set:
            _dict['rate_limit_rpm'] = None

        # set to None if rate_limit_tpm (nullable) is None
        # and model_fields_set contains the field
        if self.rate_limit_tpm is None and "rate_limit_tpm" in self.model_fields_set:
            _dict['rate_limit_tpm'] = None

        # set to None if support_level (nullable) is None
        # and model_fields_set contains the field
        if self.support_level is None and "support_level" in self.model_fields_set:
            _dict['support_level'] = None

        # set to None if primary_use_cases (nullable) is None
        # and model_fields_set contains the field
        if self.primary_use_cases is None and "primary_use_cases" in self.model_fields_set:
            _dict['primary_use_cases'] = None

        # set to None if strengths (nullable) is None
        # and model_fields_set contains the field
        if self.strengths is None and "strengths" in self.model_fields_set:
            _dict['strengths'] = None

        # set to None if limitations (nullable) is None
        # and model_fields_set contains the field
        if self.limitations is None and "limitations" in self.model_fields_set:
            _dict['limitations'] = None

        # set to None if recommended_for (nullable) is None
        # and model_fields_set contains the field
        if self.recommended_for is None and "recommended_for" in self.model_fields_set:
            _dict['recommended_for'] = None

        # set to None if mmlu_score (nullable) is None
        # and model_fields_set contains the field
        if self.mmlu_score is None and "mmlu_score" in self.model_fields_set:
            _dict['mmlu_score'] = None

        # set to None if hellaswag_score (nullable) is None
        # and model_fields_set contains the field
        if self.hellaswag_score is None and "hellaswag_score" in self.model_fields_set:
            _dict['hellaswag_score'] = None

        # set to None if humaneval_score (nullable) is None
        # and model_fields_set contains the field
        if self.humaneval_score is None and "humaneval_score" in self.model_fields_set:
            _dict['humaneval_score'] = None

        # set to None if gsm8k_score (nullable) is None
        # and model_fields_set contains the field
        if self.gsm8k_score is None and "gsm8k_score" in self.model_fields_set:
            _dict['gsm8k_score'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelMetadataCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "template_name": obj.get("template_name"),
            "display_name": obj.get("display_name"),
            "model_id": obj.get("model_id"),
            "version": obj.get("version"),
            "provider": obj.get("provider"),
            "release_date": obj.get("release_date"),
            "context_window": obj.get("context_window"),
            "max_output_tokens": obj.get("max_output_tokens"),
            "parameter_count": obj.get("parameter_count"),
            "size_class": obj.get("size_class"),
            "model_type": obj.get("model_type"),
            "architecture": obj.get("architecture"),
            "avg_latency_ms": obj.get("avg_latency_ms"),
            "max_throughput_rps": obj.get("max_throughput_rps"),
            "supports_function_calling": obj.get("supports_function_calling") if obj.get("supports_function_calling") is not None else False,
            "supports_json_mode": obj.get("supports_json_mode") if obj.get("supports_json_mode") is not None else False,
            "supports_streaming": obj.get("supports_streaming") if obj.get("supports_streaming") is not None else False,
            "supports_fine_tuning": obj.get("supports_fine_tuning") if obj.get("supports_fine_tuning") is not None else False,
            "supports_multimodal": obj.get("supports_multimodal") if obj.get("supports_multimodal") is not None else False,
            "has_content_filtering": obj.get("has_content_filtering") if obj.get("has_content_filtering") is not None else False,
            "safety_level": obj.get("safety_level"),
            "rate_limit_rpm": obj.get("rate_limit_rpm"),
            "rate_limit_tpm": obj.get("rate_limit_tpm"),
            "support_level": obj.get("support_level"),
            "primary_use_cases": obj.get("primary_use_cases"),
            "strengths": obj.get("strengths"),
            "limitations": obj.get("limitations"),
            "recommended_for": obj.get("recommended_for"),
            "mmlu_score": MmluScore.from_dict(obj["mmlu_score"]) if obj.get("mmlu_score") is not None else None,
            "hellaswag_score": HellaswagScore.from_dict(obj["hellaswag_score"]) if obj.get("hellaswag_score") is not None else None,
            "humaneval_score": HumanevalScore.from_dict(obj["humaneval_score"]) if obj.get("humaneval_score") is not None else None,
            "gsm8k_score": Gsm8KScore.from_dict(obj["gsm8k_score"]) if obj.get("gsm8k_score") is not None else None,
            "supported_languages": [ModelSupportedLanguageCreate.from_dict(_item) for _item in obj["supported_languages"]] if obj.get("supported_languages") is not None else None
        })
        return _obj


