# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from perian.models.gsm8_k_score1 import Gsm8KScore1
from perian.models.hellaswag_score1 import HellaswagScore1
from perian.models.humaneval_score1 import HumanevalScore1
from perian.models.mmlu_score1 import MmluScore1
from typing import Optional, Set
from typing_extensions import Self

class ModelMetadataUpdate(BaseModel):
    """
    Data model for updating existing model metadata (all fields optional).
    """ # noqa: E501
    display_name: Optional[StrictStr] = None
    model_id: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    provider: Optional[StrictStr] = None
    release_date: Optional[datetime] = None
    context_window: Optional[StrictInt] = None
    max_output_tokens: Optional[StrictInt] = None
    parameter_count: Optional[StrictStr] = None
    size_class: Optional[StrictStr] = None
    model_type: Optional[StrictStr] = None
    architecture: Optional[StrictStr] = None
    avg_latency_ms: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    max_throughput_rps: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    supports_function_calling: Optional[StrictBool] = None
    supports_json_mode: Optional[StrictBool] = None
    supports_streaming: Optional[StrictBool] = None
    supports_fine_tuning: Optional[StrictBool] = None
    supports_multimodal: Optional[StrictBool] = None
    has_content_filtering: Optional[StrictBool] = None
    safety_level: Optional[StrictStr] = None
    rate_limit_rpm: Optional[StrictInt] = None
    rate_limit_tpm: Optional[StrictInt] = None
    is_deprecated: Optional[StrictBool] = None
    deprecation_date: Optional[datetime] = None
    support_level: Optional[StrictStr] = None
    primary_use_cases: Optional[List[StrictStr]] = None
    strengths: Optional[StrictStr] = None
    limitations: Optional[StrictStr] = None
    recommended_for: Optional[StrictStr] = None
    mmlu_score: Optional[MmluScore1] = None
    hellaswag_score: Optional[HellaswagScore1] = None
    humaneval_score: Optional[HumanevalScore1] = None
    gsm8k_score: Optional[Gsm8KScore1] = None
    __properties: ClassVar[List[str]] = ["display_name", "model_id", "version", "provider", "release_date", "context_window", "max_output_tokens", "parameter_count", "size_class", "model_type", "architecture", "avg_latency_ms", "max_throughput_rps", "supports_function_calling", "supports_json_mode", "supports_streaming", "supports_fine_tuning", "supports_multimodal", "has_content_filtering", "safety_level", "rate_limit_rpm", "rate_limit_tpm", "is_deprecated", "deprecation_date", "support_level", "primary_use_cases", "strengths", "limitations", "recommended_for", "mmlu_score", "hellaswag_score", "humaneval_score", "gsm8k_score"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelMetadataUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mmlu_score
        if self.mmlu_score:
            _dict['mmlu_score'] = self.mmlu_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hellaswag_score
        if self.hellaswag_score:
            _dict['hellaswag_score'] = self.hellaswag_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of humaneval_score
        if self.humaneval_score:
            _dict['humaneval_score'] = self.humaneval_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gsm8k_score
        if self.gsm8k_score:
            _dict['gsm8k_score'] = self.gsm8k_score.to_dict()
        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if model_id (nullable) is None
        # and model_fields_set contains the field
        if self.model_id is None and "model_id" in self.model_fields_set:
            _dict['model_id'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if provider (nullable) is None
        # and model_fields_set contains the field
        if self.provider is None and "provider" in self.model_fields_set:
            _dict['provider'] = None

        # set to None if release_date (nullable) is None
        # and model_fields_set contains the field
        if self.release_date is None and "release_date" in self.model_fields_set:
            _dict['release_date'] = None

        # set to None if context_window (nullable) is None
        # and model_fields_set contains the field
        if self.context_window is None and "context_window" in self.model_fields_set:
            _dict['context_window'] = None

        # set to None if max_output_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.max_output_tokens is None and "max_output_tokens" in self.model_fields_set:
            _dict['max_output_tokens'] = None

        # set to None if parameter_count (nullable) is None
        # and model_fields_set contains the field
        if self.parameter_count is None and "parameter_count" in self.model_fields_set:
            _dict['parameter_count'] = None

        # set to None if size_class (nullable) is None
        # and model_fields_set contains the field
        if self.size_class is None and "size_class" in self.model_fields_set:
            _dict['size_class'] = None

        # set to None if model_type (nullable) is None
        # and model_fields_set contains the field
        if self.model_type is None and "model_type" in self.model_fields_set:
            _dict['model_type'] = None

        # set to None if architecture (nullable) is None
        # and model_fields_set contains the field
        if self.architecture is None and "architecture" in self.model_fields_set:
            _dict['architecture'] = None

        # set to None if avg_latency_ms (nullable) is None
        # and model_fields_set contains the field
        if self.avg_latency_ms is None and "avg_latency_ms" in self.model_fields_set:
            _dict['avg_latency_ms'] = None

        # set to None if max_throughput_rps (nullable) is None
        # and model_fields_set contains the field
        if self.max_throughput_rps is None and "max_throughput_rps" in self.model_fields_set:
            _dict['max_throughput_rps'] = None

        # set to None if supports_function_calling (nullable) is None
        # and model_fields_set contains the field
        if self.supports_function_calling is None and "supports_function_calling" in self.model_fields_set:
            _dict['supports_function_calling'] = None

        # set to None if supports_json_mode (nullable) is None
        # and model_fields_set contains the field
        if self.supports_json_mode is None and "supports_json_mode" in self.model_fields_set:
            _dict['supports_json_mode'] = None

        # set to None if supports_streaming (nullable) is None
        # and model_fields_set contains the field
        if self.supports_streaming is None and "supports_streaming" in self.model_fields_set:
            _dict['supports_streaming'] = None

        # set to None if supports_fine_tuning (nullable) is None
        # and model_fields_set contains the field
        if self.supports_fine_tuning is None and "supports_fine_tuning" in self.model_fields_set:
            _dict['supports_fine_tuning'] = None

        # set to None if supports_multimodal (nullable) is None
        # and model_fields_set contains the field
        if self.supports_multimodal is None and "supports_multimodal" in self.model_fields_set:
            _dict['supports_multimodal'] = None

        # set to None if has_content_filtering (nullable) is None
        # and model_fields_set contains the field
        if self.has_content_filtering is None and "has_content_filtering" in self.model_fields_set:
            _dict['has_content_filtering'] = None

        # set to None if safety_level (nullable) is None
        # and model_fields_set contains the field
        if self.safety_level is None and "safety_level" in self.model_fields_set:
            _dict['safety_level'] = None

        # set to None if rate_limit_rpm (nullable) is None
        # and model_fields_set contains the field
        if self.rate_limit_rpm is None and "rate_limit_rpm" in self.model_fields_set:
            _dict['rate_limit_rpm'] = None

        # set to None if rate_limit_tpm (nullable) is None
        # and model_fields_set contains the field
        if self.rate_limit_tpm is None and "rate_limit_tpm" in self.model_fields_set:
            _dict['rate_limit_tpm'] = None

        # set to None if is_deprecated (nullable) is None
        # and model_fields_set contains the field
        if self.is_deprecated is None and "is_deprecated" in self.model_fields_set:
            _dict['is_deprecated'] = None

        # set to None if deprecation_date (nullable) is None
        # and model_fields_set contains the field
        if self.deprecation_date is None and "deprecation_date" in self.model_fields_set:
            _dict['deprecation_date'] = None

        # set to None if support_level (nullable) is None
        # and model_fields_set contains the field
        if self.support_level is None and "support_level" in self.model_fields_set:
            _dict['support_level'] = None

        # set to None if primary_use_cases (nullable) is None
        # and model_fields_set contains the field
        if self.primary_use_cases is None and "primary_use_cases" in self.model_fields_set:
            _dict['primary_use_cases'] = None

        # set to None if strengths (nullable) is None
        # and model_fields_set contains the field
        if self.strengths is None and "strengths" in self.model_fields_set:
            _dict['strengths'] = None

        # set to None if limitations (nullable) is None
        # and model_fields_set contains the field
        if self.limitations is None and "limitations" in self.model_fields_set:
            _dict['limitations'] = None

        # set to None if recommended_for (nullable) is None
        # and model_fields_set contains the field
        if self.recommended_for is None and "recommended_for" in self.model_fields_set:
            _dict['recommended_for'] = None

        # set to None if mmlu_score (nullable) is None
        # and model_fields_set contains the field
        if self.mmlu_score is None and "mmlu_score" in self.model_fields_set:
            _dict['mmlu_score'] = None

        # set to None if hellaswag_score (nullable) is None
        # and model_fields_set contains the field
        if self.hellaswag_score is None and "hellaswag_score" in self.model_fields_set:
            _dict['hellaswag_score'] = None

        # set to None if humaneval_score (nullable) is None
        # and model_fields_set contains the field
        if self.humaneval_score is None and "humaneval_score" in self.model_fields_set:
            _dict['humaneval_score'] = None

        # set to None if gsm8k_score (nullable) is None
        # and model_fields_set contains the field
        if self.gsm8k_score is None and "gsm8k_score" in self.model_fields_set:
            _dict['gsm8k_score'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelMetadataUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "display_name": obj.get("display_name"),
            "model_id": obj.get("model_id"),
            "version": obj.get("version"),
            "provider": obj.get("provider"),
            "release_date": obj.get("release_date"),
            "context_window": obj.get("context_window"),
            "max_output_tokens": obj.get("max_output_tokens"),
            "parameter_count": obj.get("parameter_count"),
            "size_class": obj.get("size_class"),
            "model_type": obj.get("model_type"),
            "architecture": obj.get("architecture"),
            "avg_latency_ms": obj.get("avg_latency_ms"),
            "max_throughput_rps": obj.get("max_throughput_rps"),
            "supports_function_calling": obj.get("supports_function_calling"),
            "supports_json_mode": obj.get("supports_json_mode"),
            "supports_streaming": obj.get("supports_streaming"),
            "supports_fine_tuning": obj.get("supports_fine_tuning"),
            "supports_multimodal": obj.get("supports_multimodal"),
            "has_content_filtering": obj.get("has_content_filtering"),
            "safety_level": obj.get("safety_level"),
            "rate_limit_rpm": obj.get("rate_limit_rpm"),
            "rate_limit_tpm": obj.get("rate_limit_tpm"),
            "is_deprecated": obj.get("is_deprecated"),
            "deprecation_date": obj.get("deprecation_date"),
            "support_level": obj.get("support_level"),
            "primary_use_cases": obj.get("primary_use_cases"),
            "strengths": obj.get("strengths"),
            "limitations": obj.get("limitations"),
            "recommended_for": obj.get("recommended_for"),
            "mmlu_score": MmluScore1.from_dict(obj["mmlu_score"]) if obj.get("mmlu_score") is not None else None,
            "hellaswag_score": HellaswagScore1.from_dict(obj["hellaswag_score"]) if obj.get("hellaswag_score") is not None else None,
            "humaneval_score": HumanevalScore1.from_dict(obj["humaneval_score"]) if obj.get("humaneval_score") is not None else None,
            "gsm8k_score": Gsm8KScore1.from_dict(obj["gsm8k_score"]) if obj.get("gsm8k_score") is not None else None
        })
        return _obj


