# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.docker_metadata import DockerMetadata
from perian.models.requirement_metadata import RequirementMetadata
from typing import Optional, Set
from typing_extensions import Self

class ModelTemplate(BaseModel):
    """
    Data model representation of a model template.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: StrictStr
    description: Optional[StrictStr] = None
    container_port: Optional[StrictInt] = None
    docker_metadata: DockerMetadata
    requirement_metadata: RequirementMetadata
    avg_startup_time_min: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    reference_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "container_port", "docker_metadata", "requirement_metadata", "avg_startup_time_min", "created_at", "updated_at", "reference_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of docker_metadata
        if self.docker_metadata:
            _dict['docker_metadata'] = self.docker_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requirement_metadata
        if self.requirement_metadata:
            _dict['requirement_metadata'] = self.requirement_metadata.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if container_port (nullable) is None
        # and model_fields_set contains the field
        if self.container_port is None and "container_port" in self.model_fields_set:
            _dict['container_port'] = None

        # set to None if avg_startup_time_min (nullable) is None
        # and model_fields_set contains the field
        if self.avg_startup_time_min is None and "avg_startup_time_min" in self.model_fields_set:
            _dict['avg_startup_time_min'] = None

        # set to None if reference_id (nullable) is None
        # and model_fields_set contains the field
        if self.reference_id is None and "reference_id" in self.model_fields_set:
            _dict['reference_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "container_port": obj.get("container_port"),
            "docker_metadata": DockerMetadata.from_dict(obj["docker_metadata"]) if obj.get("docker_metadata") is not None else None,
            "requirement_metadata": RequirementMetadata.from_dict(obj["requirement_metadata"]) if obj.get("requirement_metadata") is not None else None,
            "avg_startup_time_min": obj.get("avg_startup_time_min"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "reference_id": obj.get("reference_id")
        })
        return _obj


