import builtins  # noqa: F401
from files_sdk.api import Api  # noqa: F401
from files_sdk.list_obj import ListObj
from files_sdk.error import (  # noqa: F401
    InvalidParameterError,
    MissingParameterError,
    NotImplementedError,
)


class ApiRequestLog:
    default_attributes = {
        "timestamp": None,  # date-time - Start Time of Action. Deprecrated: Use created_at.
        "api_key_id": None,  # int64 - API Key ID, if applicable
        "api_key_prefix": None,  # string - API Key Prefix, if applicable
        "user_id": None,  # int64 - User ID
        "username": None,  # string - Username
        "user_is_from_parent_site": None,  # boolean - true if this change was performed by a user on a parent site.
        "interface": None,  # string - API Interface
        "request_method": None,  # string - HTTP Method
        "request_path": None,  # string - Request path
        "request_ip": None,  # string - IP of requesting client
        "request_host": None,  # string - Hostname the request was sent to
        "request_id": None,  # string - Unique Id of the Request
        "api_name": None,  # string - Name of API Endpoint
        "user_agent": None,  # string - User-Agent
        "error_type": None,  # string - Error type, if applicable
        "error_message": None,  # string - Error message, if applicable
        "response_code": None,  # int64 - HTTP Response Code
        "success": None,  # boolean - `false` if HTTP Response Code is 4xx or 5xx
        "duration_ms": None,  # int64 - Duration (in milliseconds)
        "impersonator_user_id": None,  # int64 - User ID of Site Admin user impersonating this user via a Read-Only session.
        "created_at": None,  # date-time - Start Time of Action
    }

    def __init__(self, attributes=None, options=None):
        if not isinstance(attributes, dict):
            attributes = {}
        if not isinstance(options, dict):
            options = {}
        self.set_attributes(attributes)
        self.options = options

    def set_attributes(self, attributes):
        for (
            attribute,
            default_value,
        ) in ApiRequestLog.default_attributes.items():
            setattr(self, attribute, attributes.get(attribute, default_value))

    def get_attributes(self):
        return {
            k: getattr(self, k, None)
            for k in ApiRequestLog.default_attributes
            if getattr(self, k, None) is not None
        }


# Parameters:
#   cursor - string - Used for pagination.  When a list request has more records available, cursors are provided in the response headers `X-Files-Cursor-Next` and `X-Files-Cursor-Prev`.  Send one of those cursor value here to resume an existing list from the next available record.  Note: many of our SDKs have iterator methods that will automatically handle cursor-based pagination.
#   per_page - int64 - Number of records to show per page.  (Max: 10,000, 1,000 or less is recommended).
#   filter - object - If set, return records where the specified field is equal to the supplied value. Valid fields are `api_key_id`, `interface`, `request_id`, `request_ip`, `request_method`, `success`, `user_id` or `created_at`. Valid field combinations are `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ created_at ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ api_key_id, created_at ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ interface, created_at ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_id, created_at ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_ip, created_at ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ request_method, created_at ]`, `[ success, user_id ]`, `[ success, created_at ]`, `[ user_id, created_at ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, interface, created_at ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_id, created_at ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_ip, created_at ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, request_method, created_at ]`, `[ api_key_id, success, user_id ]`, `[ api_key_id, success, created_at ]`, `[ api_key_id, user_id, created_at ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_id, created_at ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_ip, created_at ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, request_method, created_at ]`, `[ interface, success, user_id ]`, `[ interface, success, created_at ]`, `[ interface, user_id, created_at ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_ip, created_at ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, request_method, created_at ]`, `[ request_id, success, user_id ]`, `[ request_id, success, created_at ]`, `[ request_id, user_id, created_at ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, request_method, created_at ]`, `[ request_ip, success, user_id ]`, `[ request_ip, success, created_at ]`, `[ request_ip, user_id, created_at ]`, `[ request_method, success, user_id ]`, `[ request_method, success, created_at ]`, `[ request_method, user_id, created_at ]`, `[ success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_ip, created_at ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, request_method, created_at ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, interface, success, created_at ]`, `[ api_key_id, interface, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_ip, created_at ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, request_method, created_at ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_id, success, created_at ]`, `[ api_key_id, request_id, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_ip, success, created_at ]`, `[ api_key_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id ]`, `[ api_key_id, request_method, success, created_at ]`, `[ api_key_id, request_method, user_id, created_at ]`, `[ api_key_id, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_ip, created_at ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, request_method, created_at ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_id, success, created_at ]`, `[ interface, request_id, user_id, created_at ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, request_method, created_at ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_ip, success, created_at ]`, `[ interface, request_ip, user_id, created_at ]`, `[ interface, request_method, success, user_id ]`, `[ interface, request_method, success, created_at ]`, `[ interface, request_method, user_id, created_at ]`, `[ interface, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, request_method, created_at ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_ip, success, created_at ]`, `[ request_id, request_ip, user_id, created_at ]`, `[ request_id, request_method, success, user_id ]`, `[ request_id, request_method, success, created_at ]`, `[ request_id, request_method, user_id, created_at ]`, `[ request_id, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id ]`, `[ request_ip, request_method, success, created_at ]`, `[ request_ip, request_method, user_id, created_at ]`, `[ request_ip, success, user_id, created_at ]`, `[ request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_ip, created_at ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_method, created_at ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_id, success, created_at ]`, `[ api_key_id, interface, request_id, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_ip, success, created_at ]`, `[ api_key_id, interface, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, interface, request_method, success, created_at ]`, `[ api_key_id, interface, request_method, user_id, created_at ]`, `[ api_key_id, interface, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_ip, success, created_at ]`, `[ api_key_id, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_id, request_method, success, created_at ]`, `[ api_key_id, request_id, request_method, user_id, created_at ]`, `[ api_key_id, request_id, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, request_method, created_at ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_ip, success, created_at ]`, `[ interface, request_id, request_ip, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_id, request_method, success, created_at ]`, `[ interface, request_id, request_method, user_id, created_at ]`, `[ interface, request_id, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, created_at ]`, `[ interface, request_ip, request_method, user_id, created_at ]`, `[ interface, request_ip, success, user_id, created_at ]`, `[ interface, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, created_at ]`, `[ request_id, request_ip, request_method, user_id, created_at ]`, `[ request_id, request_ip, success, user_id, created_at ]`, `[ request_id, request_method, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, created_at ]`, `[ interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ interface, request_id, request_ip, success, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id, created_at ]` or `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id, created_at ]`.
#   filter_gt - object - If set, return records where the specified field is greater than the supplied value. Valid fields are `created_at`. Valid field combinations are `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ created_at ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ api_key_id, created_at ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ interface, created_at ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_id, created_at ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_ip, created_at ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ request_method, created_at ]`, `[ success, user_id ]`, `[ success, created_at ]`, `[ user_id, created_at ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, interface, created_at ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_id, created_at ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_ip, created_at ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, request_method, created_at ]`, `[ api_key_id, success, user_id ]`, `[ api_key_id, success, created_at ]`, `[ api_key_id, user_id, created_at ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_id, created_at ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_ip, created_at ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, request_method, created_at ]`, `[ interface, success, user_id ]`, `[ interface, success, created_at ]`, `[ interface, user_id, created_at ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_ip, created_at ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, request_method, created_at ]`, `[ request_id, success, user_id ]`, `[ request_id, success, created_at ]`, `[ request_id, user_id, created_at ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, request_method, created_at ]`, `[ request_ip, success, user_id ]`, `[ request_ip, success, created_at ]`, `[ request_ip, user_id, created_at ]`, `[ request_method, success, user_id ]`, `[ request_method, success, created_at ]`, `[ request_method, user_id, created_at ]`, `[ success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_ip, created_at ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, request_method, created_at ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, interface, success, created_at ]`, `[ api_key_id, interface, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_ip, created_at ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, request_method, created_at ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_id, success, created_at ]`, `[ api_key_id, request_id, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_ip, success, created_at ]`, `[ api_key_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id ]`, `[ api_key_id, request_method, success, created_at ]`, `[ api_key_id, request_method, user_id, created_at ]`, `[ api_key_id, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_ip, created_at ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, request_method, created_at ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_id, success, created_at ]`, `[ interface, request_id, user_id, created_at ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, request_method, created_at ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_ip, success, created_at ]`, `[ interface, request_ip, user_id, created_at ]`, `[ interface, request_method, success, user_id ]`, `[ interface, request_method, success, created_at ]`, `[ interface, request_method, user_id, created_at ]`, `[ interface, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, request_method, created_at ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_ip, success, created_at ]`, `[ request_id, request_ip, user_id, created_at ]`, `[ request_id, request_method, success, user_id ]`, `[ request_id, request_method, success, created_at ]`, `[ request_id, request_method, user_id, created_at ]`, `[ request_id, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id ]`, `[ request_ip, request_method, success, created_at ]`, `[ request_ip, request_method, user_id, created_at ]`, `[ request_ip, success, user_id, created_at ]`, `[ request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_ip, created_at ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_method, created_at ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_id, success, created_at ]`, `[ api_key_id, interface, request_id, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_ip, success, created_at ]`, `[ api_key_id, interface, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, interface, request_method, success, created_at ]`, `[ api_key_id, interface, request_method, user_id, created_at ]`, `[ api_key_id, interface, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_ip, success, created_at ]`, `[ api_key_id, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_id, request_method, success, created_at ]`, `[ api_key_id, request_id, request_method, user_id, created_at ]`, `[ api_key_id, request_id, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, request_method, created_at ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_ip, success, created_at ]`, `[ interface, request_id, request_ip, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_id, request_method, success, created_at ]`, `[ interface, request_id, request_method, user_id, created_at ]`, `[ interface, request_id, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, created_at ]`, `[ interface, request_ip, request_method, user_id, created_at ]`, `[ interface, request_ip, success, user_id, created_at ]`, `[ interface, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, created_at ]`, `[ request_id, request_ip, request_method, user_id, created_at ]`, `[ request_id, request_ip, success, user_id, created_at ]`, `[ request_id, request_method, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, created_at ]`, `[ interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ interface, request_id, request_ip, success, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id, created_at ]` or `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id, created_at ]`.
#   filter_gteq - object - If set, return records where the specified field is greater than or equal the supplied value. Valid fields are `created_at`. Valid field combinations are `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ created_at ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ api_key_id, created_at ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ interface, created_at ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_id, created_at ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_ip, created_at ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ request_method, created_at ]`, `[ success, user_id ]`, `[ success, created_at ]`, `[ user_id, created_at ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, interface, created_at ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_id, created_at ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_ip, created_at ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, request_method, created_at ]`, `[ api_key_id, success, user_id ]`, `[ api_key_id, success, created_at ]`, `[ api_key_id, user_id, created_at ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_id, created_at ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_ip, created_at ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, request_method, created_at ]`, `[ interface, success, user_id ]`, `[ interface, success, created_at ]`, `[ interface, user_id, created_at ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_ip, created_at ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, request_method, created_at ]`, `[ request_id, success, user_id ]`, `[ request_id, success, created_at ]`, `[ request_id, user_id, created_at ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, request_method, created_at ]`, `[ request_ip, success, user_id ]`, `[ request_ip, success, created_at ]`, `[ request_ip, user_id, created_at ]`, `[ request_method, success, user_id ]`, `[ request_method, success, created_at ]`, `[ request_method, user_id, created_at ]`, `[ success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_ip, created_at ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, request_method, created_at ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, interface, success, created_at ]`, `[ api_key_id, interface, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_ip, created_at ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, request_method, created_at ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_id, success, created_at ]`, `[ api_key_id, request_id, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_ip, success, created_at ]`, `[ api_key_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id ]`, `[ api_key_id, request_method, success, created_at ]`, `[ api_key_id, request_method, user_id, created_at ]`, `[ api_key_id, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_ip, created_at ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, request_method, created_at ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_id, success, created_at ]`, `[ interface, request_id, user_id, created_at ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, request_method, created_at ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_ip, success, created_at ]`, `[ interface, request_ip, user_id, created_at ]`, `[ interface, request_method, success, user_id ]`, `[ interface, request_method, success, created_at ]`, `[ interface, request_method, user_id, created_at ]`, `[ interface, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, request_method, created_at ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_ip, success, created_at ]`, `[ request_id, request_ip, user_id, created_at ]`, `[ request_id, request_method, success, user_id ]`, `[ request_id, request_method, success, created_at ]`, `[ request_id, request_method, user_id, created_at ]`, `[ request_id, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id ]`, `[ request_ip, request_method, success, created_at ]`, `[ request_ip, request_method, user_id, created_at ]`, `[ request_ip, success, user_id, created_at ]`, `[ request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_ip, created_at ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_method, created_at ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_id, success, created_at ]`, `[ api_key_id, interface, request_id, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_ip, success, created_at ]`, `[ api_key_id, interface, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, interface, request_method, success, created_at ]`, `[ api_key_id, interface, request_method, user_id, created_at ]`, `[ api_key_id, interface, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_ip, success, created_at ]`, `[ api_key_id, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_id, request_method, success, created_at ]`, `[ api_key_id, request_id, request_method, user_id, created_at ]`, `[ api_key_id, request_id, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, request_method, created_at ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_ip, success, created_at ]`, `[ interface, request_id, request_ip, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_id, request_method, success, created_at ]`, `[ interface, request_id, request_method, user_id, created_at ]`, `[ interface, request_id, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, created_at ]`, `[ interface, request_ip, request_method, user_id, created_at ]`, `[ interface, request_ip, success, user_id, created_at ]`, `[ interface, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, created_at ]`, `[ request_id, request_ip, request_method, user_id, created_at ]`, `[ request_id, request_ip, success, user_id, created_at ]`, `[ request_id, request_method, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, created_at ]`, `[ interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ interface, request_id, request_ip, success, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id, created_at ]` or `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id, created_at ]`.
#   filter_prefix - object - If set, return records where the specified field is prefixed by the supplied value. Valid fields are `interface`, `request_id`, `request_ip` or `request_method`. Valid field combinations are `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ created_at ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ api_key_id, created_at ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ interface, created_at ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_id, created_at ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_ip, created_at ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ request_method, created_at ]`, `[ success, user_id ]`, `[ success, created_at ]`, `[ user_id, created_at ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, interface, created_at ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_id, created_at ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_ip, created_at ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, request_method, created_at ]`, `[ api_key_id, success, user_id ]`, `[ api_key_id, success, created_at ]`, `[ api_key_id, user_id, created_at ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_id, created_at ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_ip, created_at ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, request_method, created_at ]`, `[ interface, success, user_id ]`, `[ interface, success, created_at ]`, `[ interface, user_id, created_at ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_ip, created_at ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, request_method, created_at ]`, `[ request_id, success, user_id ]`, `[ request_id, success, created_at ]`, `[ request_id, user_id, created_at ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, request_method, created_at ]`, `[ request_ip, success, user_id ]`, `[ request_ip, success, created_at ]`, `[ request_ip, user_id, created_at ]`, `[ request_method, success, user_id ]`, `[ request_method, success, created_at ]`, `[ request_method, user_id, created_at ]`, `[ success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_ip, created_at ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, request_method, created_at ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, interface, success, created_at ]`, `[ api_key_id, interface, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_ip, created_at ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, request_method, created_at ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_id, success, created_at ]`, `[ api_key_id, request_id, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_ip, success, created_at ]`, `[ api_key_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id ]`, `[ api_key_id, request_method, success, created_at ]`, `[ api_key_id, request_method, user_id, created_at ]`, `[ api_key_id, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_ip, created_at ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, request_method, created_at ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_id, success, created_at ]`, `[ interface, request_id, user_id, created_at ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, request_method, created_at ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_ip, success, created_at ]`, `[ interface, request_ip, user_id, created_at ]`, `[ interface, request_method, success, user_id ]`, `[ interface, request_method, success, created_at ]`, `[ interface, request_method, user_id, created_at ]`, `[ interface, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, request_method, created_at ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_ip, success, created_at ]`, `[ request_id, request_ip, user_id, created_at ]`, `[ request_id, request_method, success, user_id ]`, `[ request_id, request_method, success, created_at ]`, `[ request_id, request_method, user_id, created_at ]`, `[ request_id, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id ]`, `[ request_ip, request_method, success, created_at ]`, `[ request_ip, request_method, user_id, created_at ]`, `[ request_ip, success, user_id, created_at ]`, `[ request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_ip, created_at ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_method, created_at ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_id, success, created_at ]`, `[ api_key_id, interface, request_id, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_ip, success, created_at ]`, `[ api_key_id, interface, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, interface, request_method, success, created_at ]`, `[ api_key_id, interface, request_method, user_id, created_at ]`, `[ api_key_id, interface, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_ip, success, created_at ]`, `[ api_key_id, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_id, request_method, success, created_at ]`, `[ api_key_id, request_id, request_method, user_id, created_at ]`, `[ api_key_id, request_id, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, request_method, created_at ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_ip, success, created_at ]`, `[ interface, request_id, request_ip, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_id, request_method, success, created_at ]`, `[ interface, request_id, request_method, user_id, created_at ]`, `[ interface, request_id, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, created_at ]`, `[ interface, request_ip, request_method, user_id, created_at ]`, `[ interface, request_ip, success, user_id, created_at ]`, `[ interface, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, created_at ]`, `[ request_id, request_ip, request_method, user_id, created_at ]`, `[ request_id, request_ip, success, user_id, created_at ]`, `[ request_id, request_method, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, created_at ]`, `[ interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ interface, request_id, request_ip, success, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id, created_at ]` or `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id, created_at ]`.
#   filter_lt - object - If set, return records where the specified field is less than the supplied value. Valid fields are `created_at`. Valid field combinations are `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ created_at ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ api_key_id, created_at ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ interface, created_at ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_id, created_at ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_ip, created_at ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ request_method, created_at ]`, `[ success, user_id ]`, `[ success, created_at ]`, `[ user_id, created_at ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, interface, created_at ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_id, created_at ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_ip, created_at ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, request_method, created_at ]`, `[ api_key_id, success, user_id ]`, `[ api_key_id, success, created_at ]`, `[ api_key_id, user_id, created_at ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_id, created_at ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_ip, created_at ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, request_method, created_at ]`, `[ interface, success, user_id ]`, `[ interface, success, created_at ]`, `[ interface, user_id, created_at ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_ip, created_at ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, request_method, created_at ]`, `[ request_id, success, user_id ]`, `[ request_id, success, created_at ]`, `[ request_id, user_id, created_at ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, request_method, created_at ]`, `[ request_ip, success, user_id ]`, `[ request_ip, success, created_at ]`, `[ request_ip, user_id, created_at ]`, `[ request_method, success, user_id ]`, `[ request_method, success, created_at ]`, `[ request_method, user_id, created_at ]`, `[ success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_ip, created_at ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, request_method, created_at ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, interface, success, created_at ]`, `[ api_key_id, interface, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_ip, created_at ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, request_method, created_at ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_id, success, created_at ]`, `[ api_key_id, request_id, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_ip, success, created_at ]`, `[ api_key_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id ]`, `[ api_key_id, request_method, success, created_at ]`, `[ api_key_id, request_method, user_id, created_at ]`, `[ api_key_id, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_ip, created_at ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, request_method, created_at ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_id, success, created_at ]`, `[ interface, request_id, user_id, created_at ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, request_method, created_at ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_ip, success, created_at ]`, `[ interface, request_ip, user_id, created_at ]`, `[ interface, request_method, success, user_id ]`, `[ interface, request_method, success, created_at ]`, `[ interface, request_method, user_id, created_at ]`, `[ interface, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, request_method, created_at ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_ip, success, created_at ]`, `[ request_id, request_ip, user_id, created_at ]`, `[ request_id, request_method, success, user_id ]`, `[ request_id, request_method, success, created_at ]`, `[ request_id, request_method, user_id, created_at ]`, `[ request_id, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id ]`, `[ request_ip, request_method, success, created_at ]`, `[ request_ip, request_method, user_id, created_at ]`, `[ request_ip, success, user_id, created_at ]`, `[ request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_ip, created_at ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_method, created_at ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_id, success, created_at ]`, `[ api_key_id, interface, request_id, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_ip, success, created_at ]`, `[ api_key_id, interface, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, interface, request_method, success, created_at ]`, `[ api_key_id, interface, request_method, user_id, created_at ]`, `[ api_key_id, interface, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_ip, success, created_at ]`, `[ api_key_id, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_id, request_method, success, created_at ]`, `[ api_key_id, request_id, request_method, user_id, created_at ]`, `[ api_key_id, request_id, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, request_method, created_at ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_ip, success, created_at ]`, `[ interface, request_id, request_ip, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_id, request_method, success, created_at ]`, `[ interface, request_id, request_method, user_id, created_at ]`, `[ interface, request_id, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, created_at ]`, `[ interface, request_ip, request_method, user_id, created_at ]`, `[ interface, request_ip, success, user_id, created_at ]`, `[ interface, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, created_at ]`, `[ request_id, request_ip, request_method, user_id, created_at ]`, `[ request_id, request_ip, success, user_id, created_at ]`, `[ request_id, request_method, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, created_at ]`, `[ interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ interface, request_id, request_ip, success, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id, created_at ]` or `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id, created_at ]`.
#   filter_lteq - object - If set, return records where the specified field is less than or equal the supplied value. Valid fields are `created_at`. Valid field combinations are `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ created_at ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ api_key_id, created_at ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ interface, created_at ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_id, created_at ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_ip, created_at ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ request_method, created_at ]`, `[ success, user_id ]`, `[ success, created_at ]`, `[ user_id, created_at ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, interface, created_at ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_id, created_at ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_ip, created_at ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, request_method, created_at ]`, `[ api_key_id, success, user_id ]`, `[ api_key_id, success, created_at ]`, `[ api_key_id, user_id, created_at ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_id, created_at ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_ip, created_at ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, request_method, created_at ]`, `[ interface, success, user_id ]`, `[ interface, success, created_at ]`, `[ interface, user_id, created_at ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_ip, created_at ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, request_method, created_at ]`, `[ request_id, success, user_id ]`, `[ request_id, success, created_at ]`, `[ request_id, user_id, created_at ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, request_method, created_at ]`, `[ request_ip, success, user_id ]`, `[ request_ip, success, created_at ]`, `[ request_ip, user_id, created_at ]`, `[ request_method, success, user_id ]`, `[ request_method, success, created_at ]`, `[ request_method, user_id, created_at ]`, `[ success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_ip, created_at ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, request_method, created_at ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, interface, success, created_at ]`, `[ api_key_id, interface, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_ip, created_at ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, request_method, created_at ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_id, success, created_at ]`, `[ api_key_id, request_id, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_ip, success, created_at ]`, `[ api_key_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id ]`, `[ api_key_id, request_method, success, created_at ]`, `[ api_key_id, request_method, user_id, created_at ]`, `[ api_key_id, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_ip, created_at ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, request_method, created_at ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_id, success, created_at ]`, `[ interface, request_id, user_id, created_at ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, request_method, created_at ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_ip, success, created_at ]`, `[ interface, request_ip, user_id, created_at ]`, `[ interface, request_method, success, user_id ]`, `[ interface, request_method, success, created_at ]`, `[ interface, request_method, user_id, created_at ]`, `[ interface, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, request_method, created_at ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_ip, success, created_at ]`, `[ request_id, request_ip, user_id, created_at ]`, `[ request_id, request_method, success, user_id ]`, `[ request_id, request_method, success, created_at ]`, `[ request_id, request_method, user_id, created_at ]`, `[ request_id, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id ]`, `[ request_ip, request_method, success, created_at ]`, `[ request_ip, request_method, user_id, created_at ]`, `[ request_ip, success, user_id, created_at ]`, `[ request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_ip, created_at ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_method, created_at ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_id, success, created_at ]`, `[ api_key_id, interface, request_id, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_ip, success, created_at ]`, `[ api_key_id, interface, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, interface, request_method, success, created_at ]`, `[ api_key_id, interface, request_method, user_id, created_at ]`, `[ api_key_id, interface, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_ip, success, created_at ]`, `[ api_key_id, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_id, request_method, success, created_at ]`, `[ api_key_id, request_id, request_method, user_id, created_at ]`, `[ api_key_id, request_id, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, request_method, created_at ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_ip, success, created_at ]`, `[ interface, request_id, request_ip, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_id, request_method, success, created_at ]`, `[ interface, request_id, request_method, user_id, created_at ]`, `[ interface, request_id, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, created_at ]`, `[ interface, request_ip, request_method, user_id, created_at ]`, `[ interface, request_ip, success, user_id, created_at ]`, `[ interface, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, created_at ]`, `[ request_id, request_ip, request_method, user_id, created_at ]`, `[ request_id, request_ip, success, user_id, created_at ]`, `[ request_id, request_method, success, user_id, created_at ]`, `[ request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, created_at ]`, `[ interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ interface, request_id, request_ip, success, user_id, created_at ]`, `[ interface, request_id, request_method, success, user_id, created_at ]`, `[ interface, request_ip, request_method, success, user_id, created_at ]`, `[ request_id, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, created_at ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id, created_at ]`, `[ api_key_id, interface, request_id, request_method, success, user_id, created_at ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id, created_at ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id, created_at ]`, `[ interface, request_id, request_ip, request_method, success, user_id, created_at ]` or `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id, created_at ]`.
def list(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    if "cursor" in params and not isinstance(params["cursor"], str):
        raise InvalidParameterError("Bad parameter: cursor must be an str")
    if "per_page" in params and not isinstance(params["per_page"], int):
        raise InvalidParameterError("Bad parameter: per_page must be an int")
    if "filter" in params and not isinstance(params["filter"], dict):
        raise InvalidParameterError("Bad parameter: filter must be an dict")
    if "filter_gt" in params and not isinstance(params["filter_gt"], dict):
        raise InvalidParameterError("Bad parameter: filter_gt must be an dict")
    if "filter_gteq" in params and not isinstance(params["filter_gteq"], dict):
        raise InvalidParameterError(
            "Bad parameter: filter_gteq must be an dict"
        )
    if "filter_prefix" in params and not isinstance(
        params["filter_prefix"], dict
    ):
        raise InvalidParameterError(
            "Bad parameter: filter_prefix must be an dict"
        )
    if "filter_lt" in params and not isinstance(params["filter_lt"], dict):
        raise InvalidParameterError("Bad parameter: filter_lt must be an dict")
    if "filter_lteq" in params and not isinstance(params["filter_lteq"], dict):
        raise InvalidParameterError(
            "Bad parameter: filter_lteq must be an dict"
        )
    return ListObj(ApiRequestLog, "GET", "/api_request_logs", params, options)


def all(params=None, options=None):
    list(params, options)


def new(*args, **kwargs):
    return ApiRequestLog(*args, **kwargs)
