"""
Subclasses SolweigRunCore - swaps in solweig function which calls Rust implementations of shadowing and GVF calculations
"""

import numpy as np
from umep.class_configs import EnvironData, ShadowMatrices, SvfData, TgMaps, WallsData
from umep.functions.SOLWEIGpython.solweig_runner_core import SolweigRunCore

from .functions.solweig import Solweig_2025a_calc as Solweig_2025a_calc_hybrid


class SolweigRunRust(SolweigRunCore):
    """Class to run the SOLWEIG algorithm with Rust optimisations."""

    def calc_solweig(
        self,
        iter: int,
        buildings: np.ndarray,
        vegdsm: np.ndarray,
        vegdsm2: np.ndarray,
        svfbuveg: np.ndarray,
        bush: np.ndarray,
        lcgrid: np.ndarray,
        wallaspect: np.ndarray,
        wallheight: np.ndarray,
        elvis: float,
        CI: float,
        amaxvalue: float,
        Twater: float,
        first: float,
        second: float,
        firstdaytime: float,
        timeadd: float,
        timestepdec: float,
        posture,
        svf_data: SvfData,
        environ_data: EnvironData,
        tg_maps: TgMaps,
        shadow_mats: ShadowMatrices,
        walls_data: WallsData,
    ):
        """
        Calculate SOLWEIG results for the given iteration.
        Uses variant with GVF and Shadows rust optimisations.
        """
        return Solweig_2025a_calc_hybrid(
            iter,
            self.dsm_arr,
            self.scale,
            self.rows,
            self.cols,
            svf_data.svf,
            svf_data.svf_north,
            svf_data.svf_west,
            svf_data.svf_east,
            svf_data.svf_south,
            svf_data.svf_veg,
            svf_data.svf_veg_north,
            svf_data.svf_veg_east,
            svf_data.svf_veg_south,
            svf_data.svf_veg_west,
            svf_data.svf_veg_blocks_bldg_sh,
            svf_data.svf_veg_blocks_bldg_sh_east,
            svf_data.svf_veg_blocks_bldg_sh_south,
            svf_data.svf_veg_blocks_bldg_sh_west,
            svf_data.svf_veg_blocks_bldg_sh_north,
            vegdsm,
            vegdsm2,
            self.params.Albedo.Effective.Value.Walls,
            self.params.Tmrt_params.Value.absK,
            self.params.Tmrt_params.Value.absL,
            self.params.Emissivity.Value.Walls,
            posture.Fside,
            posture.Fup,
            posture.Fcyl,
            environ_data.altitude[iter],
            environ_data.azimuth[iter],
            environ_data.zen[iter],
            environ_data.jday[iter],
            self.config.use_veg_dem,
            self.config.only_global,
            buildings,
            self.location,
            environ_data.psi[iter],
            self.config.use_landcover,
            lcgrid,
            environ_data.dectime[iter],
            environ_data.altmax[iter],
            wallaspect,
            wallheight,
            self.config.person_cylinder,
            elvis,
            environ_data.Ta[iter],
            environ_data.RH[iter],
            environ_data.radG[iter],
            environ_data.radD[iter],
            environ_data.radI[iter],
            environ_data.P[iter],
            amaxvalue,
            bush,
            Twater,
            tg_maps.TgK,
            tg_maps.Tstart,
            tg_maps.alb_grid,
            tg_maps.emis_grid,
            tg_maps.TgK_wall,
            tg_maps.Tstart_wall,
            tg_maps.TmaxLST,
            tg_maps.TmaxLST_wall,
            first,
            second,
            svf_data.svfalfa,
            svfbuveg,
            firstdaytime,
            timeadd,
            timestepdec,
            tg_maps.Tgmap1,
            tg_maps.Tgmap1E,
            tg_maps.Tgmap1S,
            tg_maps.Tgmap1W,
            tg_maps.Tgmap1N,
            CI,
            tg_maps.TgOut1,
            shadow_mats.diffsh,
            shadow_mats.shmat,
            shadow_mats.vegshmat,
            shadow_mats.vbshvegshmat,
            self.config.use_aniso,
            shadow_mats.asvf,
            shadow_mats.patch_option,
            walls_data.voxelMaps,
            walls_data.voxelTable,
            environ_data.Ws[iter],
            self.config.use_wall_scheme,
            walls_data.timeStep,
            shadow_mats.steradians,
            walls_data.walls_scheme,
            walls_data.dirwalls_scheme,
        )
