# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.schedule_config import ScheduleConfig
from ..types.source_connection import SourceConnection
from ..types.source_connection_job import SourceConnectionJob
from ..types.source_connection_list_item import SourceConnectionListItem
from .raw_client import AsyncRawSourceConnectionsClient, RawSourceConnectionsClient
from .types.authentication import Authentication

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SourceConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSourceConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSourceConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSourceConnectionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        collection: typing.Optional[str] = None,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[SourceConnectionListItem]:
        """
        List source connections with minimal fields for performance.

        Parameters
        ----------
        collection : typing.Optional[str]
            Filter by collection readable ID

        skip : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionListItem]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.list(
            collection="collection",
            skip=1,
            limit=1,
        )
        """
        _response = self._raw_client.list(
            collection=collection, skip=skip, limit=limit, request_options=request_options
        )
        return _response.data

    def create(
        self,
        *,
        short_name: str,
        readable_collection_id: str,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        schedule: typing.Optional[ScheduleConfig] = OMIT,
        sync_immediately: typing.Optional[bool] = OMIT,
        authentication: typing.Optional[Authentication] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnection:
        """
        Create a new source connection.

        The authentication configuration determines the flow:
        - DirectAuthentication: Immediate creation with provided credentials
        - OAuthBrowserAuthentication: Returns shell with authentication URL
        - OAuthTokenAuthentication: Immediate creation with provided token
        - AuthProviderAuthentication: Using external auth provider

        BYOC (Bring Your Own Client) is detected when client_id and client_secret
        are provided in OAuthBrowserAuthentication.

        sync_immediately defaults:
        - True for: direct, oauth_token, auth_provider
        - False for: oauth_browser, oauth_byoc (these sync after authentication)

        Parameters
        ----------
        short_name : str
            Source identifier (e.g., 'slack', 'github')

        readable_collection_id : str
            Collection readable ID

        name : typing.Optional[str]
            Connection name (defaults to '{Source Name} Connection')

        description : typing.Optional[str]
            Connection description

        config : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Source-specific configuration

        schedule : typing.Optional[ScheduleConfig]

        sync_immediately : typing.Optional[bool]
            Run initial sync after creation. Defaults to True for direct/token/auth_provider, False for OAuth browser/BYOC flows (which sync after authentication)

        authentication : typing.Optional[Authentication]
            Authentication config (defaults to OAuth browser flow for OAuth sources)

        redirect_url : typing.Optional[str]
            URL to redirect to after OAuth flow completes (only used for OAuth flows)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.create(
            short_name="short_name",
            readable_collection_id="readable_collection_id",
        )
        """
        _response = self._raw_client.create(
            short_name=short_name,
            readable_collection_id=readable_collection_id,
            name=name,
            description=description,
            config=config,
            schedule=schedule,
            sync_immediately=sync_immediately,
            authentication=authentication,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, source_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SourceConnection:
        """
        Get a source connection with optional depth expansion.

        Parameters
        ----------
        source_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.get(
            source_connection_id="source_connection_id",
        )
        """
        _response = self._raw_client.get(source_connection_id, request_options=request_options)
        return _response.data

    def delete(
        self, source_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SourceConnection:
        """
        Delete a source connection and all related data.

        Parameters
        ----------
        source_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.delete(
            source_connection_id="source_connection_id",
        )
        """
        _response = self._raw_client.delete(source_connection_id, request_options=request_options)
        return _response.data

    def update(
        self,
        source_connection_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        schedule: typing.Optional[ScheduleConfig] = OMIT,
        authentication: typing.Optional[Authentication] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnection:
        """
        Update a source connection.

        Updateable fields:
        - name, description
        - config_fields
        - cron_schedule
        - auth_fields (direct auth only)

        Parameters
        ----------
        source_connection_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        config : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Source-specific configuration

        schedule : typing.Optional[ScheduleConfig]

        authentication : typing.Optional[Authentication]
            Authentication config (defaults to OAuth browser flow for OAuth sources)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.update(
            source_connection_id="source_connection_id",
        )
        """
        _response = self._raw_client.update(
            source_connection_id,
            name=name,
            description=description,
            config=config,
            schedule=schedule,
            authentication=authentication,
            request_options=request_options,
        )
        return _response.data

    def run(
        self,
        source_connection_id: str,
        *,
        force_full_sync: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnectionJob:
        """
        Trigger a sync run for a source connection.

        Runs are always executed through Temporal workflow engine.

        Args:
            db: Database session
            source_connection_id: ID of the source connection to run
            ctx: API context with organization and user information
            guard_rail: Guard rail service for usage limits
            force_full_sync: If True, forces a full sync with orphaned entity cleanup
                            for continuous syncs. Raises 400 error if used on
                            non-continuous syncs (which are always full syncs).

        Parameters
        ----------
        source_connection_id : str

        force_full_sync : typing.Optional[bool]
            Force a full sync ignoring cursor data instead of waiting for the daily cleanup schedule. Only allowed for continuous syncs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnectionJob
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.run(
            source_connection_id="source_connection_id",
            force_full_sync=True,
        )
        """
        _response = self._raw_client.run(
            source_connection_id, force_full_sync=force_full_sync, request_options=request_options
        )
        return _response.data

    def get_source_connection_jobs(
        self,
        source_connection_id: str,
        *,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[SourceConnectionJob]:
        """
        Get sync jobs for a source connection.

        Parameters
        ----------
        source_connection_id : str

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.get_source_connection_jobs(
            source_connection_id="source_connection_id",
            limit=1,
        )
        """
        _response = self._raw_client.get_source_connection_jobs(
            source_connection_id, limit=limit, request_options=request_options
        )
        return _response.data

    def cancel_job(
        self, source_connection_id: str, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SourceConnectionJob:
        """
        Cancel a running sync job for a source connection.

        This endpoint requests cancellation and marks the job as CANCELLING.
        The workflow updates the final status to CANCELLED when it processes
        the cancellation request.

        Parameters
        ----------
        source_connection_id : str

        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnectionJob
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.source_connections.cancel_job(
            source_connection_id="source_connection_id",
            job_id="job_id",
        )
        """
        _response = self._raw_client.cancel_job(source_connection_id, job_id, request_options=request_options)
        return _response.data


class AsyncSourceConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSourceConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSourceConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSourceConnectionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        collection: typing.Optional[str] = None,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[SourceConnectionListItem]:
        """
        List source connections with minimal fields for performance.

        Parameters
        ----------
        collection : typing.Optional[str]
            Filter by collection readable ID

        skip : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionListItem]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.list(
                collection="collection",
                skip=1,
                limit=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            collection=collection, skip=skip, limit=limit, request_options=request_options
        )
        return _response.data

    async def create(
        self,
        *,
        short_name: str,
        readable_collection_id: str,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        schedule: typing.Optional[ScheduleConfig] = OMIT,
        sync_immediately: typing.Optional[bool] = OMIT,
        authentication: typing.Optional[Authentication] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnection:
        """
        Create a new source connection.

        The authentication configuration determines the flow:
        - DirectAuthentication: Immediate creation with provided credentials
        - OAuthBrowserAuthentication: Returns shell with authentication URL
        - OAuthTokenAuthentication: Immediate creation with provided token
        - AuthProviderAuthentication: Using external auth provider

        BYOC (Bring Your Own Client) is detected when client_id and client_secret
        are provided in OAuthBrowserAuthentication.

        sync_immediately defaults:
        - True for: direct, oauth_token, auth_provider
        - False for: oauth_browser, oauth_byoc (these sync after authentication)

        Parameters
        ----------
        short_name : str
            Source identifier (e.g., 'slack', 'github')

        readable_collection_id : str
            Collection readable ID

        name : typing.Optional[str]
            Connection name (defaults to '{Source Name} Connection')

        description : typing.Optional[str]
            Connection description

        config : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Source-specific configuration

        schedule : typing.Optional[ScheduleConfig]

        sync_immediately : typing.Optional[bool]
            Run initial sync after creation. Defaults to True for direct/token/auth_provider, False for OAuth browser/BYOC flows (which sync after authentication)

        authentication : typing.Optional[Authentication]
            Authentication config (defaults to OAuth browser flow for OAuth sources)

        redirect_url : typing.Optional[str]
            URL to redirect to after OAuth flow completes (only used for OAuth flows)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.create(
                short_name="short_name",
                readable_collection_id="readable_collection_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            short_name=short_name,
            readable_collection_id=readable_collection_id,
            name=name,
            description=description,
            config=config,
            schedule=schedule,
            sync_immediately=sync_immediately,
            authentication=authentication,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, source_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SourceConnection:
        """
        Get a source connection with optional depth expansion.

        Parameters
        ----------
        source_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.get(
                source_connection_id="source_connection_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(source_connection_id, request_options=request_options)
        return _response.data

    async def delete(
        self, source_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SourceConnection:
        """
        Delete a source connection and all related data.

        Parameters
        ----------
        source_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.delete(
                source_connection_id="source_connection_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(source_connection_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        source_connection_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        schedule: typing.Optional[ScheduleConfig] = OMIT,
        authentication: typing.Optional[Authentication] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnection:
        """
        Update a source connection.

        Updateable fields:
        - name, description
        - config_fields
        - cron_schedule
        - auth_fields (direct auth only)

        Parameters
        ----------
        source_connection_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        config : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Source-specific configuration

        schedule : typing.Optional[ScheduleConfig]

        authentication : typing.Optional[Authentication]
            Authentication config (defaults to OAuth browser flow for OAuth sources)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.update(
                source_connection_id="source_connection_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            source_connection_id,
            name=name,
            description=description,
            config=config,
            schedule=schedule,
            authentication=authentication,
            request_options=request_options,
        )
        return _response.data

    async def run(
        self,
        source_connection_id: str,
        *,
        force_full_sync: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnectionJob:
        """
        Trigger a sync run for a source connection.

        Runs are always executed through Temporal workflow engine.

        Args:
            db: Database session
            source_connection_id: ID of the source connection to run
            ctx: API context with organization and user information
            guard_rail: Guard rail service for usage limits
            force_full_sync: If True, forces a full sync with orphaned entity cleanup
                            for continuous syncs. Raises 400 error if used on
                            non-continuous syncs (which are always full syncs).

        Parameters
        ----------
        source_connection_id : str

        force_full_sync : typing.Optional[bool]
            Force a full sync ignoring cursor data instead of waiting for the daily cleanup schedule. Only allowed for continuous syncs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnectionJob
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.run(
                source_connection_id="source_connection_id",
                force_full_sync=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.run(
            source_connection_id, force_full_sync=force_full_sync, request_options=request_options
        )
        return _response.data

    async def get_source_connection_jobs(
        self,
        source_connection_id: str,
        *,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[SourceConnectionJob]:
        """
        Get sync jobs for a source connection.

        Parameters
        ----------
        source_connection_id : str

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.get_source_connection_jobs(
                source_connection_id="source_connection_id",
                limit=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_source_connection_jobs(
            source_connection_id, limit=limit, request_options=request_options
        )
        return _response.data

    async def cancel_job(
        self, source_connection_id: str, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SourceConnectionJob:
        """
        Cancel a running sync job for a source connection.

        This endpoint requests cancellation and marks the job as CANCELLING.
        The workflow updates the final status to CANCELLED when it processes
        the cancellation request.

        Parameters
        ----------
        source_connection_id : str

        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnectionJob
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.source_connections.cancel_job(
                source_connection_id="source_connection_id",
                job_id="job_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_job(source_connection_id, job_id, request_options=request_options)
        return _response.data
