# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .legacy_search_request_search_method import LegacySearchRequestSearchMethod
from .query_expansion_strategy import QueryExpansionStrategy
from .response_type import ResponseType


class LegacySearchRequest(UniversalBaseModel):
    """
    Legacy search request schema for backwards compatibility.
    """

    query: str = pydantic.Field()
    """
    The search query text (max 2048 tokens)
    """

    filter: typing.Optional["Filter"] = pydantic.Field(default=None)
    """
    Qdrant native filter for metadata-based filtering
    """

    offset: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of results to skip
    """

    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum number of results
    """

    score_threshold: typing.Optional[float] = pydantic.Field(default=None)
    """
    Minimum similarity score threshold (deprecated, will be ignored)
    """

    response_type: typing.Optional[ResponseType] = pydantic.Field(default=None)
    """
    Type of response - 'raw' or 'completion'
    """

    search_method: typing.Optional[LegacySearchRequestSearchMethod] = pydantic.Field(default=None)
    """
    Search method to use
    """

    recency_bias: typing.Optional[float] = pydantic.Field(default=None)
    """
    How much document age affects the similarity score (0..1)
    """

    expansion_strategy: typing.Optional[QueryExpansionStrategy] = pydantic.Field(default=None)
    """
    Query expansion strategy
    """

    enable_reranking: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enable LLM-based reranking to improve result relevance
    """

    enable_query_interpretation: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enable automatic filter extraction from natural language query
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .filter import Filter  # noqa: E402, F401, I001
from .min_should import MinShould  # noqa: E402, F401, I001
from .nested import Nested  # noqa: E402, F401, I001
from .nested_condition import NestedCondition  # noqa: E402, F401, I001

update_forward_refs(LegacySearchRequest)
