# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .response_type import ResponseType
from .search_status import SearchStatus


class LegacySearchResponse(UniversalBaseModel):
    """
    Legacy search response schema for backwards compatibility.
    """

    results: typing.List[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field()
    """
    Array of search result objects
    """

    response_type: ResponseType = pydantic.Field()
    """
    Indicates whether results are raw search matches or AI-generated completions
    """

    completion: typing.Optional[str] = pydantic.Field(default=None)
    """
    AI-generated natural language answer when response_type is 'completion'
    """

    status: SearchStatus = pydantic.Field()
    """
    Status of the search operation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
