# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .feature_flag import FeatureFlag
from .organization_billing import OrganizationBilling


class Organization(UniversalBaseModel):
    """
    Organization schema with billing and feature information.

    This is the primary organization schema used in API contexts, enriched with
    billing (including current period) and feature flags for efficient access
    without additional database queries.

    Access billing info compositionally:
    - organization.billing.plan
    - organization.billing.status
    - organization.billing.current_period
    """

    name: str
    description: typing.Optional[str] = None
    auth_0_org_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="auth0_org_id")] = None
    id: str
    created_at: dt.datetime
    modified_at: dt.datetime
    org_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    enabled_features: typing.Optional[typing.List[FeatureFlag]] = pydantic.Field(default=None)
    """
    List of enabled feature flags for this organization
    """

    billing: typing.Optional[OrganizationBilling] = pydantic.Field(default=None)
    """
    Complete billing information including current period
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
