# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .single_action_check_response_reason import SingleActionCheckResponseReason


class SingleActionCheckResponse(UniversalBaseModel):
    """
    Response schema for single action permission check.
    """

    allowed: bool = pydantic.Field()
    """
    Whether the action is allowed for the organization
    """

    action: str = pydantic.Field()
    """
    The action type that was checked
    """

    reason: typing.Optional[SingleActionCheckResponseReason] = pydantic.Field(default=None)
    """
    Reason why the action is not allowed (if applicable)
    """

    details: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional details about why the action is not allowed
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
